/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.preferences;

import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;

public enum XFormatDate implements EnumWithValue<XFormatDate>
{
    YYYY_MM_DD(1){

        public String toString() {
            return "yyyy-MM-dd";
        }

        @Override
        public String toMask() {
            return "9999-99-99";
        }

        @Override
        public int[] getYearPosition() {
            return new int[]{0, 4};
        }

        @Override
        public int[] getMonthPosition() {
            return new int[]{4, 6};
        }

        @Override
        public int[] getDayPosition() {
            return new int[]{6, 8};
        }
    }
    ,
    DD_MM_YYYY(2){

        public String toString() {
            return "dd-MM-yyyy";
        }

        @Override
        public String toMask() {
            return "99-99-9999";
        }

        @Override
        public int[] getYearPosition() {
            return new int[]{4, 8};
        }

        @Override
        public int[] getMonthPosition() {
            return new int[]{2, 4};
        }

        @Override
        public int[] getDayPosition() {
            return new int[]{0, 2};
        }
    }
    ,
    MM_DD_YYYY(3){

        public String toString() {
            return "MM-dd-yyyy";
        }

        @Override
        public String toMask() {
            return "99-99-9999";
        }

        @Override
        public int[] getYearPosition() {
            return new int[]{4, 8};
        }

        @Override
        public int[] getMonthPosition() {
            return new int[]{0, 2};
        }

        @Override
        public int[] getDayPosition() {
            return new int[]{2, 4};
        }
    };

    public final int id;
    private static XFormatDate _default;

    private XFormatDate(int id) {
        this.id = id;
    }

    public static XFormatDate from(Integer id) {
        if (id != null) {
            for (XFormatDate v : XFormatDate.values()) {
                if (v.id != id) continue;
                return v;
            }
        }
        return null;
    }

    @Override
    public int getValue() {
        return this.id;
    }

    public static boolean contains(Set<XFormatDate> ss, XFormatDate s) {
        for (XFormatDate x : ss) {
            if (!x.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static int valueOfEnumSet(EnumSet<XFormatDate> x) {
        int i = 0;
        for (XFormatDate l : x) {
            i |= l.id;
        }
        return i;
    }

    public abstract String toMask();

    public abstract int[] getYearPosition();

    public abstract int[] getMonthPosition();

    public abstract int[] getDayPosition();

    public static void setDefault(XFormatDate formatDate) {
        _default = formatDate;
    }

    public static XFormatDate getDefault() {
        if (_default == null) {
            return YYYY_MM_DD;
        }
        return _default;
    }

    public static String formatDateTime(Calendar calendar) {
        return XFormatDate.formatDateTime(calendar.getTime());
    }

    public static String formatDateTime(Date date) {
        String pattern = FormatDateProvider.getFormatDate() + " HH:mm:ss";
        return DateUtil.nonThreadSafeFormat((Long)date.getTime(), (String)pattern);
    }

    public static String formatPartialDate(IPartialDate date) {
        String y = null;
        String m = null;
        String d = null;
        if (date.getYear() != null) {
            y = StringUtils.leftPad((String)(date.getYear() + ""), (int)4, (char)'0');
        }
        if (date.getMonth() != null) {
            m = StringUtils.leftPad((String)(date.getMonth() + ""), (int)2, (char)'0');
        }
        if (date.getDay() != null) {
            d = StringUtils.leftPad((String)(date.getDay() + ""), (int)2, (char)'0');
        }
        JoinList list = new JoinList("-", 3);
        if (YYYY_MM_DD.equals(FormatDateProvider.getFormatDate())) {
            if (y != null) {
                list.add((CharSequence)y);
            }
            if (m != null) {
                list.add((CharSequence)m);
            }
            if (d != null) {
                list.add((CharSequence)d);
            }
        } else if (MM_DD_YYYY.equals(FormatDateProvider.getFormatDate())) {
            if (m != null) {
                list.add((CharSequence)m);
            }
            if (d != null) {
                list.add((CharSequence)d);
            }
            if (y != null) {
                list.add((CharSequence)y);
            }
        } else if (DD_MM_YYYY.equals(FormatDateProvider.getFormatDate())) {
            if (d != null) {
                list.add((CharSequence)d);
            }
            if (m != null) {
                list.add((CharSequence)m);
            }
            if (y != null) {
                list.add((CharSequence)y);
            }
        }
        return list.toString();
    }

    @Override
    public XFormatDate fromValue(Integer id) {
        return XFormatDate.from(id);
    }

    static {
        _default = null;
    }
}

