/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.patient;

import ca.infodata.ofys.util.math.NumberUtils;
import ca.infodata.util1.StringUtils;

public final class NAM_NB {
    private NAM_NB() {
    }

    public static boolean validateNAM(String nam) {
        if (StringUtils.isBlank((CharSequence)nam)) {
            return false;
        }
        if (nam.length() != 10 && nam.length() != 9) {
            return false;
        }
        if (nam.length() == 10 && !nam.endsWith("M")) {
            return false;
        }
        boolean valid = true;
        String s = nam;
        if (nam.endsWith("M")) {
            s = nam.substring(0, 9);
        }
        if (s.length() < 9 && NumberUtils.isNumber(s)) {
            valid = false;
        } else if (!NAM_NB.validateModulus10(s)) {
            valid = false;
        }
        return valid;
    }

    private static boolean validateModulus10(String text) {
        String temp;
        boolean valid = true;
        int validationChar = Character.getNumericValue(text.charAt(text.length() - 1));
        int total = 0;
        for (int i = 0; i < text.length() - 1; ++i) {
            temp = String.valueOf(Character.getNumericValue(text.charAt(i)) * (i % 2 + 1));
            int tempTotal = 0;
            for (int j = 0; j < temp.length(); ++j) {
                tempTotal += Character.getNumericValue(temp.charAt(j));
            }
            total += tempTotal;
        }
        String result = String.valueOf(total);
        temp = String.valueOf(10 - Character.getNumericValue(result.charAt(result.length() - 1)));
        int realValidationChar = Character.getNumericValue(temp.charAt(temp.length() - 1));
        if (realValidationChar != validationChar) {
            valid = false;
        }
        return valid;
    }

    public static void main(String[] args) {
        System.out.println(NAM_NB.validateNAM("919560706M"));
        System.out.println(NAM_NB.validateNAM("SASVD83012219"));
    }
}

