/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.interfaces;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.AbstractGenericListDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.util1.PredicateA;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Spliterator;

public final class EditableDataObjectSet<E extends IMinimalEditableDataObject>
extends AbstractGenericListDecorator<E>
implements IEditableDataObjectList<E>,
Set<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final PredicateA<E> predicate;
    private final Set<E> set;
    public final IEditableDataObjectList<E> list;

    public static <T extends IMinimalEditableDataObject> EditableDataObjectSet<T> decorate(IEditableDataObjectList<T> list) {
        return new EditableDataObjectSet<T>(list, null);
    }

    public static <T extends IMinimalEditableDataObject> EditableDataObjectSet<T> decorate(IEditableDataObjectList<T> list, PredicateA<T> predicate) {
        return new EditableDataObjectSet<T>(list, predicate);
    }

    private EditableDataObjectSet(IEditableDataObjectList<E> list, PredicateA<E> predicate) {
        super(list);
        this.list = list;
        this.predicate = predicate;
        this.set = new HashSet<E>(list);
        if (this.set.size() != list.size()) {
            throw new IllegalArgumentException("list must not contains duplicate item, result would be innacurate");
        }
    }

    private boolean isValid(E object) {
        return this.predicate == null || this.predicate.evaluate(object);
    }

    @Override
    public void add(int index, E object) {
        boolean add;
        boolean bl = add = this.isValid(object) && this.set.add(object);
        if (add) {
            super.add(index, object);
        }
    }

    @Override
    public boolean add(E object) {
        boolean add;
        boolean bl = add = this.isValid(object) && this.set.add(object);
        if (add) {
            return super.add(object);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new MyListIterator(super.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new MyListIterator(super.listIterator(index));
    }

    @Override
    public E set(int index, E object) {
        if (!this.isValid(object)) {
            throw new IllegalArgumentException("object does not respect predicate");
        }
        IMinimalEditableDataObject e = (IMinimalEditableDataObject)this.get(index);
        if (e == object) {
            return (E)((IMinimalEditableDataObject)super.set(index, object));
        }
        this.set.remove(object);
        this.set.add(object);
        return (E)((IMinimalEditableDataObject)super.set(index, object));
    }

    @Override
    public boolean containsAllByTag(Collection<E> c) {
        return this.list.containsAllByTag(c);
    }

    @Override
    public boolean containsByTag(E o) {
        return this.list.containsByTag(o);
    }

    @Override
    public IEditableDataObjectList<E> deepClone() {
        return this.list.deepClone();
    }

    @Override
    public List<E> getNotDeleted() {
        return this.list.getNotDeleted();
    }

    @Override
    public List<E> getObject_NOT_WithStatus(EnumSet<ModificationStatus> statusSet) {
        return this.list.getObject_NOT_WithStatus(statusSet);
    }

    @Override
    public List<E> getObject_NOT_WithStatus(ModificationStatus status) {
        return this.list.getObject_NOT_WithStatus(status);
    }

    @Override
    public List<E> getObject_WithStatus(EnumSet<ModificationStatus> statusSet) {
        return this.list.getObject_WithStatus(statusSet);
    }

    @Override
    public List<E> getObject_WithStatus(ModificationStatus status) {
        return this.list.getObject_WithStatus(status);
    }

    @Override
    public int indexOfByTag(E o) {
        return this.list.indexOfByTag(o);
    }

    @Override
    public boolean isDirty() {
        return this.list.isDirty();
    }

    @Override
    public IStatus preValid() {
        return this.list.preValid();
    }

    @Override
    public IStatus preValidQuestion() {
        return this.list.preValidQuestion();
    }

    @Override
    public Iterator<E> iterator() {
        return new MyIterator(super.iterator());
    }

    @Override
    public boolean remove(Object object) {
        boolean removed = super.remove(object);
        if (removed && !this.list.contains(object)) {
            this.set.remove(object);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean removeAll = super.removeAll(coll);
        if (removeAll) {
            this.set.clear();
            this.set.addAll(this.list);
        }
        return removeAll;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean retainAll = super.retainAll(coll);
        if (retainAll) {
            this.set.clear();
            this.set.addAll(this.list);
        }
        return retainAll;
    }

    @Override
    public void clear() {
        super.clear();
        this.set.clear();
    }

    @Override
    public E remove(int index) {
        IMinimalEditableDataObject old = (IMinimalEditableDataObject)super.remove(index);
        if (!this.list.contains(old)) {
            this.set.remove(old);
        }
        return (E)old;
    }

    @Override
    public boolean removeByTag(E o) {
        boolean removed = this.list.removeByTag(o);
        if (removed && !this.list.contains(o)) {
            this.set.remove(o);
        }
        return removed;
    }

    @Override
    public Object clone() {
        return this.list.clone();
    }

    @Override
    public IEditableDataObjectList<E> deepCloneSetIdNull() {
        return this.list.deepCloneSetIdNull();
    }

    @Override
    public Spliterator<E> spliterator() {
        return super.spliterator();
    }

    private class MyListIterator
    implements ListIterator<E> {
        private final ListIterator<E> wrapped;
        private E current;

        private MyListIterator(ListIterator<E> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void add(E o) {
            boolean doit;
            boolean bl = doit = EditableDataObjectSet.this.isValid(o) && EditableDataObjectSet.this.set.add(o);
            if (doit) {
                this.wrapped.add(o);
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.wrapped.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.wrapped.nextIndex();
        }

        @Override
        public E previous() {
            return (IMinimalEditableDataObject)this.wrapped.previous();
        }

        @Override
        public int previousIndex() {
            return this.wrapped.previousIndex();
        }

        @Override
        public void set(E o) {
            boolean doit;
            boolean bl = doit = EditableDataObjectSet.this.isValid(o) && EditableDataObjectSet.this.set.add(o);
            if (doit) {
                this.wrapped.set(o);
            }
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public E next() {
            this.current = (IMinimalEditableDataObject)this.wrapped.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.wrapped.remove();
            if (!EditableDataObjectSet.this.list.contains(this.current)) {
                EditableDataObjectSet.this.set.remove(this.current);
            }
        }
    }

    private class MyIterator
    implements Iterator<E> {
        private final Iterator<E> wrapped;
        private E current;

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public E next() {
            this.current = (IMinimalEditableDataObject)this.wrapped.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.wrapped.remove();
            if (!EditableDataObjectSet.this.list.contains(this.current)) {
                EditableDataObjectSet.this.set.remove(this.current);
            }
        }

        private MyIterator(Iterator<E> wrapped) {
            this.wrapped = wrapped;
        }
    }
}

