/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart;

import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Age;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.GrowChartPdfUtil;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Language;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Sex;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BMI_219 {
    private String fullname;
    private LocalDate birthdate;
    private String recordnumber;
    private String motherHeight;
    private String fatherHeight;
    private String gestionalAgeAtBirth;
    private Sex sex;
    private Language language;
    private boolean blackAndWhite;
    private List<Data> datas;

    public byte[] render() throws Exception {
        if (this.datas == null) {
            throw new NullPointerException("datas");
        }
        Collections.sort(this.datas, new Comparator<Data>(){

            @Override
            public int compare(Data o1, Data o2) {
                return o1.date.compareTo((IPartialDate)o2.date);
            }
        });
        byte[] pdf = GrowChartPdfUtil.readFile("BMI_2-19", this.getSex(), this.getLanguage(), this.isBlackAndWhite());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PdfReader reader = new PdfReader(pdf);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)output);
        boolean page = true;
        PdfContentByte overContent = stamper.getOverContent(1);
        BaseFont font = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        overContent.setFontAndSize(font, 10.0f);
        overContent.beginText();
        float x = 400.0f;
        float y = 730.0f;
        if (this.getLanguage() == Language.FR && this.getSex() == Sex.BOYS) {
            x = 390.0f;
            y = 735.0f;
        }
        overContent.showTextAligned(0, this.getFullname(), x, y, 0.0f);
        if (this.birthdate != null) {
            x = 395.0f;
            y = 716.0f;
            if (this.getLanguage() == Language.FR && this.getSex() == Sex.BOYS) {
                x = 385.0f;
                y = 721.0f;
            }
            overContent.showTextAligned(0, this.birthdate.formatSlash(), x, y, 0.0f);
        }
        x = 526.0f;
        y = 716.0f;
        if (this.getLanguage() == Language.FR && this.getSex() == Sex.BOYS) {
            y = 721.0f;
        }
        if (this.recordnumber != null) {
            overContent.showTextAligned(0, this.recordnumber, x, y, 0.0f);
        }
        float xStart = 72.0f;
        float xEnd = 517.0f;
        float yEnd = 676.25f;
        float dateXSize = 45.0f;
        float ageXSize = 50.0f;
        float lengthXSize = 45.0f;
        float weightXSize = 45.0f;
        float imcXSize = 45.0f;
        overContent.setFontAndSize(font, 6.0f);
        int reportTextLinesNumber = this.sex == Sex.BOYS ? 15 : 13;
        int datasOffset = Math.max(0, this.datas.size() - reportTextLinesNumber);
        int i = 0;
        while (i + datasOffset < this.datas.size()) {
            Data data = this.datas.get(i + datasOffset);
            y = yEnd - 6.0f - (float)i * 7.68f;
            x = xStart + 5.0f;
            overContent.showTextAligned(0, data.date.formatSlash(), x, y, 0.0f);
            x = xStart + 45.0f + 5.0f;
            overContent.showTextAligned(0, Age.formatYearMonth(this.birthdate, data.date), x, y, 0.0f);
            if (data.weight != null) {
                x = xStart + 45.0f + 50.0f + 5.0f;
                overContent.showTextAligned(0, String.valueOf(data.weight.floatValue() / 1000.0f) + " kg", x, y, 0.0f);
            }
            if (data.height != null) {
                x = xStart + 45.0f + 50.0f + 45.0f + 5.0f;
                overContent.showTextAligned(0, String.valueOf(data.height) + " cm", x, y, 0.0f);
            }
            if (data.imc != null) {
                x = xStart + 45.0f + 50.0f + 45.0f + 45.0f + 5.0f;
                overContent.showTextAligned(0, String.format("%.1f", data.imc), x, y, 0.0f);
            }
            if (data.comments != null) {
                x = xStart + 45.0f + 50.0f + 45.0f + 45.0f + 45.0f + 6.0f;
                overContent.showTextAligned(0, data.comments, x, y, 0.0f);
            }
            ++i;
        }
        xStart = 112.0f;
        float yStart = 94.0f;
        xEnd = 530.5f;
        yEnd = 684.0f;
        float minYValue = this.getSex() == Sex.BOYS ? 10.0f : 11.0f;
        float maxYValue = this.getSex() == Sex.BOYS ? 41.0f : 42.0f;
        float minXValue = 24.0f;
        float maxXValue = 228.0f;
        ArrayList<Point> dots = new ArrayList<Point>();
        for (Data data : this.datas) {
            if (data.imc == null) continue;
            float r = (data.imc.floatValue() - minYValue) / (maxYValue - minYValue);
            float rx = ((float)data.date.getMonthDiff(this.birthdate) - 24.0f) / 204.0f;
            y = 94.0f + (yEnd - 94.0f) * r;
            x = xStart + (xEnd - xStart) * rx;
            overContent.circle(x, y, 2.0f);
            dots.add(new Point(x, y));
        }
        for (int i2 = dots.size() - 1; i2 >= 0; --i2) {
            overContent.lineTo(((Point)dots.get((int)i2)).x, ((Point)dots.get((int)i2)).y);
        }
        overContent.stroke();
        overContent.endText();
        stamper.close();
        return output.toByteArray();
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public LocalDate getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(LocalDate birthdate) {
        this.birthdate = birthdate;
    }

    public String getRecordnumber() {
        return this.recordnumber;
    }

    public void setRecordnumber(String recordnumber) {
        this.recordnumber = recordnumber;
    }

    public String getMotherHeight() {
        return this.motherHeight;
    }

    public void setMotherHeight(String motherHeight) {
        this.motherHeight = motherHeight;
    }

    public String getFatherHeight() {
        return this.fatherHeight;
    }

    public void setFatherHeight(String fatherHeight) {
        this.fatherHeight = fatherHeight;
    }

    public String getGestionalAgeAtBirth() {
        return this.gestionalAgeAtBirth;
    }

    public void setGestionalAgeAtBirth(String gestionalAgeAtBirth) {
        this.gestionalAgeAtBirth = gestionalAgeAtBirth;
    }

    public List<Data> getDatas() {
        return this.datas;
    }

    public void setDatas(List<Data> datas) {
        this.datas = datas;
    }

    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public boolean isBlackAndWhite() {
        return this.blackAndWhite;
    }

    public void setBlackAndWhite(boolean blackAndWhite) {
        this.blackAndWhite = blackAndWhite;
    }

    public static void main(String[] args) throws Exception {
        String name = "Steeve St-Laurent";
        LocalDate birthdate = Age.parse("1999/08/14");
        String recordnumber = "00015";
        String motherHeight = "150 cm";
        String fatherHeight = "170 cm";
        String gestionalAgeAtBirth = "40";
        ArrayList<Data> datas = new ArrayList<Data>();
        datas.add(new Data(Age.parse("2001/01/01"), Float.valueOf(2000.0f), Float.valueOf(45.0f), Float.valueOf(19.0f), "bebe"));
        datas.add(new Data(Age.parse("2002/01/01"), Float.valueOf(3000.0f), Float.valueOf(45.0f), Float.valueOf(19.0f), "bebe"));
        datas.add(new Data(Age.parse("2003/02/01"), Float.valueOf(4000.0f), Float.valueOf(50.0f), Float.valueOf(20.0f), "mignon"));
        datas.add(new Data(Age.parse("2004/03/01"), Float.valueOf(5900.0f), Float.valueOf(55.0f), Float.valueOf(21.0f), "joue"));
        datas.add(new Data(Age.parse("2005/04/01"), Float.valueOf(6000.0f), Float.valueOf(65.0f), Float.valueOf(22.0f), "dort"));
        datas.add(new Data(Age.parse("2006/04/01"), Float.valueOf(7500.0f), Float.valueOf(70.0f), Float.valueOf(23.0f), "rie"));
        datas.add(new Data(Age.parse("2007/05/01"), Float.valueOf(9000.0f), Float.valueOf(75.0f), Float.valueOf(24.0f), "pleure"));
        datas.add(new Data(Age.parse("2008/06/01"), Float.valueOf(8700.0f), Float.valueOf(80.0f), Float.valueOf(25.0f), "boie"));
        datas.add(new Data(Age.parse("2009/07/01"), Float.valueOf(10000.0f), Float.valueOf(81.0f), Float.valueOf(26.0f), "crie"));
        datas.add(new Data(Age.parse("2010/08/01"), Float.valueOf(10000.0f), Float.valueOf(83.0f), Float.valueOf(27.0f), "sourie"));
        datas.add(new Data(Age.parse("2011/09/01"), Float.valueOf(12000.0f), Float.valueOf(87.0f), Float.valueOf(28.0f), "marche"));
        datas.add(new Data(Age.parse("2012/10/01"), Float.valueOf(14000.0f), Float.valueOf(90.0f), Float.valueOf(29.0f), "tombe"));
        datas.add(new Data(Age.parse("2013/11/01"), Float.valueOf(16000.0f), Float.valueOf(102.0f), Float.valueOf(34.0f), "attape"));
        datas.add(new Data(Age.parse("2014/11/01"), null, null, null, null));
        datas.add(new Data(Age.parse("2014/12/01"), Float.valueOf(15500.0f), Float.valueOf(102.0f), Float.valueOf(32.0f), "attape"));
        datas.add(new Data(Age.parse("2015/03/01"), Float.valueOf(14000.0f), Float.valueOf(102.0f), Float.valueOf(31.0f), "attape"));
        datas.add(new Data(Age.parse("2016/11/01"), Float.valueOf(20000.0f), Float.valueOf(102.0f), Float.valueOf(30.0f), "attape"));
        BMI_219 report = new BMI_219();
        report.setBirthdate(birthdate);
        report.setFatherHeight("170 cm");
        report.setMotherHeight("150 cm");
        report.setGestionalAgeAtBirth("40");
        report.setRecordnumber("00015");
        report.setFullname("Steeve St-Laurent");
        report.setDatas(datas);
        for (Language language : Language.values()) {
            for (Sex sex : Sex.values()) {
                report.setSex(sex);
                report.setLanguage(language);
                report.setBlackAndWhite(false);
                byte[] pdf = report.render();
                GrowChartPdfUtil.showWithExternalViewer(pdf);
            }
        }
    }

    public static class Data {
        public Float weight;
        public Float height;
        public Float imc;
        public LocalDate date;
        public String comments;

        public Data(LocalDate date, Float weight, Float height, Float imc, String comments) {
            this.date = date;
            this.height = height;
            this.weight = weight;
            this.imc = imc;
            this.comments = comments;
        }
    }

    private static class Point {
        float x;
        float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

