/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter;

import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CSummary;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class ZSumMedFile4Ai
implements Serializable {
    private static final long serialVersionUID = 189796554L;
    public String language;
    public String familyHistory;
    public String medicalHistory;
    public String socialHistory;
    public String ongoingConcerns;
    public String otherMedications;
    public List<String> allergies;
    public List<String> intolerances;
    public List<String> interventions;
    public List<String> lifeHabits;
    public List<String> immunizations;
    public List<String> bloodPressures;
    public List<String> temperatures;
    public List<String> respiratory_frequencies;
    public List<String> measurements;
    public List<String> prescriptions;
    public List<String> diagnostics;
    public List<String> problems;

    public ZSumMedFile4Ai(CSummary c) {
        if (c.socialHistoryObj != null) {
            this.socialHistory = ZSumMedFile4Ai.removeMarkdown(c.socialHistoryObj.note);
        }
        if (c.getLstLifeHabit() != null && c.getLstLifeHabit().size() > 0) {
            this.lifeHabits = new ArrayList<String>(c.getLstLifeHabit().size());
            for (CEncounter.LifeHabits lifeHabits : c.getLstLifeHabit()) {
                this.lifeHabits.add(new JoinList(" ", new Object[]{lifeHabits.descr[0], lifeHabits.descr[1], lifeHabits.descr[2]}).toString());
            }
        }
        if (c.ongoingConcernsObj != null) {
            this.ongoingConcerns = ZSumMedFile4Ai.removeMarkdown(c.ongoingConcernsObj.note);
        }
        if (c.familyHistoryObj != null) {
            this.familyHistory = ZSumMedFile4Ai.removeMarkdown(c.familyHistoryObj.note);
        }
        if (c.medicalHistoryObj != null) {
            this.medicalHistory = ZSumMedFile4Ai.removeMarkdown(c.medicalHistoryObj.note);
        }
        if (c.getLstAllergy() != null && c.getLstAllergy().size() > 0) {
            this.allergies = new ArrayList<String>(c.getLstAllergy().size());
            for (CEncounter.Allergies allergies : c.getLstAllergy()) {
                if (Boolean.TRUE.equals(allergies.noKnownAllergy)) {
                    this.allergies.add("Aucune allergie connue / No known allergy");
                    break;
                }
                this.allergies.add(allergies.descr[1] + " " + allergies.descr[2] + " " + allergies.descr[3]);
            }
        }
        if (c.getLstIntolerance() != null && c.getLstIntolerance().size() > 0) {
            this.intolerances = new ArrayList<String>(c.getLstIntolerance().size());
            for (CEncounter.Intolerances intolerances : c.getLstIntolerance()) {
                this.intolerances.add(intolerances.descr[1] + " " + intolerances.descr[2] + " " + intolerances.descr[3]);
            }
        }
        if (c.getLstImmunization() != null && c.getLstImmunization().size() > 0) {
            this.immunizations = new ArrayList<String>(c.getLstImmunization().size());
            for (CEncounter.Immunizations immunizations : c.getLstImmunization()) {
                if (Boolean.TRUE.equals(immunizations.refused)) continue;
                this.immunizations.add(new ZImmunization(immunizations.descr[0], immunizations.descr[1], null).toString());
            }
        }
        if (c.getLstDx() != null && c.getLstDx().size() > 0) {
            this.diagnostics = new ArrayList<String>(c.getLstDx().size());
            for (CEncounter.Dx dx : c.getLstDx()) {
                this.diagnostics.add(new ZDiagnostic(dx.descr[0], dx.descr[1], dx.note).toString());
            }
        }
        if (c.getLstProb() != null && c.getLstProb().size() > 0) {
            this.problems = new ArrayList<String>(c.getLstProb().size());
            for (CEncounter.Prob prob : c.getLstProb()) {
                this.problems.add(new ZProblem(prob.descr[0], prob.descr[1], prob.note).toString());
            }
        }
        if (c.getLstIntervention() != null && c.getLstIntervention().size() > 0) {
            this.interventions = new ArrayList<String>(c.getLstIntervention().size());
            for (CEncounter.Interventions interventions : c.getLstIntervention()) {
                this.interventions.add(new ZIntervention(interventions.descr[0], interventions.descr[1], interventions.note).toString());
            }
        }
        if (c.getLstAllPrescription() != null && c.getLstAllPrescription().size() > 0) {
            this.prescriptions = new ArrayList<String>(c.getLstAllPrescription().size());
            for (CEncounter.Prescription prescription : c.getLstAllPrescription()) {
                this.prescriptions.add(new ZPrescription(prescription.startDateSD, CPrescriptionFormatter.formatDrugNameWithBrackets(prescription, XPrescriptionDrugNameFormat.COMMERCIAL_AND_GENERIC, 200), prescription.strength, prescription.descr[2] + " " + prescription.descr[3]).toString());
            }
        }
    }

    private static String removeMarkdown(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (value.startsWith("\u2256")) {
            value = value.substring(1);
        }
        return value;
    }

    public static class ZLabResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String name;
        public final String unite;
        public final String value;
        public final String upper_limit;
        public final String lower_limit;
        public final String flag;
        public String date;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ZLabResult(String name, String unit, String val, String inf, String sup, String date, int flag) {
            this.name = name;
            this.unite = unit;
            this.value = val;
            this.lower_limit = inf == null || inf.equals("0") ? null : inf;
            String string = this.upper_limit = sup == null || sup.equals("0") ? null : sup;
            this.flag = flag == 2 ? "critique" : (flag == 1 ? "anormal" : "normal");
            if (!"-1".equals(date)) {
                try {
                    long l = Long.parseLong(date);
                    LocalDate ld = LocalDate.fromTimeInMillisUTC((Long)l);
                    this.date = ld.formatHyphen();
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(40);
            sb.append("date:" + this.date + ", ");
            sb.append("labTest:" + this.name.replaceAll("[ ]+", " "));
            sb.append(", value:" + this.value).append(", unit:" + this.unite);
            if (this.flag != null) {
                sb.append(" (" + this.flag + ")");
            }
            if (this.lower_limit != null) {
                sb.append(", normalRange: {minValue:" + this.lower_limit + ", maxValue:" + this.upper_limit + "}");
            }
            return sb.toString();
        }
    }

    public static abstract class ZObjectDate {
        public final String date;
        public final String note;

        public ZObjectDate(String date, String note) {
            this.date = date;
            this.note = ZSumMedFile4Ai.removeMarkdown(note);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(30);
            if (this.date != null) {
                sb.append("date:" + this.date);
            }
            if (this.note != null) {
                sb.append(", " + this.note);
            }
            return sb.toString();
        }
    }

    public static abstract class ZObject
    extends ZObjectDate {
        public final String name;

        public ZObject(String date, String name, String note) {
            super(date, note);
            this.name = name;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("date:" + this.date);
            sb.append(", " + this.name);
            if (this.note != null) {
                sb.append(", " + this.note);
            }
            return sb.toString();
        }
    }

    public static final class ZProblem
    extends ZObject
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ZProblem(String date, String name, String note) {
            super(date, name, note);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("");
            sb.append(this.name);
            if (this.note != null) {
                sb.append(", " + this.note);
            }
            return sb.toString();
        }
    }

    public static final class ZDiagnostic
    extends ZObject
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ZDiagnostic(String date, String name, String note) {
            super(date, name, note);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("");
            sb.append(this.name);
            if (this.note != null) {
                sb.append(", " + this.note);
            }
            return sb.toString();
        }
    }

    public static final class ZPrescription
    extends ZObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String strength;
        public final String posology;

        public ZPrescription(String date, String name, String s, String p) {
            super(date, name, null);
            this.strength = s;
            this.posology = p;
        }

        @Override
        public String toString() {
            JoinList sb = new JoinList(", ");
            if (this.name != null) {
                sb.add((CharSequence)this.name);
            }
            if (this.strength != null) {
                sb.add((CharSequence)this.strength);
            }
            if (this.posology != null) {
                sb.add((CharSequence)this.posology.replace("sig : ", ""));
            }
            return sb.toString();
        }
    }

    public static final class ZPhysicalExam
    extends ZObjectDate
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ZPhysicalExam(String date, String n) {
            super(date, n);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("");
            sb.append(this.note);
            return sb.toString();
        }
    }

    public static final class ZMeasurement
    extends ZObjectDate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String height;
        public final String weight;
        public final String waist;
        public final String headCirc;
        public final Double IMC;

        public ZMeasurement(String date, String height, String weight, String waist, String headCirc, Double iMC, String note) {
            super(date, note);
            this.height = height == null ? null : height + " cm";
            this.weight = weight == null ? null : weight + " kg";
            this.waist = waist == null ? null : waist + " cm";
            this.headCirc = headCirc == null ? null : headCirc + " cm";
            this.IMC = iMC;
        }

        @Override
        public String toString() {
            JoinList sb = new JoinList(", ");
            if (this.height != null) {
                sb.add((CharSequence)("height:" + this.height));
            }
            if (this.weight != null) {
                sb.add((CharSequence)("weight:" + this.weight));
            }
            if (this.waist != null) {
                sb.add((CharSequence)("waist:" + this.waist));
            }
            if (this.headCirc != null) {
                sb.add((CharSequence)("headCirc:" + this.headCirc));
            }
            if (this.IMC != null) {
                sb.add((CharSequence)("IMC:" + String.format("%.1f", this.IMC)));
            }
            return sb.toString();
        }
    }

    public static final class ZRespFreq
    extends ZObjectDate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int frequency;

        public ZRespFreq(String date, int frequency, String note) {
            super(date, note);
            this.frequency = frequency;
        }

        @Override
        public String toString() {
            JoinList sb = new JoinList(", ");
            sb.add((CharSequence)("frequency:" + this.frequency));
            if (this.note != null) {
                sb.add((CharSequence)("note:" + this.note));
            }
            return sb.toString();
        }
    }

    public static final class ZBodyTemp
    extends ZObjectDate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String type;
        public final Double temperature;

        public ZBodyTemp(String date, String type, Double temperature, String note) {
            super(date, note);
            this.type = type;
            this.temperature = temperature;
        }

        @Override
        public String toString() {
            JoinList sb = new JoinList(", ");
            if (this.temperature != null) {
                sb.add((CharSequence)("" + this.temperature));
            }
            if (this.note != null) {
                sb.add((CharSequence)this.note);
            }
            return sb.toString();
        }
    }

    public static final class ZBloodPres
    extends ZObjectDate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Integer systolic;
        public final Integer diastolic;
        public final Integer pulse;
        public final Integer saturation;

        public ZBloodPres(String date, String note, Integer systolic, Integer diastolic, Integer pulse, Integer saturation) {
            super(date, note);
            this.systolic = systolic == null || systolic == 0 ? null : systolic;
            this.diastolic = diastolic == null || diastolic == 0 ? null : diastolic;
            this.pulse = pulse == null || pulse == 0 ? null : pulse;
            this.saturation = saturation == null || saturation == 0 ? null : saturation;
        }

        @Override
        public String toString() {
            JoinList sb = new JoinList(", ");
            if (this.systolic != null) {
                sb.add((CharSequence)("BP:" + this.systolic + "/" + (this.diastolic != null ? this.diastolic : "-")));
            }
            if (this.pulse != null) {
                sb.add((CharSequence)("pulse:" + this.pulse));
            }
            if (this.saturation != null) {
                sb.add((CharSequence)("saturation:" + this.saturation));
            }
            if (this.note != null) {
                sb.add((CharSequence)this.note);
            }
            return sb.toString();
        }
    }

    public static final class ZImmunization
    extends ZObject
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ZImmunization(String date, String name, String note) {
            super(date, name, note);
        }

        @Override
        public String toString() {
            JoinList sb = new JoinList(", ");
            if (this.name != null) {
                sb.add((CharSequence)this.name);
            }
            if (this.note != null) {
                sb.add((CharSequence)this.note);
            }
            return "date:" + this.date + ", " + sb.toString();
        }
    }

    public static final class ZIntervention
    extends ZObject
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ZIntervention(String date, String name, String note) {
            super(date, name, note);
        }

        @Override
        public String toString() {
            JoinList sb = new JoinList(", ");
            if (this.name != null) {
                sb.add((CharSequence)this.name);
            }
            if (this.note != null) {
                sb.add((CharSequence)this.note);
            }
            return "date:" + this.date + ", " + sb.toString();
        }
    }
}

