/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.IaController;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IIaAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XIaTaskToDoType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.dashboard.models.IaData;

public class IaAccessorClientNotNeeded
extends BaseAccessorClient {
    private static IaAccessorClientNotNeeded instance;
    private IIaAccessor accessor;

    public static IaAccessorClientNotNeeded getInstance() throws CannotConnectToServerException {
        return IaAccessorClientNotNeeded.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static IaAccessorClientNotNeeded getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new IaAccessorClientNotNeeded(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private IaAccessorClientNotNeeded(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getIaAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    protected IIaAccessor getAccessor() {
        return this.accessor;
    }

    public Integer sendChunk(byte[] audioData, Integer idAudio, Integer chunkNo, Boolean isFinalChunk) {
        IaData iaData = new IaData();
        iaData.setAudio(audioData);
        iaData.setIdAudio(idAudio);
        iaData.setChunkNo(chunkNo);
        iaData.setIsFinalChunk(isFinalChunk);
        ReturnObject ret = this.accessor.sendChunk(iaData);
        Integer id = ret != null && ret.getObj() != null ? (Integer)ret.getObj() : Integer.valueOf(-1);
        return id;
    }

    public String medNoteFromInterview(IaData iaData) throws Exception {
        ReturnObject ret = this.accessor.medNoteFromInterview(iaData);
        String text = ret != null && ret.getObj() != null ? (String)ret.getObj() : "";
        return text;
    }

    public String consentPatient(byte[] audioData, Integer idPatient) {
        IaData iaData = new IaData();
        iaData.setAudio(audioData);
        iaData.setIdPat(idPatient);
        ReturnObject ret = this.accessor.consentPatient(iaData);
        String text = ret != null && ret.getObj() != null ? (String)ret.getObj() : "";
        return text;
    }

    public String dictation(byte[] audioData) {
        IaData iaData = new IaData();
        iaData.setAudio(audioData);
        ReturnObject ret = this.accessor.dictation(iaData);
        String text = ret != null && ret.getObj() != null ? (String)ret.getObj() : "";
        return text;
    }

    public String improveDictation(byte[] audioData) {
        IaData iaData = new IaData();
        iaData.setAudio(audioData);
        ReturnObject ret = this.accessor.improveDictation(iaData);
        String text = ret != null && ret.getObj() != null ? (String)ret.getObj() : "";
        return text;
    }

    public String improveText(IaController.Text data) {
        return this.sendTextToIa(data.text, data.lang, XIaTaskToDoType.improveText.getValue(), null, null, null);
    }

    public String medNoteFromNote(IaController.Text data, XIaTaskToDoType task) {
        return this.sendTextToIa(data.text, data.lang, task.getValue(), null, null, null);
    }

    public String generatePatientSummary(IaController.Text data) {
        return this.sendTextToIa(data.text, data.lang, XIaTaskToDoType.encNotePatientSummary.getValue(), null, null, null);
    }

    public String summaryEnc4Prof(Integer idPat, Integer idLink, String l) {
        IaData iaData = new IaData();
        iaData.setText("_");
        iaData.setIdPat(idPat);
        iaData.setIdLink(idLink);
        iaData.setLang(l);
        iaData.setTaskToDo(Integer.valueOf(XIaTaskToDoType.resumeEncounter4Prof.getValue()));
        return this.sendTextToIa(iaData);
    }

    public String summaryEnc4Pat(Integer idPat, Integer idLink, String l) {
        IaData iaData = new IaData();
        iaData.setText("_");
        iaData.setIdPat(idPat);
        iaData.setIdLink(idLink);
        iaData.setLang(l);
        iaData.setTaskToDo(Integer.valueOf(XIaTaskToDoType.resumeEncounter4Pat.getValue()));
        return this.sendTextToIa(iaData);
    }

    public String encInfoClin4Form(Integer idPat, Integer idLink, String l) {
        IaData iaData = new IaData();
        iaData.setText("_");
        iaData.setIdPat(idPat);
        iaData.setIdLink(idLink);
        iaData.setLang(l);
        iaData.setTaskToDo(Integer.valueOf(XIaTaskToDoType.encInfoClin4Form.getValue()));
        return this.sendTextToIa(iaData);
    }

    public String resumeFile(IaController.IdData data) {
        return this.sendTextToIa(data.id, data.lang, XIaTaskToDoType.resumeFile.getValue(), Integer.valueOf(data.id), null, null);
    }

    public String getLastEnc3y(IaController.IdData data) {
        return this.sendTextToIa(data.id, data.lang, XIaTaskToDoType.getPreviousResumeEncounters.getValue(), Integer.valueOf(data.id), null, null);
    }

    public String lastEnc3y(IaController.IdData data) {
        return this.sendTextToIa(data.id, data.lang, XIaTaskToDoType.doResumeEncounters.getValue(), Integer.valueOf(data.id), null, null);
    }

    public String toFrench(String text) {
        return this.sendTextToIa(text, "fr", XIaTaskToDoType.toFrench.getValue(), null, null, null);
    }

    public String toEnglish(String text) {
        return this.sendTextToIa(text, "en", XIaTaskToDoType.toEnglish.getValue(), null, null, null);
    }

    private String sendTextToIa(IaData iaData) {
        ReturnObject ret = this.accessor.iaWorkText(iaData);
        String rep = ret != null && ret.getObj() != null ? (String)ret.getObj() : "";
        return rep;
    }

    private String sendTextToIa(String text, String lang, Integer taskToDo, Integer idPatient, Integer idLink, Integer idLingType) {
        IaData iaData = new IaData();
        iaData.setText(text);
        iaData.setTaskToDo(taskToDo);
        iaData.setIdPat(idPatient);
        iaData.setLang(lang);
        iaData.setIdLink(idLink);
        iaData.setIdLinkType(idLingType);
        ReturnObject ret = this.accessor.iaWorkText(iaData);
        String rep = ret != null && ret.getObj() != null ? (String)ret.getObj() : "";
        return rep;
    }
}

