/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IAppointmentAccessor;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateDeGardeType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateMessageType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentObjects;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XSearchPeriodCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class AppointmentAccessorClient
extends BaseAccessorClient {
    private static AppointmentAccessorClient instance;
    private final IAppointmentAccessor accessor;

    public static AppointmentAccessorClient getInstance() throws CannotConnectToServerException {
        return AppointmentAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static AppointmentAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new AppointmentAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private AppointmentAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getAppointmentAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void findTodayAppointmentsByPatient(int uniqueKey, final XSession session, final ICallback callback, final int patientId) {
        final String function = "AppointmentAccessorClient.findTodayAppointmentsByPatient" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findTodayAppointmentsByPatient(patientId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, patientId), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getReservedAppointment(int uniqueKey, final XSession session, final ICallback callback) {
        final String function = "AppointmentAccessorClient.getReservedAppointment" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.getReservedAppointment();
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s}", function, session, callback), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void extendsReservedAppt(XSession session, ArrayList<Serializable> reservedAppt, SaveCallback callback) {
        if (this.isOkToCallFunction("AppointmentAccessorClient.extendsReservedAppt", null)) {
            try {
                try {
                    ReturnObject returnObject = AppointmentAccessorClient.instance.accessor.extendsReservedAppt(reservedAppt);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s}", "AppointmentAccessorClient.extendsReservedAppt", session), e);
                    this.functionCallEnded("AppointmentAccessorClient.extendsReservedAppt", callback);
                }
            }
            finally {
                this.functionCallEnded("AppointmentAccessorClient.extendsReservedAppt", callback);
            }
        }
    }

    public void saveReservedAppt(XSession session, ArrayList<Serializable> reservedAppt, SaveCallback callback) {
        if (this.isOkToCallFunction("AppointmentAccessorClient.saveReservedAppt", null)) {
            try {
                try {
                    ReturnObject returnObject = AppointmentAccessorClient.instance.accessor.saveReservedAppt(reservedAppt);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s}", "AppointmentAccessorClient.saveReservedAppt", session), e);
                    this.functionCallEnded("AppointmentAccessorClient.saveReservedAppt", callback);
                }
            }
            finally {
                this.functionCallEnded("AppointmentAccessorClient.saveReservedAppt", callback);
            }
        }
    }

    public void deleteReservedAppt(final XSession session, final ArrayList<Serializable> reservedAppt) {
        if (this.isOkToCallFunction("AppointmentAccessorClient.deleteReservedAppt", null)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            instance.accessor.deleteReservedAppt(reservedAppt);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s}", "AppointmentAccessorClient.deleteReservedAppt", session), e);
                            AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.deleteReservedAppt", null);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.deleteReservedAppt", null);
                    }
                    return null;
                }
            };
        }
    }

    public ReturnObject sendEmails(XSession session, int uniqueKey, HashMap<String, Map<String, Serializable>> map) throws Exception {
        String function = "AppointmentAccessorClient.sendEmails." + uniqueKey;
        if (this.isOkToCallFunction(function, null)) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.sendEmails(map);
                return returnObject2;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded(function, null);
            }
        }
        return null;
    }

    public ReturnObject sendEmails(XSession session, int uniqueKey, HashMap<String, Map<String, Serializable>> map, ICallback callback) throws Exception {
        String function = "AppointmentAccessorClient.sendEmails." + uniqueKey;
        if (this.isOkToCallFunction(function, null)) {
            try {
                ReturnObject returnObject = this.accessor.sendEmails(map);
                callback.response(returnObject);
                ReturnObject returnObject2 = returnObject;
                return returnObject2;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded(function, null);
            }
        }
        return null;
    }

    public ReturnObject sendTexto(XSession session, HashMap<String, Serializable> map) throws Exception {
        if (this.isOkToCallFunction("AppointmentAccessorClient.sendTexto", null)) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.sendTexto(map);
                return returnObject2;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("AppointmentAccessorClient.sendEmails", null);
            }
        }
        return null;
    }

    public void getProfessionalsWithSchedule(int uniqueKey, XSession session, LocalDate theDate, ICallback callback) {
        String function = "AppointmentAccessorClient.getProfessionalsWithSchedule" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = this.accessor.getProfessionalsWithSchedule(theDate);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, startDate=%s}", function, session, callback, theDate), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void findFutureAppointmentsByPatient(int uniqueKey, final XSession session, final ICallback callback, final int patientId) {
        final String function = "AppointmentAccessorClient.findFutureAppointmentsByPatient" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findFutureAppointmentsByPatient(patientId, null, null);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, patientId), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findFutureAppointmentsByPatientSync(int uniqueKey, XSession session, ICallback callback, int patientId) {
        String function = "AppointmentAccessorClient.findFutureAppointmentsByPatient" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = AppointmentAccessorClient.instance.accessor.findFutureAppointmentsByPatient(patientId, null, null);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, patientId), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void findFutureFamillyAppointmentsByPatient(int uniqueKey, final XSession session, final ICallback callback, final int patientId) {
        final String function = "AppointmentAccessorClient.findFutureFamillyAppointmentsByPatient" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findFutureFamillyAppointmentsByPatient(patientId, null);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, patientId), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPastAppointmentsByPatient(int uniqueKey, final XSession session, final ICallback callback, final int patientId) {
        final String function = "AppointmentAccessorClient.findPastAppointmentsByPatient" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findPastAppointmentsByPatient(patientId, null, null);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, patientId), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void setPatientStatus(int uniqueKey, final XSession session, final int appointmentId, final XPatientStatus ptStatusId, final ICallback callback) {
        final String function = "AppointmentAccessorClient.setPatientStatus" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.setPatientStatus(appointmentId, ptStatusId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, appointmentId=%s}", function, session, appointmentId), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void setPatientArrived(int uniqueKey, final XSession session, final int appointmentId, final ICallback callback) {
        final String function = "AppointmentAccessorClient.setPatientArrived" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.setPatientArrived(appointmentId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, appointmentId=%s}", function, session, appointmentId), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void setPatientSeen(int uniqueKey, final XSession session, final int appointmentId, final ICallback callback) {
        final String function = "AppointmentAccessorClient.setPatientSeen" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.setPatientSeen(appointmentId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, appointmentId=%s}", function, session, appointmentId), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void refreshFromServerSync(int uniqueKey, ICallback callback, XSession session, XAppointmentObjects list) {
        String function = "AppointmentAccessorClient.refreshFromServer" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = AppointmentAccessorClient.instance.accessor.getAppointmentObjects(list);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, appointmentId=%s}", function, session, list), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void synchronizedGetCompleteAppointmentDatasFromServer(XSession session, ICallback callback, LocalDate startDate, LocalDate endDate, List<Integer> professionalIds) {
        String function = "AppointmentAccessorClient.synchronizedGetCompleteAppointmentDatas" + AppointmentAccessorClient.getNextUniqueKey();
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    if (session != null) {
                        ReturnObject returnObject = this.accessor.getAppointmentCompleteDateContainer(startDate, endDate, professionalIds);
                        callback.response(returnObject);
                    }
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, startDate=%s, endDate=%s, professionalIds=%s}", function, session, callback, startDate, endDate, professionalIds), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void getBaseAppointmentDatesDeGarde(XSession session, ICallback callback, LocalDate date) {
        if (this.isOkToCallFunction("AppointmentAccessorClient.getAppointmentAppointmentDatesDeGarde", callback)) {
            try {
                try {
                    ReturnObject returnObject = this.accessor.getAppointmentAppointmentDatesDeGarde(date);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, dateIntervalsByProfessionnals=%s}", "AppointmentAccessorClient.getAppointmentAppointmentDatesDeGarde", session, callback, date), e);
                    this.functionCallEnded("AppointmentAccessorClient.getAppointmentAppointmentDatesDeGarde", callback);
                }
            }
            finally {
                this.functionCallEnded("AppointmentAccessorClient.getAppointmentAppointmentDatesDeGarde", callback);
            }
        }
    }

    public void synchronizedGetBaseAppointmentDatesFromServer(int uniqueKey, XSession session, ICallback callback, LocalDate startDate, LocalDate endDate, List<Integer> professionalIds) {
        String function = "AppointmentAccessorClient.synchronizedGetBaseAppointmentDatesFromServer" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = this.accessor.getAppointmentBaseAppointmentDates(startDate, endDate, professionalIds);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, startDate=%s, endDate=%s, professionalIds=%s}", function, session, callback, startDate, endDate, professionalIds), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void getBaseAppointmentDates2(int uniqueKey, XSession session, ICallback callback, HashMap<Integer, LocalDateRange> dateIntervalsByProfessionnals) {
        String function = "AppointmentAccessorClient.getBaseAppointmentDates2" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = this.accessor.getAppointmentBaseAppointmentDates2(dateIntervalsByProfessionnals);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, dateIntervalsByProfessionnals=%s}", function, session, callback, dateIntervalsByProfessionnals), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void synchronizedGetAppointmentDatesFromServer(int uniqueKey, XSession session, ICallback callback, LocalDate start, LocalDate end, List<Integer> professionalIds) {
        String function = "AppointmentAccessorClient.synchronizedGetAppointmentDatesFromServer" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = this.accessor.getAppointmentAppointmentDates(start, end, professionalIds);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, startDate=%s, endDate=%s, professionalIds=%s}", function, session, callback, start, end, professionalIds), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void synchronizedSave(int uniqueKey, XSession session, SaveCallback callback, boolean askQuestion, Serializable objectsToSave) {
        String function = "AppointmentAccessorClient.synchronizedSaveAppointmentDateContainer" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    callback.setAccessorClient(this);
                    callback.setDataObject(objectsToSave);
                    ReturnObject returnObject = AppointmentAccessorClient.instance.accessor.save(objectsToSave, askQuestion);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, objectsToSave=%s}", function, session, callback, objectsToSave), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void asynchronizedSave(int uniqueKey, final XSession session, final SaveCallback callback, final boolean askQuestion, final Serializable objectsToSave) {
        final String function = "AppointmentAccessorClient.asynchronizedSaveAppointmentDateContainer" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.setAccessorClient(AppointmentAccessorClient.this);
                            callback.setDataObject(objectsToSave);
                            ReturnObject returnObject = instance.accessor.save(objectsToSave, askQuestion);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, objectsToSave=%s}", function, session, callback, objectsToSave), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPatientRecall(XSession session, final ICallback callback, final XPatientRecallSearchCriteria criteria) {
        if (this.isOkToCallFunction("AppointmentAccessorClient.findPatientRecall", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = AppointmentAccessorClient.this.accessor.findPatientRecall(criteria);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.findPatientRecall", callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.findPatientRecall", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public List<XPatientRecall> findPatientRecallSync(XSession session, XPatientRecallSearchCriteria criteria) {
        String function = "AppointmentAccessorClient.findPatientRecallSync";
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = this.accessor.findPatientRecall(criteria);
                List list = (List)(returnObject == null ? Collections.emptyList() : returnObject.getObj());
                return list;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, criteria=%s}", function, session, criteria), e);
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return Collections.emptyList();
    }

    public void countPatientRecallAndFutureAppointmentSync(XSession session, ICallback callback, int idPatient) {
        String function = "AppointmentAccessorClient.countPatientRecallAndFutureAppointmentSync";
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = this.accessor.countPatientRecallAndFutureAppointment(idPatient);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, idPatient), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void suppressPatientRecallAndFutureAppointment(XSession session, ICallback callback, int idPatient) {
        String function = "AppointmentAccessorClient.suppressPatientRecallAndFutureAppointment";
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    ReturnObject returnObject = this.accessor.suppressPatientRecallAndFutureAppointment(idPatient);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, idPatient), e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void changePatientRecallStatus(final int uniqueKey, XSession session, final ICallback callback, final int patientRecallId, final XStatus newStatus) {
        if (this.isOkToCallFunction("ApplointmentAccessorClient.changePatientRecallStatus" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.changePatientRecallStatus(patientRecallId, newStatus);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            AppointmentAccessorClient.this.functionCallEnded("ApplointmentAccessorClient.changePatientRecallStatus" + uniqueKey, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded("ApplointmentAccessorClient.changePatientRecallStatus" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public MultiStatus changePatientRecallStatusSync(int uniqueKey, XSession session, int patientRecallId, XStatus newStatus) throws Exception {
        if (this.isOkToCallFunction("AppointmentAccessorClient.changePatientRecallStatus" + uniqueKey)) {
            try {
                ReturnObject returnObject = AppointmentAccessorClient.instance.accessor.changePatientRecallStatus(patientRecallId, newStatus);
                MultiStatus multiStatus = returnObject.getStatus();
                return multiStatus;
            }
            catch (Exception e) {
                Log.severe((String)"Erreur", (Exception)e);
                throw e;
            }
            finally {
                this.functionCallEnded("ApplointmentAccessorClient.changePatientRecallStatus" + uniqueKey);
            }
        }
        return null;
    }

    public void setPatientRecallNote(final int uniqueKey, XSession session, final ICallback callback, final int patientRecallId, final String note) {
        if (this.isOkToCallFunction("ApplointmentAccessorClient.setPatientRecallNote" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.setPatientRecallNote(patientRecallId, note);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            AppointmentAccessorClient.this.functionCallEnded("ApplointmentAccessorClient.setPatientRecallNote" + uniqueKey, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded("ApplointmentAccessorClient.setPatientRecallNote" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void changeAppointmentDateMessage(final XSession session, final List<LocalDate> dates, final List<Integer> professionnalIds, final String message, final XAppointmentDateMessageType type) {
        if (this.isOkToCallFunction("AppointmentAccessorClient.addAppointmentDateMessage", null)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            instance.accessor.changeAppointmentDateMessage(dates, professionnalIds, message, type);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s}", "AppointmentAccessorClient.addAppointmentDateMessage", session), e);
                            AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.addAppointmentDateMessage", null);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.addAppointmentDateMessage", null);
                    }
                    return null;
                }
            };
        }
    }

    public void changeAppointmentDateDeGardeTypes(final XSession session, final List<LocalDate> dates, final List<Integer> professionnalIds, final List<XAppointmentDateDeGardeType> types, final ICallback callback) {
        if (this.isOkToCallFunction("AppointmentAccessorClient.addAppointmentDateDeGardeType", null)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.changeAppointmentDateDeGardeTypes(dates, professionnalIds, types);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s}", "AppointmentAccessorClient.addAppointmentDateDeGardeType", session), e);
                            AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.addAppointmentDateDeGardeType", null);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.addAppointmentDateDeGardeType", null);
                    }
                    return null;
                }
            };
        }
    }

    public void changeAppointmentDateDeGardeType(final XSession session, final List<LocalDate> dates, final List<Integer> professionnalIds, final XAppointmentDateDeGardeType type, final ICallback callback) {
        if (this.isOkToCallFunction("AppointmentAccessorClient.addAppointmentDateDeGardeType", null)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.changeAppointmentDateDeGardeType(dates, professionnalIds, type);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s}", "AppointmentAccessorClient.addAppointmentDateDeGardeType", session), e);
                            AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.addAppointmentDateDeGardeType", null);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded("AppointmentAccessorClient.addAppointmentDateDeGardeType", null);
                    }
                    return null;
                }
            };
        }
    }

    protected IAppointmentAccessor getAccessor() {
        return this.accessor;
    }

    public void findAvailableAppointmentSpaces(final XSearchPeriodCriteria c, int uniqueKey, final XSession session, final ICallback callback) {
        final String function = "AppointmentAccessorClient.findAvailableAppointmentSpaces" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findAvailableAppointmentSpaces(c);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, c), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getPatientRecall(int uniqueKey, final XSession session, final ICallback callback, final int idRecall, final boolean xbase) {
        final String function = "AppointmentAccessorClient.getPatientRecall" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.getPatientRecall(idRecall, xbase);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, idRecall=%s}", function, session, callback, idRecall), e);
                            AppointmentAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        AppointmentAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }
}

