/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain.fco;

import ca.infodata.dsq.service.DSQTimeSourceProvider;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;
import java.util.TimeZone;
import org.w3c.dom.Node;

public final class CandidateConsentDirective
implements Serializable {
    private static final long MININUM_EFFECTIVE_START_TIME = Helper.parseDATETIME_NONSTRICT("20070101000000", TimeZone.getTimeZone("GMT"));
    private static final long serialVersionUID = 1L;
    private transient Node consentEventNode;
    private boolean hasAccepted;
    private Long effectiveStartTime;
    private Long expirationDatetime;

    public CandidateConsentDirective(Node consentEventNode, boolean hasAccepted, Long effectiveEndTime) {
        this.consentEventNode = consentEventNode;
        this.hasAccepted = hasAccepted;
        this.expirationDatetime = effectiveEndTime;
    }

    public CandidateConsentDirective(Node consentEventNode, boolean hasAccepted, Long effectiveStartTime, Long effectiveEndTime) {
        this.consentEventNode = consentEventNode;
        this.hasAccepted = hasAccepted;
        this.expirationDatetime = effectiveEndTime;
        this.effectiveStartTime = effectiveStartTime;
    }

    public boolean hasAccepted() {
        return this.hasAccepted;
    }

    public Node getConsentEventNode() {
        return this.consentEventNode;
    }

    public Long getExpirationDatetime() {
        return this.expirationDatetime;
    }

    public boolean hasPastConsentRefusal() {
        return this.effectiveStartTime != null && this.effectiveStartTime != MININUM_EFFECTIVE_START_TIME;
    }

    public Long getEffectiveStartTime() {
        return this.effectiveStartTime;
    }

    public String toString() {
        return String.format("CandidateConsentDirective [consentEventNode=%s, expirationDatetime=%s, effectiveStartTime=%s, hasAccepted=%s, hasPastRefusal=%s]", this.consentEventNode, this.expirationDatetime, this.effectiveStartTime, this.hasAccepted, this.hasPastConsentRefusal());
    }

    public void valid() {
        if (!this.hasAccepted()) {
            throw new IllegalArgumentException("candidate has not accepted");
        }
        if (this.getConsentEventNode() == null) {
            throw new NullPointerException("consentDirective.node");
        }
        if (this.getExpirationDatetime() != null && this.getExpirationDatetime() <= DSQTimeSourceProvider.currentTimeMillis()) {
            throw new IllegalArgumentException("consentDirective is expired");
        }
    }
}

