/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.ApprovedRequest;
import ca.infodata.dsq.signature.Signature;
import java.io.Serializable;

public final class ToBeApprovedRequest<C extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String eventType;
    public final String eventId;
    public final long eventTime;
    public final String hash;
    public final C criteria;
    public final String xml;

    public ToBeApprovedRequest(String eventType, String eventId, long eventTime, String hash, String xml, C criteria) {
        if (eventId == null) {
            throw new NullPointerException("eventId");
        }
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        if (hash == null) {
            throw new NullPointerException("hash");
        }
        if (xml == null) {
            throw new NullPointerException("xml");
        }
        if (criteria == null) {
            throw new NullPointerException("criteria");
        }
        this.eventType = eventType;
        this.eventId = eventId;
        this.eventTime = eventTime;
        this.hash = hash;
        this.criteria = criteria;
        this.xml = xml;
    }

    public ApprovedRequest<C> toApprovedRequest(Signature signature) {
        return new ApprovedRequest<C>(this.eventType, this.eventId, this.eventTime, this.hash, this.xml, signature, this.criteria);
    }

    public String toString() {
        return String.format("NonApprovedRequest [eventType=%s, eventId=%s, eventTime=%s, hash=%s, criteria=%s]", this.eventType, this.eventId, this.eventTime, this.hash, this.criteria);
    }
}

