/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.DispenseDetails;
import ca.infodata.dsq.domain.Duration;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.Ingredient;
import ca.infodata.dsq.domain.Quantity;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;
import java.util.ArrayList;

public final class DispenseSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int sequence;
    public String id;
    public DispenseDetails dispenseDetails;
    public Long date;
    public String status;
    public IProvider performer;
    public ILocation location;
    public Quantity quantity;
    public Duration expectedUseTime;
    public Code drugCode;
    public String drugName;
    public String drugDescription;
    public Code drugFormCode;
    public String drugLotNumber;
    public String drugExpiryDate;
    public ArrayList<Ingredient> drugIngredients;
    public String dosageInstructions;
    public String prescriptionId;
    public String prescriptionVersion;
    public Long prescriptionDate;
    public String prescriptionStatus;
    public IProvider prescriber;
    public Boolean hasIssues;
    public Boolean hasAnnotations;

    public DispenseSummary() {
    }

    public DispenseSummary(String id, Long date, String status, IProvider performer, ILocation location, Quantity quantity, Duration expectedUseTime, Code drugCode, String drugName, String drugDescription, Code drugFormCode, String drugLotNumber, String drugExpiryDate, ArrayList<Ingredient> drugIngredients, String dosageInstructions, String prescriptionId, String prescriptionVersion, Long prescriptionDate, String prescriptionStatus, IProvider prescriber, Boolean hasIssues, Boolean hasAnnotations) {
        this.id = id;
        this.date = date;
        this.status = status;
        this.performer = performer;
        this.location = location;
        this.quantity = quantity;
        this.expectedUseTime = expectedUseTime;
        this.drugCode = drugCode;
        this.drugName = drugName;
        this.drugDescription = drugDescription;
        this.drugFormCode = drugFormCode;
        this.drugLotNumber = drugLotNumber;
        this.drugExpiryDate = drugExpiryDate;
        this.drugIngredients = drugIngredients;
        this.dosageInstructions = dosageInstructions;
        this.prescriptionId = prescriptionId;
        this.prescriptionVersion = prescriptionVersion;
        this.prescriptionDate = prescriptionDate;
        this.prescriptionStatus = prescriptionStatus;
        this.prescriber = prescriber;
        this.hasIssues = hasIssues;
        this.hasAnnotations = hasAnnotations;
    }

    public String toString() {
        return String.format("DrugDispenseSummary [id=%s, value=%s, date=%s(%s)\nPerformer %s\nLocation %s\nDrug [DIN=%s, name=%s, desc=%s, lotNumber=%s, expiryDate=%s],\nMagistral [formCode=%s, ingredients=%s],\nPosology quantity=%s, expectedUseTime=%s, dosage=%s,\nPrescription [id=%s, ver=%s, value=%s, date=%s]\nPrescriber %s\nhasIssues=%s, hasAnnotations=%s]", this.id, this.status, this.date, Helper.formatFULLDATETIME(this.date), this.performer, this.location, this.drugCode, this.drugName, this.drugDescription, this.drugLotNumber, this.drugExpiryDate, this.drugFormCode, this.drugIngredients, this.quantity, this.expectedUseTime, this.dosageInstructions, this.prescriptionId, this.prescriptionVersion, this.prescriptionStatus, this.prescriptionDate, this.prescriber, this.hasIssues, this.hasAnnotations);
    }
}

