/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.lm;

import org.ddogleg.optimization.FactoryNumericalDerivative;
import org.ddogleg.optimization.GaussNewtonBase_F64;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.optimization.lm.LevenbergMarquardt_F64;
import org.ddogleg.optimization.math.HessianLeastSquares;
import org.ddogleg.optimization.math.MatrixMath;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.ReshapeMatrix;

public class UnconLeastSqLevenbergMarquardt_F64<S extends DMatrix>
extends LevenbergMarquardt_F64<S, HessianLeastSquares<S>>
implements UnconstrainedLeastSquares<S> {
    S jacobian;
    protected FunctionNtoM functionResiduals;
    protected FunctionNtoMxN<S> functionJacobian;

    public UnconLeastSqLevenbergMarquardt_F64(MatrixMath<S> math, HessianLeastSquares<S> hessian) {
        super(math, hessian);
        this.jacobian = math.createMatrix();
    }

    @Override
    public void setFunction(FunctionNtoM function, FunctionNtoMxN<S> jacobian) {
        this.functionResiduals = function;
        this.functionJacobian = jacobian == null ? FactoryNumericalDerivative.jacobianForwards(function, this.jacobian.getClass()) : jacobian;
        int M = this.functionResiduals.getNumOfOutputsM();
        int N = this.functionResiduals.getNumOfInputsN();
        ((ReshapeMatrix)this.jacobian).reshape(M, N);
    }

    @Override
    public void initialize(double[] initial, double ftol, double gtol) {
        ((ConfigLevenbergMarquardt)this.config).ftol = ftol;
        ((ConfigLevenbergMarquardt)this.config).gtol = gtol;
        super.initialize(initial, this.functionResiduals.getNumOfInputsN(), this.functionResiduals.getNumOfOutputsM());
    }

    @Override
    public double[] getParameters() {
        return this.x.data;
    }

    @Override
    public double getFunctionValue() {
        return this.fx;
    }

    @Override
    public boolean isUpdated() {
        return this.mode == GaussNewtonBase_F64.Mode.COMPUTE_DERIVATIVES;
    }

    @Override
    public boolean isConverged() {
        return this.mode == GaussNewtonBase_F64.Mode.CONVERGED;
    }

    @Override
    protected void functionGradientHessian(DMatrixRMaj x, boolean sameStateAsResiduals, DMatrixRMaj gradient, HessianLeastSquares<S> hessian) {
        if (!sameStateAsResiduals) {
            this.functionResiduals.process(x.data, this.residuals.data);
        }
        this.functionJacobian.process(x.data, this.jacobian);
        hessian.updateHessian(this.jacobian);
        this.math.multTransA(this.jacobian, this.residuals, gradient);
    }

    @Override
    protected void computeResiduals(DMatrixRMaj x, DMatrixRMaj residuals) {
        this.functionResiduals.process(x.data, residuals.data);
    }
}

