/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper.images;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class JpegByteImageSequence<T extends ImageBase<T>>
implements SimpleImageSequence<T> {
    int index;
    List<byte[]> jpegData = new ArrayList<byte[]>();
    ImageType<T> imageType;
    BufferedImage imageGUI;
    T output;
    BufferedImage imageNext;
    boolean loop = false;
    boolean forward = true;

    public JpegByteImageSequence(ImageType<T> imageType, List<byte[]> jpegData, boolean loop) {
        this.imageType = imageType;
        this.jpegData = jpegData;
        this.loop = loop;
        this.output = imageType.createImage(1, 1);
        this.loadNext();
    }

    public JpegByteImageSequence(Class<T> imageType, List<byte[]> jpegData, boolean loop) {
        this(ImageType.single(imageType), jpegData, loop);
    }

    @Override
    public int getNextWidth() {
        return this.imageNext.getWidth();
    }

    @Override
    public int getNextHeight() {
        return this.imageNext.getHeight();
    }

    @Override
    public boolean hasNext() {
        return this.loop || this.index < this.jpegData.size();
    }

    @Override
    public T next() {
        this.imageGUI = this.imageNext;
        ((ImageBase)this.output).reshape(this.imageGUI.getWidth(), this.imageGUI.getHeight());
        ConvertBufferedImage.convertFrom(this.imageGUI, this.output, true);
        if (this.forward) {
            ++this.index;
            if (this.loop && this.index >= this.jpegData.size()) {
                this.index = this.jpegData.size() - 1;
                this.forward = false;
            }
        } else {
            --this.index;
            if (this.loop && this.index < 0) {
                this.index = 1;
                this.forward = true;
            }
        }
        if (this.hasNext()) {
            this.loadNext();
        }
        return this.output;
    }

    private void loadNext() {
        try {
            this.imageNext = ImageIO.read(new ByteArrayInputStream(this.jpegData.get(this.index)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public BufferedImage getGuiImage() {
        return this.imageGUI;
    }

    @Override
    public void close() {
    }

    @Override
    public int getFrameNumber() {
        return this.index;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void reset() {
        this.index = 0;
        this.forward = true;
    }
}

