/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.abst.sfm.d2.WrapImageMotionPtkSmartRespawn;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.robust.DistanceAffine2DSq;
import boofcv.alg.geo.robust.DistanceHomographySq;
import boofcv.alg.geo.robust.DistanceSe2Sq;
import boofcv.alg.geo.robust.GenerateAffine2D;
import boofcv.alg.geo.robust.GenerateHomographyLinear;
import boofcv.alg.geo.robust.GenerateSe2_AssociatedPair;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.sfm.d2.FactoryStitchingTransform;
import boofcv.alg.sfm.d2.ImageMotionPointTrackerKey;
import boofcv.alg.sfm.d2.ImageMotionPtkSmartRespawn;
import boofcv.alg.sfm.d2.StitchingFromMotion2D;
import boofcv.alg.sfm.d2.StitchingTransform;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.fitting.affine.ModelManagerAffine2D_F64;
import georegression.fitting.homography.ModelManagerHomography2D_F64;
import georegression.fitting.se.ModelManagerSe2_F64;
import georegression.fitting.se.MotionSe2PointSVD_F64;
import georegression.struct.InvertibleTransform;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.se.Se2_F64;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class FactoryMotion2D {
    public static <I extends ImageBase<I>, IT extends InvertibleTransform> ImageMotion2D<I, IT> createMotion2D(int ransacIterations, double inlierThreshold, int outlierPrune, int absoluteMinimumTracks, double respawnTrackFraction, double respawnCoverageFraction, boolean refineEstimate, PointTracker<I> tracker, IT motionModel) {
        DistanceFromModel<Homography2D_F64, AssociatedPair> distance;
        ModelGenerator<Homography2D_F64, AssociatedPair> fitter;
        ModelManager<Affine2D_F64> manager;
        ModelFitter<Homography2D_F64, AssociatedPair> mf;
        ModelFitter<Homography2D_F64, AssociatedPair> modelRefiner = null;
        if (motionModel instanceof Homography2D_F64) {
            mf = new GenerateHomographyLinear(true);
            manager = new ModelManagerHomography2D_F64();
            fitter = mf;
            if (refineEstimate) {
                modelRefiner = mf;
            }
            distance = new DistanceHomographySq();
        } else if (motionModel instanceof Affine2D_F64) {
            manager = new ModelManagerAffine2D_F64();
            fitter = mf = new GenerateAffine2D();
            if (refineEstimate) {
                modelRefiner = mf;
            }
            distance = new DistanceAffine2DSq();
        } else if (motionModel instanceof Se2_F64) {
            manager = new ModelManagerSe2_F64();
            MotionSe2PointSVD_F64 alg = new MotionSe2PointSVD_F64();
            GenerateSe2_AssociatedPair mf2 = new GenerateSe2_AssociatedPair(alg);
            fitter = mf2;
            distance = new DistanceSe2Sq();
        } else {
            throw new RuntimeException("Unknown model type: " + motionModel.getClass().getSimpleName());
        }
        Ransac<Homography2D_F64, AssociatedPair> modelMatcher = new Ransac<Homography2D_F64, AssociatedPair>(123123L, manager, fitter, distance, ransacIterations, inlierThreshold);
        ImageMotionPointTrackerKey<I, Homography2D_F64> lowlevel = new ImageMotionPointTrackerKey<I, Homography2D_F64>(tracker, (ModelMatcher<Homography2D_F64, AssociatedPair>)modelMatcher, modelRefiner, (Homography2D_F64)motionModel, outlierPrune);
        ImageMotionPtkSmartRespawn<I, Homography2D_F64> smartRespawn = new ImageMotionPtkSmartRespawn<I, Homography2D_F64>(lowlevel, absoluteMinimumTracks, respawnTrackFraction, respawnCoverageFraction);
        return new WrapImageMotionPtkSmartRespawn<I, Homography2D_F64>(smartRespawn);
    }

    public static <I extends ImageBase<I>, IT extends InvertibleTransform> StitchingFromMotion2D<I, IT> createVideoStitch(double maxJumpFraction, ImageMotion2D<I, IT> motion2D, ImageType<I> imageType) {
        StitchingTransform<InvertibleTransform<Affine2D_F64>> transform = motion2D.getTransformType() == Affine2D_F64.class ? FactoryStitchingTransform.createAffine_F64() : FactoryStitchingTransform.createHomography_F64();
        if (imageType.getFamily() != ImageType.Family.GRAY && imageType.getFamily() != ImageType.Family.PLANAR) {
            throw new IllegalArgumentException("Unsupported image type");
        }
        InterpolatePixelS interp = FactoryInterpolation.createPixelS(0.0, 255.0, InterpolationType.BILINEAR, BorderType.EXTENDED, imageType.getImageClass());
        ImageDistort distorter = FactoryDistort.distort(false, interp, imageType);
        distorter.setRenderAll(false);
        return new StitchingFromMotion2D<I, Affine2D_F64>(motion2D, distorter, transform, maxJumpFraction);
    }
}

