/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii;

import boofcv.alg.transform.ii.IntegralImageOps;
import boofcv.alg.transform.ii.IntegralKernel;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class GIntegralImageOps {
    public static <I extends ImageGray<I>, II extends ImageGray<II>> Class<II> getIntegralType(Class<I> inputType) {
        if (inputType == GrayF32.class) {
            return GrayF32.class;
        }
        if (inputType == GrayU8.class) {
            return GrayS32.class;
        }
        if (inputType == GrayS32.class) {
            return GrayS32.class;
        }
        throw new IllegalArgumentException("Unknown input image type: " + inputType.getSimpleName());
    }

    public static <I extends ImageGray<I>, T extends ImageGray> T transform(I input, T transformed) {
        if (input instanceof GrayF32) {
            return (T)IntegralImageOps.transform((GrayF32)input, (GrayF32)transformed);
        }
        if (input instanceof GrayF64) {
            return (T)IntegralImageOps.transform((GrayF64)input, (GrayF64)transformed);
        }
        if (input instanceof GrayU8) {
            return (T)IntegralImageOps.transform((GrayU8)input, (GrayS32)transformed);
        }
        if (input instanceof GrayS32) {
            return (T)IntegralImageOps.transform((GrayS32)input, (GrayS32)transformed);
        }
        if (input instanceof GrayS64) {
            return (T)IntegralImageOps.transform((GrayS64)input, (GrayS64)transformed);
        }
        throw new IllegalArgumentException("Unknown input type: " + input.getClass().getSimpleName());
    }

    public static <T extends ImageGray<T>> T convolve(T integral, IntegralKernel kernel, T output) {
        if (integral instanceof GrayF32) {
            return (T)IntegralImageOps.convolve((GrayF32)integral, kernel, (GrayF32)output);
        }
        if (integral instanceof GrayF64) {
            return (T)IntegralImageOps.convolve((GrayF64)integral, kernel, (GrayF64)output);
        }
        if (integral instanceof GrayS32) {
            return (T)IntegralImageOps.convolve((GrayS32)integral, kernel, (GrayS32)output);
        }
        if (integral instanceof GrayS64) {
            return (T)IntegralImageOps.convolve((GrayS64)integral, kernel, (GrayS64)output);
        }
        throw new IllegalArgumentException("Unknown input type: " + integral.getClass().getSimpleName());
    }

    public static <T extends ImageGray<T>> T convolveBorder(T integral, IntegralKernel kernel, T output, int borderX, int borderY) {
        if (integral instanceof GrayF32) {
            return (T)IntegralImageOps.convolveBorder((GrayF32)integral, kernel, (GrayF32)output, borderX, borderY);
        }
        if (integral instanceof GrayF64) {
            return (T)IntegralImageOps.convolveBorder((GrayF64)integral, kernel, (GrayF64)output, borderX, borderY);
        }
        if (integral instanceof GrayS32) {
            return (T)IntegralImageOps.convolveBorder((GrayS32)integral, kernel, (GrayS32)output, borderX, borderY);
        }
        if (integral instanceof GrayS64) {
            return (T)IntegralImageOps.convolveBorder((GrayS64)integral, kernel, (GrayS64)output, borderX, borderY);
        }
        throw new IllegalArgumentException("Unknown input type");
    }

    public static <T extends ImageGray<T>> double convolveSparse(T integral, IntegralKernel kernel, int x, int y) {
        if (integral instanceof GrayF32) {
            return IntegralImageOps.convolveSparse((GrayF32)integral, kernel, x, y);
        }
        if (integral instanceof GrayF64) {
            return IntegralImageOps.convolveSparse((GrayF64)integral, kernel, x, y);
        }
        if (integral instanceof GrayS32) {
            return IntegralImageOps.convolveSparse((GrayS32)integral, kernel, x, y);
        }
        if (integral instanceof GrayS64) {
            return IntegralImageOps.convolveSparse((GrayS64)integral, kernel, x, y);
        }
        throw new IllegalArgumentException("Unknown input type");
    }

    public static <T extends ImageGray<T>> double block_zero(T integral, int x0, int y0, int x1, int y1) {
        if (integral instanceof GrayF32) {
            return IntegralImageOps.block_zero((GrayF32)integral, x0, y0, x1, y1);
        }
        if (integral instanceof GrayF64) {
            return IntegralImageOps.block_zero((GrayF64)integral, x0, y0, x1, y1);
        }
        if (integral instanceof GrayS32) {
            return IntegralImageOps.block_zero((GrayS32)integral, x0, y0, x1, y1);
        }
        if (integral instanceof GrayS64) {
            return IntegralImageOps.block_zero((GrayS64)integral, x0, y0, x1, y1);
        }
        throw new IllegalArgumentException("Unknown input type");
    }

    public static <T extends ImageGray<T>> double block_unsafe(T integral, int x0, int y0, int x1, int y1) {
        if (integral instanceof GrayF32) {
            return IntegralImageOps.block_unsafe((GrayF32)integral, x0, y0, x1, y1);
        }
        if (integral instanceof GrayF64) {
            return IntegralImageOps.block_unsafe((GrayF64)integral, x0, y0, x1, y1);
        }
        if (integral instanceof GrayS32) {
            return IntegralImageOps.block_unsafe((GrayS32)integral, x0, y0, x1, y1);
        }
        if (integral instanceof GrayS64) {
            return IntegralImageOps.block_unsafe((GrayS64)integral, x0, y0, x1, y1);
        }
        throw new IllegalArgumentException("Unknown input type");
    }
}

