/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block.select;

import boofcv.alg.feature.disparity.block.SelectSparseStandardWta;

public class SelectSparseErrorWithChecksWta_S32
extends SelectSparseStandardWta<int[]> {
    protected int textureThreshold;
    protected static final int discretizer = 10000;

    public SelectSparseErrorWithChecksWta_S32(int maxError, double texture) {
        super(maxError, texture);
    }

    @Override
    protected void setTexture(double texture) {
        this.textureThreshold = (int)(10000.0 * texture);
    }

    @Override
    public boolean select(int[] scores, int disparityMax) {
        int disparity = 0;
        int best = scores[0];
        for (int i = 1; i < disparityMax; ++i) {
            if (scores[i] >= best) continue;
            best = scores[i];
            disparity = i;
        }
        if (best > this.maxError) {
            return false;
        }
        if (this.textureThreshold > 0) {
            int i;
            int secondBest = Integer.MAX_VALUE;
            for (i = 0; i < disparity - 1; ++i) {
                if (scores[i] >= secondBest) continue;
                secondBest = scores[i];
            }
            for (i = disparity + 2; i < disparityMax; ++i) {
                if (scores[i] >= secondBest) continue;
                secondBest = scores[i];
            }
            if (10000 * (secondBest - best) <= this.textureThreshold * best) {
                return false;
            }
        }
        this.disparity = disparity;
        return true;
    }
}

