/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block.score;

import boofcv.alg.feature.disparity.block.DisparitySparseScoreSadRect;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.image.GrayF32;
import java.util.Arrays;

public class DisparitySparseScoreBM_SAD_F32
extends DisparitySparseScoreSadRect<float[], GrayF32> {
    float[] scores;

    public DisparitySparseScoreBM_SAD_F32(int radiusX, int radiusY) {
        super(radiusX, radiusY);
    }

    @Override
    public void configure(int disparityMin, int disparityRange) {
        super.configure(disparityMin, disparityRange);
        this.scores = new float[disparityRange];
    }

    @Override
    public boolean process(int x, int y) {
        if (x < this.disparityMin) {
            return false;
        }
        this.localMaxRange = Math.min(x, this.disparityMax) - this.disparityMin + 1;
        Arrays.fill(this.scores, 0.0f);
        if (x < this.localMaxRange + this.radiusX + this.disparityMin || x >= ((GrayF32)this.left).width - this.radiusX || y < this.radiusY || y >= ((GrayF32)this.left).height - this.radiusY) {
            this.scoreBorder(x, y);
        } else {
            this.scoreInner(x, y);
        }
        return true;
    }

    private void scoreBorder(int cx, int cy) {
        ImageBorder_F32 bleft = (ImageBorder_F32)this.bleft;
        ImageBorder_F32 bright = (ImageBorder_F32)this.bright;
        for (int y = -this.radiusY; y <= this.radiusY; ++y) {
            int d = 0;
            while (d < this.localMaxRange) {
                float score = 0.0f;
                for (int x = -this.radiusX; x <= this.radiusX; ++x) {
                    float diff = bleft.get(cx + x, cy + y) - bright.get(cx + x - d - this.disparityMin, cy + y);
                    score += Math.abs(diff);
                }
                int n = d++;
                this.scores[n] = this.scores[n] + score;
            }
        }
    }

    private void scoreInner(int x, int y) {
        for (int row = 0; row < this.regionHeight; ++row) {
            int startLeft = ((GrayF32)this.left).startIndex + ((GrayF32)this.left).stride * (y - this.radiusY + row) + x - this.radiusX;
            int startRight = ((GrayF32)this.right).startIndex + ((GrayF32)this.right).stride * (y - this.radiusY + row) + x - this.radiusX - this.disparityMin;
            int i = 0;
            while (i < this.localMaxRange) {
                int indexLeft = startLeft;
                int indexRight = startRight - i;
                float score = 0.0f;
                for (int j = 0; j < this.regionWidth; ++j) {
                    float diff = ((GrayF32)this.left).data[indexLeft++] - ((GrayF32)this.right).data[indexRight++];
                    score += Math.abs(diff);
                }
                int n = i++;
                this.scores[n] = this.scores[n] + score;
            }
        }
    }

    @Override
    public float[] getScore() {
        return this.scores;
    }

    @Override
    public Class<GrayF32> getImageType() {
        return GrayF32.class;
    }
}

