/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.File;
import java.lang.reflect.Field;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.ReflectClass;
import org.eclipse.swt.tools.internal.ReflectItem;
import org.eclipse.swt.tools.internal.ReflectType;

public class ReflectField
extends ReflectItem
implements JNIField {
    Field field;
    ReflectType type;
    ReflectType type64;
    ReflectClass declaringClass;

    public ReflectField(ReflectClass declaringClass, Field field, String source, CompilationUnit unit) {
        this.declaringClass = declaringClass;
        this.field = field;
        Class<?> clazz = field.getType();
        this.type64 = this.type = new ReflectType(clazz);
        boolean changes = this.canChange64(clazz);
        if (changes && new File(declaringClass.sourcePath).exists()) {
            TypeDeclaration type1 = (TypeDeclaration)unit.types().get(0);
            Object result = null;
            FieldDeclaration[] fields = type1.getFields();
            int i = 0;
            while (i < fields.length && result == null) {
                FieldDeclaration node = fields[i];
                for (VariableDeclarationFragment decl : node.fragments()) {
                    if (!decl.getName().getIdentifier().equals(field.getName())) continue;
                    String s = source.substring(node.getStartPosition(), node.getStartPosition() + node.getLength());
                    if (clazz == Integer.TYPE && s.indexOf("int /*long*/") != -1) {
                        this.type64 = new ReflectType(Long.TYPE);
                        break;
                    }
                    if (clazz == Float.TYPE && s.indexOf("float /*double*/") != -1) {
                        this.type64 = new ReflectType(Double.TYPE);
                        break;
                    }
                    if (clazz == int[].class && (s.indexOf("int /*long*/") != -1 || s.indexOf("int[] /*long[]*/") != -1)) {
                        this.type64 = new ReflectType(long[].class);
                        break;
                    }
                    if (clazz == float[].class && (s.indexOf("float /*double*/") != -1 || s.indexOf("float[] /*double[]*/") != -1)) {
                        this.type = new ReflectType(double[].class);
                        break;
                    }
                    if (clazz == Long.TYPE && s.indexOf("long /*int*/") != -1) {
                        this.type = new ReflectType(Integer.TYPE);
                        break;
                    }
                    if (clazz == Double.TYPE && s.indexOf("double /*float*/") != -1) {
                        this.type = new ReflectType(Float.TYPE);
                        break;
                    }
                    if (clazz == long[].class && (s.indexOf("long /*int*/") != -1 || s.indexOf("long[] /*int[]*/") != -1)) {
                        this.type = new ReflectType(int[].class);
                        break;
                    }
                    if (clazz != double[].class || s.indexOf("double /*float*/") == -1 && s.indexOf("double[] /*float[]*/") == -1) break;
                    this.type = new ReflectType(float[].class);
                    break;
                }
                ++i;
            }
        }
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReflectField)) {
            return false;
        }
        return ((ReflectField)obj).field.equals(this.field);
    }

    @Override
    public JNIClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public int getModifiers() {
        return this.field.getModifiers();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public JNIType getType() {
        return this.type;
    }

    @Override
    public JNIType getType64() {
        return this.type64;
    }

    @Override
    public String getAccessor() {
        return (String)this.getParam("accessor");
    }

    @Override
    public String getCast() {
        String cast = ((String)this.getParam("cast")).trim();
        if (cast.length() > 0) {
            if (!cast.startsWith("(")) {
                cast = "(" + cast;
            }
            if (!cast.endsWith(")")) {
                cast = String.valueOf(cast) + ")";
            }
        }
        return cast;
    }

    @Override
    public String getExclude() {
        return (String)this.getParam("exclude");
    }

    @Override
    public String getMetaData() {
        String className = this.getDeclaringClass().getSimpleName();
        String key = String.valueOf(className) + "_" + this.field.getName();
        return this.declaringClass.metaData.getMetaData(key, "");
    }

    @Override
    public void setAccessor(String str) {
        this.setParam("accessor", str);
    }

    @Override
    public void setCast(String str) {
        this.setParam("cast", str);
    }

    @Override
    public void setExclude(String str) {
        this.setParam("exclude", str);
    }

    @Override
    public void setMetaData(String value) {
        String className = this.declaringClass.getSimpleName();
        String key = String.valueOf(className) + "_" + this.field.getName();
        this.declaringClass.metaData.setMetaData(key, value);
    }

    public String toString() {
        return this.field.toString();
    }
}

