(function(){
	var employee = angular.module('employee', []);
	
	/**
	 * @ngdoc directive
	 * @name patient.directive:employeeEdit
	 * @restrict E
	 * @scope
	 * @param {object} patient Pass the patient we want the edit form to open on
	 * @Description
	 * Directive opening the patient edit and creation form.
	 * @example
	 * <patient-edit patient="model.patient().currPatient"><patient-edit>
	 */
	employee.directive('employeeEdit',
						['utils', '$q', '$timeout', 'model','ProfAccessor','FlView','ModificationStatus', 'PrefAccessor',
						 '$filter','PatientFormService','UserAccessor','QConfirm','QValidation','Rights','QuickView', 'Event',
					function(utils, $q, $timeout, model, ProfAccessor, FlView, ModificationStatus, prefAccessor,
							 $filter, PatientFormService, UserAccessor, QConfirm, QValidation, Rights, QuickView, Event){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/employee/profil/employee_edit.html?v=bb',
			scope: {
				patient: "=",
				options: "=?",
				qv: "=?"
			},
			link: function(scope, element, attrs){
				scope.uiready = false;// required for loading lists otherwise refresh bugs appear.
				scope.isReadOnly = !model.user().isUserAdmin; //USER_MANAGEMENT||INFODATA  // !model.roles().hasOneOfRoles(["USER_MANAGEMENT"]);
				scope.isDirty = false;
				scope.isAdmin = model.roles().hasOneOfRoles(['ADMIN']);
				scope.editPatientStatus = false;
				scope.isUserAdmin = model.user().isUserAdmin;
				//init patient for when its a new patient
				var defaultPatientData = {
					modificationStatus: ModificationStatus.STATUS_NEUTRAL,
					gender:'I',
					version:0,
					tag:0,
					maritalStatus: 0,
					race: 0,
					lstAddress:[],
					lstContactInformation:[],
					lstSites:[],
				};
				var defaultOptions = {
					showExit: false
				};

				if(!scope.options){
					scope.options = {};
				}

				scope.options =  OfysUtils.extendIfNotDefined(scope.options, angular.copy(defaultOptions));
				// scope.editPatient = angular.copy(defaultPatientData);
				
				scope.languageCodes = [{val:0,name:'French'},{val:1,name:'English'},{val:2,name:'Spanish'},{val:3,name:'Other'}];
				scope.allRaces = [
					{val: 0, name: 'Caucasian'},
					{val: 1, name: 'Native'},
					{val: 2, name: 'African'},
					{val: 3, name: 'Latino'},
					{val: 4, name: 'Asian'},
					{val: 5, name: 'Chinese'},
					{val: 6, name: 'Filipino'},
					{val: 7, name: 'Arab'},
					{val: 8, name: 'Japanese'},
					{val: 9, name: 'Korean'},
					{val: 10, name:'Other'},
					{val: 11, name:'Unspecified'}
				];

				UserAccessor.getAllCitizenships(function(citizenships){
					scope.allCitizenships = citizenships;
				});

//				UserAccessor.getAllEmployeeTypes(function(employeeTypes){
//					scope.allEmployeeTypes = Object.values(employeeTypes);
//					scope.allEmployeeTypes.sort(function(a, b){
//						if(a.i18n > b.i18n){
//							return 1;
//						}else if(b.i18n > a.i18n){
//							return -1;
//						}
//						return 0;
//					})
//					if(scope.editPatient && !scope.editPatient.type){
//						var obj = scope.allEmployeeTypes.filter(obj => {
//								return obj.value == 0;
//							})
//						scope.editPatient.type = obj[0].type;
//					}
//				});
				scope.allEmployeeTypes = model.allEmployeeTypes;

				
				scope.allmartialStatus = [
					{val: 0, name: 'N/A'},
					{val: 1, name: 'Single'},
					{val: 2, name: 'Partnership'},
					{val: 3, name: 'Married'},
					{val: 4, name: 'Divorced'},
					{val: 5, name: 'Widowed'}
				];

				scope.viewModeClass = "read";
				
				scope.changeViewModeClass = function(){
					scope.viewModeClass = scope.viewModeClass === "read"?"edit":"read"; 
				};
				
				// scope.preferences= {};
				
				// model.addPrefSettings([
				// 	'language','dob', 'numerised', 'sensible','sofy', 'lastVerif', 'lastActivity', 'professional', 
				// 	'partner', 'mother', 'father', 'tutor', 'citizenship', 'race', 'civil', 'appMsg', 'childMsg', 
				// 	'address', 'contacts', 'otherProf', 'sites', 'ident', 'pharma', 'alerts', 'limitations', 'note', 
				// 	'inactive', 'isdead', 'gender', 'popover'
				// ], scope.preferences, 'ptedit_');
				
				function elemInEdit(){
					return (scope.formOptions.inEditMode !== undefined && scope.formOptions.inEditMode > 0);
				}
				function elemsValid(){
					var isValid = true;
					for( var i = 0; i < scope.formOptions.inEditMode; i++){
						if(!scope.formOptions.inEditItems[i].viewbag.okToClose()){
							isValid = false;
						}else{
							scope.formOptions.inEditItems[i].viewbag.save();
						}
					};
					return isValid;
				}

				scope.closeView = function(){
					// if(scope.formOptions.inEditMode > 0){
					// 	model.notice().fail($filter('translate')('PatientSaveEditModeForm' ));
					// 	return;
					// }
					//if(scope.createform.$dirty || scope.isDirty || elemInEdit()){
					if(scope.formDirty() || elemInEdit()){
						QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}, {windowClass:'top-modal'})
						.then(function(save){
							if(save){
								scope.savePatient().then(exit); //should change the dirty state to make sure that the second time closing goes through
							}else{
								exit();
							}
						});
					}else{
						exit();
					}
				};
				//expose the close function to allow parent to close the patient edit.
				scope.options.close = scope.closeView;
				
				function exit(res){
					if(scope.options.exit){
						scope.options.exit();
						unregisterDirty();
					}
				}
				

                //This function should be normalized and put in quickview function as a helper function
                //It is useful for all quickview activities that need to listen to quickview events 
                //especially ones that can have a dirty state 
                // - forms, docs, laboratories and eventullly all other items that can be modified
                function addEventsEvent(){
					if(!scope.qv){
						return;// not in quickview mode
					}
					if(!QuickView.eventsActive(scope.qv)){
						return;// event have already been deleted (because of a close or one quickview that triggers another)
					}
                    //Si c'est la première ouverture, créer la variable d'événements
                    if(!scope.qv.ActiveEventsRef){
                        scope.qv.ActiveEventsRef = {};
                    }
                    //Make sure previously created evens are not referred to 
                    //Very important to avoid leaks
                    QuickView.removeAllEventHandlers(scope);

                    function onMinimizeOrClose(event, fct) {
                        var act = event.mObj.quickViewData.qvActData;
                        if (registeredDirtyId) {
                            event.stopPropagation();
                            QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}).then(function(save){
                                function continueAction(res){
                                    unregisterDirty();
                                    scope.ignoreChanges = true;
                                    //Makes sure the original action is called again in 'fct()' 
                                    //- if changeActivity was the origianl action it should be recalled and 
                                    //   the second time the validation message is not shown because scope.ignoreChanges === true
                                    if (fct){
										fct();
									}
                                }
                                function saveFailedCanNotContinue(res){
                                    var errMsg = res.statusText ? res.statusText : ""; 
                                    model.notice().fail($filter('translate')('docFailedSaveErrMsg', {errMsg: errMsg}));
                                }
                                if(save){
                                    scope.savePatient().then(continueAction, saveFailedCanNotContinue);//should change the dirty state to make sure that the second time closing goes through
                                }else{
                                    exit();
                                    continueAction();
                                }
                            });
                            return true;
                        }
                        return false;
                    }
                    
                    //L'événement existe donc il ne faut pas le recréer
                    if(!scope.qv.ActiveEventsRef.onQvClose){
                        //Ici elle est appeller ajouté aussi-tot que le viewer s'ouvre donc toujours active
                        //Comme le scope n'est pas passé en parametre, le handler est seulement detruit quand le quickview est fermer
                        scope.qv.ActiveEventsRef.onQvClose = Event.on(scope.qv.onQvClose,function(event){
                            onMinimizeOrClose(event, scope.qv.$$close);
                        });
                    }
                    
                    if(!scope.qv.ActiveEventsRef.onQvMinimize){
                        scope.qv.ActiveEventsRef.onQvMinimize = Event.on(scope.qv.onQvMinimize, function(event){
                            if(onMinimizeOrClose(event, scope.qv.$$minimize)){
                                QuickView.removeAllEventHandlers(scope);
                            }
                        }, scope);
                    }
                    
                    //événement de changement d'activité
                    if(!scope.qv.ActiveEventsRef.onQvActivityChange){
                        scope.qv.ActiveEventsRef.onQvActivityChange = Event.on(scope.qv.onQvActivityChange,function(event){
                            var newAct = event.newAct;
                            onMinimizeOrClose(event, function(){
                                if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (newAct)){
                                    model.actUpdated(true);
                                    scope.ignoreChanges = false;
                                    QuickView.removeAllEventHandlers(scope);	
                                }
                            });
                        }, scope);
                    }
                    
                    if(!scope.qv.ActiveEventsRef.onQvExternalize){
                        scope.qv.ActiveEventsRef.onQvExternalize = Event.on(scope.qv.onQvExternalize,function(event){
                            QuickView.removeAllEventHandlers(scope);
                        }, scope);
                    }
				}
				
				//checks patientviewmode and format preferences
				if(model.patientViewMode == 1){
					setTimeout(function(){
						scope.preferences.popover=true;
						scope.preferences.picture=false;
					},0);
					
				}
				
				//sets modificationStatus
				// scope.editPatient.modificationStatus= ModificationStatus.STATUS_UPDATED; // pourquoi??? on ne veut pas sauver tout à chaque fois...
				//get needed information in model.user
				scope.sessionUser = model.user().sessionUser;
				scope.lstUsers = model.user().list;
//				.sort(function(o1,o2) {
//                	if (o1.personName && o2.personName) {
//                		return o1.personName.toUpperCase().localeCompare(o2.personName.toUpperCase());
//                	}
//                	return o1.str.localeCompare(o2.str);
//				});
				scope.lstProfs = $filter('orderBy')(model.store.profs.list(), ['lastName', 'firstName']);
				scope.lstProfs.splice(0, 0, {});
				scope.allsites = model.user().sites;
				
				//sets form status to dirty or pristine
				scope.setFormStatus = function(status){
					scope.formStatus(status);
					scope.editPatient.modificationStatus = ModificationStatus.STATUS_UPDATED;
				};
				
				scope.formStatus = function(status){
					scope.isDirty = scope.createform.$dirty;

					if(status === "dirty"){
						scope.isDirty = true;
					}
					else if(status === "pristine"){
						scope.isDirty = false;
					}
				};
				
				scope.changeEmployeeActiveState = function(){
					if(!scope.editPatient.isDeleted && scope.editPatient.isUser && scope.editPatient.user){
						var qconfirmOptions = {
							title: $filter('translate')('disableUserAlert')
						};
						QConfirm.open(qconfirmOptions).then(function(proceed){
							if(proceed){
								scope.editPatient.isUser = false;
								scope.editPatient.user.modificationStatus = ModificationStatus.STATUS_DELETED;
								scope.editPatient.user.isDeleted = true;
							}
							scope.createform.$setDirty();
							scope.editPatient.isDeleted=!scope.editPatient.isDeleted;
						});	
					}else{
						scope.createform.$setDirty();
						scope.editPatient.isDeleted=!scope.editPatient.isDeleted;
					}
					
				}

				var isFormDirty = false;
				scope.formDirty = function(){
					var dirty = scope.isDirty || 
						(scope.createform && scope.createform.$dirty) || 
						scope.formOptions.childrenDirty();
					if(isFormDirty !== dirty){
						if(dirty){
							registerDirty();
						}else{
							unregisterDirty();
						}
					}
					isFormDirty = dirty;
					return isFormDirty;
				};
				scope.options.dirty = scope.formDirty;
				
				scope.formOptions = {
					setFormStatus: scope.formStatus,
					isReadOnly: scope.isReadOnly,
					inEditMode: 0, 
					children: [],
					childrenDirty: function(){
						for (var i = 0; i < this.children.length; i++) {
							if(this.children[i].isDirty()){
								return true;
							}
						}
						return false;
					}, 
					childrenOkToClose: function (){
						var isOk = true;
						for(var j = 0; j < scope.formOptions.children.length; j++){
							if(!scope.formOptions.children[j].okToClose()){
								isOk = false;
							}
						}
						return isOk;
					},
					resetChildren: function (){
						for(var j = 0; j < scope.formOptions.children.length; j++){
							scope.formOptions.children[j].reset();
						}
					}

				};

				function setNoteInactiveText(reason, note){
					var allReasons = ["Other","Deceased","Moving"];
					note = note ? note : "";
					scope.editPatient.note = scope.editPatient.note ? scope.editPatient.note + ' ': scope.editPatient.note;
					scope.editPatient.note = scope.editPatient.note + $filter("translate")("InactiveReason")+
						" : " + $filter("translate")(allReasons[reason])+"/DATE : "+
						scope.editPatient.inactiveDate+"\n"+ note;
				}

				//Open modal if dead
				scope.isDead = function(value){
					if(value=="false"){
						scope.createform.$setDirty();
						scope.editPatient.isDeleted=false;
						scope.editPatient.inactiveRaison=null;
						scope.editPatient.inactiveDate="";
					}
					else{
						var modalData = {
							editFormUrl: '/dashboard/resources/ofys/pat/profil/deceased_modal.html?v=bb',
							isNew: true,
							data: {date: moment().format('YYYY-MM-DD')},
							inactiveDynaDateOptions: {
								acceptFutureDate: true, 
								// onDateSelected: function(selectedDate){
								// 	scope.editPatient.inactiveDate = selectedDate;
								// }
							}
						};
						
						var promise = PatientFormService.editModal(modalData).then(angular.noop, function (){ 
							//if clicked out
							scope.createform.$setDirty();
							scope.editPatient.inactiveRaison=2;
							scope.editPatient.inactiveDate = modalData.data.date;
							setNoteInactiveText(1);
	//							scope.editPatient.note= $filter("translate")("InactiveReason")+" : "+$filter("translate")("Deceased")+"/DATE : "+scope.editPatient.inactiveDate;
						});
					}
						
				};
				
				//Reactivates patient
				scope.reactivate=function(){
					scope.createform.$setDirty();
					scope.editPatient.isDeleted=false;
					scope.editPatient.inactiveRaison=null;
					scope.inactiveDate="";
				};
				
				//Opens modal to deactivation
				scope.openInactiveModal = function(){
					var modalData = {
							editFormUrl: '/dashboard/resources/ofys/pat/profil/inactive_modal.html?v=bb',
							isNew: true,
							data:{ reason:1 , note:"", date:moment().format('YYYY-MM-DD')},
							reasonsList: [{val:1,name:'Other'},{val:2,name:'Deceased'},{val:3,name:'Moving'}],
							inactiveDynaDateOptions: {
								acceptFutureDate: true,
								// onDateSelected: function(selectedDate){
								// 	modalData.date = selectedDate;
								// }
							},
							isModal: true
					};

					PatientFormService.editModal(modalData).then(angular.noop, function (){
						scope.createform.$setDirty();
						scope.editPatient.isDeleted=true;
						scope.editPatient.inactiveDate = modalData.data.date;
						scope.editPatient.inactiveRaison = mObj.data.reason;
						
						if(mObj.data.reason > 0 && mObj.data.reason < 4){
							//make sure reason is in base 0 for required array
							setNoteInactiveText(mObj.data.reason - 1, mObj.data.note);
						}
					});
				};
				
				
				/**
				 *@ngdoc method
				 *@name openProfSearch
				 *@methodOf patient.directive:
				 *@description
				 *This method opens the Professional search window.
				 *When one is selected, returns this professional ID to the patient
				 */
				scope.openProfSearch = function(){
					FlView.open({templateUrl: "/dashboard/resources/ofys/pat/profil/search_prof.html?v=bb"}, {windowClass:'top-modal'}).then(function(prof){
						scope.editPatient.treatingProfessionnal=prof.id;
						scope.setFormStatus("dirty");
					});
				};
				function profName(prof){
					return prof.lastName + ', '+ prof.firstName;
				}
				function loadLimitations(limitations){
					if(limitations && limitations.length > 0){
						limitations.forEach(function(limitation){
							limitation.keys = Rights.updateLimitationTypes(limitation.droits);
						});
					}
				}
				function loadPatient(patient){
					if(scope.patient || patient){ //if existing patient
						model.safeCall(addEventsEvent);
						patient = patient ? patient : scope.patient;
						//To make sure all defaults are always present 
						scope.editPatient = $.extend(angular.copy(defaultPatientData),angular.copy(patient));
						if(scope.editPatient && !scope.editPatient.type){
							var obj = scope.allEmployeeTypes.filter(obj => {
									return obj.value == 0;
								})
							scope.editPatient.type = obj[0].type;
						}
						scope.isUserOwnData = model.user().profil.id==patient.id;
						if(scope.editPatient.viewbag) delete scope.editPatient.viewbag;
						scope.uiready = true;
						setDirty(false);
					}
				}
				var watchcount = 0;
				scope.$watch(function (){
					if(scope.patient && scope.editPatient && scope.patient.idPerson !== scope.editPatient.idPerson){
						watchcount++
					}
					return watchcount;
				}, function(){
					loadPatient()
				});


				function prepForSave(){
//					if(scope.createform.$dirty){
					if(scope.formDirty()){
						scope.editPatient.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
				}
				var registeredDirtyId;

				function registerDirty(){
					registeredDirtyId = "pat_"+scope.editPatient.id;
					QValidation.registerDirty(registeredDirtyId, scope.savePatient, function(){
						return true;
					});
				}
				
				function unregisterDirty(){
					if(registeredDirtyId){
						QValidation.unregisterDirty(registeredDirtyId);
						registeredDirtyId = undefined;
					}
				}
				function saving(isSaving){
					if(isSaving){
						scope.saving = true;
					}else{
						$timeout(function(){
							scope.saving = false;
						}, 2000);
					}
				}
				scope.savePatientAndClose= function(close){
					scope.savePatient().then(close);
				}
				scope.saving = false;
				
				scope.changeDsqKey = function(){
					var qconfirmOptions = {templateUrl: 'editDsqAliasKey_index.html',
						pref : {
							dsqAlias: scope.patient.user.userPreferences.dsqPreferences.dsqTokenAlias,
						},
						qconfirm: {
							hideNo: true,
							yesTitle: "Save",
							beforeYes: function(e, obj){
								scope.patient.user.userPreferences.dsqPreferences.dsqTokenAlias = obj.pref.dsqAlias;
								scope.patient.user.userPreferences.modificationStatus = ModificationStatus.STATUS_UPDATED;
								prefAccessor.saveUserPref(scope.patient.user.userPreferences, function(res){
									scope.patient.user.userPreferences = res;
								})
							}
					}};
					QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(){});
				}

				function setDirty(isDirty){
					if(isDirty){
						scope.isDirty = isDirty;
					}else{
						scope.createform.$setPristine();
						scope.isDirty = false;
						scope.formOptions.resetChildren();
					}
				}

				/**
				 *@ngdoc method
				 *@name 
				 *@methodOf patient.directive
				 *@description
				 *This method saves the patient.
				 *It sends its current patient.
				 *On the callback,it updates the current patient informations,sets form to pristine and sends a notice.
				 */
				scope.savePatient= function(){
					scope.createformErrors = PatientFormService.getFormErrors(scope.createform,null,{expirationcam: "Invalid"});
					if(scope.createform.$valid){
						if(!scope.saving){
							if((elemInEdit() && !elemsValid()) || !scope.formOptions.childrenOkToClose()){
								return $q.reject($filter('translate')('EditValidationFailed'));
							}
							// console.log(scope.editPatient);
							// return false;
							saving(true);
							prepForSave();
							// saving();
							// return ;
							return UserAccessor.saveEmployee(scope.editPatient, function(res){
								var savedElem = res[0];
								
								scope.createform.$setPristine();
								scope.isDirty = false;
								scope.formOptions.resetChildren();

								//Make sure that the new id is updated if in qv mode.. 
								//otherwise two groups are created when the patient is opened again.
								if(model.qv().group[scope.editPatient.idPerson]){
									model.qv().group[savedElem.idPerson] = model.qv().group[scope.editPatient.idPerson];
									delete model.qv().group[scope.editPatient.idPerson]
								}
								loadPatient(savedElem);
								OfysUtils.update(scope.patient, savedElem, ['viewbag']);
								model.notice().success($filter('translate')('SaveSuccess'));
								scope.formDirty()//Certain cases the dirty state is not remove. Must be called to reset.
								//Filtre le tab et rajoute l'employé dans la liste au besoin
								var obj = model.user().tab.currList.filter(obj => {
										return obj.className == "CEmployee";
									})
								var tabList = obj.filter(obj => {
										return obj.id == savedElem.id;
									})
								if((obj.length > 0 && tabList.length == 0) || obj.length == 0){
									model.user().tab.currList.push(savedElem);
									model.searchPtUpdated(true);
								}
								model.patientUpdated(true);
								//ajouter au last seen
								if(scope.editPatient.isNew){
									PatientAccessor.setAsUsed(scope.patient.id);
								}

								//unlock savingPatient function
								saving();
							}, function(res){
								//unlock savingPatient function
								saving();
								model.notice().fail(res.status + ' : ' + $filter('translate')('SaveFailed'));
							});
						}
					}else{
						var msg = 'PatientSaveInvalidForm';

						model.notice().fail($filter('translate')(msg));
						return $q(function(resolve, reject) {
							reject($filter('translate')(msg));
						});
					}
				};

				//Option object taking care of creating the preferences tooltip
				scope.patientInfoFilterOptions = {
					trigger: 'click',
					closeOnMouseleave: true,
					templateUrl: '/dashboard/resources/ofys/pat/profil/patientInfoFilter.html?v=bb',
					position: {
						x: 'right',
						y: 'center'
					},
					outside: 'x',
					onClose: function(){
						//scope.updateData();
					}
				};

			}
		};
	}]);
	

})();