(function(){
    var debug = angular.module('ofys.debug', []);

    debug.controller('DebugController', 
    ['$log', '$translate','model', '$http','$timeout', 'DashWebSocket','FlView','QuickView',
        function($log, $translate, model, $http, $timeout, DashWebSocket, FlView, QuickView){
		this.testWebSocket = function(){
			DashWebSocket.send({url: "/dashboard/docs/test", data:"Albert"});
		};
		this.searchProf = function(){
			FlView.open({templateUrl: "/dashboard/resources/ofys/prof/search_prof.html"});
		}
		this.placeHolderTitle = "Load QV";
		this.placeHolder = function(){
			if(localStorage.strQV){
				var jsonQV = JSON.parse(localStorage.strQV);
				model.qv().group =jsonQV.group;
				model.qv().items =jsonQV.items;
				model.qv().itemsGroupCount =jsonQV.itemsGroupCount;
			}
		}
		this.placeHolderTitle2 = "Save QV";
		this.placeHolder2 = function(){
			localStorage.setItem('strQV',JSON.stringify(model.qv()));
		}
		this.overlay = function(){
			// model.loadingOverlay().show('LOADING_DATA', true);
			// try{
			// 	screen.lavender.amp = jam;
			// }catch(e){
				// $log.error(e);
			// }
			$log.error("simple dump");
		}
		this.openInBrowser = function(){
			var url = window.location.href;
			model.search().q = url;
			window.open(url, '_blank');
		}
		this.openOfys4Current = function(){
			$http.get("/dashboard/Patients/ws/openFile");
		}
		this.changeLanguage = function(lang){
			$translate.use(lang);
		}
		this.closeWindow = function(lang){
			window.close();
		}

		this.placeHolder();
		$timeout(function(){
			var items = model.qv().items;
			var val = OfysUtils.ObjectValuesAsArray(items)[0];
			if(val){
				QuickView.open(val);
			}
		}, 100);
	}]);

	debug.factory('DebugAccessor',['$http', '$cacheFactory','$compile',
	function($http, $cacheFactory,$compile){
		var service = {
			updateTemplate: function(url, callback, error){
				//NOT WORKING debug later
				
				// var $httpDefaultCache = $cacheFactory.get('$http');
				// $httpDefaultCache.remove(url);
			},
		};
		return service;
	}] )
})();