(function(){
    var appointment = angular.module('appointment');

    appointment.directive("scheduler", ['ScheduleStore','utils','$popover', '$interval', 'PrefAccessor','model','QConfirm','$timeout',
        'OfysFCUtils','$filter', 'AppointmentAccessor', 'PatientFormService', '$compile', 'PrintAccessor', 'FlView', 'PatientAccessor',
        function(ScheduleStore, utils,$popover, $interval, PrefAccessor, model, QConfirm, $timeout,
            OfysFCUtils, $filter, AppointmentAccessor, PatientFormService, $compile, PrintAccessor, FlView, PatientAccessor){
        return {
            restrict: 'EA',
            templateUrl:'/dashboard/resources/ofys/appointment/scheduler.html?v=bb',
			link: function(scope, element, attrs){
                if(!model.schedule().contextSite){
                    PrefAccessor.contextSite(function (res) {
                        model.schedule().contextSite = res.data;
                    });
                }
                scope.toggleSideBar = function(){
                    model.schedule().showSideBar = !model.schedule().showSideBar;
                    scope.store.schedule.renderDV();
                    if(model.schedule().showSideBar){
                        scope.store.schedule.renderMV();
                    }
                }
				
                scope.shdlContext = function(){
                    if(scope.store.schedule){
                        return scope.store.schedule.currentContext().type();
                    }
                    return 'scheduleDate';
                }
                scope.profList = "All";
				scope.appointmentDynaDateOptions = {acceptFutureDate: true};
                scope.compassnav = function(direction){
                    var d = moment(model.schedule().currDate, OfysUtils.DATEFORMAT);
                    var res;
                    var viewSpan = scope.store.schedule.daysViewed() == 7?'weeks':'days';
                    if(direction === 'N'){
                        res = d.add(1, viewSpan).format(OfysUtils.DATEFORMAT);
                    }else if(direction === 'C'){
                        res = moment().format(OfysUtils.DATEFORMAT);
                    }else if(direction === 'S'){
                        res = d.subtract(1, viewSpan).format(OfysUtils.DATEFORMAT);
                    }
                    if (scope.store.schedule) {
                    	scope.store.schedule.currentDate(res);
                    }
                };
				scope.changeDate = function(dateStr){
					if(dateStr.length == 10 && moment(dateStr, OfysUtils.DATEFORMAT).isValid()){
						scope.store.schedule.currentDate(dateStr)
					}
				}
				
                var allOpenContextMenus = [];
                var eventApi = {
                    open: function(id){
                        console.log("Event: "+ id);
                    },
                    ShowContextMenu: function(){
                        console.log("I have been right clicked");

                    }
                }

                scope.toggleSchedule = function(view){
                    if(scope.store.schedule.canClose()){
                        scope.store.schedule.isScheduleEditMode(view)
                    }
                }

				scope.getCurrDayAbsence = function(date, profId){
                    var shdl = scope.store.schedule.getMultiProfOrSelf(profId);
					if(shdl && shdl.dates(date)
						&& shdl.dates(date).baseAppointmentDate){
						return true;
					}
				}
				
				scope.getCurrDayAbsenceMessage = function(date, profId){
                    var shdl = scope.store.schedule.getMultiProfOrSelf(profId);
                    if(shdl.currentContext().type() === shdl.contextTypes.SCHEDULE_DATE 
                            && shdl.dates(date) && shdl.dates(date).baseAppointmentDate){
                        var fullMsg;
                        let msg = shdl.dates(date).baseAppointmentDate.message
                        let msgAll = shdl.dates(date).baseAppointmentDate.messageAll
                        if(msg && msgAll){
                            fullMsg = msg + '/' + msgAll
                        } else if (msg || msgAll){
                            fullMsg = msg ? msg : msgAll
                        }
                        return fullMsg
                    }
				}
                
                scope.filterProfList = function(q){
                    if(!q || q === ""){
                        scope.professionals = scope.store.scheduleProfs;
                    }else{
						scope.professionals = scope.store.scheduleProfs
							.filter(function(a){return OfysUtils.matchInRegExpArray(OfysUtils.searchRegExpArray(q,2), OfysUtils.normaliseSearchField(scope.store.ProfListCtrl.getName(a)))})
							.sort(function(a,b){
                            	return scope.store.ProfListCtrl.getName(a).localeCompare(scope.store.ProfListCtrl.getName(b));
                        	});
                    }
                }
				scope.openFavoritesProfs = function(){
                    var favsIds = scope.store.listProfessionnalFavorite.concat(Object.keys(scope.store.listMultiProfessionnalFavorite.schdls));
					var listFavProf = scope.professionals.filter(function(a){
						return  favsIds.includes(a.id);
					});
					scope.store.toggleScheduleFavoriteProf(listFavProf)
				}
                scope.getActiveSchedule = function(){
                    if(scope.store.schedule){
                        if(scope.store.schedule.isMultiSchedule){
                            return scope.store.schedule.multiViewCtrl.currentSchedule;
                        }else{
                            return scope.store.schedule;
                        }
                    }
                }

                function multiViewInitOnOpen(schedule){
                    if(schedule.isMultiSchedule && schedule.initOnOpen){
                        delete schedule.initOnOpen;
                        initMultiView(schedule);
                    }
                }
                
                scope.openSchedule = function(schedule){
                    multiViewInitOnOpen(schedule);
                    scope.store.selectProf(schedule)
                }
                scope.newMultiProfSchedule = function(){
                    // only have one multi prof schedule
                    var firstSchedule = scope.professionals[0];
                    if(firstSchedule.isMultiSchedule){
                        if(firstSchedule.id !== scope.store.schedule.prof.id){
                            scope.store.selectProf(firstSchedule)
                        }
                        return;
                    }

                    var mView = {
                        id: scope.store.MultiViewId.next(),
                        name:scope.store.MultiViewId.nextName(),
                        isMultiSchedule: true,
                        profs:[],
                        
                    }
                    initMultiView(mView);
                    scope.professionals.unshift(mView);
                    scope.store.selectProf(mView);
                    
                }

                function initMultiView(schedule){
                    schedule.dayViewGen = dayViewer;
                    schedule.addActiveProf= function(prof){
                        var schdl = scope.store.getSchedule(schedule);
                        schdl.multiViewCtrl.addSchedule(prof)
                        schdl.multiViewCtrl.renderCalendars();
                        linkMutliViewScrollingFn();
                    }
                    schedule.removeActiveProf=function(prof){
                        var schdl = scope.store.getSchedule(schedule);
                        schdl.multiViewCtrl.removeSchedule(prof)
                        schdl.multiViewCtrl.renderCalendars();
                        linkMutliViewScrollingFn();
                    }
                }
                function getEventDate(e){
                    return OfysFCUtils.noTimezoneDate(e.oldEvent._instance.range.start);
                }
                var clickThrottle = {};

                function singleClick(group,key){
                    var skip = false;
                    if(clickThrottle[group] != undefined && clickThrottle[group][key] != undefined){
                        skip = true;
                    }else{
                        if(clickThrottle[group] == undefined){
                            clickThrottle[group] = {};
                        }
                        clickThrottle[group][key] = $timeout(function(){
                            delete clickThrottle[group][key];
                        },2000);
                        //if a new click is registered remove previous locks
                        Object.keys(clickThrottle[group]).filter(e=>e !== key).forEach(k=>delete clickThrottle[group][k]);
                    }

                    return skip;
                }
                function dayViewer(shdl){
                    var temp ={};
                    var res = {
                        preset: 'day',
                        options: {
                            eventDidMount: function(info){
                                if(info && info.event.extendedProps && info.event.extendedProps.statusColor){
                                    $(info.el).find(".fc-event-main").css("borderRight", info.event.extendedProps.statusColor);
                                }
								if(info && info.event.extendedProps && info.event.extendedProps.type == "period" && info.event.extendedProps.siteColor){
									$(info.el).parent().css("borderLeft", info.event.extendedProps.siteColor)
								}else if(info && info.event.extendedProps && info.event.extendedProps.siteColor){
									$(info.el).find(".fc-event-main").css("borderLeft", info.event.extendedProps.siteColor)
                                }
								if(OfysFCUtils.isPeriod(info.event)){
								    info.el.addEventListener("contextmenu", (jsEvent)=>{
								        jsEvent.preventDefault();
										var isPeriod = OfysFCUtils.isPeriod(info.event);
		                                if(isPeriod){
		                                    var per = shdl().getPeriod(info.event.id);
		                                    if (per) {
		                                        var periodtype = AppointmentAccessor.periodTypesById()[per.appointmentPeriodType];
		                                        temp.isClosed = per.isClosed || !periodtype.canHaveAppointment;
		                                    }
		                                    temp.period = info.event.id;// sets the period. used by dateClick when creating new appointment
		                                }
										var elements = document.elementsFromPoint(jsEvent.clientX, jsEvent.clientY);
										var rowElement = elements.filterFast(function(a){return a.classList.contains("fc-timegrid-slot");});
										var colElement = elements.filterFast(function(a){return a.classList.contains("fc-timegrid-col");});
									    $(rowElement[0]).trigger('contextmenu', [colElement]);
								    })
                                }else{
                                    var menu = $popover($(info.el), {
                                        trigger:"contextmenu",
                                        autoClose: true,
                                        placement: "right",
                                        container: "body",
                                        keyboard: false,
                                        animation: "am-flip-x",
                                        templateUrl: "app_edit_contextmenu_index.html",
                                        onShow: function(){
                                            for (var i = 0; i < allOpenContextMenus.length; i++) {
                                                allOpenContextMenus[i].hide();
                                            }
                                            allOpenContextMenus = [];
                                            $(info.el).parents(".fc-scroller").on('scroll', menu.hide);
                                            allOpenContextMenus.push(menu);
                                        },
                                        onHide: function(){
                                            $(info.el).parents(".fc-scroller").off('scroll', menu.hide);
                                            for (var i = 0; i < allOpenContextMenus.length; i++) {
                                                if(allOpenContextMenus[i] === menu){
                                                    allOpenContextMenus.splice(i, 1);
                                                }
                                            }
                                        },
                                    });
                                    menu.$scope.api = eventApi;
                                    menu.$scope.ofysEventId = info.event.id;
        
                                    menu.$scope.copy = function(){
										model.appointment().copyApp = angular.copy(shdl().getAppointmentById(this.ofysEventId));
										model.appointment().copyApp.status = "NORMAL";
										model.appointment().copyApp.patientStatus = "NONE";
										delete model.appointment().copyApp.seenTime;
										delete model.appointment().copyApp.arrivedTime;
										model.appointment().toCut = false;
                                        menu.hide();
                                    };
                                    menu.$scope.cut = function(){
										model.appointment().copyApp = shdl().getAppointmentById(this.ofysEventId);
                                        if(shdl() && shdl().currentAppointment() != null && shdl().currentAppointment().id == model.appointment().copyApp.id){
                                            shdl().clearSelectedAppointment();// unselect the appointment 
                                        }
                                        shdl().clearAppointment(model.appointment().copyApp);// remove from calendar viewer.
										model.appointment().toCut = true;
                                        menu.hide();
                                    };
                                    menu.$scope.print = function(){
                                        model.print().type.id = this.ofysEventId
										model.print().type.type = "appointment"
										
										PrintAccessor.getAvailableReports(model.print().type, function(res){
											res.data.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
											for(list of res.data){
												list.reports.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
											}
											model.print().currList = res.data;
											FlView.open({templateUrl: "/dashboard/resources/ofys/print/print.html?v=bb", list: res.data, type: appointment}, {
												backdrop: 'static',windowClass: "printmodal"}).then(function(data){
													
											});
										});
                                        menu.hide();
                                    };
                                    menu.$scope.remove = function(){
										currApp = shdl().getAppointmentById(this.ofysEventId)
                                        QConfirm.open({title: $filter('translate')('CONFIRM_DELETE_APP')}).then(function(ok){
				    						if(ok){
				    							shdl().deleteAppointment(currApp);
				    						}
				    					});
                                        menu.hide();
                                    };
								}
                            },
                            eventDrop:function(info){
                                shdl().setSelectedDateIfDiffrent(getEventDate(info)).then(function(){
                                    if(OfysFCUtils.isPeriod(info.event)){
                                        shdl().updatePeriodDateTimeIfPossible(info.event).then(angular.noop, info.revert);
                                    }else{
										if(shdl().isScheduleEditMode() == 2){
											shdl().isScheduleEditMode(0);
										}
                                        var qconfirmOptions = {title: $filter('translate')('MSG_CONFIRM_APP_TIME_CHANGE', {name: info.event.title, time: moment(info.event.start).format(OfysUtils.DATETIMEFORMAT)})};
                                        QConfirm.open(qconfirmOptions).then(proceedTimeChange, info.revert);
                                        function proceedTimeChange(proceed){
                                            shdl().currentAppointment(info.event.id);
                                            if(proceed){
                                                var app = shdl().currentAppointment();
                                                if (app.adhocPatient != undefined || (app.patients && app.patients.length>0)) {
                                                    shdl().updateAppointmentDateTime(info.event).then(function(res){
                                                        // console.log(res);
                                                    }, info.revert);
                                                } else {
                                                    // réservation
                                                    shdl().moveReservation(info.event, app);
                                                }
                                                model.apptLstUpdated(true);
                                                model.apptUpdated(true);
                                            }else{
                                                info.revert();
                                            }
                                        }
                                    }
                                });
                            },
                            eventResize:function(info){
                                shdl().setSelectedDateIfDiffrent(OfysFCUtils.noTimezoneDate(info.event._instance.range.start)).then(function(){
                                    if(OfysFCUtils.isPeriod(info.event)){
                                        shdl().updatePeriodDateTimeIfPossible(info.event).then(angular.noop, info.revert);
                                    }else{
										if(shdl().isScheduleEditMode() == 2){
											shdl().isScheduleEditMode(0);
										}
                                        var qconfirmOptions = {title: $filter('translate')('MSG_CONFIRM_APP_TIME_EXTENSION', {name: info.event.title, time: info.event.end.toLocaleTimeString('en-US', {hour12:false}).substring(0,5)})};
                                        QConfirm.open(qconfirmOptions).then(proceedTimeChange, info.revert);
                                        function proceedTimeChange(proceed){
                                            if(proceed){
                                                shdl().currentAppointment(info.event.id);
                                                var app = shdl().currentAppointment();
                                                if (app.adhocPatient != undefined ||(app.patients && app.patients.length>0)) {
                                                    shdl().updateAppointmentDateTime(info.event).then(function(res){
                                                    //console.log(res);
                                                    }, info.revert);
                                                } else {
                                                    // réservation
                                                    shdl().moveReservation(info.event, app);
                                                }
                                                model.apptLstUpdated(true);                                    	
                                                model.apptUpdated(true);
                                            }else{
                                                info.revert();
                                            }
                                        }
                                    }
                                });
                            },
                            eventClick: function(info){
                                if(singleClick("eventClick",info.event.id + info.event._instance.range.start.toISOString())){
                                    // temp.isClosed = true
									return;
                                }

                                // set temporary fields 
                                var isPeriod = OfysFCUtils.isPeriod(info.event);
                                if(isPeriod){
                                    var per = shdl().getPeriod(info.event.id);
                                    if (per) {
                                        var periodtype = AppointmentAccessor.periodTypesById()[per.appointmentPeriodType];
                                        temp.isClosed = per.isClosed || !periodtype.canHaveAppointment;
                                    }
                                    temp.period = info.event.id;// sets the period. used by dateClick when creating new appointment
                                }

                                shdl().setSelectedDateIfDiffrent(OfysFCUtils.noTimezoneDate(info.event._instance.range.start)).then(function(){
                                    // var start = performance.now();
									if(shdl().isScheduleEditMode() == 2){
										shdl().isScheduleEditMode(0);
									}
									if(!model.schedule().showRightSideBar){
										shdl().toggleRightSideBar();
									}
                                    if(isPeriod){
                                         if(shdl() && shdl().isScheduleEditMode() == 1 &&
                                            !shdl().currentPeriodInEditMode()){
                                            shdl().currentPeriod(info.event.id);
                                         }
                                    }else if(shdl().isScheduleEditMode() == 0){
                                        var selectedAppointment = shdl().dates(shdl().currentDate()).appointments[info.event.id];
                                        if(selectedAppointment && !selectedAppointment.editLocked){
                                            if(!shdl().currentInEditMode()){
                                                shdl().currentAppointment(info.event.id);
												AppointmentAccessor.clearMessageLink();
												AppointmentAccessor.updateMessageLink(selectedAppointment.patients[0], scope); 
                                            }else{
                                                // est en mode d'édition. Si le rv est diff de celui en édition (donc l'actif), il faut alertEditMode
                                                    var currApt = shdl().currentAppointment();
                                                    if (currApt && selectedAppointment.id!==currApt.id) {
                                                        shdl().currentAppointment().editable.viewbag.alertEditMode()                                       	
                                                    }
                                            }
                                        }                            		
                                    }
                                    // var end = performance.now();
                                    // console.log(`Execution time: ${end - start} ms`);
                                })
                            },
                            navLinks: true,
                            navLinkWeekClick: function(weekStart, jsEvent) {
                                console.log("loge");
                            },
                            navLinkDayClick: function(date, jsEvent) {
                                if(shdl().currentContext().type() === shdl().contextTypes.SCHEDULE_DATE){
                                    shdl().setSelectedDateIfDiffrent(moment(date).format(OfysUtils.DATEFORMAT)).then(function(){
                                        shdl().toggleViewspan();
                                    });
                                }
                                if(shdl().isChildSchedule){
                                    scope.openSchedule(shdl().prof);
                                }
                            },
                            // fc-col-header-cell-cushion 
                            dayHeaderContent: function(obj){
                                
                                if(!!shdl()){
                                    if(shdl().isChildSchedule){
                                        obj.text = scope.store.ProfListCtrl.getName(shdl().prof);
                                    }else{
                                        var ctx = shdl().currentContext();
                                        if(ctx && ctx.setHeaderName && obj){
                                            obj.text = ctx.setHeaderName(obj);
                                        }
                                    }
                                }
                            },
							dayCellDidMount: function(info){
								var coldate = moment(info.date).format("YYYY-MM-DD");
								// console.log(coldate); // un objet ds console n'est jamais supprimé de la mémoire. A éviter
                                if(shdl() && shdl().getProfId() !== undefined){
									var message = scope.getCurrDayAbsenceMessage(coldate, shdl().getProfId());
									if(message){
										var html = angular.element('<div class="app-absence-day-block">' +
					                		message +
					             		'</div>');
										$(info.el).append(html);
									}
								}else{
	                                var html = angular.element('<div class="app-absence-day-block" data-ng-if="getCurrDayAbsence(\u0027'+coldate+'\u0027)"' +
	                                    'ng-bind-template="{{ getCurrDayAbsenceMessage(\u0027'+coldate+'\u0027)}}">' +
	                                    '</div>');
	                                var compiledHtml = $compile(html)(scope);
	                                $(info.el).append(compiledHtml);
                                }
								
							},
							slotLaneDidMount: function(info){
								$(info.el).contextmenu(function(event, colElement){
									if(!colElement){
										var elements = document.elementsFromPoint(event.clientX, event.clientY);
										var element = elements.filterFast(function(a){return a.classList.contains("fc-timegrid-col");});
										info.chosenDate = element[0].attributes['data-date'].value;
									} else {
										info.chosenDate = colElement[0].attributes['data-date'].value;
									}
								})
                                var menu = $popover($(info.el), {
                                    trigger:"contextmenu",
                                    autoClose: true,
                                    placement: "bottom",
                                    container: "body",
                                    keyboard: false,
                                    animation: "am-flip-x",
                                    templateUrl: "app_recall_contextmenu_index.html",
                                    onShow: function(event){
                                        for (var i = 0; i < allOpenContextMenus.length; i++) {
                                            allOpenContextMenus[i].hide();
                                        }
                                        allOpenContextMenus = [];
                                        $(info.el).parents(".fc-scroller").on('scroll', menu.hide);
                                        allOpenContextMenus.push(menu);
                                    },
                                    onHide: function(){
                                        $(info.el).parents(".fc-scroller").off('scroll', menu.hide);
                                        for (var i = 0; i < allOpenContextMenus.length; i++) {
                                            if(allOpenContextMenus[i] === menu){
                                                allOpenContextMenus.splice(i, 1);
                                            }
                                        }
                                    },
                                });

								menu.$scope.genPatName = function(){
									var stringToReturn = " " + $filter('translate')('from') + " " + model.recall().copyRecall.patient.lastName
										+ ", " + model.recall().copyRecall.patient.firstName
										+ (model.recall().copyRecall.profName ? ", " + $filter('translate')('with') + " " + model.recall().copyRecall.profName : "")
										+ (model.recall().copyRecall.dateRecall ? ", " + $filter('translate')('requestedOn') + " " + model.recall().copyRecall.dateRecall  : "")
										+ " " + model.recall().copyRecall.reason
									return stringToReturn;
								}
    
                                menu.$scope.api = eventApi;
                                menu.$scope.ofysEventId = "true";
                                menu.$scope.pasteRecall = function(){
									if(model.recall().copyRecall !== null && !temp.isClosed){
										var start = info.date.getHours() * 60 + info.date.getMinutes();
										shdl().createNewAppointmentRecall(start, info.chosenDate, temp.period);
	                                    if(temp.period !== undefined){
	                                        delete temp.period;
	                                    }
									}else if(temp.isClosed){
										model.notice().warn($filter('translate')('closedPeriod'))
									}else{
										model.notice().warn($filter('translate')('err_no_recall_copy'))
									}
                                    menu.hide();
                                };

								menu.$scope.pasteApp = function(){
									if(model.appointment().copyApp !== null && !temp.isClosed){
										if(shdl().isScheduleEditMode() == 2){
											shdl().isScheduleEditMode(0);
										}
										startTime = info.date.getHours() * 60 + info.date.getMinutes();
	                                    shdl().pasteAppointment(info.chosenDate, startTime, temp.period);
										if(temp.period !== undefined){
	                                        delete temp.period;
	                                    }
									}else if(temp.isClosed){
										model.notice().warn($filter('translate')('closedPeriod'))
									}else{
										model.notice().warn($filter('translate')('err_no_recall_copy'))
									}
								}
																
							},
                            dayHeaderDidMount: function(info){
								if(false){
	                                var eventScope = scope.$new();
	                                var menu = $popover($(info.el), {
	                                    trigger:"contextmenu",
	                                    autoClose: true,
	                                    placement: "bottom",
	                                    container: "body",
	                                    keyboard: false,
	                                    animation: "am-flip-x",
	                                    templateUrl: "app_edit_daymenu_index.html",
	                                    onShow: function(){
	                                        for (var i = 0; i < allOpenContextMenus.length; i++) {
	                                            allOpenContextMenus[i].hide();
	                                        }
	                                        allOpenContextMenus = [];
	                                        $(info.el).parents(".fc-scroller").on('scroll', menu.hide);
	                                        allOpenContextMenus.push(menu);
	                                    },
	                                    onHide: function(){
	                                        $(info.el).parents(".fc-scroller").off('scroll', menu.hide);
	                                        for (var i = 0; i < allOpenContextMenus.length; i++) {
	                                            if(allOpenContextMenus[i] === menu){
	                                                allOpenContextMenus.splice(i, 1);
	                                            }
	                                        }
	                                    },
	                                    scope: eventScope
	                                });
	    
	                                eventScope.api = eventApi;
	                                eventScope.ofysEventId = "true";
	    
	                                eventScope.deleteDay = function(){
	                                    console.log(this.ofysEventId);
	                                    // console.log(info);
	                                    menu.hide();
	                                };
	    
	                                $(info.el.querySelector('.fc-title')).append(utils.getTemplateAndCompileSync(eventScope, 'appointment_edit_btns_index.html'));
                            	}
                            },							
							nowIndicatorDidMount: function(info){
								$timeout(function(){
                                    info.el.scrollIntoView()
                                }, 350)
							},
                            dateClick: function(info) {
                                if(singleClick("dateClick",info.dateStr)){
                                    return;
                                }
                                if(shdl().reservationLock == true){
                                    console.log("ReservationLock: A reservation already exist schedule. Cancel or save the reservation to continue.");
                                    return;
                                }
                                
								if(shdl().isScheduleEditMode() == 2){
									shdl().isScheduleEditMode(0);
								}
								if(!model.schedule().showRightSideBar){
									shdl().toggleRightSideBar();
									shdl().tempPopout = true;
								}
                                shdl().setSelectedDateIfDiffrent(info.dateStr.substring(0, 10)).then(function(){
                                    if(shdl().isScheduleEditMode() == 1){
                                        // shdl().createNewPeriod(info.dateStr, model.prefSettings('schedule_settings_scheduleDayViewScale'));
                                        shdl().createNewPeriod(info.dateStr, model.prefSettings('schedule_settings_appointmentDayViewScale'));
                                    }else if (shdl() && temp.isClosed!==true && shdl().isScheduleEditMode() == 0) {
                                        if(!shdl().currentInEditMode()){
                                            shdl().createNewAppointment(info.dateStr, temp.period);
                                        }else{
                                            shdl().currentAppointment().editable.viewbag.alertEditMode()
                                        }
                                        if(temp.period !== undefined){
                                            delete temp.period;
                                        }
                                    }
                                    temp.isClosed = false;
                                    model.apptLstUpdated(true);
                                    model.apptUpdated(true);
                                });
                           }, 
                        },
                        calendarApi: function(api){
                            this.ctrler = api;
                            initViewer(shdl);
                        },
                    }
                    return res;
                }

                function getInitialProf(){
                    var res = model.currentApptMd();
                    if(res && res.useAppointment){
                        return res;
                    }else{
                        return scope.professionals[0];
                    }
                }

                function initViewer(shdl){
                    if(!shdl()){
                        var prof = getInitialProf();
                        if(prof){
                            scope.store.selectProf(prof, scope.viewers);
                        }
                    }else{
                        //Reinstate the fullcalendar viewers with appointments and periods..
                        //useful when the viewers are recretated by a navigation.
                        shdl()//
                        shdl().clearView();
                        shdl().initDay();
                        shdl().init();
                        shdl().initMonth();
                        if(scope.store.schedule.isMultiSchedule){
                            scope.store.schedule.multiViewCtrl.rememberCurrentSchedule.setAndForget();
                        }
                    }
                    if (shdl()) {	// sera undefined si pas de prof
                        var monthctrler = scope.store.viewers.month.ctrler;
                        if(monthctrler){
                            monthctrler.cal.select(shdl().currentDate());
                        }
                    }
                    if(scope.store.schedule.isMultiSchedule){
                        linkMutliViewScrollingFn();
                    }
                }

                var multiViewScrollingLinked = false;
                function linkMutliViewScrolling(){
                    var allCalendars = document.querySelectorAll( '.schdldayV .fc-scroller.fc-scroller-liquid-absolute' );


                    allCalendars.forEach(function(cal){

                        function linkMutliViewScrollingListener(e){
                            allCalendars.forEach(d => {
                            d.scrollTop = cal.scrollTop;
                            d.scrollLeft = cal.scrollLeft;
                            });
                        }
                        if(multiViewScrollingLinked){
                            cal.removeEventListener('scroll', linkMutliViewScrollingListener);
                        }
                        cal.addEventListener( 'scroll', linkMutliViewScrollingListener)
                    });
                    multiViewScrollingLinked = true;
                }


                var linkMutliViewScrollingFn = _.throttle(_.debounce(linkMutliViewScrolling, 200), 200, {leading: false});
                function monthViewer(){
                    function openDate(dateStr){
						scope.firstEvent = true;
                        if(scope.store.schedule.currentContext().type() == scope.store.schedule.contextTypes.SCHEDULE_DATE){
                            scope.store.schedule.setSelectedDateIfDiffrent(dateStr).then(function(){
                                model.apptLstUpdated(true);
                            })
                        }else if(scope.store.schedule.currentContext().okToClose()){
                            scope.store.schedule.currentContext(scope.store.schedule.contextTypes.SCHEDULE_DATE);
                            scope.store.schedule.setSelectedDateIfDiffrent(dateStr).then(function(){
                                model.apptLstUpdated(true);
                            })
                        }
                    }
                    var res = {
                        preset: 'month',
                        options: {
                            customButtons: {
                                todayBtn: {
                                    text: $filter("translate")("Today"),
                                    click: function() {
                                        scope.store.schedule.currentDate(moment().format(OfysUtils.DATEFORMAT));
                                    }
                                }
                            },
                            headerToolbar: {
                                right: 'todayBtn prev,next',
                                left: 'title',
                                // left: 'month,agendaWeek,agendaDay'
                            },
                            datesSet:function(dateInfo){
                                try{
                                    if(scope.store.schedule){
                                        scope.store.schedule.monthChanged();
                                    }
                                }catch(e){
                                    console.error(e);
                                    model.notice().fail($filter("translate")("ScheduleMonthUpdateFail"));
                                }
                            },
							select : function(info){
								$(".day-highlight").removeClass("day-highlight");
  								$(".fc-highlight").parents(".fc-daygrid-day-frame").addClass("day-highlight");
							},
                            eventClick: function(info){
                                openDate(OfysFCUtils.noTimezoneDate(info.event._instance.range.start));
                            },
							dayCellDidMount: function(info){
                                var menu = $popover($(info.el), {
                                    trigger:"contextmenu",
                                    autoClose: true,
                                    placement: "bottom",
                                    container: "body",
                                    keyboard: false,
                                    animation: "am-flip-x",
                                    templateUrl: "month_contextmenu_index.html",
                                    onShow: function(){
                                        for (var i = 0; i < allOpenContextMenus.length; i++) {
                                            allOpenContextMenus[i].hide();
                                        }
										menu.$scope.isMultiSchedule = scope.store.schedule.isMultiSchedule;
										menu.$scope.baseAppDate = scope.store.schedule.dates(moment(info.date).format("YYYY-MM-DD")).baseAppointmentDate;
                                        allOpenContextMenus = [];
                                        menu.$scope.canSendConfirmationEmail = function(){
											return !menu.$scope.isMultiSchedule && menu.$scope.baseAppDate 
													&& (!model.clientPreferences().hubEnabled
														|| !['MD_OMNIPRATICIEN', 'INFIRMIERE', 'INFIRMIERE_PRATICIENNE', 'RESIDENT'].some(e => e === scope.store.schedule.prof.professionalType));
										}
                                        $(info.el).parents(".fc-scroller").on('scroll', menu.hide);
                                        allOpenContextMenus.push(menu);
                                    },
                                    onHide: function(){
                                        $(info.el).parents(".fc-scroller").off('scroll', menu.hide);
                                        for (var i = 0; i < allOpenContextMenus.length; i++) {
                                            if(allOpenContextMenus[i] === menu){
                                                allOpenContextMenus.splice(i, 1);
                                            }
                                        }
                                    },
                                });
    
                                menu.$scope.api = eventApi;
                                menu.$scope.ofysEventId = "true";
                                
                                menu.$scope.sendMsgToPatients = function(){
									if(menu.$scope.baseAppDate){
										AppointmentAccessor.list({day:moment(info.date).format("YYYY-MM-DD"), idProf:menu.$scope.baseAppDate.professional}, function success(response) {
											let removeDeletedOrCanceled = [...response.data.filter(appt => appt.patientStatus !== "CANCEL" && appt.isDeleted === false)]
											if(removeDeletedOrCanceled.length > 0){
												let filtered = [...removeDeletedOrCanceled.filter(function(appt){
													return appt.status !== "CONFIRMED" && !(appt.status.includes("CONFIRMATION") && appt.status.includes("RECUE")) &&
																			(PatientAccessor.getPatientEmail(appt.patients[0]).hasMainEmail ||
																			PatientAccessor.getPatientTexto(appt.patients[0]).hasCell);
												})];
												filtered.forEach(appt => appt.selected = true);
												var qconfirmOptions = {templateUrl: 'confirmEmailToSend_index.html',
													selectSendTo: {confirmed: true, texto:false, email:false},
													apptList: {
														orig : removeDeletedOrCanceled,
														filtered: filtered,
													},
													updateApptList: function(){
														this.apptList.filtered = [...this.apptList.orig.filter(function(appt){
															if(this.selectSendTo.confirmed && appt.status !== "CONFIRMED" && !(appt.status.includes("CONFIRMATION") && appt.status.includes("RECUE"))){
																if(this.selectSendTo.email){
																	return PatientAccessor.getPatientEmail(appt.patients[0]).hasMainEmail;
																}else if(this.selectSendTo.texto){
																	return PatientAccessor.getPatientTexto(appt.patients[0]).hasCell;
																}else{
																	return PatientAccessor.getPatientEmail(appt.patients[0]).hasMainEmail ||
																			PatientAccessor.getPatientTexto(appt.patients[0]).hasCell;
																}
															}else if(!this.selectSendTo.confirmed){
																if(this.selectSendTo.email){
																	return PatientAccessor.getPatientEmail(appt.patients[0]).hasMainEmail;
																}else if(this.selectSendTo.texto){
																	return PatientAccessor.getPatientTexto(appt.patients[0]).hasCell;
																}else{
																	return PatientAccessor.getPatientEmail(appt.patients[0]).hasMainEmail ||
																			PatientAccessor.getPatientTexto(appt.patients[0]).hasCell;
																}
															}
														}, this)]
														this.apptList.filtered.forEach(appt => appt.selected = true)
													},
													getAppt: function(appt){
														return appt.patients[0].firstName + ", " + appt.patients[0].lastName
													},
													qconfirm: {
														hideNo: true,
//														yesTitle: "Save",
														beforeYes: function(e, obj){
															var data = [];
															for(let i=0; i<obj.apptList.filtered.length; i++){
																if(obj.apptList.filtered[i].selected){
																	var contactDetails;
																	if(obj.selectSendTo.email){
																		contactDetails = PatientAccessor.getPatientEmail(obj.apptList.filtered[i].patients[0]);
																	}else if(obj.selectSendTo.texto){
																		contactDetails = PatientAccessor.getPatientTexto(obj.apptList.filtered[i].patients[0]);
																	}else{
																		contactDetails = PatientAccessor.getPatientEmail(obj.apptList.filtered[i].patients[0]).hasMainEmail ? PatientAccessor.getPatientEmail(obj.apptList.filtered[i].patients[0]) 
																				: PatientAccessor.getPatientTexto(obj.apptList.filtered[i].patients[0]);
																	}
																	key = contactDetails.useContact.contact + "~" + obj.apptList.filtered[i].patients[0].firstName + " " + obj.apptList.filtered[i].patients[0].lastName
																	 		+ "~" + obj.apptList.filtered[i].patients[0].idPatient
															 		data.push({
																		key: key,
																		data:{
																			date:moment(info.date).format("YYYY-MM-DD"),
																			site: obj.apptList.filtered[i].siteNom,
																			start: obj.apptList.filtered[i].startTime,
																			id: obj.apptList.filtered[i].id,
																			prof: obj.apptList.filtered[i].profNom
																		}
																	})
																}
															}
															AppointmentAccessor.sendEmails(data, function(res){
																
															}, function(err){
																console.log(err);
															})
														}
													}
												}
												QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(){});
			                                    menu.hide();
		                                    }
										});
									}
								}

								menu.$scope.getMsgTypeName = function(type){
									let name = [];
									if(type === 1){
										name.push("ABSENT_ALL_DAY");
									}else if(type == 2){
										name.push("ABSENT_AM");
									}else if(type == 4){
										name.push("ABSENT_PM");
									}else if(type == 8){
										name.push("ABSENT_EVE");
									}else if(type == 16){
										name.push("PLAIN");
									}
									return name;
								}
								menu.$scope.getDeGardeName = function(type){
									let name = [];
									if(type.includes(1)){
										name.push("AM");
									}if(type.includes(2)){
										name.push("PM");
									}if(type.includes(4)){
										name.push("SOIR");
									}
									return name;
								}

								menu.$scope.addGarde = function(listGarde){
									var data = {
										dates: [moment(info.date).format("x")],
										profs: [scope.store.schedule.prof.id],
										gardeTypes: listGarde											
									}
									if(!menu.$scope.baseAppDate){
										menu.$scope.baseAppDate = scope.store.schedule.dates(moment(info.date).format("YYYY-MM-DD")).baseAppointmentDate = {};
									}
									AppointmentAccessor.changeAppointmentDateDeGardeType(data);
									menu.$scope.baseAppDate.deGardeTypes = menu.$scope.getDeGardeName(listGarde);
									menu.hide();
								}
								
								menu.$scope.delGarde = function(){
									var data = {
										dates: [moment(info.date).format("x")],
										profs: [scope.store.schedule.prof.id],
										gardeTypes: null											
									}
									AppointmentAccessor.deleteAppointmentDateDeGardeType(data)
									delete  menu.$scope.baseAppDate.deGardeTypes
									menu.hide();
								}
    
                                menu.$scope.addMsg = function(msgType, allProf){
									var qconfirmOptions = {templateUrl: 'addAbsenceMsgFrm_index.html',
										msgText: {msg: ""},
										qconfirm: {
											hideNo: true,
											yesTitle: "Save",
											beforeYes: function(e, obj){
												if(obj.qconfirm.frm && obj.qconfirm.frm.$valid){
													let profsList = [];
													if(allProf){
														let idSite = model.user().session.workSite.id
														for(const prof of scope.professionals){
															if(prof.code && prof.sites.filter(e => e.idSite == idSite).length > 0){
																profsList.push(prof.id)
															}
														}
													}else{
														profsList.push(scope.store.schedule.prof.id)
													}
													var data = {
														dates: [moment(info.date).format("x")],
														profs: profsList,
														message: obj.msgText.msg,
														messageType: msgType											
													}
													AppointmentAccessor.changeAppointmentDateMessage(data, function(){
														var dateStr = moment(info.date).format("YYYY-MM-DD")
														if(!menu.$scope.baseAppDate){
															menu.$scope.baseAppDate = scope.store.schedule.dates(dateStr).baseAppointmentDate = {};
														}
														if(allProf){
															menu.$scope.baseAppDate.messageTypesAll = menu.$scope.getMsgTypeName(msgType);
															menu.$scope.baseAppDate.messageAll = obj.msgText.msg;
														}else{
															menu.$scope.baseAppDate.messageTypes = menu.$scope.getMsgTypeName(msgType);
															menu.$scope.baseAppDate.message = obj.msgText.msg;
														}
														scope.store.schedule.updateBaseAppointmentDate(menu.$scope.baseAppDate, false)
														if($('.schdldayV .fc-timegrid-col[data-date='+ dateStr +']').length){
															var message = scope.getCurrDayAbsenceMessage(dateStr);
															var html = angular.element('<div class="app-absence-day-block">' +
										                		message +
										             		'</div>');
															$('.schdldayV .fc-timegrid-col[data-date='+ dateStr +']').append(html);
														}
													})
												}else{
													obj.qconfirm.frm.errorMsgs = PatientFormService.getFormErrors(obj.qconfirm.frm);
													e.prevent();
												}
											}
									}};
									QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(){});
                                    menu.hide();
                                };

								menu.$scope.delMsg = function(allProf){

                                    var	dateStr = moment(info.date).format("YYYY-MM-DD");
									let profsList = [];
									if(allProf){
										let idSite = model.user().session.workSite.id
										for(const prof of scope.professionals){
											if(prof.code && prof.sites.filter(e => e.idSite == idSite).length > 0){
												profsList.push(prof.id)
											}
										}
									}else{
										profsList.push(scope.store.schedule.prof.id)
									}
									var data = {
										dates: [moment(info.date).format("x")],
										profs: profsList,
										message: null,
										messageType: null											
									}
									AppointmentAccessor.changeAppointmentDateMessage(data)
									if(allProf){
										menu.$scope.baseAppDate.messageTypesAll = [];
										delete menu.$scope.baseAppDate.messageAll;
									}else{
										menu.$scope.baseAppDate.messageTypes = [];
										delete menu.$scope.baseAppDate.message;
									}
                                    var message = scope.getCurrDayAbsenceMessage(dateStr,scope.store.schedule.getProfId())
									if($('.schdldayV .fc-timegrid-col[data-date='+ dateStr +']').length &&
                                        message){
										var html = angular.element('<div class="app-absence-day-block">' +
					                		message +
					             		'</div>');
										$('.schdldayV .fc-timegrid-col[data-date='+ dateStr +']').append(html);
									} else if($('.schdldayV .fc-timegrid-col[data-date='+ dateStr +']').length){
										$('.schdldayV .fc-timegrid-col[data-date='+ dateStr +']').find(".app-absence-day-block").remove();
									}
									menu.hide();
								}
                            
							},
                            dateClick: function(info) {
                                openDate(info.dateStr.substring(0, 10))
                            },
                        },
                        calendarApi: function(api){
                            this.ctrler = api;
                        },
                    }
                    return res;
                }

                function getCurrentSchedule(){
                    return scope.store.schedule;
                }
                scope.getWeekDayName = function(){
                    if(model.schedule().currDate != undefined){
                        return moment(model.schedule().currDate).format("dddd");
                    }
                }
                function init(){
                    if(!model.schedule().store){
                        model.schedule().store = ScheduleStore;
                    }
                    if(!model.schedule().vb){
                        model.schedule().vb = {
                            search: true,
                            schedule: false,
                        }
                    }
                    if(_.isEmpty(ScheduleStore.viewers)){
                        ScheduleStore.viewers.month = monthViewer();
                        ScheduleStore.viewers.day = dayViewer(getCurrentSchedule);
                    }
                    scope.store = model.schedule().store;
					
                    if(scope.store.schedule && scope.store.schedule.isMultiSchedule && scope.store.schedule.multiViewCtrl.currentSchedule){
                        scope.store.schedule.multiViewCtrl.rememberCurrentSchedule.remember();
                    }
                    scope.professionals = scope.store.scheduleProfs;
                    scope.store.scheduleProfs.forEach(sp=>multiViewInitOnOpen(sp));
                    if(scope.store.schedule && scope.store.viewerTabs.tabs.length > 0){
                        var activeIndex = scope.store.viewerTabs.tabs.findIndex(function(e){
                            return e.name === scope.store.schedule.prof.id;
                        });
                        if(activeIndex > -1){
                            scope.store.viewerTabs.activeTab = activeIndex;
                        }
                    }
					if(scope.store.schedule && scope.store.schedule.currentAppointment()){
						AppointmentAccessor.updateMessageLink(scope.store.schedule.currentAppointment().patients[0], scope);
					}
                    scope.$watch(function(){
                        return scope.store.viewerTabs.activeTab;
                    }, function(n, o){
                        scope.store.viewerTabs.onChangeTab(n);
                    });
                }
                init();
            }
			
        }
    }]);


	appointment.directive('periodName', ['AppointmentAccessor','$translate',
        function (AppointmentAccessor, $translate) {
		return {
			restrict: 'E',
            templateUrl:'period_name_index.html',
			scope: { period:"=" },
            link: function(scope, element, attrs){
                scope.ofystime = function(input){
					if(input){
						input = input || 0;
						var hour = (input/60) | 0;
						var minutes = input%60;
						return (hour<10?'0':'')+hour+':'+(minutes<10?'0':'')+minutes;
					}
                }

                scope.getTypeString = function(type){
                    if(type){
                        var t = AppointmentAccessor.periodTypesById()[type];
                        var lang = 'french';
                        if ($translate.use()=='en') {
                            lang = 'english';
                        }
                        return t[lang];
                    }
                }
            }
        }
    }]);

	appointment.directive('editableAppointmentPatient', ["utils", "model", "$q", function (utils, model, $q) {
		return {
			restrict: 'A',
			scope: true,
			link: function (scope, element, attrs) {
                if(!scope.patient ){
                    scope.$watch(attrs.editableAppointmentPatient, function(){
                        scope.patient = scope.$eval(attrs.editableAppointmentPatient);
                    })
                }
				function handleUpdateView(){
					model.schedule().store.schedule.appToload.forEach(function(e){
						if(model.schedule().store.multiViewNofiticationIndex[e.idProf]){
			                Object.keys(model.schedule().store.multiViewNofiticationIndex[e.idProf]).forEach(function(multiViewId){
			                    model.schedule().store.activeSchedulesIndex[multiViewId].multiViewCtrl.getScheduleByProfId(e.idProf, e.handlFn);
			                });
			            }
					})
					delete model.schedule().store.schedule.reloadAfterSave;
					model.schedule().store.schedule.reloadAfterSave = []
				}
                scope.centerInPage = true;
                scope.editPatientPopoverOptions = {
                    showExit: true,
                    exit:function(s){
						delete model.schedule().store.schedule.patientInEdit;
						if(model.schedule().store.schedule.reloadAfterSave){
							model.schedule().store.schedule.multiViewCtrl.rememberCurrentSchedule.remember()
	          				$q.resolve(handleUpdateView())
								.then(model.schedule().store.schedule.multiViewCtrl.rememberCurrentSchedule.setAndForget);	
						}
						scope.popoverEdit = false;
                        scope.editPatientPopoverOptions.widget.api.hide();
                    },
                    widget:{
                        bsOptions: {
                            placement: "left",
                            container: "body",
                            trigger:"click",
                            keyboard: false,
                            animation: "am-flip-x",
                            templateUrl: "/dashboard/resources/ofys/pat/profil/patient_edit_popover.html?v=bb",
                            scope:scope,
                            onShow:function(){
								model.schedule().store.schedule.patientInEdit = true;
								model.schedule().store.schedule.appToload = [];
                                utils.showPopoverOverlay(true);
                            },
                            onHide:function(){
                                utils.showPopoverOverlay(false);
                            }
                        }
                    },
                    onSave: function(p){
                        if(scope.onSave){
                            scope.onSave(p, scope.editPatientPopoverOptions, scope);
                        }
                    }
                };
			}
		};
    }]);

    appointment.directive('appointmentSearchCriteria', ['PatientFormService','model', 'QConfirm','$filter', 'ModificationStatus', 'AppointmentAccessor','$timeout','$log',
							'Rights', 'PrefAccessor', 'Store',
        function(PatientFormService, model, QConfirm, $filter, ModificationStatus, AppointmentAccessor, $timeout , $log, Rights, PrefAccessor, Store){
            return {
                restrict: 'E',
                templateUrl: '/dashboard/resources/ofys/appointment/appointment_search_criteria.html?v=bb',
                scope: true,
                link: function(scope, element, attrs){

					scope.fromAppointmentPage = true;
					
					scope.hourFormat = 'HH:mm:ss'
					scope.dateFormat
					
					scope.showSearchOptionSwitch = function(){
						model.appointmentResearch().showSearchOption = !model.appointmentResearch().showSearchOption
					}
					
					scope.goToPeriod = function (period) {
						scope.showSearchOptionSwitch();
						var date = moment.utc(new Date(period.date * 24 * 60 * 60 * 1000)).format(OfysUtils.DATEFORMAT);
						var hour = moment.utc(new Date(period.startTime * 60 * 1000)).format(scope.hourFormat);
						scope.professionals = model.store.profs.filter.appointment.list();
						let prof = scope.professionals.find(prof => {
							return prof.id == period.idProfessionnal;
						})
						scope.store.selectProf(prof);
						if(scope.store.schedule.currentContext().type() == scope.store.schedule.contextTypes.SCHEDULE_DATE){
                            scope.store.schedule.setSelectedDateIfDiffrent(date).then(function(){
                                model.apptLstUpdated(true)
								$timeout(function(){
		                            let elem = $('.schdldayV .fc-timegrid-slot-label[data-time="'+ hour +'"]');
									elem[0].scrollIntoView();
									let periodId = getPeriodIdFromHour(scope.store.viewers.day.ctrler.cal.currentData.eventStore, moment(hour, scope.hourFormat), date);
									scope.store.schedule.createNewAppointment(date + "T" + hour, periodId);
								},550);
                            })
                        }else if(scope.store.schedule.currentContext().okToClose()){
                            scope.store.schedule.currentContext(scope.store.schedule.contextTypes.SCHEDULE_DATE);
                            scope.store.schedule.setSelectedDateIfDiffrent(date).then(function(){
                                model.apptLstUpdated(true);
								$timeout(function(){
		                            let elem = $('.schdldayV .fc-timegrid-slot-label[data-time="'+ hour +'"]')
									elem[0].scrollIntoView();
		                        },550);
                            })
                        }
					}
					
					function getPeriodIdFromHour(events, hour, date){
						let eventInstance = Object.values(events.instances).find(instance => {
							datePeriod =  moment(instance.range.start).format(OfysUtils.DATEFORMAT);
							startHour = moment(moment.utc(instance.range.start).format(scope.hourFormat), scope.hourFormat);
							endHour = moment(moment.utc(instance.range.end).format(scope.hourFormat), scope.hourFormat);
							return (startHour <= hour &&  endHour > hour && date == datePeriod)
						})
						return Object.values(events.defs).find(def => {
							return def.defId == eventInstance.defId
						}).publicId;
					}
                }
            }
    }]);

    appointment.directive('scheduleTemplatesLst', ['PatientFormService','model', 'QConfirm','$filter', 'ModificationStatus', 'AppointmentAccessor','$timeout','$log','Rights',
        function(PatientFormService, model, QConfirm, $filter, ModificationStatus, AppointmentAccessor, $timeout , $log, Rights){
            return {
                restrict: 'E',
                templateUrl: '/dashboard/resources/ofys/appointment/schedule_templates_lst.html?v=bb',
                scope: {
                    schedule:"=",
                },
                link: function(scope, element, attrs){

                }
            }
    }]);

    appointment.directive('scheduleDate', ['PatientFormService','model', 'QConfirm','$filter', 'ModificationStatus', 'AppointmentAccessor','$timeout','$log','Rights',
        function(PatientFormService, model, QConfirm, $filter, ModificationStatus, AppointmentAccessor, $timeout , $log, Rights){
            return {
                restrict: 'E',
                templateUrl: '/dashboard/resources/ofys/appointment/schedule_date.html?v=bb',
                scope: {
                    schedule:"=",
                    item:"="
                },
                link: function(scope, element, attrs){
                    scope.model = model;
                    scope.frmManager = new PatientFormService.formStateManager(scope.createform, 
                    {
                        registerDirty:function(){
                            // scope.item.modificationStatus = ModificationStatus.STATUS_UPDATED;
                            if(scope.item && scope.item.id){// element is not new. already has a Status new 
                                scope.item.dateTemplate.modificationStatus = ModificationStatus.STATUS_UPDATED;
                            }
                            scope.addToSavableIfValid();
                        },
                        unregisterDirty:function(){
                            // scope.item.modificationStatus = ModificationStatus.STATUS_NEUTRAL;

                            if(scope.item && scope.item.id){// element is not new. already has a Status new 
                                scope.item.dateTemplate.modificationStatus = ModificationStatus.STATUS_NEUTRAL;
                            }
                        },
                        errorObj:{
                            validfn: "SchlInvalid"
                        },
                        watch: function(){
                            scope.$watch('createform.$dirty',function(v){
                                scope.frmManager.dirty();
                            });
                        }
                    });
                    scope.humanReadableDate = function(date){
                        if(date){
                            return moment(date).format($filter("translate")("dateFormatHumanReadable"))
                        }
                    }
                    scope.backToDateContext = function(){
                        if(!scope.isScheduleDateContext()){
                            
                        }
                    }
                    scope.validFn = {
                        greaterThanStart: function(val){
                            return scope.item && scope.item.dateTemplate && val > scope.item.dateTemplate.startHour;
                        },
                        smallerThanEnd: function(val){
                            return scope.item && scope.item.dateTemplate && val < scope.item.dateTemplate.endHour;
                        }
                    }
                    scope.isScheduleDateContext = function(){
                        return scope.schedule.currentContext().type() === scope.schedule.contextTypes.SCHEDULE_DATE;
                    }
                    scope.addToSavableIfValid = function(){
					    // if(scope.frmManager.isValid()){
                            scope.schedule.addSavable(scope.item, 'dates', scope.item.date);
                        // }
                    }
                    scope.save = function(){
                        scope.frmManager.checkErrors();
                        scope.addToSavableIfValid();
                    }

                    function update(){
                        if(scope.item){
                            if(!scope.item.viewbag){
                                scope.schedule.initViewbag(scope.item);
                                scope.item.viewbag.manager = scope.frmManager; 
                                scope.item.viewbag.update = update;
                                scope.item.viewbag.okToClose = function(){
                                    scope.frmManager.checkErrors();
                                    return scope.frmManager.isValid();
                                }
                            }
                        }

                        scope.frmManager.dirty(false);
                    }
					scope.$watch("item", update);

                }
            }
    }]);

    appointment.directive('dateTemplatesLst', ['OfysFCUtils','model', 'QConfirm','$filter', 'ModificationStatus', 'AppointmentAccessor','$timeout','$log','Rights',
    function(OfysFCUtils, model, QConfirm, $filter, ModificationStatus, AppointmentAccessor, $timeout , $log, Rights){
        return {
            restrict: 'E',
            templateUrl:"/dashboard/resources/ofys/appointment/date_templates_lst.html?v=bb",
            scope: {
                schedule:"=",
            },
            link: function(scope, element, attrs){
                scope.opt = {
                    q: ""
                };
                scope.model = model;
                scope.showList = function(status){
                    if(status !== undefined){
                        scope.schedule.views.scheduleTemplatesLst.showDateTemplateList = status;
                    }else{
                        return scope.schedule.views.scheduleTemplatesLst.showDateTemplateList
                    }
                };

                scope.tagOrId = OfysFCUtils.getIdOrTag;
                scope.confirmDeleteWidget = function(template){
                    return function(){
                        scope.schedule.deleteDateTemplate(template);
                    }
                }
                scope.currProfTemplate = function(value, index, arr){
                    if(!value || value.isDeleted || 
                        (value.professionnal && value.professionnal !== scope.schedule.prof.id) ||
                        (scope.opt.q && value.note.toLowerCase().indexOf(scope.opt.q.toLowerCase()) === -1)
                        ){
                        return false;
                    }
                    return true;
                }

                scope.newDateTemplate = function(){
                    // scope.showList = false;
                    var t = scope.schedule.createNewDateTemplate()
                    model.schedule().appointmentDateTemplates.push(t)
                    scope.schedule.currentDateTemplate(t);
                }

                scope.cloneDateAsTemplate = function(){
                    // scope.showList = false;
                    var newTemplate = scope.schedule.cloneDateAsTemplate(scope.schedule.dates(scope.schedule.currentDate()));
                    model.schedule().appointmentDateTemplates.push(newTemplate);
                }

                scope.open = function(template){
                    // scope.showList = false;
                    // console.log(template);
                    if(scope.schedule.dateTemplateToWeekTemplateActive && 
                        scope.schedule.currentContext().type() === scope.schedule.contextTypes.WEEKTEMPLATE){
                            scope.schedule.currentContext().copyTemplate(template)
                    }else{
                        scope.schedule.currentDateTemplate(template);
                    }
                }
            }
        }
    }]);

    appointment.directive('appointmentcalSettings', ['PatientFormService','model', 'QConfirm','$filter', 'ModificationStatus', 'AppointmentAccessor','$timeout','$log','Rights',
    function(PatientFormService, model, QConfirm, $filter, ModificationStatus, AppointmentAccessor, $timeout , $log, Rights){
        return {
            restrict: 'A',
            scope: true,
            link: function(scope, element, attrs){
                scope.scheduleSettings= {};

                model.addPrefSettings(['ShowCanceledAppt'], scope.scheduleSettings, 'user_settings_');
		        model.addPrefSettings(['appointmentDayViewScale'], scope.scheduleSettings, 'schedule_settings_');
		        model.addPrefSettings(['scheduleDayViewScale'], scope.scheduleSettings, 'schedule_settings_');
		        model.addPrefSettings(['showAppTime'], scope.scheduleSettings, 'schedule_settings_');
		        model.addPrefSettings(['showDeletedAppt'], scope.scheduleSettings, 'schedule_settings_');
            }
        }
    }]);

    appointment.directive('dateTemplatesApply', ['PatientFormService','model', 'QConfirm','$filter', 'ModificationStatus', 'AppointmentAccessor','$timeout','$log','Rights',
    function(PatientFormService, model, QConfirm, $filter, ModificationStatus, AppointmentAccessor, $timeout , $log, Rights){
        return {
            restrict: 'A',
            scope: true,
            link: function(scope, element, attrs){
                scope.ONCE = "once";
                scope.RECURRING = "Recurring";
                scope.tab = scope.ONCE;
                scope.model = model;
                scope.showList = true;
                scope.wdays = ["Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa"];

                var types = [
                    {"Di":true, "Lu":true, "Ma":true, "Me":true, "Je":true, "Ve":true, "Sa":true},
                    {"Di":false, "Lu":true, "Ma":true, "Me":true, "Je":true, "Ve":true, "Sa":false},
                    {"Di":false, "Lu":false, "Ma":false, "Me":false, "Je":false, "Ve":false, "Sa":false}
                ];
                scope.wsd = angular.copy(types[0]);
                scope.setDaysShortCut = function(){
                    scope.wsd = angular.copy(types[(scope.dateselect.repeatdayShortcut*1)-1]);
                    if(scope.dateselect.repeatdayShortcut == "3"){
                        scope.wsd[scope.wdays[moment(scope.dateselect.startdate).day()]] = true;
                    }
                }

                scope.selectRightDayOfWeek = function(d){
                    scope.wsd[d] = !scope.wsd[d];
                    for (let i = 0; i < types.length; i++) {
                        if(_.isEqual(scope.wsd,types[i])){
                            scope.dateselect.repeatdayShortcut = (i+1)+"";
                            return;
                        }
                    }
                    scope.dateselect.repeatdayShortcut = "3";
                }

                scope.CR_OVERRIDE = '1';
                scope.CR_MERGE = '2';
                scope.CR_MERGE_MODEL_FIRST = '21';
                scope.CR_MERGE_DAY_FIRST = '22';
                scope.CR_MERGE = '2';
                scope.CR_SKIP = '3';
                scope.CR_ASK = '4';

                scope.crMergeOptions = [{id:scope.CR_MERGE_MODEL_FIRST, name:"STAFTMergeModelFirst"}, 
                    {id:scope.CR_MERGE_DAY_FIRST, name:"STAFTMergeDayFirst"}];

                scope.crOptions = [{id:scope.CR_OVERRIDE, name:"STAFTOverride"}, 
                    {id:scope.CR_MERGE, name:"STAFTMerge"},
                    {id:scope.CR_SKIP, name:"STAFTSkip"},
                    {id:scope.CR_ASK, name:"STAFTAsk"}];

                scope.selectDateDynaOptions = {acceptFutureDate: true};
                scope.startDateDynaOptions = {acceptFutureDate: true};
                scope.dateselect = {
                    date: scope.schedule.currentDate(),
                    startdate: scope.schedule.currentDate(),
                    endcount:1,
                    endcountType:"days",
                    repeatdayShortcut: "1",
                    conflictresolution: scope.CR_ASK,
                    conflictresolutionprivilege: scope.CR_MERGE_DAY_FIRST,
                }

                scope.currProfTemplate = function(value, index, arr){
                    if(!value || value.isDeleted || 
                        (value.professionnal && value.professionnal !== scope.schedule.prof.id) ||
                        (scope.q && value.note.toLowerCase().indexOf(scope.q.toLowerCase()) === -1)
                        ){
                        return false;
                    }
                    return true;
                }

                function getRecurringDates(){
                    var momentStart = moment(scope.dateselect.startdate)
                    var cursor = moment(scope.dateselect.startdate)
                    var res = [];
                    var momentEnd = moment(scope.dateselect.startdate).add(scope.dateselect.endcount, scope.dateselect.endcountType);
                    var deltaDays = momentEnd.diff(momentStart, "days");
                    for (let i = 0; i < deltaDays; i++) {
                        if(cursor.isBefore(momentEnd) && isSelectedWeekDay(cursor.day())){// i
                            res.push({date: cursor.format(OfysUtils.DATEFORMAT), dayIndex: cursor.day()})
                        }
                        cursor.add(1, "day");
                    }
                    return res;
                }
                function isSelectedWeekDay(i){
                    return scope.wsd[scope.wdays[i]];
                }
                function textDesc(){

                }

                scope.apply = function(template){
                    if(scope.tab === scope.ONCE){
                        scope.schedule.setDateTemplateToDate(scope.template, scope.dateselect.date, scope.dateselect);
                    }else if(scope.tab === scope.RECURRING){
                        scope.schedule.setBatchDateTemplateToDate(function(){return scope.template}, getRecurringDates(), scope.dateselect)
					}
                }
            }
        }
    }]);

    appointment.directive('weekTemplatesApply', ['model', 'AppointmentAccessor',
    function(model, AppointmentAccessor){
        return {
            restrict: 'A',
            scope: true,
            link: function(scope, element, attrs){
                scope.ONCE = "once";
                scope.RECURRING = "Recurring";
                scope.tab = scope.ONCE;
                scope.model = model;
                scope.showList = true;
                scope.wdays = ["Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa"];
                scope.wsd = {"Di":false, "Lu":false, "Ma":false, "Me":false, "Je":false, "Ve":false, "Sa":false};

                scope.CR_OVERRIDE = '1';
                scope.CR_MERGE = '2';
                scope.CR_MERGE_MODEL_FIRST = '21';
                scope.CR_MERGE_DAY_FIRST = '22';
                scope.CR_MERGE = '2';
                scope.CR_SKIP = '3';
                scope.CR_ASK = '4';

                scope.crMergeOptions = [{id:scope.CR_MERGE_MODEL_FIRST, name:"STAFTMergeModelFirst"}, 
                    {id:scope.CR_MERGE_DAY_FIRST, name:"STAFTMergeDayFirst"}];

                scope.crOptions = [{id:scope.CR_OVERRIDE, name:"STAFTOverride"}, 
                    {id:scope.CR_MERGE, name:"STAFTMerge"},
                    {id:scope.CR_SKIP, name:"STAFTSkip"},
                    {id:scope.CR_ASK, name:"STAFTAsk"}];

                scope.selectDateDynaOptions = {acceptFutureDate: true,
                onDateSelected:function(date, cal){
                    setToWeekStart(date, function(start){
                        cal.baseElement.data("DateTimePicker").date(start);
                        scope.dateselect.date = start;
                    })
                }};
                scope.startDateDynaOptions = {acceptFutureDate: true,
                    onDateSelected:function(date, cal){
                        setToWeekStart(date, function(start){
                            cal.baseElement.data("DateTimePicker").date(start);
                            scope.dateselect.startdate = start;
                        })
                }};
                scope.dateselect = {
                    date: AppointmentAccessor.getStartOfWeek(scope.schedule.currentDate()),
                    startdate: AppointmentAccessor.getStartOfWeek(scope.schedule.currentDate()),
                    endcount:2,
                    endcountType:"weeks",
                    conflictresolution: scope.CR_ASK,
                    conflictresolutionprivilege: scope.CR_MERGE_DAY_FIRST,
                }

                function setSelectedDate(start){
                    scope.dateselect.date = start;
                }
                scope.setStartOfWeek = function(){
                    setToWeekStart(scope.dateselect.date, setSelectedDate);
                }
                scope.setRecurringStartOfWeek = function(){
                    setToWeekStart(scope.dateselect.startdate, function(e){
                        scope.dateselect.startdate = e;
                    });
                }
                
                function setToWeekStart(origDate, fn){
                    if(origDate && moment(origDate).isValid()){
                        var start = AppointmentAccessor.getStartOfWeek(origDate)
                        if(start !== origDate){
                            fn && fn(start);
                        }
                    }
                }
                scope.currProfTemplate = function(value, index, arr){
                    if(!value || value.isDeleted || 
                        (value.professionnal && value.professionnal !== scope.schedule.prof.id) ||
                        (scope.q && value.note.toLowerCase().indexOf(scope.q.toLowerCase()) === -1)
                        ){
                        return false;
                    }
                    return true;
                }

                function getWeekDatesList(weekstart, rep){
                    var momentStart = moment(weekstart);
                    var res = [{date:weekstart, dayIndex:momentStart.day()}];
                    var days = (7 * rep)-1;
                    for (let i = 0; i < days; i++) {
                        momentStart.add(1, 'day')
                        res.push({date:momentStart.format(OfysUtils.DATEFORMAT), dayIndex: momentStart.day()})
                    }
                    return res;
                }

                scope.apply = function(template){
                    var start = scope.tab === scope.ONCE ? scope.dateselect.date: scope.dateselect.startdate;
                    var repetitions = scope.tab === scope.ONCE ? 1: scope.dateselect.endcount;
					scope.schedule.isWeekRecuringLoading = true
                    scope.schedule.setWeekTemplateToDate(scope.template, 
                        getWeekDatesList(start, repetitions), 
                        scope.dateselect);
                }
            }
        }
    }]);

    appointment.directive('weekTemplatesLst', ['OfysFCUtils','model', 'QConfirm','$filter', 'ModificationStatus', 'AppointmentAccessor','$timeout','$log','Rights',
    function(OfysFCUtils, model, QConfirm, $filter, ModificationStatus, AppointmentAccessor, $timeout , $log, Rights){
        return {
            restrict: 'E',
            templateUrl: "/dashboard/resources/ofys/appointment/week_templates_lst.html?v=bb",
            scope: {
                schedule:"=",
            },
            link: function(scope, element, attrs){
                scope.opt = {
                    q: ""
                };
                scope.model = model
                scope.showList = function(status){
                    if(status !== undefined){
                        scope.schedule.views.scheduleTemplatesLst.showWeekTemplateList = status;
                    }else{
                        return scope.schedule.views.scheduleTemplatesLst.showWeekTemplateList;
                    }
                };
                
                scope.tagOrId = OfysFCUtils.getIdOrTag;
                scope.confirmDeleteWidget = function(template){
                    return function(){
                        scope.schedule.deleteWeekTemplate(template);
                    }
                }

                scope.currProfTemplate = function(value, index, arr){
                    if(!value || value.isDeleted || 
                        (value.professionnal && value.professionnal !== scope.schedule.prof.id) ||
                        (scope.opt.q && value.note.toLowerCase().indexOf(scope.opt.q.toLowerCase()) === -1)
                        ){
                        return false;
                    }
                    return true;
                }

                scope.newWeekTemplate = function(){
                    // scope.showList = false;
                    var t = scope.schedule.createNewWeekTemplate()
                    model.schedule().appointmentWeekTemplates.push(t);
                    scope.schedule.currentWeekTemplate(t);
                }

                scope.open = function(template){
                    scope.schedule.currentWeekTemplate(template);
                }

                scope.setToWeek = function(template){

                }
            }
        }
    }]);

	appointment.directive('scheduleHeader', ['model','$filter','ModificationStatus','AppointmentAccessor',
        function(model, $filter, ModificationStatus,AppointmentAccessor){
            return {
                restrict: 'E',
                templateUrl:"/dashboard/resources/ofys/appointment/schedule_header.html?v=bb",
                scope: {
                    schedule: "=",
                },
                link: function(scope, element, attrs){
                    scope.types = ["dates","dateTemplates","weekTemplates"];
                    scope.titles = {
                        dates: function(k,v){
                            return k;
                        },
                        dateTemplates: function(k,v){
                            return $filter("translate")("ScheduleDateTemplate")+ " : "+ (v.note?v.note:"");
                        },
                        weekTemplates:function(k,v){
                            return $filter("translate")("ScheduleWeekTemplate")+ " : "+  (v.note?v.note:"");
                        }
                    }

                    scope.showModifications = function(type){
                        if(type){
                            if(scope.isDirty(scope.schedule.getScheduleSaveContainer()[type])){
                                scope.schedule.views.activeModificationTab = type;
                            }
                        }else{
                            return scope.schedule.views.activeModificationTab;
                        }
                    }
                    scope.objLength = function(obj){
                        return Object.keys(obj).length;
                    }
                    scope.isDirty = function(type){
                        return !_.isEmpty(type);
                        var saveContainer = scope.schedule.getScheduleSaveContainer();
                        for (let i = 0; i < scope.types.length; i++) {
                            if(!_.isEmpty(saveContainer[scope.types[i]])){
                                return true;
                            }
                        }
                        return false;
                    }
                    scope.cancel = function(){
                        scope.schedule.cancelModifications();
                    }
                    
                }
            }
    }]);

    appointment.directive('schedulePeriodLst', ['$translate','model', 'OfysFCUtils','$filter', 'ModificationStatus', 'AppointmentAccessor','$timeout','$log','Rights',
    function($translate, model, OfysFCUtils, $filter, ModificationStatus, AppointmentAccessor, $timeout , $log, Rights){
        return {
            restrict: 'E',
            templateUrl: "/dashboard/resources/ofys/appointment/periods_lst.html?v=bb",
            scope: {
                schedule:"=",
                lst:"=",
                headertitle:"=",
                dateTemplate:"=",
            },
            link: function(scope, element, attrs){
                scope.showList = true;
                scope.allTypes = AppointmentAccessor.activePeriodTypes();
                scope.ofystime = function(input){
					if(input){
						input = input || 0;
						var hour = (input/60) | 0;
						var minutes = input%60;
						return (hour<10?'0':'')+hour+':'+(minutes<10?'0':'')+minutes;
					}
                }
                scope.tagOrId = OfysFCUtils.getIdOrTag;

                scope.getTypeString = function(type){
                    if(type){
                        var t = AppointmentAccessor.periodTypesById()[type];
                        var lang = 'french';
                        if ($translate.use()=='en') {
                            lang = 'english';
                        }
                        return t[lang];
                    }
                }

                function hourToTime(h){
                    if(h != undefined){
                        return moment(h+"", "H").startOf('hour').format("HH:mm")
                    }
                }
                scope.newPeriod = function(){
                    var n = nextAvailableSlot();
                    if(n !== undefined){
                        scope.schedule.createNewPeriod(moment(n, "HH:mm").format('YYYY-MM-DD HH:mm'));
                    }
                }
                function nextAvailableSlot(){
                    var res;
                    if(scope.lst && scope.lst.length > 0){
                        scope.lst.forEach(function(p){
                            if(res == undefined || p.endTime > res){
                                res = p.endTime;
                            }
                        });
                        res = moment().startOf('day').add(res, 'm').format("HH:mm")
                    }else if(scope.dateTemplate && scope.dateTemplate.startHour){
                        res = hourToTime(scope.dateTemplate.startHour);
                    }
                    return res;
                }
                
                scope.confirmDeleteWidget = function(period){
                    return function(){
                        scope.schedule.currentContext().deletePeriod(period)
                    }
                }

				scope.deleteAppDate = function(){
					return function(){
						for(let i = scope.lst.length; i > 0; i--){
							scope.schedule.currentContext().deletePeriod(scope.lst[i-1])
						}
					}
                }

				scope.closeAllAppDate = function(){
					return function(){
						scope.lst.forEach(period => {
							period.isClosed = true;
							scope.schedule.redrawPeriod(period)
						})
						scope.schedule.currentContext().dirty(true);
					}
                }

                scope.open = function(period){
                    scope.schedule.currentPeriod(OfysFCUtils.getIdOrTag(period));
                }
            }
        }
    }]);

	appointment.directive('periodEdit', ['model','$translate','ModificationStatus','PatientFormService','AppointmentAccessor', '$filter',
        function(model, $translate, ModificationStatus,PatientFormService, AppointmentAccessor, $filter){
            return {
                restrict: 'E',
                templateUrl:"/dashboard/resources/ofys/appointment/period_edit.html?v=bb",
                scope: {
                    schedule: "=",
                    context:"=",
                    item: "=",
                },
                link: function(scope, element, attrs){
                    scope.isRVSQEnabled = false;

                    function isRVSQEnabled () {
                        // model.clientPreferences().
                    }
                    scope.frmManager = new PatientFormService.formStateManager(scope.createform, 
                    {
                        registerDirty:function(){
                            // console.log(scope.item);
                            scope.context.dirty(true);
                            scope.item.modificationStatus = ModificationStatus.STATUS_UPDATED;
                        },
                        unregisterDirty:function(){
                            scope.context.dirty(false);
                            scope.item.modificationStatus = ModificationStatus.STATUS_NEUTRAL;
                        },
                        errorObj:{
                            validfn: "SchlInvalid"
                        },
                        watch: function(){
                            scope.$watch('createform.$dirty',function(v){
                                scope.frmManager.dirty();
                            });
                        }
                    });
                    scope.allsites = OfysUtils.ObjectValuesAsArray(model.user().sites);

                    scope.allTypes = AppointmentAccessor.activePeriodTypes();
                    scope.allTypesById = AppointmentAccessor.periodTypesById();

                    scope.getTypeString = function(type){
                        if(type){
                            var lang = 'french';
                            if ($translate.use()=='en') {
                                lang = 'english';
                            }
                            return type[lang];
                        }
                    }
					scope.getOrderedType = function(){
                            var lang = 'french';
                            if ($translate.use()=='en') {
                                lang = 'english';
                            }
                            return $filter('orderBy')(scope.allTypes, [lang]);
                    }
                    scope.sofyTreatingChanged = function(){
                        if(scope.item && scope.item.isSofyTreatingRestricted){
                            scope.item.isSofyEnabled = true;
                        }
                    }

                    function getTimeDynaOptions(){
                        return {
                            acceptFutureDate: true,
                            format: 'HH:mm',
                            stepping: 5,
                        };
                    }
                    scope.starttimeDynaDateOptions = getTimeDynaOptions();
                    scope.endtimeDynaDateOptions = getTimeDynaOptions();

                    scope.validFn = {
                        greaterThanStart: function(val){
                            if(scope.item && scope.item.startTime){
                                var isValid = val > scope.item.startTime;
                                return isValid && noPeriodConflicts();
                            }
                            return true;
                        },
                        smallerThanEnd: function(val){
                            if(scope.item && scope.item.endTime){
                                var isValid = val < scope.item.endTime;
                                return isValid && noPeriodConflicts();
                            }
                            return true;
                        },
                        longerThanPeriodDuration: function(val){
							
                            if(scope.item && scope.item.endTime && scope.item.startTime){
                                var isValid = (val*1) <= (scope.item.endTime - scope.item.startTime ) && (val*1) > 0;
                                return isValid ;
                            }
                            return true;
                        },
						noPeriodConflicts: function(){
							return noPeriodConflicts();
						},
                    }
                    function noPeriodConflicts(){
                        return scope.schedule.noPeriodConflicts(scope.item, scope.context.currentDateTemplate());
                    }

                    var prevalidate = true;// ensures that prevalidate is only called once per validation.
                    scope.prevalidateStartEndValid = function(validator) {
                        if(prevalidate){
                            prevalidate = false;// weird code but very useful. Prevents stack overflow as the $validate() function seems to trigger the change function.
                            validator.startTime.$validate();
                            validator.endTime.$validate();
                            validator.defaultlenght.$validate();
							validator.periodconflicts.$validate();
                            if(scope.frmManager.errors && scope.frmManager.errors.length > 0){
                                scope.frmManager.checkErrors();
                            }
                            scope.redrawIfValid(validator);
                            prevalidate = true;// weird code but very useful. Prevents stack overflow as the $validate() function seems to trigger the change function.
                        }
                    }

                    scope.updateLastModifiedPeriodType = function(periodTypeid){
                        if(periodTypeid){
                            if(scope.allTypesById[periodTypeid]){
                                scope.schedule.lastModifiedPeriodType = scope.allTypesById[periodTypeid];
                            }
                        }
                    }

                    scope.redrawIfValid = function(validator) {
                        if(validator.$valid){
                            scope.redraw();
                        }
                    }

                    scope.redraw = function(){
                        scope.schedule.redrawPeriod(scope.item);
                    }

                    scope.save = function(app){
                        // scope.frmManager.checkErrors();
					    // if(scope.frmManager.isValid()){
                        //     scope.schedule.addSavable(scope.item, 'dates', scope.item.dateTemplate.note);
                        // }
                    }

                    function update(v){
                        if(!scope.item.viewbag){
                            scope.item.viewbag = {
                                okToClose: function(){
                                    scope.frmManager.checkErrors();
                                    return scope.frmManager.isValid();
                                }
                            }
                        }

                        scope.frmManager.dirty(scope.item.modificationStatus !== ModificationStatus.STATUS_NEUTRAL);
                    }

                    scope.$watch('item',update);
                }
            }
    }]);

	appointment.directive('weekTemplateEdit', ['model','$filter','ModificationStatus','PatientFormService',
        function(model, $filter, ModificationStatus,PatientFormService){
            return {
                restrict: 'E',
                templateUrl:"/dashboard/resources/ofys/appointment/week_template_edit.html?v=bb",
                scope: {
                    schedule: "=",
                    item: "=",
                },
                link: function(scope, element, attrs){
                    scope.frmManager = new PatientFormService.formStateManager(scope.createform, 
                    {
                        registerDirty:function(){
                            if(scope.item.id){
                                scope.item.modificationStatus = ModificationStatus.STATUS_UPDATED;
                            }
                            scope.addToSavableIfValid();
                        },
                        unregisterDirty:function(){
                            if(scope.item.id){
                                scope.item.modificationStatus = ModificationStatus.STATUS_NEUTRAL;
                            }
                        },
                        errorObj:{
                            validfn: "SchlInvalid"
                        },
                        watch: function(){
                            scope.$watch('createform.$dirty',function(v){
                                scope.frmManager.dirty();
                            });
                        }
                    });
                    scope.days = scope.schedule.WEEKDAYS;

                    scope.toggleCopy = function(){
                        scope.schedule.dateTemplateToWeekTemplateActive = !scope.schedule.dateTemplateToWeekTemplateActive;
                        scope.schedule.views.scheduleTemplatesLst.showDateTemplateList = scope.schedule.dateTemplateToWeekTemplateActive;
                    }

                    scope.toCurrentProf =function(isCurrent){
                        if(isCurrent !== undefined){
                            if(isCurrent){
                                scope.item.professionnal = scope.schedule.prof.id;
                            }else{
                                delete scope.item.professionnal;
                            }
                        }else{
                            return !!(scope.item.professionnal);
                        }
                    }

                    function deleteIfNewAndEmpty(){
                        if(!scope.item.id && scope.schedule.isEmptyWeekTemplate(scope.item)){
                            scope.schedule.deleteWeekTemplate(scope.item);
                            scope.frmManager.dirty(false);
                        }
                    }

                    scope.close = function(){
                        deleteIfNewAndEmpty();
                        if(scope.schedule.currentContext().okToClose()){
                            scope.schedule.showCurrentDate();
                        }
                    }

                    scope.daylable = function(day){
                        var res = $filter("translate")("sd_"+day);
                        if(day && scope.item && scope.item[day] && scope.item[day].lstPeriods && scope.item[day].lstPeriods.length > 0){
                            res += ' '+scope.item[day].lstPeriods.length;
                        }
                        return res;
                    }

                    scope.setDay = function(day){
                        if(day && day !== scope.selectedday){
                            // scope.schedule.currentContext().beforeUpdate();
                            if(scope.item[day] == undefined){
                                scope.item[day] = scope.schedule.createNewDateTemplate();
                            }
                            scope.item.viewbag.selectedday = day;
                            scope.schedule.clearSelectedPeriod();
                            // scope.schedule.currentContext().updated();
                        }
                    }

                    scope.addToSavableIfValid = function(){
					    // if(scope.frmManager.isValid()){
                            scope.schedule.addSavable(scope.item, 'weekTemplates', scope.item.id ? scope.item.id : scope.item.tag);
                        // }
                    }
                    scope.save = function(app){
                        scope.frmManager.checkErrors();
                        scope.addToSavableIfValid();
                    }

                    function update(){
                        if(scope.item){
                            if(!scope.item.viewbag){
                                scope.schedule.initViewbag(scope.item);
                                var d = scope.item.viewbag.selectedday = scope.schedule.WEEKDAYS[moment(scope.schedule.currentDate()).day()];
                                if(!scope.item[d]){
                                    scope.item[d] = scope.schedule.createNewDateTemplate();
                                }
                                scope.item.viewbag.manager = scope.frmManager;
                                scope.item.viewbag.update = update;
                                scope.item.viewbag.okToClose = function(){
                                    scope.frmManager.checkErrors();
                                    var child;
                                    if(scope.item.viewbag.selectedday && 
                                        scope.item[scope.item.viewbag.selectedday] &&
                                        scope.item[scope.item.viewbag.selectedday].viewbag &&
                                        scope.item[scope.item.viewbag.selectedday].viewbag.okToClose){
                                        child = scope.item[scope.item.viewbag.selectedday].viewbag.okToClose;
                                    }
                                    return scope.frmManager.isValid() && (!child || child());
                                }
                                // scope.setDay("monday");
                            }
                            scope.frmManager.dirty(false);//make sure form is pristine
                        }
                    }

                    scope.$watch("item", update);
                }
            }
    }]);

	appointment.directive('dateTemplateEdit', ['model','$translate','ModificationStatus','PatientFormService',
        function(model, $translate, ModificationStatus,PatientFormService){
            return {
                restrict: 'E',
                templateUrl:"/dashboard/resources/ofys/appointment/date_template_edit.html?v=bb",
                scope: {
                    schedule: "=",
                    item: "=",
                    headertitle:"=",
                    context:"=",
                },
                link: function(scope, element, attrs){
                    
                    scope.frmManager = new PatientFormService.formStateManager(scope.createform, 
                    {
                        registerDirty:function(){
                            if(scope.item.id){// element is not new. already has a Status new 
                                scope.item.modificationStatus = ModificationStatus.STATUS_UPDATED;
                            }
                            if(!scope.hasContext(function(){scope.context.dirty(true);})){
                                scope.addToSavableIfValid();
                            }
                        },
                        unregisterDirty:function(){
                            scope.hasContext(function(){scope.context.dirty(false);})
                            if(scope.item.id){// element is not new. already has a Status new 
                                scope.item.modificationStatus = ModificationStatus.STATUS_NEUTRAL;
                            }
                        },
                        errorObj:{
                            validfn: "SchlInvalid"
                        },
                        watch: function(){
                            scope.$watch('createform.$dirty',function(v){
                                scope.frmManager.dirty();
                            });
                        }
                    });
                    scope.editDayLength = false;
                    scope.changeEditDayLength = function(){
                        scope.editDayLength = true;
                    }

                    scope.toCurrentProf =function(isCurrent){
                        if(isCurrent !== undefined){
                            if(isCurrent){
                                scope.item.professionnal = scope.schedule.prof.id;
                            }else{
                                delete scope.item.professionnal;
                            }
                        }else{
                            return !!(scope.item.professionnal);
                        }
                    }

                    scope.addToSavableIfValid = function(){
                        scope.schedule.addSavable(scope.item, 'dateTemplates', scope.item.id ? scope.item.id: scope.item.tag);
                    }
                    scope.save = function(app){
                        scope.frmManager.checkErrors();
                        scope.addToSavableIfValid();
					    // if(scope.frmManager.isValid()){
                            // scope.schedule.clearSelectedDateTemplate();
                            scope.schedule.showCurrentDate()
                        // }
                    }



                    scope.validFn = {
                        greaterThanStart: function(val){
                            if(scope.item && scope.item.startHour == undefined){
                                // this condition avoid a bug where if both values are invalid the form is locked in an invalid state and the user must refresh the page.
                                return true;
                            }
                            return scope.item && val > scope.item.startHour;
                        },
                        smallerThanEnd: function(val){
                            if(scope.item && scope.item.endHour == undefined){
                                // this condition avoid a bug where if both values are invalid the form is locked in an invalid state and the user must refresh the page.
                                return true;
                            }
                            return scope.item && val < scope.item.endHour;
                        }
                    }
                    scope.hasContext = function (fn){
                        if(scope.context){
                            fn && fn();
                            return true;
                        }
                        return false;
                    }


                    function deleteIfNewAndEmpty(){
                        if(!scope.item.id && scope.schedule.isEmptyDateTemplate(scope.item)){
                            scope.schedule.deleteDateTemplate(scope.item);
                            scope.frmManager.dirty(false);
                        }
                    }
    
                    scope.close = function(){
                        deleteIfNewAndEmpty();
                        if(scope.schedule.currentContext().okToClose()){
                            scope.schedule.showCurrentDate();
                        }
                    }
                    
                    function update(){
                        if(scope.item){
                            if(!scope.item.viewbag){
                                scope.schedule.initViewbag(scope.item);
                                scope.item.viewbag.manager = scope.frmManager; 
                                scope.item.viewbag.update = update;
                                scope.item.viewbag.okToClose = function(){
                                    scope.frmManager.checkErrors();
                                    return scope.frmManager.isValid();
                                }
                            }
                            scope.frmManager.dirty(false);//make sure form is pristine
                        }
                    }

                    scope.$watch("item", update);
                }
            }
    }]);

	appointment.directive('recallSearch', ['model', '$filter', 'AppointmentAccessor', 'RecallAccessor', 'PrintAccessor', 'FlView',
		function(model, $filter, AppointmentAccessor, RecallAccessor, PrintAccessor, FlView){
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/appointment/recall_search.html?v=bb',
				scope: true,
				link: function(scope, element, attrs){
					scope.recallDynaDateOptionsDateAfter = {acceptFutureDate: true};
					scope.recallDynaDateOptionsDateBefore = {acceptFutureDate: true};
					scope.recallDynaDateOptionsRequestedAfter = {acceptFutureDate: true};
					scope.recallDynaDateOptionsRequestedBefore = {acceptFutureDate: true};
//					model.notice().note($filter('translate')('err_recall_edit'));
					scope.isSearching = false;
					scope.lstProf = $filter('orderBy')(model.store.profs.filter.treating.list(), ['lastName', 'firstName']);
					scope.allLables = [];
					if(!model.recall().searchData.professionnalId){
						model.recall().searchData.professionnalId = scope.store.schedule.prof.id
					}
					const datesArr = [['dateCreatedStart','dateCreatedEnd'],['dateRecallStart','dateRecallEnd']];
					const DATEFORMAT = 'YYYY-MM-DD';
					
					RecallAccessor.labels(function(labels){
                   		scope.allLables = labels;
	                });
//					res.data.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
					model.enums().recallPreferredTime
					scope.$watch('allLables|filter:{selected:true}', function (nv) {
						model.recall().searchData.labels = nv.map(function (option) {
					   		return option.id;
						});
					}, true);
					
					function setMissingDate(ds, dates, itv) {
						var now = moment();
						for (var i=0;i<dates.length;i++) {
							var dd = dates[i];
							if (MyNamespace.helpers.isNotEmpty(ds[dd[0]]) && MyNamespace.helpers.isEmpty(ds[dd[1]])) {
								var max = moment(ds[dd[0]]).add(itv.nb, itv.unit);
								ds[dd[1]] = max.format(DATEFORMAT);
								
							} else if (MyNamespace.helpers.isNotEmpty(ds[dd[1]]) && MyNamespace.helpers.isEmpty(ds[dd[0]])) {
								var min = moment(ds[dd[1]]).subtract(itv.nb, itv.unit);
								ds[dd[0]] = min.format(DATEFORMAT);
							}
						}					
					}
					
					function hasADate(ds, dates) {
						for (var i=0;i<dates.length;i++) {
							var dd = dates[i];
							if (MyNamespace.helpers.isNotEmpty(ds[dd[0]]) || MyNamespace.helpers.isNotEmpty(ds[dd[1]])) {
								return true;
							}
						}
					}
					scope.hasSelectedADate = function(){
						return hasADate(model.recall().searchData, datesArr);
					}
					
					scope.getRecallList = function(){
						scope.isSearching = true;
						if(!scope.hasSelectedADate()){
							model.recall().searchData.dateRecallEnd = moment().format(OfysUtils.DATEFORMAT)
						}
						setMissingDate(model.recall().searchData, datesArr, {unit:'years', nb:1});
						AppointmentAccessor.recall(model.recall().searchData, function(res){
							scope.isSearching = false;
							if (res.data.success===false) {
								model.notice().warn(res.data.ms);
							} else  {
								model.recall().currList = res.data;
								scope.store.schedule.switchRecallEditMode(true);
								model.apptUpdated(true);
							}
						}, function(err) {
							console.log(err);
							model.notice().warn($filter('translate')('error') + ": " + err);										
							scope.isSearching = false;
						});	
					}
					
					scope.getAvailableReportsRecall = function(recalls){
						let recallsIds = [];
						for(const recall of recalls){
							recallsIds.push(recall.id);
						}
						model.print().type.ids = recallsIds;
						model.print().type.type = "patientrecall"
						
						PrintAccessor.getAvailableReports(model.print().type, function(res){
							res.data.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
							for(list of res.data){
								list.reports.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
							}
							model.print().currList = res.data;
							FlView.open({templateUrl: "/dashboard/resources/ofys/print/print.html?v=bb", list: res.data, type: appointment}, {
								backdrop: 'static',windowClass: "printmodal"}).then(function(data){
									
							});
						});
					}
					
					scope.switchRecallEditMode = function(){
						scope.store.schedule.switchRecallEditMode()
					}
					
					scope.addNewRecall = function(){
						if(model.recall().inEditMode == false){
							model.recall().currRecall = {};
							model.recall().inEditMode = true;
							scope.store.schedule.switchRecallEditMode(false);
							model.apptUpdated(true);
						} else{
							model.notice().warn($filter('translate')('err_recall_edit'))
						}
					}
				}
			}
	}]);
	
	appointment.directive('recallList', ['model', '$filter', 'patientShowTitles', 'AppointmentAccessor', '$popover', '$timeout',
		function(model, $filter, patientShowTitles, appointmentAccessor, $popover, $timeout){
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/appointment/recall_list.html?v=bb',
				scope: true,
				link: function(scope, element, attrs){
					
					scope.switchRecallEditMode = function(){
						scope.store.schedule.switchRecallEditMode()
					}

					scope.passRecall = function(act){
						scope.data = act;
					}
					
					scope.actOptions = {verbose: false, fct:scope.passRecall};
					
					scope.copy = function(){
                        model.recall().copyRecall = scope.data;
                    };
			
					scope.showPatientHtml = function(pat) {
						return patientShowTitles.showPatientHtml(pat);
					};
					
					scope.edit = function(){
						if(model.recall().inEditMode == false){
							model.recall().currRecall = scope.data;
							if(model.recall().currRecall.patient){
								model.recall().currRecall.patient.fullName = model.recall().currRecall.patient.lastName 
																				+ ', '+ model.recall().currRecall.patient.firstName
							}
							if(model.recall().currRecall.labels){
								for(const label of model.recall().currRecall.labels){
									label.selected = true;
								}
							}
							model.recall().inEditMode = true;
							scope.store.schedule.switchRecallEditMode(false);
							model.apptUpdated(true);
						}else{
							model.notice().warn($filter('translate')('err_recall_edit'))
						}
                    };
					var menu;
					scope.getFuturPatAppt = function(e){
						if(menu)menu.destroy();
						appointmentAccessor.findFuturAppointmentPatient(scope.data.patient.id, function(res){
							menu = $popover($(e.currentTarget),{
					            trigger:"focus",
					            autoClose: true,
					            placement: "auto left",
					            keyboard: false,
					            animation: "am-flip-x",
					            templateUrl: "/dashboard/resources/ofys/appointment/past_futur_appt_modal.html?v=bb",
					        });
							menu.$scope.apptList = res.data.sort(function(a,b){
								return a.when-b.when;
							})
							menu.$scope.futur = true
							$timeout(function(){
								menu.show();
							}, 100)
						})
					}
					
					scope.getPastPatAppt = function(e){
						if(menu)menu.destroy();
						appointmentAccessor.findPastAppointmentPatient(scope.data.patient.id, function(res){
							menu = $popover($(e.currentTarget),{
					            trigger:"focus",
					            autoClose: true,
					            placement: "auto left",
					            keyboard: false,
					            animation: "am-flip-x",
					            templateUrl: "/dashboard/resources/ofys/appointment/past_futur_appt_modal.html?v=bb",
					        });
							menu.$scope.apptList = res.data.sort(function(a,b){
								return b.when-a.when;
							})
							menu.$scope.futur = false
							$timeout(function(){
								menu.show();
							}, 100)
						})
					}
	                
				}
			}
	}]);
	
	appointment.directive('recallEdit', ['model', '$filter', '$q', 'PatientAccessor', 'utils', '$timeout',
							'RecallAccessor', 'PatientFormService', 'QConfirm', 'patientShowTitles',
		function(model, $filter, $q, PatientAccessor, utils, $timeout, RecallAccessor, PatientFormService, QConfirm, patientShowTitles){
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/appointment/recall_edit.html?v=bb',
				scope: true,
				link: function(scope, element, attrs){
					
					var patientSearchTemplate = '/dashboard/resources/ofys/pat/profil/patient_searchItem.html?v=bb';
					utils.getTemplate(patientSearchTemplate);
					scope.lstProf = scope.lstProf = $filter('orderBy')(model.store.profs.filter.treating.list(), ['lastName', 'firstName']);
					scope.lstProf.sort((a,b) => (a.lastName > b.lastName) ? 1 : ((b.name > a.name) ? -1 : 0));
					scope.profName = null;
					scope.isSaving = false;
					scope.newRecall = false;
					
					RecallAccessor.labels(function(labels){
                   		scope.allLables = labels;
						if(model.recall().currRecall.labels){
							for(label of model.recall().currRecall.labels){
								isSelected = scope.allLables.find(x => x.id === label.id)
								isSelected.selected = true;
							}
						}
	                });

					scope.$watch('allLables|filter:{selected:true}', function (nv) {
						if(scope.allLables){
							model.recall().currRecall.labels = nv.map(function (option) {
						   		return option;
							});
						}
					}, true);
					
					scope.isNotUndefined = function(val){
                        return model.recall().currRecall.patient != undefined ;
                    }
					
					scope.recallEditDateDynaDateOptions = {
	                    format: 'YYYY-MM-DD',
	                    acceptFutureDate: true,
	                    onDateSelected: function (mDate, dAssist) {
	                        if (model.recall().currRecall) {
	                            var m = mDate.format(dAssist.format);
	                            model.recall().currRecall.dateRecall = m;
	                            // console.log(m);
	                        }
	                    }
	                };

					scope.hasPatient = function(){
						return model.recall().currRecall.patient != null && model.recall().currRecall.patient.id;
					}

					scope.patientSearchAssist = {
						assistId: "autocomplete_recall_patient",
						nextTabOnTab: true,
						nextTabOnEnter: true,
						hasDetails: false,
						hasHeader: false,
						trigger: 'focus',
						getAsyncData: function(query, assist){
							query = query.replace(',', '');//make sure that composed names with commas are searchable too
							return $q(function(resolve, reject) {
								if(query.length > 2){
									PatientAccessor.search(b64EncodeUnicode(query), function(res){
										resolve(res.data);
									}, angular.noop);
								}else{
									resolve([]);
								}
							});
						},
						getKey: function(recipient) {
							var newScope = scope.$new();
							newScope.item = recipient;
							var res =  utils.getTemplateAndCompileSync(newScope, patientSearchTemplate);
							$timeout(function(){
								if(!newScope.$$phase) {
									newScope.$digest();
								}
							},0);
							return res;
						},
						selection: function(pat, assistObject) {
							model.recall().currRecall.patient = pat;
							model.recall().currRecall.patientSearch = scope.patName(pat);
							return scope.patName(pat);
						}
	                };

					scope.professionalSearchAssist = {
						assistId: "autocomplete_recall_prof",
						nextTabOnTab: true,
						nextTabOnEnter: true,
						hasDetails: false,
						hasHeader: false,
						minChar: 0,
						trigger: 'focus',
						getAsyncData: function(query, assist){
							return $q(function(resolve, reject) {
								resolve($filter('filter')(scope.lstProf, query));
							});
						},
						getKey: function(prof) {
							return scope.profName(prof);
						},
						selection: function(prof, assistObject) {
							model.recall().currRecall.profName = scope.profName(prof);
	                        model.recall().currRecall.professionnal = prof.id;
							return model.recall().currRecall.profName;
						}
	                };
			 		scope.refProfSearchAssist = angular.copy(scope.professionalSearchAssist);
					scope.refProfSearchAssist.assistId = "autocomplete_recall_ref_prof";
					scope.refProfSearchAssist.selection = function(prof, assistObject){
	                    model.recall().currRecall.refProfName = scope.profName(prof);
	                    model.recall().currRecall.referringProfessionnal = prof.id;
	                    return model.recall().currRecall.refProfName;
	                };

					scope.profName = function(prof){
						return prof.lastName + ', '+ prof.firstName + ' (' + prof.code + ')';
	                }
	
					scope.patName = function (pat){
	                    if(pat){
	                        return pat.lastName + ', '+ pat.firstName;
	                    }
	                    return "";
	                }

					scope.removePatient = function(recall){
						model.recall().currRecall.patient = undefined;
						model.recall().currRecall.patientSearch = null;
					}

					scope.removeProf = function(recall){
	                    model.recall().currRecall.professionnal = null;
	                    model.recall().currRecall.profName = null;
						model.apptUpdated(true);
	                }
	
	                scope.removeRefProf = function(recall){
	                    model.recall().currRecall.referringProfessionnal = null;
	                    model.recall().currRecall.refProfName = null;
						model.apptUpdated(true);
	                }
					
					scope.saveRecall = function(frm){
						scope.frmErrors = PatientFormService.getFormErrors(frm,null, {validfn: "InvalidRecall_"});
						if(frm.$valid && scope.hasPatient()){
							isSaving = true;
							RecallAccessor.save(model.recall().currRecall, function(res){
								var saved ;
		                        if(res.className === "CPatientRecall"){
		                            saved = res;
									model.recall().inEditMode = false
									if(scope.newRecall){
										res.isShowPatient = true;
										model.recall().currList.push(res)
									} else {
										saved.isShowPatient = true;
										const index = model.recall().currList.findIndex(e => e.id == model.recall().currRecall.id);
										model.recall().currList[index] = saved;
									}
									scope.store.schedule.switchRecallEditMode()
		                        }
		                        if (!saved) {
		                            model.notice().fail($filter('translate')('SaveError'));
		                        }
								isSaving = false;
								model.apptUpdated(true);
							})
						}
					}
					
					scope.closeEdit = function(frm){
						QConfirm.open({title: $filter('translate')('recallUnsavedChanges')}).then(function(ok){
    						if(ok){
    							scope.saveRecall(frm);
    						} else {
								model.recall().inEditMode = false;
								model.recall().currRecall = {};
								if (model.recall().currList.length > 0){
									scope.store.schedule.switchRecallEditMode()
								}else{
									scope.store.schedule.views.recallEdit.visible = false;
								}
							}
    					});
						
						model.apptUpdated(true);
					}
					
					if(_.isEmpty(model.recall().currRecall)){
						scope.newRecall = true
						model.recall().currRecall.profName = scope.profName(model.schedule().store.schedule.prof);
	                    model.recall().currRecall.professionnal = model.schedule().store.schedule.prof.id;
						model.recall().currRecall.priority =  model.enums().recallPriority.NORMAL.type;
						model.recall().currRecall.status = model.enums().recallStatus.NORMAL.type;
						model.recall().currRecall.preferredTime = model.enums().recallPreferredTime.NONE.type;
					} else {
						model.recall().currRecall.patientSearch = scope.patName(model.recall().currRecall.patient);
					}

				}
			}
	}]);
	
	appointment.controller('RecallAppointmentLinkController', ['$scope', 'model', 'RecallAccessor', '$filter',
		function($scope, model, RecallAccessor, $filter){
			
			$scope.chosenRecall = undefined;
			
			$scope.genRecallText = function(recall){
				return (recall.dateCreated ? recall.dateCreated : "") + " "
					+ $filter('translate')('from')+ ": " + recall.profName + ', ' 
					+ (recall.dateRecall ? "demandé le : " + recall.dateRecall + ", " : "")
					+ recall.reason
					+ (recall.status === "CLIENT_NOT_REACHED" ? ", " + $filter('translate')('CLIENT_NOT_REACHED') : "")
			}
			
			$scope.closeRecallModal = function(app){
				model.schedule().store.schedule.saveAppointment(app)
				$scope.fl.cancel()
			}
			
			$scope.updateRecall = function(app){
				if($scope.chosenRecall){
					$scope.chosenRecall.status = "APPOINTMENT_GIVEN";
					RecallAccessor.save($scope.chosenRecall, function(res){
						var saved ;
	                    if(res.className === "CPatientRecall"){
	                        saved = res;
	                    }
	                    if (!saved) {
	                        model.notice().fail($filter('translate')('SaveError'));
	                    }
						$scope.fl.cancel();
					})
					if(app.note && $scope.chosenRecall.reason !== ""){
						app.note = app.note + "; " + $filter('translate')('recall_note') + ": " + $scope.chosenRecall.reason
					}else if ($scope.chosenRecall.reason !== ""){
						app.note = $scope.chosenRecall.reason
					}
					model.schedule().store.schedule.saveAppointment(app)
				}
			}
		}
	]);

	appointment.directive('appointmentEdit', ['DashAPI','PatientAccessor','PatientFormService','patientShowTitles','model', 'QConfirm','$filter', 'ModificationStatus', 'AppointmentAccessor','$timeout',
												'$log','Rights','utils','$translate','PrintAccessor', 'FlView', 'hotkeys',
        function(DashAPI, PatientAccessor, PatientFormService, patientShowTitles, model, QConfirm, $filter, ModificationStatus, AppointmentAccessor, $timeout , $log, Rights,utils, $translate, PrintAccessor, FlView, hotkeys){
            return {
                restrict: 'E',
                templateUrl: '/dashboard/resources/ofys/appointment/appointment_edit.html?v=bb',
                scope: true,
                link: function(scope, element, attrs){
                    scope.serv = {};
                    scope.allsites = OfysUtils.ObjectValuesAsArray(model.user().sites);
                    scope.dateDynaDateOptions = {
                        acceptFutureDate: true,
                    };
                    function getTimeDynaOptions(){
                        return {
                            acceptFutureDate: true,
                            format: 'HH:mm',
                        };
                    }

                    scope.addNewPatient = function(){
                        var newPatient = {isNew: true, className: "CPatient", viewbag: {limitations:Rights.getConsent()}};
                        return newPatient;
                    };
                    scope.newPatient = {
                        patient: scope.addNewPatient(),
                        onSave: function(saved, options, s){
                            scope.patientSearch.onSelect(saved);
                            s.patient = scope.addNewPatient();//TODO: make this code better.too much variable piping.
                            scope.newPatient.patient = s.patient;
                            // if(options && options.exit && options.widget
                            //     && options.widget.api
                            //     && options.widget.api.$isShown){
                            //     options.exit();
                            // }
                            console.log("saved");
                        }
                    }
                    scope.formatDate = function(reqDate, dateFormat){
                        moment.locale(model.prefSettings('language'));
                        return moment(reqDate).format(dateFormat);
                    }

                    scope.details = {
                        activeTab: "PatientResume",
                        tabs:[
                            {
                                title: 'PatientResume',
                                template: 'resumepatient_index.html',
                            },
                            // {
                            //     title: 'LINK_FORM',
                            //     template: 'resumepatient_index.html',
                            // },
                            // {
                            //     title: 'LINK_SCAN',
                            //     template: 'resumepatient_index.html',
                            // },
                            // {
                            //     title: 'LINK_LABO',
                            //     template: 'resumepatient_index.html',
                            // },
                        ]
                    }

                    scope.patientResumeOptions ={
                        fileOpenActive: function(){
                            return !scope.app.editMode
                        },
                        onAdhocPatientSave: function(saved){
                            if(scope.app.adhocPatient && scope.app.patients.length == 0){
                                scope.app.patients = [saved];
                                scope.app.modificationStatus = ModificationStatus.STATUS_UPDATED;
                                scope.store.schedule.saveAppointment(scope.app, true);
                            }
                        }
                    }
                    AppointmentAccessor.appointementStatus(function(res){
                        scope.allstatus = res.sort((a,b) => a.i18n.localeCompare(b.i18n));
                        scope.allstatusByType = _.indexBy(res, 'type');
                    })
//                    AppointmentAccessor.patientStatus(function(res){
//                        scope.allpatientstatus = res;
//                        scope.allpatientstatusByType = _.indexBy(res, 'type');
//                    });
					scope.getPatientStatusText = function(key){
						if(key){
							return model.patientStatuses().find(e=> e.key == key).text;
						}else{
							return undefined;
						}		
					}
                    scope.allTypes = AppointmentAccessor.activeAppointmentTypes();
                    scope.allServices = AppointmentAccessor.activePeriodTypes();
                    scope.hubEnabled = model.clientPreferences().hubEnabled;
                    scope.allTypesById = AppointmentAccessor.appointmentTypesById();

                    scope.patientSearch = {
                        onSelect:function(pat){
                            if(scope.app){
                                updatePatientWithLimitation(pat)
                                var index = scope.app.patients.findIndex(function(e){return e.id == pat.id;})
                                if(index > -1){
                                    scope.app.patients.splice(index, 1, pat);
                                }else{
                                    scope.app.patients.push(pat);
                                }
                                scope.selectPatient(pat);
                                redrawAppoitnment();
                            }
                        },
                        fixPositioning:function(dxA){
                            if(dxA != null && dxA.assistElement != null ){
                                var position = dxA.assistElement[0].getBoundingClientRect();
                                var maincontainer = dxA.assistElement.find(".assist-main-div");
                                var width = maincontainer[0].offsetWidth;
                                var xEnd = (position.x + width);
                                if(xEnd > window.innerWidth){// element is overflowing
                                    dxA.assistElement.css("position","fixed");
                                    dxA.assistElement.css("top","initial");
                                    dxA.assistElement.css("z-index","100");
                                    var leftpos = (position.x-(xEnd - window.innerWidth)-5);
                                    dxA.assistElement.css("left",+leftpos+"px");
                                }
                            }
                        }
                    }

                    function updatePatientWithLimitation(p){
                        if(p && !p.viewbag){
                            p.viewbag = {};
                            p.viewbag.limitations = Rights.getSessionUserConsent(p);
                        }
                    }

                    scope.removeProf = function(profId){
                        if(scope.app.idProfessionals){
                            var i = scope.app.idProfessionals.findIndex(function(e){return profId === e;});
                            i > -1 && scope.app.idProfessionals.splice(i, 1);
                            redrawAppoitnment();
                        }
                    }

                    scope.profSearch = {
                        onSelect:function(prof){
                            if(scope.app){
                                scope.app.idProfessionals.push(prof.id);
                                redrawAppoitnment();
                            }
                        }
                    }

                    function redrawAppoitnment(){
                        if(scope.store && scope.store.schedule){
                            scope.store.schedule.redrawAppointment(scope.app, scope.originalApp);
                        }
                    }
					
                    scope.selectPatient = function(pat){
                        scope.app.selectedPatient = pat;
                    }

                    scope.getAppointmentPatients = function(app){
                        if(app && app.patients.length == 0  && app.adhocPatient){
                            return [app.adhocPatient];
                        }else if(app){
                            return app.patients;
                        }
                    }

                    scope.removePatient =function(pat){
                        if(scope.app.patients){
                            var i = scope.app.patients.findIndex(function(e){return pat.idPatient === e.idPatient;});
                            i > -1 && scope.app.patients.splice(i, 1);
                            if(scope.app.selectedPatient == pat){
                                scope.app.selectedPatient = null;
                            }
                            redrawAppoitnment();
                        }
                    }

					// section pour le popop des questionnaires.
					scope.srvyTitle = function(srvy) {
						return srvy['surveyTitle_'+ DashAPI.lang];	
					};
					scope.popupView = function (dataviewerPopover, patient, srvy) {
						var srvyId = 'SRVY' + srvy.id;
						if(!dataviewerPopover || dataviewerPopover.open === false){
							clearPopups();
						}
						if(dataviewerPopover){
							dataviewerPopover.open = !dataviewerPopover.open;
							scope.data = scope.dataviewerPopover[srvyId].popupdata.quickViewData;
							scope.titleNoTranslate = scope.srvyTitle(srvy);
						}else{
							scope.dataviewerPopover[srvyId] = {
								popupdata: patientShowTitles.getQVPayLoad(srvy, {hasHeader: false}, patient),
								open: true
							};
							scope.data = scope.dataviewerPopover[srvyId].popupdata.quickViewData;
							scope.titleNoTranslate = scope.srvyTitle(srvy);
						}
						scope.dataviewerPopover[srvyId].open ? openPopup(scope.dataviewerPopover[srvyId]) : closePopup(scope.dataviewerPopover[srvyId]);
					};
					var OPENEDDATAVIEWERS = ".popupViewData.open";
					function clearPopups(removeClass) {
						var els = $(OPENEDDATAVIEWERS)
						function clear(){
							for (var i = 0; i < els.length; i++) {
								angular.element(els[i]).triggerHandler("click");
							}
						}
						$timeout(clear);
					}
					function openPopup(pop){
						function hideOnClickOutside(selector) {
							pop.listener = (event) => {
							  $target = $(event.target);
							  if (!$target.closest(selector).length && $(selector).is(':visible')) {
								  clearPopups();
								  pop.removeClickListener();
							  }
							}
							pop.removeClickListener = function() {
							  document.removeEventListener('click', pop.listener);
							}
							document.addEventListener('click', pop.listener);
						}
						hideOnClickOutside('.dataviewerpopover');
					}
					function closePopup(pop){
						if(pop.removeClickListener){
							pop.removeClickListener();
						}
					}

                    function initEditableAppointment(){
                        scope.starttimeDynaDateOptions = getTimeDynaOptions();
                        scope.endtimeDynaDateOptions = getTimeDynaOptions();
                        scope.endtimeDynaDateOptions.widgetPositioning = {horizontal: 'right'};
                        scope.arrivedtimeDynaDateOptions = getTimeDynaOptions();
                        scope.seentimeDynaDateOptions = getTimeDynaOptions();
                        if(scope.originalApp && scope.originalApp.editable){
                            scope.app = scope.originalApp.editable;
                        }else{
                            scope.app = angular.copy(scope.originalApp);
                            // scope.data = scope.app;	// nécessaire pour le popop de Q-R
							if(scope.app){
				                for (var i = 0; i < scope.app.patients.length; i++) {
		                        	var pat = scope.app.patients[i];
		                        	if (pat.srvy==undefined) {
										PatientAccessor.patientAptsurvey({idPatient: pat.id, idApt:scope.originalApp.id}, function(res){
											if (res.data && res.data.length!==undefined && res.data.length>0 ) {
												pat.srvy = res.data;
											} else {
												pat.srvy = [];
											}
										});
									}
								}
	                            scope.originalApp.editable = scope.app;
	                            
	                            if(scope.originalApp.reservation){//make sure that it is not cloned
	                                scope.app.reservation = scope.originalApp.reservation;
	                            }
	                            scope.app.viewbag = {orig: scope.originalApp , alertEditMode: function(){
	                                vb = this;
	                                vb.shake = true;
	                                $timeout(function(){
	                                    vb.shake = false;
	                                }, 2000)
	                            }};
	                            if(scope.app.modificationStatus === ModificationStatus.STATUS_NEW){
	                                scope.schedule.setAppointmentEditMode(scope.app, true);
	                            }
							}
                        }
                    }

                    function update(){
						scope.dataviewerPopover={hideCloseBtn:true};
                        scope.originalApp = scope.$eval(attrs.app);
                        scope.schedule = scope.$eval(attrs.schedule);

                        initEditableAppointment()
                        initialFocus();
                    };

                    function initialFocus(){
                        $timeout(function(){
                            if(scope.patientSearch.focus){
                                scope.patientSearch.focus();
                            }
                        }, 50)
                    };

                    scope.setPatientStatus = function(noop, ptStatus) {
                        var rdv = scope.store.schedule.currentAppointment();
                        //console.log(rdv);
                        if(rdv.editable){
                            rdv.editable.patientStatus = ptStatus.key;
                        }
                        // return;
                        var data = {apptId: rdv.id, statusId:ptStatus.index};
                        AppointmentAccessor.setPatientStatus(data, function(){
                            $log.log("succès setPatientStatus!");

                            rdv.patientStatus = ptStatus.key;
                            var newCol = model.patientStatusColors(rdv.patientStatus);
                            rdv.ptStatColor[0] = newCol[0];
                            rdv.ptStatColor[1] = newCol[1];
                            rdv.ptStatColor[2] = newCol[2];
							model.apptUpdated(true);
                        }, function() {
                            $log.log("Erreur setPatientStatus ...");
                        });
                    };

					scope.setApppointmentStatus = function(rdv, appStatus) {
						var rdv = scope.store.schedule.currentAppointment();
						if(rdv.editable){
                            rdv.editable.status = appStatus.key;
                        }
						$timeout(function(){
							rdv.status = appStatus.key;
							var data = {apptId: rdv.id, statusId:appStatus.index};
							AppointmentAccessor.setAppointmentStatus(data,
								function() {
									$log.log("succès setAppointmentStatus!");
								}, function() {
									$log.log("Erreur setPatientStatus ...");
								});
						}, 10);
					};

                    scope.cancel = function(appointment){
                        if(scope.schedule.reservationLock){
                            scope.schedule.reservationLock = false;
                        }
                        if(appointment.reservation){
                            AppointmentAccessor.deleteReservation(appointment.reservation, angular.noop);
                        }
						if(scope.schedule.tempPopout){
							scope.schedule.toggleRightSideBar();
							scope.schedule.tempPopout = false; 
						}
                        scope.schedule.cancelEdit();
                        scope.frmErrors = [];
                        if(scope.schedule.currentAppointment()){
                            delete scope.originalApp.editable;
                            initEditableAppointment();
                            scope.store.schedule.redrawAppointment(scope.originalApp, scope.originalApp);
                        }
                    }

                    scope.edit = function(){
                        scope.schedule.setAppointmentEditMode(scope.app, !scope.app.editMode);
                        model.apptUpdated(true);
                    }

                    scope.extendReservation = function(appointment){
                        if(appointment.reservation){
                            AppointmentAccessor.extendReservation(appointment.reservation, angular.noop);
                        }
                    }
                    scope.greaterThanStart = function(val){
                        if(scope.app.startTime != undefined){
                            return val > scope.app.startTime;
                        }
                        return true;
                    }
                    scope.smallerThanEnd = function(val){
                        if(scope.app.endTime != undefined && val != undefined){
                            return val < scope.app.endTime ;
                        }
                        return true;
                    }
                    scope.getterThanZero = function(val){
                        return val > 0;
                    }
                    scope.validType = function(val){
                        return !!(scope.allTypesById[val])
                    }

                    scope.save = function(appointment, frm){
                        scope.frmErrors = PatientFormService.getFormErrors(frm,null, {validfn: "InvalidRDV"});
					    if(frm.$valid){
							if(scope.schedule.tempPopout){
								scope.schedule.toggleRightSideBar();
								scope.schedule.tempPopout = false; 
							}
							if(appointment.modificationStatus === "STATUS_NEW" && appointment.patients.length < 2){
								AppointmentAccessor.recall({patientId:appointment.selectedPatient.id}, function(res){
									listRecall = res.data.filter(function(obj){
										return obj.status === "CLIENT_NOT_REACHED" || obj.status === "NORMAL";
									})
									if(listRecall.length > 0){
										FlView.open({templateUrl: "/dashboard/resources/ofys/appointment/recall_link_appointment.html?v=bb", list: listRecall, app: appointment}, 
													{backdrop: 'static',windowClass:'recallmodal'})
//											.then(function(){});
									} else {
										scope.schedule.saveAppointment(appointment);
									}
								});
							} else {
								scope.schedule.saveAppointment(appointment);
							}
                        }
                    }

                    scope.revalidateStartEnd = function(frm){
                        if (!frm.endTime.$valid || !frm.startTime.$valid){
                            frm.startTime.$validate();
                            frm.endTime.$validate();
                        }
                    }
                    scope.renewReservation = function(app, frm, redraw){
                        if(app && frm && frm.endTime.$valid && frm.startTime.$valid){
                            scope.store.schedule.renewReservation(app);
                        }else if(!redraw && frm){
							scope.frmErrors = PatientFormService.getFormErrors(frm,null, {validfn: "InvalidRDV"});
						}
                        if(redraw && frm && frm.endTime.$valid && frm.startTime.$valid){
                            redrawAppoitnment()
                        }
                    }

                    scope.deleteSelected = function(appointment){
    					QConfirm.open({title: $filter('translate')('CONFIRM_DELETE_APP')}).then(function(ok){
    						if(ok){
    							scope.schedule.deleteAppointment(appointment);
    						}
    					});
                    }

                    scope.undeleteSelected = function(appointment){
                        scope.schedule.undeleteAppointment(appointment);
                    }

                    scope.closeSelected = function(appointment){
                    	scope.schedule.clearSelectedAppointment();
                    }

					scope.getAvailableReportsApp = function(appointment){
						model.print().type.id = appointment.id
						model.print().type.type = "appointment"
						
						PrintAccessor.getAvailableReports(model.print().type, function(res){
							res.data.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
							for(list of res.data){
								list.reports.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
							}
							model.print().currList = res.data;
							FlView.open({templateUrl: "/dashboard/resources/ofys/print/print.html?v=bb", list: res.data, type: appointment}, {
								backdrop: 'static',windowClass: "printmodal"}).then(function(data){
									
							});
						});
					}
					
					scope.canPrint = function(appointment){
						let canPrint = true;
						if(appointment){
							for(const pat of appointment.patients){
								canPrint = canPrint && pat.viewbag && pat.viewbag.limitations
											&& pat.viewbag.limitations.Address && pat.viewbag.limitations.ContactMeans 
							}
						}
						return canPrint;
					}
                    
                    scope.setToLatestVersion = function(appointment){
                        utils.showPopoverOverlay(false);
                        if(appointment.date != appointment.latestVersion.date){
                            var appointmentOnNewDate = appointment.latestVersion;
                            scope.schedule.clearAppointment(appointment);
                            scope.schedule.updateAppointment(appointmentOnNewDate)
                        }else{
                            scope.schedule.updateAppointment(appointment, appointment.latestVersion);
                        }
                        
                    }

                    scope.updateType = function(){
                        var t = scope.app.typeAppointment
                        if(t != undefined
                            && scope.allTypesById[t].duree){
                            setEndTimeWithMinsDuration(scope.allTypesById[t].duree, scope.app)
                            redrawAppoitnment();
                        }
                    }

                    function setEndTimeWithMinsDuration(mins, app){
                        app.endTime = app.startTime + mins;
                    }

                    scope.getTypeString = function(type){
                        if(type != undefined){
                            var res = [];
                            if(type.code){
                                res.push(type.code);
                            }
                            if(type.str){
                                res.push(type.str);
                            }
                            if(type.duree){
                                res.push(type.duree + ' mins' );
                            }
                            return res.join(' | ')
                        }
                    }

					scope.editMode = {}
					
                    var lang = 'french';
                    if ($translate.use()=='en') {
                        lang = 'english';
                    }
					scope.getServiceTypeString = function(idService){
						var type = scope.allServices.find(e => e.id == idService);
						return scope.getServiceString(type);
					}
					scope.getOrderedService = function(){
                            var lang = 'french';
                            if ($translate.use()=='en') {
                                lang = 'english';
                            }
                            return $filter('orderBy')(scope.allServices, [lang]);
                    }
                    scope.getServiceString = function(type){
                        if(type){
                            return type[lang];
                        }
                    }
                    if(scope.qv){
                        scope.qv.isDirty = function(){
                            return false;//does not support modifications yet
                        };
                    }
                    
					var patStatusActions = {l: "CANCEL", u: "SEEN", a: "ARRIVED", e: "NOT_CAME", k: "PLACED"};
					var apptStatusActions = {g: "MESSAGE_LEAVED", i: "CONFIRMED", d: "NO_ANSWER"};
					var macKey = ['command+l','command+u','command+a','command+e','command+k','command+g','command+i','command+d'];
					var winKey = ['ctrl+l','ctrl+u','ctrl+a','ctrl+e','ctrl+k','ctrl+g','ctrl+i','ctrl+d'];
					hotkeys.bindTo(scope).add({
						combo: OfysUtils.isMac? macKey: winKey,
						description: 'Raccourcis clavier pour status de rendez-vous et patient',
						callback: function(event) {
							event.preventDefault();
							key = event.key;
							if(model.patientStatuses().some(e => e.key == patStatusActions[key])){
								scope.setPatientStatus(undefined, model.patientStatuses().find(e => e.key == patStatusActions[key]))
							}else if(model.appAllStatus().some(e => e.key == apptStatusActions[key])){
								scope.setApppointmentStatus(undefined, model.appAllStatus().find(e => e.key == apptStatusActions[key]))
							}
						}
					});
					
                    scope.$watch(attrs.app, update);
                }
            }
    }]);
})();
