/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.rxdrugref.impl;

import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;

public class RxUtil {
    private static String defaultPattern = "yyyy/MM/dd";
    private static Locale locale = Locale.CANADA;
    private static String defaultQuantity = "30";
    public static String OD = "ID";
    public static String d = "j";
    public static String D = "J";
    public static String day = "jour";
    public static String _day = "/jour";
    public static String days = "jours";
    public static String Week = "Semaine";
    public static String week = "semaine";
    public static String weeks = "semaines";
    public static String Month = "Mois";
    public static String Months = "Mois";
    public static String months = "mois";
    public static String month = "mois";
    public static String mo = "mo";
    public static String w = "s";
    public static String W = "S";
    public static String m = "m";
    public static String M = "M";
    public static String Day = "Jour";
    public static String daily = "chaque jour";
    public static String _daily = "/jour";
    public static String once_daily = "chaque jour";
    public static String _1_daily = "1 fois par jour";
    public static String twice_daily = "deux fois par jour";
    public static String _2_daily = "2 fois par jour";
    public static String weekly = "chaque semaine";
    public static String _1_weekly = "1 fois par semaine";
    public static String _weekly = "/semaine";
    public static String monthly = "chaque mois";
    public static String _1_monthly = "1 fois par mois";
    public static String _monthly = "/mois";
    public static String zero = "zero";
    public static String one = "un";
    public static String two = "deux";
    public static String three = "trois";
    public static String four = "quatre";
    public static String five = "cinq";
    public static String six = "six";
    public static String seven = "sept";
    public static String eight = "huit";
    public static String nine = "neuf";
    public static String ten = "dix";
    public static String Take = "Prendre";
    public static String take = "prendre";
    public static String Apply = "Appliquer";
    public static String apply = "appliquer";
    public static String Rub_well_in = "Frottez bien";
    public static String rub_well_in = "frottez bien";
    public static String[] zeroToTen = new String[]{"(?i)" + zero, "(?i)" + one, "(?i)" + two, "(?i)" + three, "(?i)" + four, "(?i)" + five, "(?i)" + six, "(?i)" + seven, "(?i)" + eight, "(?i)" + nine, "(?i)" + ten};
    public static String RUB_WELL_IN = "FROTTER BIEN";
    public static String Rub_Well_In = "Frotter Bien";
    public static String TAKE = "PRENDRE";
    public static String APPLY = "APPLIQUER";
    public static String Repeats = "Rep";
    public static String Qty = "Qte";
    public static String NoSubs = "Pas de substitution";

    public static void setDefaultQuantity(String quantity) {
        defaultQuantity = quantity;
    }

    public static String getDefaultQuantity() {
        return defaultQuantity;
    }

    public static Date StringToDate(String Expression) {
        return RxUtil.StringToDate(Expression, defaultPattern);
    }

    public static Date StringToDate(String Expression, String pattern) {
        try {
            FastDateFormat df = FastDateFormat.getInstance((String)pattern, (Locale)locale);
            return df.parse(Expression);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String DateToString(Date Expression) {
        return RxUtil.DateToString(Expression, defaultPattern);
    }

    public static String DateToString(Date Expression, String pattern) {
        if (Expression != null) {
            FastDateFormat df = FastDateFormat.getInstance((String)pattern, (Locale)locale);
            return df.format(Expression);
        }
        return "";
    }

    public static String DateToString(Date Expression, String pattern, Locale locale2) {
        if (Expression != null) {
            FastDateFormat df = FastDateFormat.getInstance((String)pattern, (Locale)locale2);
            return df.format(Expression);
        }
        return "";
    }

    public static Date Today() {
        return GregorianCalendar.getInstance().getTime();
    }

    public static int BoolToInt(boolean Expression) {
        if (Expression) {
            return 1;
        }
        return 0;
    }

    public static boolean IntToBool(int Expression) {
        return Expression != 0;
    }

    public static String FloatToString(float value) {
        Float f = new Float(value);
        NumberFormat fmt = NumberFormat.getNumberInstance();
        String s = fmt.format(f.doubleValue());
        return s;
    }

    public static float StringToFloat(String value) {
        return Float.parseFloat(value);
    }

    public static Object IIf(boolean Expression, Object TruePart, Object FalsePart) {
        if (Expression) {
            return TruePart;
        }
        return FalsePart;
    }

    public static String joinArray(Object[] array) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = ret + "'" + String.valueOf(array[i]) + "'";
            if (i >= array.length - 1) continue;
            ret = ret + ", ";
        }
        return ret;
    }

    public static String replace(String expression, String searchFor, String replaceWith) {
        if (expression != null) {
            StringBuilder buf = new StringBuilder(expression);
            int pos = -1;
            while ((pos = buf.indexOf(searchFor, pos)) > -1) {
                buf.delete(pos, pos + searchFor.length());
                buf.insert(pos, replaceWith);
                pos += replaceWith.length();
            }
            return buf.toString();
        }
        return null;
    }

    public static int getClcr(int age, double weight, double sCr, boolean female) throws Exception {
        if (age < 0) {
            throw new Exception("age must be greater than 0");
        }
        if (weight < 0.0) {
            throw new Exception("weight must be greater than 0");
        }
        if (sCr < 0.0) {
            throw new Exception("sCr must be greater than 0");
        }
        double Clcr = (double)(140 - age) * weight / (sCr * 0.8);
        if (female) {
            Clcr *= 0.85;
        }
        return (int)Math.round(Clcr);
    }

    public static double findNDays(String durationUnit) {
        double nDays = 0.0;
        if (durationUnit.equalsIgnoreCase("D") || durationUnit.equalsIgnoreCase("J")) {
            nDays = 1.0;
        } else if (durationUnit.equalsIgnoreCase("W") || durationUnit.equalsIgnoreCase("S")) {
            nDays = 7.0;
        } else if (durationUnit.equalsIgnoreCase("M")) {
            nDays = 30.0;
        }
        return nDays;
    }

    public static Double findNPerDay(String frequency) {
        double nPerDay = 0.0;
        if (frequency.equalsIgnoreCase(OD)) {
            nPerDay = 1.0;
        } else if (frequency.equalsIgnoreCase("bid")) {
            nPerDay = 2.0;
        } else if (frequency.equalsIgnoreCase("tid")) {
            nPerDay = 3.0;
        } else if (frequency.equalsIgnoreCase("qid")) {
            nPerDay = 4.0;
        } else if (frequency.equalsIgnoreCase("Q1H")) {
            nPerDay = 24.0;
        } else if (frequency.equalsIgnoreCase("Q2H")) {
            nPerDay = 12.0;
        } else if (frequency.equalsIgnoreCase("Q1-2H")) {
            nPerDay = 24.0;
        } else if (frequency.equalsIgnoreCase("Q3-4H")) {
            nPerDay = 8.0;
        } else if (frequency.equalsIgnoreCase("Q4H")) {
            nPerDay = 6.0;
        } else if (frequency.equalsIgnoreCase("Q4-6H")) {
            nPerDay = 6.0;
        } else if (frequency.equalsIgnoreCase("Q6H")) {
            nPerDay = 4.0;
        } else if (frequency.equalsIgnoreCase("Q8H")) {
            nPerDay = 3.0;
        } else if (frequency.equalsIgnoreCase("Q12H")) {
            nPerDay = 2.0;
        } else if (frequency.equalsIgnoreCase("QAM")) {
            nPerDay = 1.0;
        } else if (frequency.equalsIgnoreCase("QPM")) {
            nPerDay = 1.0;
        } else if (frequency.equalsIgnoreCase("QHS")) {
            nPerDay = 1.0;
        } else if (frequency.equalsIgnoreCase("Q1" + Week)) {
            nPerDay = 0.14285714285714285;
        } else if (frequency.equalsIgnoreCase("Q2" + Week)) {
            nPerDay = 0.07142857142857142;
        } else if (frequency.equalsIgnoreCase("Q1" + Month)) {
            nPerDay = 0.03333333333333333;
        } else if (frequency.equalsIgnoreCase("Q3" + Month)) {
            nPerDay = 0.011111111111111112;
        }
        return nPerDay;
    }

    public static String getUnitNameFromQuantityText(String qStr) {
        String qNum;
        String qUnit;
        Pattern p1;
        Matcher m1;
        if (qStr != null && (m1 = (p1 = Pattern.compile("\\d+")).matcher(qStr)).find() && (qUnit = qStr.replace(qNum = qStr.substring(m1.start(), m1.end()), "").trim()) != null && qUnit.length() > 0) {
            return qUnit;
        }
        return null;
    }

    public static String getQuantityFromQuantityText(String qStr) {
        Pattern p1;
        Matcher m1;
        if (qStr != null && (m1 = (p1 = Pattern.compile("\\d+")).matcher(qStr)).find()) {
            String qNum = qStr.substring(m1.start(), m1.end());
            return qNum;
        }
        return null;
    }

    public static boolean isMitte(String qStr) {
        String[] durationUnits;
        boolean isMitte = false;
        for (String s : durationUnits = new String[]{"[0-9]+\\s+(?i)" + days + "\\s", "[0-9]+\\s+(?i)" + weeks + "\\s", "[0-9]+\\s+(?i)" + months + "\\s", "[0-9]+\\s+(?i)" + day + "\\s", "[0-9]+\\s+(?i)" + week + "\\s", "[0-9]+\\s+(?i)" + month + "\\s", "[0-9]+\\s+(?i)" + d + "\\s", "[0-9]+\\s+(?i)" + w + "\\s", "[0-9]+\\s+(?i)" + m + "\\s", "[0-9]+\\s+(?i)" + mo + "\\s", "[0-9]+\\s+(?i)" + days + "$", "[0-9]+\\s+(?i)" + weeks + "$", "[0-9]+\\s+(?i)" + months + "$", "[0-9]+\\s+(?i)" + day + "$", "[0-9]+\\s+(?i)" + week + "$", "[0-9]+\\s+(?i)" + month + "$", "[0-9]+\\s+(?i)" + d + "$", "[0-9]+\\s+(?i)" + w + "$", "[0-9]+\\s+(?i)" + m + "$", "[0-9]+\\s+(?i)" + mo + "$", "\\s[0-9]+(?i)" + days + "\\s", "\\s[0-9]+(?i)" + weeks + "\\s", "\\s[0-9]+(?i)" + months + "\\s", "\\s[0-9]+(?i)" + day + "\\s", "\\s[0-9]+(?i)" + week + "\\s", "\\s[0-9]+(?i)" + month + "\\s", "\\s[0-9]+(?i)" + d + "\\s", "\\s[0-9]+(?i)" + w + "\\s", "\\s[0-9]+(?i)" + m + "\\s", "\\s[0-9]+(?i)" + mo + "\\s", "\\s[0-9]+(?i)" + days + "$", "\\s[0-9]+(?i)" + weeks + "$", "\\s[0-9]+(?i)" + months + "$", "\\s[0-9]+(?i)" + day + "$", "\\s[0-9]+(?i)" + week + "$", "\\s[0-9]+(?i)" + month + "$", "\\s[0-9]+(?i)" + d + "$", "\\s[0-9]+(?i)" + w + "$", "\\s[0-9]+(?i)" + m + "$", "\\s[0-9]+(?i)" + mo + "$", "^[0-9]+(?i)" + days + "$", "^[0-9]+(?i)" + weeks + "$", "^[0-9]+(?i)" + months + "$", "^[0-9]+(?i)" + day + "$", "^[0-9]+(?i)" + week + "$", "^[0-9]+(?i)" + month + "$", "^[0-9]+(?i)" + d + "$", "^[0-9]+(?i)" + w + "$", "^[0-9]+(?i)" + m + "$", "^[0-9]+(?i)" + mo + "$", "^[0-9]+\\s+(?i)" + days + "$", "^[0-9]+\\s+(?i)" + weeks + "$", "^[0-9]+\\s+(?i)" + months + "$", "^[0-9]+\\s+(?i)" + day + "$", "^[0-9]+\\s+(?i)" + week + "$", "^[0-9]+\\s+(?i)" + month + "$", "^[0-9]+\\s+(?i)" + d + "$", "^[0-9]+\\s+(?i)" + w + "$", "^[0-9]+\\s+(?i)" + m + "$", "^[0-9]+\\s+(?i)" + mo + "$"}) {
            Pattern p = Pattern.compile(s);
            Matcher m = p.matcher(qStr);
            if (!m.find()) continue;
            String foundStr = qStr.substring(m.start(), m.end()).trim();
            qStr = qStr.replace(foundStr, "");
            if ((qStr = qStr.trim()).length() != 0) continue;
            isMitte = true;
            break;
        }
        return isMitte;
    }

    public static String getDurationFromQuantityText(String qStr) {
        String[] durationUnits;
        String retStr = "";
        for (String s : durationUnits = new String[]{"[0-9]+\\s+(?i)" + days + "\\s", "[0-9]+\\s+(?i)" + weeks + "\\s", "[0-9]+\\s+(?i)" + months + "\\s", "[0-9]+\\s+(?i)" + day + "\\s", "[0-9]+\\s+(?i)" + week + "\\s", "[0-9]+\\s+(?i)" + month + "\\s", "[0-9]+\\s+(?i)" + d + "\\s", "[0-9]+\\s+(?i)" + w + "\\s", "[0-9]+\\s+(?i)" + m + "\\s", "[0-9]+\\s+(?i)" + mo + "\\s", "[0-9]+\\s+(?i)" + days + "$", "[0-9]+\\s+(?i)" + weeks + "$", "[0-9]+\\s+(?i)" + months + "$", "[0-9]+\\s+(?i)" + day + "$", "[0-9]+\\s+(?i)" + week + "$", "[0-9]+\\s+(?i)" + month + "$", "[0-9]+\\s+(?i)" + d + "$", "[0-9]+\\s+(?i)" + w + "$", "[0-9]+\\s+(?i)" + m + "$", "[0-9]+\\s+(?i)" + mo + "$", "\\s[0-9]+(?i)" + days + "\\s", "\\s[0-9]+(?i)" + weeks + "\\s", "\\s[0-9]+(?i)" + months + "\\s", "\\s[0-9]+(?i)" + day + "\\s", "\\s[0-9]+(?i)" + week + "\\s", "\\s[0-9]+(?i)" + month + "\\s", "\\s[0-9]+(?i)" + d + "\\s", "\\s[0-9]+(?i)" + w + "\\s", "\\s[0-9]+(?i)" + m + "\\s", "\\s[0-9]+(?i)" + mo + "\\s", "\\s[0-9]+(?i)" + days + "$", "\\s[0-9]+(?i)" + weeks + "$", "\\s[0-9]+(?i)" + months + "$", "\\s[0-9]+(?i)" + day + "$", "\\s[0-9]+(?i)" + week + "$", "\\s[0-9]+(?i)" + month + "$", "\\s[0-9]+(?i)" + d + "$", "\\s[0-9]+(?i)" + w + "$", "\\s[0-9]+(?i)" + m + "$", "\\s[0-9]+(?i)" + mo + "$"}) {
            String duration;
            Pattern p = Pattern.compile(s);
            Matcher m = p.matcher(qStr);
            if (!m.find()) continue;
            String foundStr = qStr.substring(m.start(), m.end()).trim();
            Pattern p2 = Pattern.compile("[0-9]+");
            Matcher m2 = p2.matcher(foundStr);
            if (!m2.find()) break;
            retStr = duration = foundStr.substring(m2.start(), m2.end()).trim();
            break;
        }
        return retStr;
    }

    public static String getDurationUnitFromQuantityText(String qStr) {
        String[] durationUnits;
        String retStr = "";
        for (String s : durationUnits = new String[]{"[0-9]+\\s+(?i)" + days + "\\s", "[0-9]+\\s+(?i)" + weeks + "\\s", "[0-9]+\\s+(?i)" + months + "\\s", "[0-9]+\\s+(?i)" + day + "\\s", "[0-9]+\\s+(?i)" + week + "\\s", "[0-9]+\\s+(?i)" + month + "\\s", "[0-9]+\\s+(?i)" + d + "\\s", "[0-9]+\\s+(?i)" + w + "\\s", "[0-9]+\\s+(?i)" + m + "\\s", "[0-9]+\\s+(?i)" + mo + "\\s", "[0-9]+\\s+(?i)" + days + "$", "[0-9]+\\s+(?i)" + weeks + "$", "[0-9]+\\s+(?i)" + months + "$", "[0-9]+\\s+(?i)" + day + "$", "[0-9]+\\s+(?i)" + week + "$", "[0-9]+\\s+(?i)" + month + "$", "[0-9]+\\s+(?i)" + d + "$", "[0-9]+\\s+(?i)" + w + "$", "[0-9]+\\s+(?i)" + m + "$", "[0-9]+\\s+(?i)" + mo + "$", "\\s[0-9]+(?i)" + days + "\\s", "\\s[0-9]+(?i)" + weeks + "\\s", "\\s[0-9]+(?i)" + months + "\\s", "\\s[0-9]+(?i)" + day + "\\s", "\\s[0-9]+(?i)" + week + "\\s", "\\s[0-9]+(?i)" + month + "\\s", "\\s[0-9]+(?i)" + d + "\\s", "\\s[0-9]+(?i)" + w + "\\s", "\\s[0-9]+(?i)" + m + "\\s", "\\s[0-9]+(?i)" + mo + "\\s", "\\s[0-9]+(?i)" + days + "$", "\\s[0-9]+(?i)" + weeks + "$", "\\s[0-9]+(?i)" + months + "$", "\\s[0-9]+(?i)" + day + "$", "\\s[0-9]+(?i)" + week + "$", "\\s[0-9]+(?i)" + month + "$", "\\s[0-9]+(?i)" + d + "$", "\\s[0-9]+(?i)" + w + "$", "\\s[0-9]+(?i)" + m + "$", "\\s[0-9]+(?i)" + mo + "$"}) {
            Pattern p = Pattern.compile(s);
            Matcher ma = p.matcher(qStr);
            if (!ma.find()) continue;
            String foundStr = qStr.substring(ma.start(), ma.end()).trim();
            Pattern p2 = Pattern.compile("[0-9]+");
            Matcher m2 = p2.matcher(foundStr);
            if (!m2.find()) continue;
            String duration = foundStr.substring(m2.start(), m2.end()).trim();
            String durationUnit = foundStr.replace(duration, "").trim().toLowerCase();
            if (durationUnit.startsWith(d)) {
                retStr = d.toUpperCase();
                break;
            }
            if (durationUnit.startsWith(w)) {
                retStr = w.toUpperCase();
                break;
            }
            if (durationUnit.startsWith(m)) {
                retStr = m.toUpperCase();
                break;
            }
            retStr = "";
            break;
        }
        return retStr;
    }
}

