/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XFacturationType;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.ui.dashboard.models.CBaseUser;
import ca.infodata.ofys.ui.dashboard.models.CUserPreferences;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import java.util.EnumSet;

public class CUser
extends CBaseUser {
    private static final long serialVersionUID = 1L;
    public String name;
    public boolean changePassword;
    public String newPassword;
    public String newPasswordConfirm;
    public String encryptedPassword;
    public String encryptedPasswordConfirm;
    public Boolean isDeleted;
    public boolean mustChangePassword;
    public CUserPreferences userPreferences;
    public Integer basePerson;
    public String passwordCreationDate;
    public String validFromDate;
    public String validToDate;
    public EnumSet<XUserRole> role;
    public EnumSet<XUserRole> crisisRole;
    public Boolean crisisRoleEnabled;
    public String crisisRoleEndDate;
    public XFacturationType factType;
    public Integer factTypeI;
    public String factCodeProf;
    public String factUsername;
    public String factPswd;
    public String factNoagenceRamq;
    public Boolean twoFactorSuspended;
    public Boolean twoFactorActive;
    public Boolean twoFactorConfigured;
    public String twoFactorEmail;

    public CUser(XUser usr) {
        super((XBaseUser)usr);
        this.init(usr);
    }

    public void init(XUser usr) {
        this.className = CUser.class.getSimpleName();
        this.name = usr.name;
        this.changePassword = false;
        this.encryptedPassword = usr.encryptedPassword;
        this.encryptedPasswordConfirm = usr.encryptedPasswordConfirm;
        this.isDeleted = usr.isDeleted;
        this.mustChangePassword = usr.mustChangePassword;
        this.userPreferences = usr.userPreferences == null ? null : new CUserPreferences(usr.userPreferences);
        this.basePerson = usr.basePerson;
        this.passwordCreationDate = usr.passwordCreationDate != null ? usr.passwordCreationDate.formatHyphen() : null;
        this.validFromDate = usr.validFromDate != null ? usr.validFromDate.formatHyphen() : null;
        this.validToDate = usr.validToDate != null ? usr.validToDate.formatHyphen() : null;
        this.role = usr.role;
        this.crisisRole = usr.crisisRole;
        this.crisisRoleEnabled = usr.crisisRoleEnabled;
        this.crisisRoleEndDate = usr.crisisRoleEndDate != null ? usr.crisisRoleEndDate.formatHyphen() : null;
        this.factType = usr.factType;
        this.factTypeI = usr.factType == null ? 0 : usr.factType.getValue();
        this.factCodeProf = usr.factCodeProf;
        this.factUsername = usr.factUsername;
        this.factPswd = usr.factPswd;
        this.factNoagenceRamq = usr.factNoagenceRamq;
        this.twoFactorSuspended = usr.twoFactorSuspended;
        this.twoFactorActive = usr.twoFactorActive;
        this.twoFactorConfigured = usr.twoFactorConfigured;
        this.twoFactorEmail = usr.twoFactorEmail;
    }

    public XUser x() {
        XUser xu = new XUser();
        super.xbase((XBaseUser)xu);
        xu.name = this.name;
        xu.encryptedPassword = this.encryptedPassword;
        xu.encryptedPasswordConfirm = this.encryptedPasswordConfirm;
        xu.isDeleted = this.isDeleted;
        xu.mustChangePassword = this.mustChangePassword;
        xu.userPreferences = this.userPreferences == null ? null : this.userPreferences.x();
        xu.basePerson = this.basePerson;
        xu.passwordCreationDate = Utils.strToLocalDate(this.passwordCreationDate, "yyyy-MM-dd");
        xu.validFromDate = Utils.strToLocalDate(this.validFromDate, "yyyy-MM-dd");
        xu.validToDate = Utils.strToLocalDate(this.validToDate, "yyyy-MM-dd");
        xu.role = this.role;
        xu.crisisRole = this.crisisRole;
        xu.crisisRoleEnabled = this.crisisRoleEnabled;
        xu.crisisRoleEndDate = Utils.strToLocalDate(this.crisisRoleEndDate, "yyyy-MM-dd");
        xu.factType = this.factType == null ? XFacturationType.AUCUN : this.factType;
        xu.factCodeProf = this.factCodeProf;
        xu.factUsername = this.factUsername;
        xu.factPswd = this.factPswd;
        xu.factNoagenceRamq = this.factNoagenceRamq;
        xu.twoFactorEmail = this.twoFactorEmail;
        xu.twoFactorActive = this.twoFactorActive;
        xu.twoFactorConfigured = this.twoFactorConfigured;
        xu.twoFactorSuspended = this.twoFactorSuspended;
        return xu;
    }

    public static CUser c(XUser x) {
        return x == null ? null : new CUser(x);
    }

    @Override
    public <T> void convertc(T type) {
        XUser x = (XUser)XUser.class.cast(type);
        this.init(x);
    }

    public XUser convertx() {
        return this.x();
    }
}

