/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.eform.XAttenteResultats;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboFile;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalStatus;
import ca.infodata.ofys.ui.dashboard.models.CAppointment;
import ca.infodata.ofys.ui.dashboard.models.CAttenteResultats;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.ofys.util.EnumWithValueFactory;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CLaboFile
implements Serializable {
    private static final long serialVersionUID = 6259815403548949473L;
    public final String className = CLaboFile.class.getSimpleName();
    public int uid;
    public Integer id;
    public Integer idText;
    public Integer idPatient;
    public String req;
    public String str;
    public String strWithPat;
    public int flag;
    public String date;
    public String entryDate;
    public String labNo;
    public List<CLaboProf> profs = new ArrayList<CLaboProf>();
    public String statsTests;
    public List<CLaboStructure> lstNs;
    public List<CLaboStructure> lstAbns;
    public List<CLaboStructure> lstVeryAbns;
    public boolean hasUnRes = false;
    public String notValidated;
    public boolean hasNote = false;
    public String note;
    public String notesHistory;
    public CLaboProf activeProf;
    public CLaboProf selectedProf;
    public CPatient patient;
    public List<CAppointment> futurApts;
    public List<CAttenteResultats> attentes;
    public Boolean appTodayOrFutur;
    public Boolean appHasOnlyToday;
    public Boolean appHasOnlyFutur;
    public Boolean appHasTodayAndFutur;
    public Boolean fromSearch = Boolean.FALSE;
    private static final Comparator<CLaboProf> compCLaboProf = new Comparator<CLaboProf>(){

        @Override
        public int compare(CLaboProf o1, CLaboProf o2) {
            return o2.id.compareTo(o1.id);
        }
    };

    public CLaboFile(XLaboResultsProfessionnal x) {
        this.uid = Utils.getNewAtomicInteger();
        this.id = null;
        this.idText = x.getLaboResults().getId();
        this.idPatient = x.getIdPatient();
        this.req = x.getLaboResults().getRequests();
        this.str = null;
        this.strWithPat = null;
        this.date = null;
        this.entryDate = null;
        this.labNo = null;
        boolean seen = false;
        this.hasNote = StringUtils.isNotEmpty((String)x.getNotesHistory()) && StringUtils.isNotEmpty((String)x.getNote());
        this.note = x.getNote();
        this.notesHistory = x.getNotesHistory();
        CLaboProf clp = new CLaboProf(x.getId(), x.getProfessionnal().getId(), x.getSeenDatetime(), x.getSignedDatetime(), this.idText, x.getNote());
        clp.getStatus().addAll(x.getStatus());
        clp.activeSt.addAll(clp.getStatus());
        Integer activeIdProf = x.getProfessionnal().getId();
        if (clp.idText.intValue() == this.idText.intValue()) {
            if (clp.seenDatetime != null) {
                seen = true;
            }
            this.activeProf = clp;
            this.selectedProf = clp;
            this.setSeenUnseenStatusAndSelectedProf(activeIdProf, activeIdProf, seen, activeIdProf, clp);
        }
    }

    public CLaboFile(XLaboFile x, Integer activeIdProf, Integer selectedIdProf) {
        this.uid = Utils.getNewAtomicInteger();
        this.id = x.idFile;
        this.idText = x.idText;
        this.idPatient = x.idPat;
        this.req = x.req;
        this.str = x.str;
        this.strWithPat = x.strWithPat;
        this.flag = x.flag;
        this.date = x.entryDate;
        this.entryDate = x.date;
        this.labNo = x.labNo;
        this.hasUnRes = x.hasUnRes;
        if (x.patient != null) {
            this.patient = CPatient.c(x.patient);
        }
        if (x.futurApts != null && !x.futurApts.isEmpty()) {
            this.futurApts = new ArrayList<CAppointment>(x.futurApts.size());
            boolean hasToday = false;
            boolean hasFutur = false;
            for (XAppointment xApt : x.futurApts) {
                CAppointment cApt = new CAppointment(xApt);
                this.futurApts.add(cApt);
                hasToday = hasToday || cApt.when == 0;
                hasFutur = hasFutur || cApt.when > 0;
            }
            this.appTodayOrFutur = hasToday || hasFutur;
            this.appHasOnlyFutur = !hasToday && hasFutur;
            this.appHasOnlyToday = hasToday && !hasFutur;
            this.appHasTodayAndFutur = hasToday && hasFutur;
        }
        if (x.attente != null && !x.attente.isEmpty()) {
            this.attentes = new ArrayList<CAttenteResultats>(x.attente.size());
            for (XAttenteResultats xAtt : x.attente) {
                CAttenteResultats cAtt = new CAttenteResultats(xAtt);
                this.attentes.add(cAtt);
            }
        }
        boolean globalSeen = false;
        HashMap<Integer, EnumSet<XLaboResultsProfessionnalStatus>> mapProfStatus = new HashMap<Integer, EnumSet<XLaboResultsProfessionnalStatus>>();
        if (x.profs != null) {
            if (selectedIdProf == null) {
                selectedIdProf = activeIdProf;
            }
            for (String string : x.profs) {
                boolean seen = false;
                String[] p = string.split("(\u0131)");
                Integer idProf = Integer.valueOf(p[1]);
                Long seenDt = null;
                if (p[3].length() > 0) {
                    seenDt = Long.valueOf(p[3]);
                    seenDt = seenDt == -1L ? null : seenDt;
                }
                Long signedDt = null;
                if (p[4].length() > 0) {
                    signedDt = Long.valueOf(p[4]);
                    signedDt = signedDt == -1L ? null : signedDt;
                }
                Integer idText = Integer.valueOf(p[5]);
                this.hasNote = this.hasNote || p.length > 6 && StringUtils.isNotEmpty((String)p[6]);
                CLaboProf clp = new CLaboProf(Integer.valueOf(p[0]), idProf, seenDt, signedDt, idText, p.length > 6 ? p[6] : null);
                EnumSet fromSet = EnumWithValueFactory.fromSet(XLaboResultsProfessionnalStatus.class, (Integer)Integer.valueOf(p[2]));
                if (clp.seenDatetime != null && fromSet.contains(XLaboResultsProfessionnalStatus.UNSEEN)) {
                    fromSet.remove(XLaboResultsProfessionnalStatus.UNSEEN);
                }
                clp.activeSt.addAll(fromSet);
                if (mapProfStatus.containsKey(idProf)) {
                    EnumSet s = (EnumSet)mapProfStatus.get(idProf);
                    EnumSet<XLaboResultsProfessionnalStatus> stToRemove = EnumSet.noneOf(XLaboResultsProfessionnalStatus.class);
                    for (XLaboResultsProfessionnalStatus en : fromSet) {
                        if (s.contains(en)) {
                            stToRemove.add(en);
                            continue;
                        }
                        s.add(en);
                    }
                    fromSet.removeAll(stToRemove);
                } else {
                    mapProfStatus.put(idProf, fromSet);
                }
                clp.st.addAll(fromSet);
                if (clp.idText.intValue() == this.idText.intValue()) {
                    if (clp.seenDatetime != null) {
                        seen = true;
                        globalSeen = true;
                    }
                    this.setSeenUnseenStatusAndSelectedProf(activeIdProf, selectedIdProf, seen, idProf, clp);
                } else if (clp.seenDatetime != null && clp.st.contains(XLaboResultsProfessionnalStatus.UNSEEN)) {
                    clp.st.remove(XLaboResultsProfessionnalStatus.UNSEEN);
                }
                this.profs.add(clp);
            }
            if (this.activeProf != null) {
                this.setStatusToActiveLaboProf(this.activeProf, activeIdProf, mapProfStatus);
            }
            if (this.selectedProf != null) {
                this.setStatusToActiveLaboProf(this.selectedProf, selectedIdProf, mapProfStatus);
            }
            Collections.sort(this.profs, compCLaboProf);
        }
        if (!globalSeen) {
            this.notValidated = "UNSEEN";
        }
        if (x.ns != null) {
            this.lstNs = new ArrayList<CLaboStructure>();
            for (String string : x.ns) {
                String[] p = string.split("(\u0131)");
                this.lstNs.add(new CLaboStructure(Integer.parseInt(p[0]), p[1], p[2], p[3], p[4], p[5], p[6], p[7], Integer.parseInt(p[8]), p[9].equals("1"), Integer.parseInt(p[10])));
            }
            Collections.sort(this.lstNs);
            x.ns = null;
        }
        if (x.abns != null) {
            this.lstAbns = new ArrayList<CLaboStructure>();
            for (String string : x.abns) {
                String[] p = string.split("(\u0131)");
                this.lstAbns.add(new CLaboStructure(Integer.parseInt(p[0]), p[1], p[2], p[3], p[4], p[5], p[6], p[7], Integer.parseInt(p[8]), p[9].equals("1"), Integer.parseInt(p[10])));
            }
            Collections.sort(this.lstAbns);
            x.abns = null;
        }
        if (x.veryAbns != null) {
            this.lstVeryAbns = new ArrayList<CLaboStructure>();
            for (String string : x.veryAbns) {
                String[] p = string.split("(\u0131)");
                this.lstVeryAbns.add(new CLaboStructure(Integer.parseInt(p[0]), p[1], p[2], p[3], p[4], p[5], p[6], p[7], Integer.parseInt(p[8]), p[9].equals("1"), Integer.parseInt(p[10])));
            }
            Collections.sort(this.lstVeryAbns);
            x.veryAbns = null;
        }
    }

    public void setStatusToActiveLaboProf(CLaboProf laboProf, Integer selectedIdProf, Map<Integer, EnumSet<XLaboResultsProfessionnalStatus>> mapProfStatus) {
        if (mapProfStatus.containsKey(selectedIdProf)) {
            EnumSet<XLaboResultsProfessionnalStatus> statusActiveProf = mapProfStatus.get(selectedIdProf);
            laboProf.st.addAll(statusActiveProf);
        }
        for (CLaboProf clp : this.profs) {
            if (clp.idProf.intValue() != laboProf.idProf.intValue()) continue;
            clp.st.clear();
            if (clp.idText.intValue() != this.idText.intValue()) continue;
            clp.st.addAll(laboProf.st);
        }
    }

    private void setSeenUnseenStatusAndSelectedProf(Integer activeIdProf, Integer selectedIdProf, boolean seen, Integer idProf, CLaboProf clp) {
        if (seen) {
            if (!clp.st.contains(XLaboResultsProfessionnalStatus.SEEN)) {
                clp.st.add(XLaboResultsProfessionnalStatus.SEEN);
            }
            if (clp.st.contains(XLaboResultsProfessionnalStatus.UNSEEN)) {
                clp.st.remove(XLaboResultsProfessionnalStatus.UNSEEN);
            }
        } else {
            if (clp.st.contains(XLaboResultsProfessionnalStatus.SEEN)) {
                clp.st.remove(XLaboResultsProfessionnalStatus.SEEN);
            }
            if (!clp.st.contains(XLaboResultsProfessionnalStatus.UNSEEN)) {
                clp.st.add(XLaboResultsProfessionnalStatus.UNSEEN);
            }
        }
        if (idProf != null) {
            if (idProf.equals(activeIdProf)) {
                this.activeProf = clp.clone();
            }
            if (idProf.equals(selectedIdProf)) {
                this.selectedProf = clp.clone();
            }
        }
    }

    public CLaboFile() {
    }

    public static class CLaboStructure
    implements Comparable<CLaboStructure> {
        final int id;
        final int l;
        final String c;
        final String n;
        final String u;
        final String v;
        final String x;
        final String i;
        final boolean un;
        final int f;
        String d;
        public transient int d1970;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CLaboStructure(int lc, String cd, String n, String u, String v, String i, String x, String d, int id, boolean unique, int b) {
            this.id = id;
            this.l = lc;
            this.c = cd;
            this.n = n;
            this.u = u;
            this.v = v;
            this.i = i;
            this.un = unique;
            this.x = x;
            this.f = b;
            if (!"-1".equals(d)) {
                try {
                    long l = Long.parseLong(d);
                    LocalDate ld = LocalDate.fromTimeInMillisUTC((Long)l);
                    this.d1970 = ld.dayFrom1970;
                    this.d = ld.formatHyphen();
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }

        public int getId() {
            return this.id;
        }

        public String getCode() {
            return this.c;
        }

        public int getLoincCode() {
            return this.l;
        }

        public String getName() {
            return this.n;
        }

        public String getUnite() {
            return this.u;
        }

        public String getValue() {
            return this.v;
        }

        public boolean isUnique() {
            return this.un;
        }

        public String getInferieurInterval() {
            return this.i;
        }

        public String getSuperieurInterval() {
            return this.x;
        }

        public String getDate() {
            return this.d;
        }

        public void setDate(String dt) {
            this.d = dt;
        }

        public boolean isNormal() {
            return this.f == 0;
        }

        public boolean isAbNormalNotCritical() {
            return this.f == 1;
        }

        public boolean isCritical() {
            return this.f == 2;
        }

        @Override
        public int compareTo(CLaboStructure o) {
            return this.n.compareTo(o.n);
        }
    }

    public static class CLaboProf {
        final Integer id;
        final Integer idProf;
        final Integer idText;
        final String note;
        public Long seenDatetime;
        public Long signedDatetime;
        EnumSet<XLaboResultsProfessionnalStatus> st = EnumSet.noneOf(XLaboResultsProfessionnalStatus.class);
        EnumSet<XLaboResultsProfessionnalStatus> activeSt = EnumSet.noneOf(XLaboResultsProfessionnalStatus.class);
        public String title = Messages.getString((String)"DESTINATAIRES", (String[])new String[0]);
        public String[] descr;
        public String[] descrTitle = new String[]{Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]), Messages.getString((String)"VU", (String[])new String[0]), Messages.getString((String)"SIGNE", (String[])new String[0]), Messages.getString((String)"NOTE", (String[])new String[0])};

        public CLaboProf(Integer id, Integer idP, Long seen, Long signed, Integer idText, String n) {
            this.id = id;
            this.idProf = idP;
            this.idText = idText;
            this.seenDatetime = seen == null || seen == -1L ? null : seen;
            this.signedDatetime = signed == null || signed == -1L ? null : signed;
            this.note = StringUtils.isNotEmpty((String)n) ? n : null;
            XBaseProfessionnal prof = null;
            try {
                prof = Application.get().getPersonPluginController().getBaseProfessionnal(idP);
            }
            catch (Exception e) {
                this.descr = new String[]{"? ", this.seenDatetime == null ? "" : Utils.getDateTimeFromLong(this.seenDatetime), this.signedDatetime == null ? "" : Utils.getDateTimeFromLong(this.signedDatetime), this.note == null ? "" : this.note};
            }
            if (prof != null) {
                this.descr = new String[]{this.getdescName(prof), this.seenDatetime == null ? "" : Utils.getDateTimeFromLong(this.seenDatetime), this.signedDatetime == null ? "" : Utils.getDateTimeFromLong(this.signedDatetime), this.note == null ? "" : this.note};
            }
        }

        private String getdescName(XBaseProfessionnal prof) {
            return prof.getLastName() + " " + StringUtils.substring((String)prof.getFirstName(), (Integer)0, (Integer)1);
        }

        public EnumSet<XLaboResultsProfessionnalStatus> getStatus() {
            return this.st;
        }

        public CLaboProf clone() {
            CLaboProf c = new CLaboProf(this.id, this.idProf, this.seenDatetime, this.signedDatetime, this.idText, this.note);
            c.descr = this.descr;
            c.descrTitle = this.descrTitle;
            c.st = this.st.clone();
            c.activeSt = this.activeSt.clone();
            return c;
        }
    }
}

