/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.util.ExceptionUtils;
import ca.infodata.ofys.client.util.KeyValueYieldIterator;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.JsonAsMap;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.routes.RequestPredicates;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.XWebLink;
import ca.infodata.ofys.data.middle.dataobjects.XWebLinkContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.dashboard.accessor.PreferencesSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CClientPreferences;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CSite;
import ca.infodata.ofys.ui.dashboard.models.CUserPreferences;
import ca.infodata.ofys.ui.dashboard.models.CWebLink;
import ca.infodata.util1.date.LocaleProvider;
import java.util.Map;

public class PrefController
extends AbstractWebController {
    private final PreferencesSyncAccessorClient prefAccessor = new PreferencesSyncAccessorClient();

    public CClientPreferences getPrefData() {
        XClientPreferences pre;
        XClientPreferences xClientPreferences = pre = Application.get().getGlobalInstances().getSession() == null ? null : Application.get().getGlobalInstances().getSession().getClientPreferences();
        if (pre != null) {
            return new CClientPreferences(pre);
        }
        return null;
    }

    public ReturnObject getWebLinks(Integer id) {
        ReturnObject res = this.prefAccessor.getWebLinks();
        XWebLinkContainer wlc = (XWebLinkContainer)res.getObj();
        boolean byId = id != null && id > 0;
        boolean found = false;
        if (byId) {
            for (XWebLink wl : wlc.getWebLinks()) {
                if (!id.equals(wl.getId())) continue;
                res.setObj((Object)new CWebLink(wl));
                return res;
            }
        } else {
            res.setObj(new CEditableDataObjectList<CWebLink>(wlc.getWebLinks(), CWebLink.class));
        }
        if (byId && !found) {
            res.setObj(null);
            MultiStatus ms = new MultiStatus("Le lien est introuvable, si le probl\u00e8me persist contactez infodata.");
            ms.setSeverity(IStatus.Severity.ERROR);
            res.setStatus(ms);
        }
        return res;
    }

    public ReturnObject saveUserPref(CUserPreferences userPref) {
        return this.prefAccessor.save(userPref.x());
    }

    public Map<String, Object> getUserSettings(String[] keys) {
        return Application.get().getPreferencesPluginController().getUser(keys);
    }

    public void setUserSettings(String[] keys) {
        Application.get().getPreferencesPluginController().put(new KeyValueYieldIterator(keys));
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/pref/ws", RouterFunctions.routeAction("/user/get", req -> {
            ReturnObject ro = this.get(MVPROPS_MAPS.USER, req);
            return ServerResponses.toJsonActionResult(ro);
        }), RouterFunctions.routeAction("/global/get", req -> {
            ReturnObject ro = this.get(MVPROPS_MAPS.GLOBAL, req);
            return ServerResponses.toJsonActionResult(ro);
        }), RouterFunctions.routeAction("/user/set", req -> {
            ReturnObject ro = this.setDefaut(MVPROPS_MAPS.USER, req);
            return ServerResponses.toJsonActionResult(ro);
        }), RouterFunctions.routeAction("/user/savePref", req -> {
            CUserPreferences userPref = req.getPostBody(CUserPreferences.class);
            return ServerResponses.toJsonActionResult(this.saveUserPref(userPref));
        }), RouterFunctions.routeAction(RequestPredicates.get("/contextSite"), req -> {
            boolean isAdmin = Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(XUserRole.ADMIN);
            XSite s = Application.get().getSitePluginController().getContextSite();
            if (!isAdmin) {
                XSite x = s.clone();
                x.hideFaxCredentials();
            } else {
                XSite x = s;
            }
            CSite obj = new CSite(s);
            return ServerResponses.toJsonActionResult((Object)obj);
        }), RouterFunctions.routeReturnObject(RequestPredicates.post("/contextSite"), req -> {
            Integer site = req.getPostBody(JsonAsMap.class).get("site", Integer.class);
            Application.get().getDataAccessors().getLoginAccessor().setUserSessionSite(site);
            return ServerResponses.OKReturnObject();
        }), RouterFunctions.routeAction("/global/set", req -> {
            ReturnObject ro = this.setDefaut(MVPROPS_MAPS.GLOBAL, req);
            return ServerResponses.toJsonActionResult(ro);
        }), RouterFunctions.routeAction("/debugMode", req -> {
            boolean inDebugMode = Application.get().getGlobalInstances().inDebugMode();
            return ServerResponses.toJsonActionResult(inDebugMode);
        }), RouterFunctions.routeAction("/jetty_restart", req -> {
            try {
                WebApplication.get().restart();
                return ServerResponses.toJsonActionResult(ServerResponses.OKReturnObject());
            }
            catch (Exception e) {
                return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(e.getMessage()));
            }
        }), RouterFunctions.routeAction("/clientPref", req -> {
            CClientPreferences prefData = this.getPrefData();
            return ServerResponses.toJsonActionResult((Object)prefData);
        }), RouterFunctions.routeAction("/getWebLinks", req -> {
            Integer linkId = req.getQueryParam("linkId", Integer.class);
            return ServerResponses.toJsonActionResult(this.getWebLinks(linkId));
        }), RouterFunctions.routeAction("/getUserSetting", req -> {
            String[] keys = req.getQueryParam("keys", new String[0], String[].class);
            Map<String, Object> userSettings = this.getUserSettings(keys);
            return ServerResponses.toJsonActionResult(userSettings);
        }), RouterFunctions.routeAction("/setUserSetting", req -> {
            String[] keys = req.getQueryParam("keysdatapair", new String[0], String[].class);
            this.setUserSettings(keys);
            return ServerResponses.SUCCESS();
        }));
    }

    private ReturnObject get(MVPROPS_MAPS t, IServerRequest req) {
        String[] keys = null;
        if (req.hasPostBody()) {
            JsonAsMap map = req.getPostBody(JsonAsMap.class);
            keys = map.get("k", String[].class);
        } else {
            keys = req.getQueryParam("k", String[].class);
        }
        return this.get(t, keys);
    }

    private ReturnObject get(MVPROPS_MAPS type, String[] keys) {
        this.validType(type);
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        try {
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = keys[i].replace("\"", "");
            }
            Map<String, Object> values = null;
            if (type == MVPROPS_MAPS.GLOBAL) {
                values = Application.get().getPreferencesPluginController().getGlobal(keys);
            } else if (type == MVPROPS_MAPS.USER) {
                values = Application.get().getPreferencesPluginController().getUser(keys);
            }
            for (Map.Entry<String, Object> e : values.entrySet()) {
                XSession session;
                Object v;
                String key = e.getKey();
                if ("language".equals(key)) {
                    e.setValue(LocaleProvider.getLocale().getLanguage().toLowerCase().substring(0, 2));
                    continue;
                }
                if ("superviseurId".equals(key)) {
                    Object value = e.getValue();
                    Integer supId = null;
                    supId = value instanceof String ? Integer.valueOf(Integer.parseInt((String)value)) : (Integer)value;
                    Application.get().getPersonPluginController().setSessionSuperviseur(supId);
                    continue;
                }
                if ("user_settings_DirectPrint".equals(key)) {
                    v = e.getValue();
                    boolean b = v instanceof Integer ? new Integer(1).equals((Integer)v) : Boolean.TRUE.equals((Boolean)v);
                    Application.get().getPersonPluginController().setDirectPrint(b);
                    continue;
                }
                if ("user_settings_PrintRxDevSep".equals(key)) {
                    v = e.getValue();
                    boolean b = v instanceof Integer ? new Integer(1).equals((Integer)v) : Boolean.TRUE.equals((Boolean)v);
                    Application.get().getPersonPluginController().setPrintRxDevSep(b);
                    continue;
                }
                if (!"user_settings_ShowAllLabs".equals(key) || (session = Application.get().getGlobalInstances().getSession()) == null || !session.mustLoadAllLabVersion) continue;
                e.setValue(session.mustLoadAllLabVersion);
            }
            Object[] resp = new Object[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                resp[i] = values.get(keys[i]);
            }
            ro.setObj((Object)resp);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
        }
        catch (Exception e) {
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private void validType(MVPROPS_MAPS type) {
        switch (type) {
            case GLOBAL: 
            case USER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported MVPROPS_MAPS type " + (Object)((Object)type));
            }
        }
    }

    private ReturnObject setDefaut(MVPROPS_MAPS t, IServerRequest req) {
        String k = null;
        Object v = null;
        if (req.hasPostBody()) {
            JsonAsMap map = req.getPostBody(JsonAsMap.class);
            k = map.get("k", String.class);
            v = map.get("v");
        } else {
            k = req.getQueryParam("k");
            v = req.getQueryParam("v");
        }
        String string = k = k == null ? null : k.replace("\"", "");
        if (v instanceof String && ((String)v).startsWith("\"")) {
            v = ((String)v).replace("\"", "");
        }
        return this.setDefaut(t, k, v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ReturnObject setDefaut(MVPROPS_MAPS type, String key, Object value) {
        this.validType(type);
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        String k = key;
        Object v = value;
        try {
            Object o = null;
            if (v == null) {
                if (type == MVPROPS_MAPS.USER) {
                    Application.get().getPreferencesPluginController().removeUserProp(k);
                } else if (type == MVPROPS_MAPS.GLOBAL) {
                    Application.get().getPreferencesPluginController().removeGlobalProp(k);
                }
            } else if (type == MVPROPS_MAPS.USER) {
                Application.get().getPreferencesPluginController().addUserProp(k, v);
            } else if (type == MVPROPS_MAPS.GLOBAL) {
                Application.get().getPreferencesPluginController().addGlobalProp(k, v);
            }
            if ("superviseurId".equals(k)) {
                Integer id = v instanceof Integer ? (Integer)v : Integer.valueOf(Integer.parseInt((String)v));
                Application.get().getPersonPluginController().setSessionSuperviseur(id);
            } else if ("user_settings_DirectPrint".equals(k)) {
                boolean b = v instanceof Integer ? new Integer(1).equals((Integer)v) : Boolean.TRUE.equals((Boolean)v);
                Application.get().getPersonPluginController().setDirectPrint(b);
            } else if ("user_settings_PrintRxDevSep".equals(k)) {
                boolean b = v instanceof Integer ? new Integer(1).equals((Integer)v) : Boolean.TRUE.equals((Boolean)v);
                Application.get().getPersonPluginController().setPrintRxDevSep(b);
            }
            ro.setObj(o);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
            if (type != MVPROPS_MAPS.GLOBAL) return ro;
        }
        catch (Exception e) {
            ms.setSeverity(IStatus.Severity.ERROR);
            ms.setMessage(ExceptionUtils.getMessage(e));
            ro.setStatus(ms);
        }
        return ro;
    }

    private static enum MVPROPS_MAPS {
        USER,
        GLOBAL;

    }
}

