/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.ofys.data.dataaccess.IConnectionInfoProvider;
import ca.infodata.ofys.data.dataaccess.ILoginAccessor;
import ca.infodata.ofys.data.dataaccess.ISessionProvider;
import ca.infodata.ofys.data.dataaccess.impl.BaseAccessor;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClient;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilder;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilderWithSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import java.util.HashMap;
import java.util.Locale;

public class LoginAccessor
extends BaseAccessor
implements ILoginAccessor {
    private static String getPath() {
        return "/" + contextRoot + "/jaxrs/LoginAccessor";
    }

    public LoginAccessor(RestfulClient restfulClient, IConnectionInfoProvider connectionInfoProvider, ISessionProvider sessionProvider) {
        super(restfulClient, connectionInfoProvider, sessionProvider);
    }

    @Override
    public void lockSession() {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(LoginAccessor.getPath() + "/lockSession"), "application/octet-stream", "application/json");
        wb.post();
    }

    @Override
    public ReturnObject logIn(String userName, String password, Integer twoFactorCode, String sid, Boolean autolog, String macAddress, String systemUser, String ip, String nl, String clientCode, Integer st) {
        WebBuilder wb = super.buildWebBuilder(this.getSecureURI(LoginAccessor.getPath() + "/logIn"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("username", userName);
        post.put("password", password);
        post.put("twoFactorCode", twoFactorCode);
        post.put("sid", sid);
        post.put("autolog", autolog);
        post.put("macAddress", macAddress);
        post.put("systemUser", systemUser);
        post.put("ip", ip);
        post.put("nl", nl);
        post.put("code_client", clientCode);
        post.put("st", st);
        ReturnObject response = wb.post(ReturnObject.class, post);
        return response;
    }

    @Override
    public void logOut(Integer idSession) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(LoginAccessor.getPath() + "/logOut"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idSession);
        ((WebBuilder)wb).post(post);
    }

    @Override
    public void setUserSessionSite(int site) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(LoginAccessor.getPath() + "/setUserSessionSite"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("site", site);
        ((WebBuilder)wb).post(post);
    }

    @Override
    public void setUserSessionLocale(Locale locale) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(LoginAccessor.getPath() + "/setUserSessionLocale"), "application/octet-stream", "application/json");
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("locale", locale.getLanguage());
        ((WebBuilder)wb).post(post);
    }

    @Override
    public ReturnObject sendTwoFactorCodeToEmail(String userName, String password, String clientCode, String lang, String email) {
        WebBuilder wb = super.buildWebBuilder(this.getSecureURI(LoginAccessor.getPath() + "/sendTwoFactorCodeToEmail"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("userName", userName);
        post.put("password", password);
        post.put("clientCode", clientCode);
        post.put("email", email);
        post.put("lang", lang);
        ReturnObject response = wb.post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject saveTwoFactorConfigEmail(String userName, String password, String clientCode, Integer code, String email) {
        WebBuilder wb = super.buildWebBuilder(this.getSecureURI(LoginAccessor.getPath() + "/saveTwoFactorConfigEmail"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("userName", userName);
        post.put("password", password);
        post.put("clientCode", clientCode);
        post.put("email", email);
        post.put("code", code);
        ReturnObject response = wb.post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject unlockSession() {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(LoginAccessor.getPath() + "/unlockSession"), "application/octet-stream", "application/json");
        HashMap post = new HashMap();
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findActiveSessions() {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(LoginAccessor.getPath() + "/findActiveSessions"), "application/octet-stream", "application/json");
        HashMap post = new HashMap();
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject newMetabaseToken(Integer q) {
        String method;
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        if (q != null) {
            method = "/newMetabaseTokenQuestion";
            post.put("idQuestion", q);
        } else {
            method = "/newMetabaseToken";
        }
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(LoginAccessor.getPath() + method), "application/octet-stream", "application/json");
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject metabaseQuestion() {
        HashMap post = new HashMap();
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(LoginAccessor.getPath() + "/metabaseQuestion"), "application/octet-stream", "application/json");
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject newRxVigilanceToken() {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(LoginAccessor.getPath() + "/newRxVigilanceToken"), "application/octet-stream", "application/json");
        HashMap post = new HashMap();
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }
}

