/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IConnectionInfoProvider;
import ca.infodata.ofys.data.dataaccess.ISessionProvider;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClient;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilder;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilderWithSession;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageContainer;
import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.restful.Response;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public abstract class BaseAccessor {
    public static String contextRoot = "ca.infodata.ofys.data.server.application.web.dataaccess";
    private GZIPContentEncodingFilter gzipContentEncodingFilter;
    private boolean useGzipContentEncodingFilter;
    private final RestfulClient restfulClient;
    private final ISessionProvider sessionProvider;
    private IConnectionInfoProvider connectionInfoProvider;
    protected static ConcurrentHashMap<String, Long> lastConnexionTime;

    public BaseAccessor(RestfulClient restfulClient, IConnectionInfoProvider connectionInfoProvider, ISessionProvider sessionProvider) {
        this.restfulClient = restfulClient;
        this.sessionProvider = sessionProvider;
        this.connectionInfoProvider = connectionInfoProvider;
        this.gzipContentEncodingFilter = new GZIPContentEncodingFilter();
    }

    public void dispose() {
    }

    protected URI getSecureURI(String path) {
        try {
            URL url = this.connectionInfoProvider.get().getServerUrl();
            return new URI(url.getProtocol(), null, url.getHost(), url.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Map<String, Object> asMap(Object ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyMap();
        }
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("array must contains values by pair String, Object");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(objects.length / 2);
        int i = 0;
        while (i < objects.length) {
            String key;
            if ((key = (String)objects[i++]) == null) {
                throw new IllegalArgumentException("key cant be null");
            }
            Object value = objects[i++];
            map.put(key, value);
        }
        return map;
    }

    public Client getClient() {
        return this.restfulClient.getJerseyClient();
    }

    public RestfulClient getRestfulClient() {
        return this.restfulClient;
    }

    protected WebBuilder buildWebBuilder(URI uri, String accept, String type) {
        WebResource resource = this.buildResource(uri);
        WebBuilder wb = new WebBuilder(resource, accept, type);
        return wb;
    }

    protected WebBuilderWithSession buildWebBuilderWithSession(URI uri, String accept, String type) {
        XSession session = this.sessionProvider.getSession();
        WebResource resource = this.buildResource(uri);
        WebBuilderWithSession wb = new WebBuilderWithSession(resource, accept, type, session);
        return wb;
    }

    protected XSession getSession() {
        return this.sessionProvider.getSession();
    }

    protected String getCodeClient() {
        XSession session = this.sessionProvider.getSession();
        if (session == null) {
            return null;
        }
        return session.getClient().getClientCode();
    }

    protected WebResource buildResource(URI uri) {
        WebResource resource = this.getClient().resource(uri);
        if (this.useGzipContentEncodingFilter) {
            resource.addFilter((ClientFilter)this.gzipContentEncodingFilter);
        }
        return resource;
    }

    protected void processResponse(Response<?> response) {
        if (response.errorIndicator.booleanValue()) {
            throw new RuntimeException(response.errorMessage);
        }
    }

    public boolean isUseGzipContentEncodingFilter() {
        return this.useGzipContentEncodingFilter;
    }

    public void setUseGzipContentEncodingFilter(boolean useGzipContentEncodingFilter) {
        this.useGzipContentEncodingFilter = useGzipContentEncodingFilter;
    }

    protected byte[] serialize(Serializable ret, boolean useCompression) {
        if (ret == null) {
            return null;
        }
        return LZMAClientSerialiser.serialize((Object)ret, (boolean)useCompression);
    }

    protected byte[] serialize(Serializable a) {
        return this.serialize(a, a instanceof XPatientImageContainer);
    }

    protected Integer dayFrom1970(LocalDate date) {
        return date == null ? null : Integer.valueOf(date.dayFrom1970);
    }

    protected JsonArray toJsonArray(Stream<Map.Entry<String, String>> s) {
        JsonArray jsonArray = new JsonArray();
        s.forEachOrdered(e -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty((String)e.getKey(), (String)e.getValue());
            jsonArray.add((JsonElement)jsonObject);
        });
        return jsonArray;
    }

    protected <T extends EnumWithValue<T>> List<Integer> values(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> values = new ArrayList<Integer>(list.size());
        for (EnumWithValue t : list) {
            values.add(t.getValue());
        }
        return values;
    }

    protected <T extends EnumWithValue<T>> Integer value(T t) {
        if (t == null) {
            return null;
        }
        return t.getValue();
    }

    protected List<Integer> dayFrom1970(List<LocalDate> dates) {
        if (dates == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(dates.size());
        if (dates != null) {
            for (LocalDate date : dates) {
                if (date == null) continue;
                list.add(this.dayFrom1970(date));
            }
        }
        return list;
    }

    public IConnectionInfoProvider getConnectionInfoProvider() {
        return this.connectionInfoProvider;
    }

    public static void validThatServerIsAccessible(IConnectionInfo connectionInfo) {
        BaseAccessor.validThatServerIsAccessible(connectionInfo.getServerAddress());
    }

    public static void validThatServerIsAccessible(String serverAddress) {
        if (!lastConnexionTime.containsKey(serverAddress) || System.currentTimeMillis() - lastConnexionTime.get(serverAddress) > TimeUnit.MINUTES.toMillis(1L)) {
            // empty if block
        }
    }

    static {
        String value = System.getProperty("ca.infodata.ofys.server.url.contextRoot");
        if (value != null) {
            contextRoot = value;
        }
        lastConnexionTime = new ConcurrentHashMap(3);
    }
}

