/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.controller.DSQController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.WebSocketFilterByRequest;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.CDsqDmeObjectList;
import ca.infodata.ofys.data.middle.dataobjects.LightweightReport;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CSummary;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLabType;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboFile;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboFilter;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboFollow;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsFlag;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalQuery;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsText;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintMode;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.dashboard.accessor.LaboResultsSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CBaseLaboResultsProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CLabNote;
import ca.infodata.ofys.ui.dashboard.models.CLaboFile;
import ca.infodata.ofys.ui.dashboard.models.CLaboFilter;
import ca.infodata.ofys.ui.dashboard.models.CLaboFollow;
import ca.infodata.ofys.ui.dashboard.models.CLaboHistory;
import ca.infodata.ofys.ui.dashboard.models.CLaboResultSearchQuery;
import ca.infodata.ofys.ui.dashboard.models.CLaboResultsProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CLaboResultsText;
import ca.infodata.ofys.ui.dashboard.models.IdsProf;
import ca.infodata.ofys.ui.dashboard.models.LaboDescription;
import ca.infodata.ofys.ui.dashboard.models.OpenDocPdfParams;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import ca.infodata.readhl7.Doit;
import ca.infodata.util1.ByteSerialiser;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class LaboratoryController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(LaboratoryController.class.getName());
    private final LaboResultsSyncAccessorClient laboResultsAccessor;
    private final DSQController dsqController;
    protected static Cache<String, CLaboResultsProfessionnal> cacheXLaboText = Caffeine.newBuilder().maximumSize(250L).initialCapacity(10).expireAfterAccess(20L, TimeUnit.SECONDS).build();

    public LaboratoryController(DSQController dsqController) {
        this.dsqController = dsqController;
        this.laboResultsAccessor = new LaboResultsSyncAccessorClient();
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XLaboResultsProfessionnal) {
            CLaboResultsProfessionnal jMsg = new CLaboResultsProfessionnal((XLaboResultsProfessionnal)object, false);
            ServerResponses.sendJsonToClient(notification.getClientId(), "labo.results.professionnal.update", jMsg);
        }
    }

    public XLaboResultsProfessionnalQuery laboQuery(Integer patientId, Integer professionalId, XLaboResultsProfessionnalStatus status) {
        XLaboResultsProfessionnalQuery query = new XLaboResultsProfessionnalQuery();
        if (patientId != null) {
            query.setIdPatient(patientId);
        }
        if (professionalId != null) {
            query.setIdProfessionnal(professionalId);
        }
        if (status != null) {
            query.setStatus(status);
        }
        return query;
    }

    public List<LaboDescription> search(String[] query) {
        return this.getLaboList(this.laboResultsAccessor.laboList(this.laboQuery(null, null, null)), query);
    }

    private ActionResult assignOtherPatient(Integer labId, Integer patId) {
        ReturnObject ro = this.laboResultsAccessor.reassignLaboResultsToPatient(labId, patId);
        return ServerResponses.toJsonActionResult(ro);
    }

    private List<LaboDescription> getLaboList(List<XBaseLaboResultsProfessionnal> laboList, String[] query) {
        ArrayList<LaboDescription> res = new ArrayList<LaboDescription>();
        if (laboList == null) {
            return res;
        }
        boolean search = query != null;
        for (XBaseLaboResultsProfessionnal labo : laboList) {
            boolean match = false;
            if (search) {
                for (int i = 0; !match && i < query.length; ++i) {
                    match = labo.getStr().toLowerCase().contains(query[i]);
                }
            } else {
                match = true;
            }
            if (!match) continue;
            res.add(this.getLaboItem(labo));
        }
        return res;
    }

    private List<CBaseLaboResultsProfessionnal> getLabos(List<XBaseLaboResultsProfessionnal> laboList, String[] query) {
        ArrayList<CBaseLaboResultsProfessionnal> res = new ArrayList<CBaseLaboResultsProfessionnal>();
        if (laboList == null) {
            return res;
        }
        boolean search = query != null;
        for (XBaseLaboResultsProfessionnal labo : laboList) {
            boolean match = false;
            if (search) {
                for (int i = 0; !match && i < query.length; ++i) {
                    match = labo.getStr().toLowerCase().contains(query[i]);
                }
            } else {
                match = true;
            }
            if (!match) continue;
            res.add(new CBaseLaboResultsProfessionnal(labo));
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> getFileLabos(List<XLaboFile> laboList, String[] query, Integer selectedProf, boolean withCreat) {
        Integer idProf;
        ArrayList<Object> res = new ArrayList<Object>();
        if (laboList == null) {
            return res;
        }
        boolean search = query != null;
        XBaseProfessionnal sessionProfessionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
        Integer n = idProf = sessionProfessionnal == null ? null : sessionProfessionnal.getId();
        if (selectedProf == null) {
            selectedProf = idProf;
        }
        ArrayList<LaboStructureDate> lstCreat = new ArrayList<LaboStructureDate>();
        ArrayList<LaboStructureDate> lstRSOS = new ArrayList<LaboStructureDate>();
        ArrayList<LaboStructureDate> lstHbA1c = new ArrayList<LaboStructureDate>();
        ArrayList<LaboStructureDate> lstPsa = new ArrayList<LaboStructureDate>();
        ArrayList<LaboStructureDate> lstCho = new ArrayList<LaboStructureDate>();
        HashMap mapLstCls = new HashMap();
        for (XLaboFile xLaboFile : laboList) {
            boolean match = false;
            if (search) {
                void var18_22;
                boolean bl = false;
                while (!match && var18_22 < query.length) {
                    match = xLaboFile.req.toLowerCase().contains(query[var18_22]);
                    ++var18_22;
                }
            } else {
                match = true;
            }
            if (!match) continue;
            CLaboFile cLaboFile = new CLaboFile(xLaboFile, idProf, selectedProf);
            res.add(cLaboFile);
        }
        if (withCreat) {
            List<CLaboFile.CLaboStructure> listLS;
            String laboFileDate;
            CLaboFile cLaboFile;
            Comparator<LaboStructureDate> comparator = new Comparator<LaboStructureDate>(){

                @Override
                public int compare(LaboStructureDate o1, LaboStructureDate o2) {
                    return o2.date.compareTo(o1.date);
                }
            };
            for (Object e : res) {
                cLaboFile = (CLaboFile)e;
                if (cLaboFile.lstVeryAbns == null) continue;
                laboFileDate = cLaboFile.date.substring(0, 10);
                for (CLaboFile.CLaboStructure ls : cLaboFile.lstVeryAbns) {
                    listLS = (ArrayList<CLaboFile.CLaboStructure>)mapLstCls.get(ls.getName());
                    if (listLS == null) {
                        listLS = new ArrayList<CLaboFile.CLaboStructure>();
                        mapLstCls.put(ls.getName(), listLS);
                    }
                    listLS.add(ls);
                    this.extracted(laboFileDate, ls, lstCreat, lstRSOS, lstHbA1c, lstPsa, lstCho);
                }
            }
            for (Object e : res) {
                cLaboFile = (CLaboFile)e;
                laboFileDate = cLaboFile.date.substring(0, 10);
                if (cLaboFile.lstNs != null) {
                    for (CLaboFile.CLaboStructure ls : cLaboFile.lstNs) {
                        listLS = (List)mapLstCls.get(ls.getName());
                        if (listLS == null) {
                            listLS = new ArrayList();
                            mapLstCls.put(ls.getName(), listLS);
                        }
                        listLS.add(ls);
                        this.extracted(laboFileDate, ls, lstCreat, lstRSOS, lstHbA1c, lstPsa, lstCho);
                    }
                }
                if (cLaboFile.lstAbns == null) continue;
                for (CLaboFile.CLaboStructure ls : cLaboFile.lstAbns) {
                    listLS = (List)mapLstCls.get(ls.getName());
                    if (listLS == null) {
                        listLS = new ArrayList();
                        mapLstCls.put(ls.getName(), listLS);
                    }
                    listLS.add(ls);
                    this.extracted(laboFileDate, ls, lstCreat, lstRSOS, lstHbA1c, lstPsa, lstCho);
                }
            }
            if (!lstCreat.isEmpty()) {
                Collections.sort(lstCreat, comparator);
                res.add(0, lstCreat.get(0));
            } else {
                res.add(0, new Object());
            }
            if (!mapLstCls.isEmpty()) {
                ArrayList<CSummary.CAbnLab4Rxv> arrayList = new ArrayList<CSummary.CAbnLab4Rxv>();
                for (String key : mapLstCls.keySet()) {
                    List list = (List)mapLstCls.get(key);
                    if (list.isEmpty()) continue;
                    Collections.sort(list, new Comparator<CLaboFile.CLaboStructure>(){

                        @Override
                        public int compare(CLaboFile.CLaboStructure o1, CLaboFile.CLaboStructure o2) {
                            return ObjectUtils.compare((Comparable)((Object)o2.getDate()), (Comparable)((Object)o1.getDate()));
                        }
                    });
                    CLaboFile.CLaboStructure lsd = (CLaboFile.CLaboStructure)list.get(0);
                    int on1YearAgo = LocalDate.today().plusYear((int)-1).dayFrom1970;
                    if (lsd.d1970 <= on1YearAgo) continue;
                    String labName = lsd.getName().toLowerCase();
                    String code = null;
                    try {
                        String inferieurInterval = lsd.getInferieurInterval();
                        double inf = Double.parseDouble(inferieurInterval);
                        if (inf < 1.0E-4) continue;
                        if (((Set)XLabType.mapTypeCodes.get("~~ZK")).contains(lsd.getCode())) {
                            if (inf >= 3.0 && inf <= 4.0) {
                                code = "kalis";
                            }
                        } else if (labName.contains("potassium")) {
                            if (inf >= 3.0 && inf <= 4.0) {
                                code = "kalis";
                            }
                        } else if (((Set)XLabType.mapTypeCodes.get("~~ZFERR")).contains(lsd.getCode())) {
                            code = "fer";
                        } else if (labName.contains("ferritine")) {
                            code = "fer";
                        } else if (labName.contains("acid") && labName.contains("foli")) {
                            code = "afols";
                        } else if (labName.contains("albumin")) {
                            if (inf >= 25.0 && inf <= 38.0) {
                                code = "alb";
                            }
                        } else if (labName.contains("acid") && labName.contains("uri")) {
                            code = "auri";
                        } else if (((Set)XLabType.mapTypeCodes.get("~~ZUREE")).contains(lsd.getCode())) {
                            if (inf >= 1.7 && inf <= 3.2) {
                                code = "BUN";
                            }
                        } else if (labName.contains("ur\u00e9e") || labName.contains("bun") || labName.contains("azote") && labName.contains("ur") && labName.contains("sang") || labName.contains("blood") && labName.contains("urea") && labName.contains("nitrogen")) {
                            if (inf >= 1.7 && inf <= 3.2) {
                                code = "BUN";
                            }
                        } else if (((Set)XLabType.mapTypeCodes.get("~~ZCA")).contains(lsd.getCode())) {
                            code = "calcs";
                        } else if (labName.contains("calcium") && inf >= 1.9 && inf <= 2.2) {
                            code = "calcs";
                        } else if (((Set)XLabType.mapTypeCodes.get("~~ZCAI")).contains(lsd.getCode())) {
                            code = "calis";
                        } else if (labName.contains("calcium") && inf >= 0.9 && inf <= 1.17) {
                            code = "calis";
                        } else if (labName.contains("chlor")) {
                            if (inf >= 96.0 && inf <= 103.0) {
                                code = "chlore";
                            }
                        } else if (labName.contains("cholest") && labName.contains("total") || ((Set)XLabType.mapTypeCodes.get("~~ZCHOL")).contains(lsd.getCode())) {
                            if (inf >= 2.6 && inf <= 3.8) {
                                code = "ctots";
                            }
                        } else if (labName.contains("digoxin")) {
                            code = "digo";
                        } else if (labName.equals("alt") || labName.contains("alanin") && labName.contains("transf")) {
                            code = "ealts";
                        } else if (labName.equals("ast") || labName.contains("aspart") && labName.contains("transf")) {
                            code = "easts";
                        } else if (labName.equals("ck")) {
                            code = "ecpks";
                        } else if (labName.equals("fer")) {
                            code = "fe";
                        } else if (((Set)XLabType.mapTypeCodes.get("~~ZGLU")).contains(lsd.getCode())) {
                            code = "glu";
                        } else if (labName.startsWith("glucos") && inf >= 2.2 && inf <= 4.6) {
                            code = "glu";
                        } else if (((Set)XLabType.mapTypeCodes.get("~~ZHB")).contains(lsd.getCode())) {
                            code = "hb";
                        } else if ((labName.startsWith("h\u00e9moglobin") || labName.startsWith("hemoglobin")) && inf >= 100.0 && inf <= 140.0) {
                            code = "hb";
                        } else if ((labName.contains("glyqu") || labName.contains("glycos") || labName.contains("a1c")) && (labName.startsWith("h\u00e9moglobin") || labName.startsWith("hemoglobin")) && inf >= 0.03 && inf <= 0.05) {
                            code = "hba1c%";
                        } else if (labName.startsWith("lithium") && inf >= 0.4 && inf <= 0.6) {
                            code = "lith";
                        } else if (labName.startsWith("magn") && inf >= 0.6 && inf <= 0.75) {
                            code = "mag";
                        } else if (((Set)XLabType.mapTypeCodes.get("~~MG")).contains(lsd.getCode())) {
                            code = "mag";
                        } else if (((Set)XLabType.mapTypeCodes.get("~~ZNA")).contains(lsd.getCode())) {
                            code = "sodium";
                        } else if ((labName.startsWith("sodium") || labName.startsWith("na")) && inf >= 133.0 && inf <= 139.0) {
                            code = "sodium";
                        } else if (labName.startsWith("tsh") && inf >= 0.2 && inf <= 0.7) {
                            code = "tsh";
                        } else if (labName.startsWith("t4") && inf >= 7.0 && inf <= 13.0) {
                            code = "T4L";
                        } else if (labName.startsWith("t4") && inf >= 50.0 && inf <= 80.0) {
                            code = "T4";
                        }
                        if (code == null) continue;
                        String superieurInterval = lsd.getSuperieurInterval();
                        String value = lsd.getValue();
                        double sup = Double.parseDouble(superieurInterval);
                        double val = Double.parseDouble(value);
                        String abn = null;
                        if (val > sup) {
                            abn = "H";
                        } else if (val < inf) {
                            abn = "B";
                        }
                        if (abn == null) continue;
                        arrayList.add(new CSummary.CAbnLab4Rxv(lsd.getDate(), code, abn));
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                res.add(1, arrayList);
            } else {
                res.add(1, new Object());
            }
            if (!lstRSOS.isEmpty()) {
                res.add(2, lstRSOS.stream().sorted(comparator).findFirst().get());
            } else {
                res.add(2, new Object());
            }
            if (!lstHbA1c.isEmpty()) {
                res.add(3, lstHbA1c.stream().sorted(comparator).findFirst().get());
            } else {
                res.add(3, new Object());
            }
            if (!lstPsa.isEmpty()) {
                res.add(4, lstPsa.stream().sorted(comparator).findFirst().get());
            } else {
                res.add(4, new Object());
            }
            if (!lstCho.isEmpty()) {
                res.add(5, lstCho.stream().sorted(comparator).findFirst().get());
            } else {
                res.add(5, new Object());
            }
        }
        return res;
    }

    private void extracted(String laboFileDate, CLaboFile.CLaboStructure ls, List<LaboStructureDate> lstCreat, List<LaboStructureDate> lstRSOS, List<LaboStructureDate> lstHbA1c, List<LaboStructureDate> lstPsa, List<LaboStructureDate> lstCho) {
        String lc = ls.getName().toLowerCase();
        if (((Set)XLabType.mapTypeCodes.get("~~ZCREA")).contains(ls.getCode())) {
            lstCreat.add(new LaboStructureDate(laboFileDate, ls));
        } else if (ls.getName().indexOf("RSOS") != -1) {
            lstRSOS.add(new LaboStructureDate(laboFileDate, ls));
        } else if (lc.indexOf("hba1c") != -1 && lc.indexOf("comment") == -1 && lc.indexOf("interpr") == -1 || lc.indexOf("moglobine") != -1 && (lc.indexOf("glyqu") != -1 || lc.indexOf("glyco") != -1) && lc.indexOf("comment") == -1 && lc.indexOf("interpr") == -1) {
            lstHbA1c.add(new LaboStructureDate(laboFileDate, ls));
        } else if ((ls.getName().indexOf("PSA") != -1 || ls.getName().indexOf("PSA") != -1) && lc.indexOf("ratio") == -1 && ls.getName().indexOf("%") == -1 && ls.getName().indexOf("TAPSE") == -1) {
            lstPsa.add(new LaboStructureDate(laboFileDate, ls));
        } else if (((Set)XLabType.mapTypeCodes.get("~~ZLDL")).contains(ls.getCode()) || lc.indexOf("chol") != -1 && lc.indexOf("ldl") != -1) {
            lstCho.add(new LaboStructureDate(laboFileDate, ls));
        }
    }

    public List<CBaseLaboResultsProfessionnal> getReview(Integer patientId, Integer professionalId, XLaboResultsProfessionnalStatus status) {
        List<CBaseLaboResultsProfessionnal> res = this.getLabos(this.laboResultsAccessor.laboList(this.laboQuery(patientId, professionalId, status)), null);
        return res;
    }

    public ActionResult getLaboItemFile(IServerRequest req) {
        Integer baseLaboId = req.getRequiredQueryParam("baseLaboId", Integer.class);
        ActionResult res = new ActionResult("labo");
        res.setSkin(this.getLaboAsHtml(baseLaboId));
        return res;
    }

    public String getLaboAsHtml(int baseLaboId) {
        CLaboResultsProfessionnal labo = new CLaboResultsProfessionnal(this.getLaboById(baseLaboId, Boolean.FALSE), false);
        return labo.html;
    }

    public void copyToClipboard(String text) {
        Application.get().getApplicationUiPlugin().copyToClipboard(text);
    }

    public CLaboResultsProfessionnal getLaboInfo(int baseLaboId, Boolean loadAllVersion, boolean keepHl7) {
        CLaboResultsProfessionnal labo = new CLaboResultsProfessionnal(this.getLaboById(baseLaboId, loadAllVersion), keepHl7);
        return labo;
    }

    public CLaboResultsProfessionnal getLaboInfoFromIdText(int idtext, boolean keepHl7) {
        CLaboResultsProfessionnal labo = new CLaboResultsProfessionnal(this.getLaboByIdText(idtext), keepHl7);
        return labo;
    }

    private ReturnObject printLabo(Integer id) {
        XBaseLaboResultsProfessionnal base = new XBaseLaboResultsProfessionnal();
        base.id = id;
        IPrintController printController = Application.get().getPrintControllerFactory().newPrintController((Serializable)base);
        printController.getSelection().add((IReport)new LightweightReport("labo2", "R\u00e9sultats de laboratoire", PrintMode.ACTUAL_SIZE));
        return ServerResponses.print(printController);
    }

    public ActionResult openLaboEditor(IServerRequest req) {
        Integer baseLaboId = req.getQueryParam("baseLaboId", Integer.class);
        Boolean loadAllVersion = req.getQueryParam("loadAllVesion", Boolean.class);
        XLaboResultsProfessionnal laboResultsProfessionnal = this.laboResultsAccessor.getLaboResultsProfessional(baseLaboId, (boolean)(loadAllVersion == null || loadAllVersion == false ? Boolean.FALSE : Boolean.TRUE));
        Application.get().getApplicationUiPlugin().openLaboEditor(laboResultsProfessionnal);
        return ServerResponses.SUCCESS();
    }

    public CLaboFile sign(Integer id) {
        try {
            XLaboResultsProfessionnal saved;
            XLaboResultsProfessionnal doc = this.getLaboById(id, Boolean.FALSE);
            doc.setSignedDatetime(Long.valueOf(DateUtil.nowUTC()));
            if (doc.getSeenDatetime() == null) {
                doc.setSeenDatetime(Long.valueOf(DateUtil.nowUTC()));
                doc.addXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.SEEN);
                doc.removeXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.UNSEEN);
            }
            if (null != (saved = this.laboResultsAccessor.save(doc))) {
                Application.get().getGlobalInstances().getNotificationSystem().sendDataObjectUpdatedNotification((IDataObject)saved);
                return new CLaboFile(saved);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private LaboDescription getLaboItem(XBaseLaboResultsProfessionnal container) {
        LaboDescription desc = new LaboDescription(container.getStr());
        return desc;
    }

    public XLaboResultsProfessionnal getLaboById(int baseLaboId, Boolean loadAllVersoin) {
        return this.laboResultsAccessor.getLaboResultsProfessional(baseLaboId, loadAllVersoin);
    }

    public XLaboResultsProfessionnal getLaboByIdText(int idText) {
        return this.laboResultsAccessor.getLaboResultsProfessionnalByIdText(idText);
    }

    private CLaboFile save(CLabNote labNote) {
        XLaboResultsProfessionnal saved;
        XLaboResultsProfessionnal document = this.getLaboById(labNote.id, Boolean.FALSE);
        MultiStatus status = new MultiStatus();
        if (document.getSeenDatetime() == null) {
            document.setSeenDatetime(Long.valueOf(DateUtil.nowUTC()));
            document.addXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.SEEN);
        }
        if (ObjectUtils.notEqual((Object)document.getNote(), (Object)StringUtils.defaultString((String)labNote.note, (String)""))) {
            document.setNote(labNote.note);
        }
        if (Boolean.TRUE.equals(labNote.openWithFile)) {
            document.addXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.OPEN_WITH_FILE);
        } else {
            document.removeXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.OPEN_WITH_FILE);
        }
        if (Boolean.TRUE.equals(labNote.toResolve)) {
            document.addXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.TO_RESOLVE);
        } else {
            document.removeXLaboResultsProfessionnalStatus(XLaboResultsProfessionnalStatus.TO_RESOLVE);
        }
        CLaboFile savedCLaboFile = null;
        if (labNote.labNotes != null && labNote.labNotes.length > 0) {
            int[] ids = new int[labNote.labNotes.length];
            for (int i = 0; i < labNote.labNotes.length; ++i) {
                CLabNote ln = labNote.labNotes[i];
                ids[i] = ln.id;
            }
            status.add(this.laboResultsAccessor.setLaboResultsProfessionnalEnumSetStatus(ids, new Integer(1), labNote.idPatient));
        }
        if (null != (saved = this.laboResultsAccessor.save(document))) {
            Application.get().getGlobalInstances().getNotificationSystem().sendDataObjectUpdatedNotification((IDataObject)saved);
            savedCLaboFile = new CLaboFile(saved);
        }
        return savedCLaboFile;
    }

    private IStatus saveEnumReset(CLabNote labNote) {
        MultiStatus status = new MultiStatus();
        if (labNote.labNotes != null && labNote.labNotes.length > 0) {
            int[] ids = new int[labNote.labNotes.length];
            for (int i = 0; i < labNote.labNotes.length; ++i) {
                CLabNote ln = labNote.labNotes[i];
                ids[i] = ln.id;
            }
            IStatus stat = this.laboResultsAccessor.setLaboResultsProfessionnalEnumSetStatus(ids, new Integer(1), labNote.idPatient);
            status.setMessage(stat.getMessage());
            status.setSeverity(stat.getSeverity());
            if (status.isOK()) {
                status.setData((Serializable)ids);
            }
        }
        return status;
    }

    private IStatus delAllAutoOpen(CLabNote labNote) {
        MultiStatus status = new MultiStatus();
        if (labNote.labNotes != null && labNote.labNotes.length > 0) {
            int[] ids = new int[labNote.labNotes.length];
            for (int i = 0; i < labNote.labNotes.length; ++i) {
                CLabNote ln = labNote.labNotes[i];
                ids[i] = ln.id;
            }
            IStatus stat = this.laboResultsAccessor.delAllLaboProfStatus(ids, new Integer(8), labNote.idPatient);
            status.setMessage(stat.getMessage());
            status.setSeverity(stat.getSeverity());
            if (status.isOK()) {
                status.setData((Serializable)ids);
            }
        }
        return status;
    }

    public List<CLaboResultsText> findPartialLaboResultsText(List<CLaboResultsText> respVersions, String labNo, Integer idPatient) {
        List<XLaboResultsText> allXVersions = this.laboResultsAccessor.findPartialLaboResultsText(labNo, idPatient);
        if (allXVersions != null) {
            for (XLaboResultsText lab : allXVersions) {
                if (lab == null) continue;
                respVersions.add(new CLaboResultsText(lab));
            }
        }
        return respVersions;
    }

    private XLaboResultsProfessionnalQuery laboSearchQuery(CLaboResultSearchQuery data) throws ParseException {
        XLaboResultsProfessionnalQuery criteria = new XLaboResultsProfessionnalQuery();
        criteria.setDateRangeRequest(this.createLocalDateRange(data.labRequestAfterDate, data.labRequestBeforeDate));
        criteria.setDateRangeSeen(this.createLocalDateRange(data.labSeenAfterDate, data.labSeenBeforeDate));
        criteria.setDateRangeService(this.createLocalDateRange(data.labServiceAfterDate, data.labServiceBeforeDate));
        criteria.setDateRangeSigned(this.createLocalDateRange(data.labSignAfterDate, data.labSignBeforeDate));
        if (data.getResultFlag() != null) {
            criteria.setResultFlag(XLaboResultsFlag.from((Integer)data.getResultFlag()));
        }
        if (data.getStatus() != null) {
            criteria.setStatus(XLaboResultsProfessionnalStatus.from((Integer)data.getStatus()));
        }
        criteria.setHasExtremeValues(data.getHasExtremeValue());
        criteria.setName(data.getName());
        criteria.setIdPatient(data.getIdPatient());
        criteria.setIdProfessionnal(data.getIdProfessionnal());
        criteria.setIdDispensateur(data.getIdDispensateur());
        return criteria;
    }

    private LocalDateRange createLocalDateRange(Long startDate, Long endDate) throws ParseException {
        if (startDate != null || endDate != null) {
            LocalDate localStartDate = null;
            LocalDate LocalEndDate = null;
            if (startDate != null) {
                localStartDate = LocalDate.fromTimeInMillisUTC((Long)startDate);
            }
            if (endDate != null) {
                LocalEndDate = LocalDate.fromTimeInMillisUTC((Long)endDate);
            }
            return new LocalDateRange(localStartDate, LocalEndDate, RangeNotation.CLOSED);
        }
        return null;
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard", RouterFunctions.routeAction("/Labo/file", req -> this.getLaboItemFile(req)), RouterFunctions.routeAction("/Labo/editor", req -> this.openLaboEditor(req)), RouterFunctions.routes("/Labo/ws", RouterFunctions.routeAction("/review", req -> {
            XLaboResultsProfessionnalStatus status = req.getRequiredQueryParam("status", XLaboResultsProfessionnalStatus.class);
            Integer patientId = req.getQueryParam("patientId", Integer.class);
            Integer professionalId = req.getQueryParam("idProf", Integer.class);
            List<CBaseLaboResultsProfessionnal> review = this.getReview(patientId, professionalId, status);
            return ServerResponses.toJsonActionResult(review);
        }), RouterFunctions.routeAction("/copyToClip", req -> {
            String text = req.getQueryParam("text");
            if (text != null) {
                this.copyToClipboard(text);
            }
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/addLaboFilter", req -> {
            Integer id = req.getRequiredQueryParam("id", Integer.class);
            Integer idPat = req.getRequiredQueryParam("patientId", Integer.class);
            Integer idProf = req.getRequiredQueryParam("profId", Integer.class);
            XLaboFilter x = new XLaboFilter();
            x.setIdLabStructure(id);
            x.setIdPatient(idPat);
            x.setIdProfessionnal(idProf);
            IStatus status = this.laboResultsAccessor.addLaboFilter(x);
            if (status.getSeverity().equals((Object)IStatus.Severity.ERROR)) {
                return ServerResponses.ERROR(status.getMessage());
            }
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/addLaboFollow", req -> {
            String code = req.getRequiredQueryParam("code", String.class);
            String loinc = req.getQueryParam("loinc", String.class);
            Integer idPat = req.getRequiredQueryParam("patientId", Integer.class);
            Integer idProf = req.getRequiredQueryParam("profId", Integer.class);
            XLaboFollow x = new XLaboFollow();
            x.setTypes(code + "," + loinc);
            x.setIdPatient(idPat);
            x.setIdProfessionnal(idProf);
            IStatus status = this.laboResultsAccessor.addLaboFollow(x);
            if (status.getSeverity().equals((Object)IStatus.Severity.ERROR)) {
                return ServerResponses.ERROR(status.getMessage());
            }
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/delLaboFollow", req -> {
            String code = req.getRequiredQueryParam("code", String.class);
            String loinc = req.getQueryParam("loinc", String.class);
            Integer idPat = req.getRequiredQueryParam("patientId", Integer.class);
            Integer idProf = req.getRequiredQueryParam("profId", Integer.class);
            XLaboFollow x = new XLaboFollow();
            x.setTypes(code + "," + loinc);
            x.setIdPatient(idPat);
            x.setIdProfessionnal(idProf);
            IStatus status = this.laboResultsAccessor.delLaboFollow(x);
            if (status.getSeverity().equals((Object)IStatus.Severity.ERROR)) {
                return ServerResponses.ERROR(status.getMessage());
            }
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/reviewCount", req -> {
            Integer professionalId = req.getQueryParam("idProf", Integer.class);
            XLaboResultsProfessionnalQuery container = new XLaboResultsProfessionnalQuery();
            EnumSet<XLaboResultsProfessionnalStatus> setStatus = EnumSet.noneOf(XLaboResultsProfessionnalStatus.class);
            setStatus.add(XLaboResultsProfessionnalStatus.UNSEEN);
            container.setIdProfessionnal(professionalId);
            container.setStatusSet(setStatus);
            return ServerResponses.toJsonActionResult(this.laboResultsAccessor.countLaboResultsProfessionnal(container));
        }), RouterFunctions.routeAction("/bypat", req -> {
            ArrayList<CLaboFilter> lst;
            Integer idPat = req.getRequiredQueryParam("id", Integer.class);
            CDsqDmeObjectList ol = this.laboResultsAccessor.laboListByPatient(idPat);
            if (ol.lstLaboFileBA != null && (ol.lstLaboFile == null || ol.lstLaboFile.isEmpty())) {
                ol.lstLaboFile = (ArrayList)LZMAClientSerialiser.deserialize((byte[])ol.lstLaboFileBA, (boolean)true);
            }
            if (ol.lstLaboFilterBA != null && ol.lstLaboFilter == null) {
                lst = new ArrayList<CLaboFilter>();
                CLaboFilter.getListFromArrayString(lst, (String[])LZMAClientSerialiser.deserialize((byte[])ol.lstLaboFilterBA, (boolean)false));
                if (lst.size() > 0) {
                    ol.lstLaboFilter = new ArrayList(lst.size());
                    ol.lstLaboFilter.addAll(lst);
                }
            }
            if (ol.lstLaboFollowBA != null && ol.lstLaboFollow == null) {
                lst = new ArrayList();
                CLaboFollow.getListFromArrayString(lst, (String[])LZMAClientSerialiser.deserialize((byte[])ol.lstLaboFollowBA, (boolean)false));
                if (lst.size() > 0) {
                    ol.lstLaboFollow = new ArrayList(lst.size());
                    ol.lstLaboFollow.addAll(lst);
                }
            }
            try {
                IWebSocketChannel wsChannel = WebApplication.get().getWebSocketDelegate().get(new WebSocketFilterByRequest(req));
                if (ol.result != null) {
                    this.dsqController.sendDsqListLabo(wsChannel, ol);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "failed to sendDsqListLabo to clientUid ", e);
            }
            List<Object> fileLabos = this.getFileLabos(ol.lstLaboFile, null, null, true);
            fileLabos.add(6, ol.lstLaboFilter);
            fileLabos.add(7, ol.lstLaboFollow);
            return ServerResponses.toJsonActionResult(fileLabos);
        }), RouterFunctions.routeAction("/openDocPdf", req -> {
            OpenDocPdfParams data = req.getPostBody(OpenDocPdfParams.class);
            if (data.idPatient != null && data.year != null && data.labNo != null) {
                byte[] filledPdf = this.laboResultsAccessor.getDocPdf(data.idPatient, data.year, data.labNo);
                String filledPdfUrl = WebApplication.get().getWebResourcesDelegate().newHtmlPdfResource(filledPdf).getUrl();
                if (Application.get().getApplicationUiPlugin().isOfysProWeb()) {
                    return ServerResponses.toJsonActionResult(filledPdfUrl);
                }
                Application.get().getApplicationUiPlugin().programLaunch(filledPdfUrl);
                return ServerResponses.SUCCESS();
            }
            return null;
        }), RouterFunctions.routeAction("/byIds", req -> {
            IdsProf data = req.getPostBody(IdsProf.class);
            if (data.ids != null && data.ids.length > 0) {
                return ServerResponses.toJsonActionResult(this.getFileLabos(this.laboResultsAccessor.laboListByIds(data.ids, Boolean.TRUE), null, data.idProf, false));
            }
            return null;
        }), RouterFunctions.routeAction("/search", req -> {
            if (req.hasQueryParam("p")) {
                Integer idPat = req.getRequiredQueryParam("p", Integer.class);
                String[] query = req.getQueryParam("q", String[].class);
                CDsqDmeObjectList ol = this.laboResultsAccessor.laboListByPatient(idPat);
                if (ol.lstLaboFileBA != null && ol.lstLaboFile == null) {
                    ol.lstLaboFile = (ArrayList)LZMAClientSerialiser.deserialize((byte[])ol.lstLaboFileBA, (boolean)true);
                }
                return ServerResponses.toJsonActionResult(this.getFileLabos(ol.lstLaboFile, query, null, false));
            }
            if (req.hasQueryParam("q")) {
                String[] query = req.getQueryParam("q", String[].class);
                return ServerResponses.toJsonActionResult(this.getLabos(this.laboResultsAccessor.laboList(this.laboQuery(null, null, null)), query));
            }
            if (req.hasPostBody()) {
                XLaboResultsProfessionnalQuery data = req.getPostBody(XLaboResultsProfessionnalQuery.class);
                return ServerResponses.toJsonActionResult(this.getLabos(this.laboResultsAccessor.laboList(data), null));
            }
            return null;
        }), RouterFunctions.routeAction("/sign", req -> {
            Integer laboId = req.getRequiredQueryParam("id", Integer.class);
            return ServerResponses.toJsonActionResult(this.sign(laboId));
        }), RouterFunctions.routeReturnObject("/printLabo", req -> {
            Integer laboId = req.getRequiredQueryParam("id", Integer.class);
            return this.printLabo(laboId);
        }), RouterFunctions.routeAction("/assignOtherPatient", req -> {
            Integer laboId = req.getRequiredQueryParam("id", Integer.class);
            Integer patientId = req.getRequiredQueryParam("idPatient", Integer.class);
            return this.assignOtherPatient(laboId, patientId);
        }), RouterFunctions.routeAction("/save", req -> {
            if (req.hasPostBody()) {
                CLabNote note = req.getPostBody(CLabNote.class);
                return ServerResponses.toJsonActionResult(this.save(note));
            }
            return ServerResponses.ERROR("\u00c9chec de sauvegarde");
        }), RouterFunctions.routeAction("/saveEnumSet", req -> {
            if (req.hasPostBody()) {
                CLabNote note = req.getPostBody(CLabNote.class);
                return ServerResponses.toJsonActionResult(this.saveEnumReset(note));
            }
            return ServerResponses.ERROR("\u00c9chec de sauvegarde");
        }), RouterFunctions.routeAction("/delAllAutoOpen", req -> {
            if (req.hasPostBody()) {
                CLabNote note = req.getPostBody(CLabNote.class);
                return ServerResponses.toJsonActionResult(this.delAllAutoOpen(note));
            }
            return ServerResponses.ERROR("\u00c9chec de sauvegarde");
        }), RouterFunctions.routeAction("/searchLabo", req -> {
            CLaboResultSearchQuery data = req.getPostBody(CLaboResultSearchQuery.class);
            try {
                XLaboResultsProfessionnalQuery laboSearchQuery = this.laboSearchQuery(data);
                return ServerResponses.toJsonActionResult(this.getFileLabos(this.laboResultsAccessor.laboFileList(laboSearchQuery), null, null, false));
            }
            catch (Exception e) {
                return ServerResponses.ERROR(e.getMessage());
            }
        }), RouterFunctions.routeAction("/history", req -> {
            Integer patientId = req.getRequiredQueryParam("patientId", Integer.class);
            String idField = req.getRequiredQueryParam("idField");
            String labTypeCode = idField.substring(0, idField.lastIndexOf("-"));
            return ServerResponses.toJsonActionResult(new CLaboHistory(idField, this.laboResultsAccessor.getPatientLastSpecificResults(patientId, labTypeCode)));
        }), RouterFunctions.routeAction("/labview", req -> {
            Integer baseLaboId = req.getQueryParam("baseLaboId", Integer.class);
            Boolean loadAllVersion = req.getQueryParam("loadAllVesion", Boolean.class);
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            Integer idText = req.getQueryParam("idText", Integer.class);
            if (baseLaboId == null && idText == null) {
                return ServerResponses.ERROR("Invalid idLaboProf or idText");
            }
            if (baseLaboId != null) {
                CLaboResultsProfessionnal laboInfo = this.getLaboInfo(baseLaboId, (boolean)(loadAllVersion == null || loadAllVersion == false ? Boolean.FALSE : Boolean.TRUE), false);
                cacheXLaboText.put((Object)(laboInfo.labNo + "~" + idPatient), (Object)laboInfo);
                return ServerResponses.toJsonActionResult(laboInfo);
            }
            CLaboResultsProfessionnal laboInfo = this.getLaboInfoFromIdText(idText, false);
            cacheXLaboText.put((Object)(laboInfo.labNo + "~" + idPatient), (Object)laboInfo);
            if (laboInfo.prevLaboResultsVersion != null) {
                laboInfo.prevLaboResultsVersion.clear();
            }
            return ServerResponses.toJsonActionResult(laboInfo);
        }), RouterFunctions.routeAction("/diff", req -> {
            Integer baseLaboId = req.getQueryParam("baseLaboId", Integer.class);
            Integer idText = req.getQueryParam("idText", Integer.class);
            String hl7 = "";
            String prevHl7 = "";
            String prevHtml = "";
            CLaboResultsProfessionnal cLaboResultsProfessionnal = null;
            if (baseLaboId == null && idText == null) {
                return ServerResponses.ERROR("Invalid idLaboProf or idText");
            }
            cLaboResultsProfessionnal = baseLaboId != null ? this.getLaboInfo(baseLaboId, Boolean.FALSE, true) : this.getLaboInfoFromIdText(idText, true);
            if (cLaboResultsProfessionnal != null && cLaboResultsProfessionnal.laboResults != null && cLaboResultsProfessionnal.laboResults.hl7ValueCompressed != null) {
                hl7 = (String)ByteSerialiser.deserialize((byte[])cLaboResultsProfessionnal.laboResults.hl7ValueCompressed);
                cLaboResultsProfessionnal.laboResults.hl7ValueCompressed = null;
                if (cLaboResultsProfessionnal.previousLaboResultsSeen != null && cLaboResultsProfessionnal.previousLaboResultsSeen.hl7ValueCompressed != null) {
                    prevHl7 = (String)ByteSerialiser.deserialize((byte[])cLaboResultsProfessionnal.previousLaboResultsSeen.hl7ValueCompressed);
                    cLaboResultsProfessionnal.previousLaboResultsSeen.hl7ValueCompressed = null;
                }
            }
            Patch patch = null;
            if (StringUtils.isNotEmpty((String)prevHl7) && StringUtils.isNotEmpty((String)hl7)) {
                Doit d = new Doit();
                String printedBy = Messages.getString((String)"PRINTED_BY", (String[])new String[0]) + " " + Application.get().getPersonPluginController().getUserName(Application.get().getGlobalInstances().getSessionIdUser()) + " " + FastDateFormat.getInstance((String)(FormatDateProvider.getFormatDate().toString() + " HH:mm")).format(new Date()) + " - " + Messages.getString((String)"CONFIDENTIAL", (String[])new String[0]);
                String splitChar = "([\n]|[\r]|[\r\n])";
                List<String> original = Arrays.asList(prevHl7.split(splitChar));
                String mshLine = "";
                String pidLine = "";
                String orcLine = "";
                for (String os : original) {
                    if (os.startsWith("MSH")) {
                        mshLine = os;
                        continue;
                    }
                    if (os.startsWith("PID")) {
                        pidLine = os;
                        break;
                    }
                    if (!os.startsWith("ORC")) continue;
                    orcLine = os;
                    break;
                }
                List<String> revised = Arrays.asList(hl7.split(splitChar));
                patch = DiffUtils.diff(original, revised);
                StringBuilder hl7Diff = new StringBuilder();
                boolean mshDone = false;
                boolean pidDone = false;
                boolean orcDone = false;
                String saut = "\r\n";
                for (Delta delta : patch.getDeltas()) {
                    for (Object l : delta.getRevised().getLines()) {
                        String sl = (String)l;
                        if (!mshDone) {
                            if (sl.startsWith("MSH")) {
                                hl7Diff.append(sl + saut);
                            } else if (!mshDone) {
                                hl7Diff.append(mshLine + saut);
                            }
                            mshDone = true;
                            continue;
                        }
                        if (!pidDone) {
                            pidDone = true;
                            if (sl.startsWith("PID")) {
                                hl7Diff.append(sl + saut);
                                continue;
                            }
                            hl7Diff.append(pidLine + saut);
                            if (sl.startsWith("ORC")) {
                                orcDone = true;
                            }
                            hl7Diff.append(sl + saut);
                            continue;
                        }
                        if (!orcDone) {
                            orcDone = true;
                            if (sl.startsWith("ORC")) {
                                hl7Diff.append(sl + saut);
                                continue;
                            }
                            hl7Diff.append(orcLine + saut);
                            continue;
                        }
                        hl7Diff.append(sl + saut);
                    }
                }
                prevHtml = hl7Diff.toString();
                prevHtml = d.getHtmlFromHl7(prevHtml);
                prevHtml = StringUtils.replaceOnce((String)prevHtml, (String)"print-by-and-date-time", (String)printedBy);
                prevHtml = StringUtils.replace((String)prevHtml, (String)":#ECFAFF", (String)":#FFFFF0");
                System.out.println(prevHtml);
                cLaboResultsProfessionnal.html = prevHtml;
            }
            return ServerResponses.toJsonActionResult(cLaboResultsProfessionnal);
        }), RouterFunctions.routeAction("/findPartialLaboResultsText", req -> {
            String labNo = req.getRequiredQueryParam("labNo");
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            ArrayList<CLaboResultsText> allVersions = new ArrayList<CLaboResultsText>();
            return ServerResponses.toJsonActionResult(this.findPartialLaboResultsText(allVersions, labNo, idPatient));
        }), RouterFunctions.routeAction("/labVersions", req -> {
            String labNo = req.getRequiredQueryParam("labNo");
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            Integer initial = req.getRequiredQueryParam("initial", Integer.class);
            CLaboResultsProfessionnal cLaboResultsProfessionnal = (CLaboResultsProfessionnal)cacheXLaboText.getIfPresent((Object)(labNo + "~" + idPatient));
            ArrayList<CLaboResultsText> allVersions = new ArrayList<CLaboResultsText>();
            if (cLaboResultsProfessionnal == null || cLaboResultsProfessionnal.prevLaboResultsVersion == null) {
                this.findPartialLaboResultsText(allVersions, labNo, idPatient);
            } else {
                allVersions.add(cLaboResultsProfessionnal.laboResults);
                allVersions.addAll(cLaboResultsProfessionnal.prevLaboResultsVersion);
            }
            ArrayList<CLaboResultsProfessionnal> res = new ArrayList<CLaboResultsProfessionnal>();
            if (allVersions != null && allVersions.size() > 0) {
                for (CLaboResultsText labV : allVersions) {
                    if (initial.equals(labV.id)) continue;
                    CLaboResultsProfessionnal labo = new CLaboResultsProfessionnal();
                    labo.idLabText = labV.id;
                    labo.className = CLaboResultsProfessionnal.class.getSimpleName();
                    labo.note = null;
                    labo.seenDatetime = null;
                    labo.signedDatetime = null;
                    labo.professionnal = null;
                    labo.status = null;
                    labo.laboResults = labV;
                    labo.previousLaboResultsSeen = null;
                    labo.notesHistory = null;
                    labo.str = labV.requestTypes;
                    labo.desc = new LaboDescription(labo.str, labV.entryDatetime);
                    labo.text = CLaboResultsProfessionnal.getCleanText(labV);
                    labo.html = CLaboResultsProfessionnal.getCleanLaboHtml(labV);
                    labo.type = labo.html != null && labo.html != "" ? "html" : (labo.text != null && labo.text != "" ? "txt" : "nan");
                    res.add(labo);
                }
            }
            return ServerResponses.toJsonActionResult(res);
        })));
    }

    protected class LaboStructureDate {
        public final String date;
        public final CLaboFile.CLaboStructure laboStructure;

        public LaboStructureDate(String date, CLaboFile.CLaboStructure laboStructure) {
            this.date = date;
            this.laboStructure = laboStructure;
        }
    }
}

