/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.College;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_COLLEGE;
import ca.infodata.dsq.domain.NIU_OTHER_MEDICATION_DM;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION_DM;
import ca.infodata.dsq.service.ri.FindProviderCriteria;
import ca.infodata.dsq.service.sommhosp.list.PatientDischargeCareSummary;
import ca.infodata.dsq.signature.Pkcs7SignatureI;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.cache.IPatientDsqControllerCache;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.Job;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.modules.dsq.PatientDsqControllers;
import ca.infodata.ofys.client.modules.dsq.PatientDsqControllersKey;
import ca.infodata.ofys.client.modules.dsq.internal.CDsqResponse;
import ca.infodata.ofys.client.modules.dsq.internal.ExportPrescriptionToDsqControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.FindCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.GetDischargeCareDetailControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.GetImagingResultExamReportControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.GetLaboListControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.GetLaboReportControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.JSonObjectResponse;
import ca.infodata.ofys.client.modules.dsq.internal.ListDischargeCareSummaryControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.ListImagingExamControllerWeb;
import ca.infodata.ofys.client.modules.dsq.internal.ListImagingExamWebControllerPrint;
import ca.infodata.ofys.client.modules.person.IPersonPluginController;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.controller.AppointmentController;
import ca.infodata.ofys.client.web.controller.DocumentsController;
import ca.infodata.ofys.client.web.controller.PatientController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.IWebResource;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.routes.POSTPredicate;
import ca.infodata.ofys.client.web.core.routes.PathPredicate;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.client.web.core.routes.WSPredicate;
import ca.infodata.ofys.data.middle.dataobjects.CDsqDmeObjectList;
import ca.infodata.ofys.data.middle.dataobjects.LightweightReport;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.dsq.imaging.XImagingResultExamWrapper;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterModificationRequest;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.notification.ProgressStatusNotification;
import ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintMode;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.dashboard.accessor.AppointmentSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.accessor.DSQSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CDSQResult;
import ca.infodata.ofys.ui.dashboard.models.CDsqRequest;
import ca.infodata.ofys.ui.dashboard.models.CFindCandidateCriteria;
import ca.infodata.ofys.ui.dashboard.models.CPatientDischargeCareSummary;
import ca.infodata.ofys.ui.dashboard.models.CProfessional;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.Pair;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DSQController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(DSQController.class.getName());
    private final DSQSyncAccessorClient dsqAccessorClient;
    private final AppointmentSyncAccessorClient appointmentAccessor;
    private final IPatientDsqControllerCache cache;
    private final Supplier<DocumentsController> documentsController;
    private final PatientController patientController;
    private final IDSQPluginController dsq;
    private final IPersonPluginController personPluginController;

    public DSQController(PatientController patientController, Supplier<DocumentsController> documentsController) {
        this.patientController = patientController;
        this.documentsController = documentsController;
        this.dsqAccessorClient = new DSQSyncAccessorClient();
        this.appointmentAccessor = new AppointmentSyncAccessorClient();
        this.cache = Application.get().getCache().getPatientDsqControllerCache();
        this.personPluginController = Application.get().getPersonPluginController();
        this.dsq = Application.get().getDsqPluginController();
        this.getNotificationSystemConsumer().setHandleOtherMethod(this::handleNotification);
    }

    private void handleNotification(Notification notification) throws Exception {
        if (notification instanceof ProgressStatusNotification) {
            ProgressStatusNotification jMsg = (ProgressStatusNotification)notification;
            String clientUid = jMsg.getClientUid();
            ServerResponses.sendJsonToClient(stream -> stream.filter(c -> clientUid.equals(c.getId())), jMsg.getChannelName(), jMsg);
        }
    }

    private PatientDsqControllers getPatientCtrls(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        XPatient patient = this.patientController.getPatient(dsqRequest.patientId);
        return this.getPatientCtrls((IPatient)patient, wsChannel);
    }

    private PatientDsqControllers getPatientCtrls(IPatient patient, IWebSocketChannel channel) throws Exception {
        PatientDsqControllersKey key = new PatientDsqControllersKey(channel, patient.getId(), Application.get().getGlobalInstances().getSession());
        return this.cache.get(key, () -> new PatientDsqControllers(key, this.documentsController.get()));
    }

    private void getHtml(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        String html = this.getHtml(this.getPatientCtrls(dsqRequest, wsChannel));
        JSonObjectResponse jres = new JSonObjectResponse(null, null, html);
        CDsqResponse res = new CDsqResponse("getHtml", jres);
        ServerResponses.sendJsonToClient(wsChannel, "dsq.response.update", res);
    }

    private String getHtml(PatientDsqControllers ctrls) throws Exception {
        String html = DSQController.getHtmlFileTemplate("dashboard/resources/ofys/dsq/dsq.html");
        String css = DSQController.getHtmlFileTemplate("dashboard/resources/ofys/dsq/dsq.css");
        String js = DSQController.getHtmlFileTemplate("dashboard/resources/ofys/dsq/dsq.js");
        html = DSQController.replaceString(html, "__CSS__", css);
        html = DSQController.replaceString(html, "__JS__", js);
        html = DSQController.replaceString(html, "__OE_START__", ctrls.getOePrescriptionController().getStart() == null ? "" : ctrls.getOePrescriptionController().getStart().formatSlash());
        html = DSQController.replaceString(html, "__OE_END__", ctrls.getOePrescriptionController().getEnd() == null ? "" : ctrls.getOePrescriptionController().getEnd().formatSlash());
        html = DSQController.replaceString(html, "__OE_CHK__", ctrls.getOePrescriptionController().isOnlyActive() ? "CHECKED" : "");
        html = DSQController.replaceString(html, "__MED_START__", ctrls.getDmMedicationController().getAdministrationEffectiveStart() == null ? "" : ctrls.getDmMedicationController().getAdministrationEffectiveStart().formatSlash());
        html = DSQController.replaceString(html, "__MED_END__", ctrls.getDmMedicationController().getAdministrationEffectiveEnd() == null ? "" : ctrls.getDmMedicationController().getAdministrationEffectiveEnd().formatSlash());
        html = DSQController.replaceString(html, "__MED_MODIF_START__", ctrls.getDmMedicationController().getAmendedInTimeStart() == null ? "" : ctrls.getDmMedicationController().getAmendedInTimeStart().formatSlash());
        html = DSQController.replaceString(html, "__MED_MODIF_END__", ctrls.getDmMedicationController().getAmendedInTimeEnd() == null ? "" : ctrls.getDmMedicationController().getAmendedInTimeEnd().formatSlash());
        html = DSQController.replaceString(html, "__MED_CHK__", ctrls.getDmMedicationController().isOnlyThoseWithIssue() ? "CHECKED" : "");
        html = DSQController.replaceString(html, "__D_START__", ctrls.getDispenseController().getStart() == null ? "" : ctrls.getDispenseController().getStart().formatSlash());
        html = DSQController.replaceString(html, "__D_END__", ctrls.getDispenseController().getEnd() == null ? "" : ctrls.getDispenseController().getEnd().formatSlash());
        html = DSQController.replaceString(html, "__D_ACTIVE__", ctrls.getDispenseController().getActiveProfile() ? "CHECKED" : "");
        html = DSQController.replaceString(html, "__D_CUSTOM__", !ctrls.getDispenseController().getActiveProfile() ? "CHECKED" : "");
        html = DSQController.replaceString(html, "__D_MOSTRECENT__", ctrls.getDispenseController().isMostRecent() ? "CHECKED" : "");
        IPatient patient = ctrls.getPatient();
        String patInfo = "<b>" + patient.getNameBirthdateSex() + "</b>";
        if (patient.getHealthInsuranceNumber() != null) {
            patInfo = patInfo + " (" + patient.getHealthInsuranceNumber() + ")";
        }
        html = DSQController.replaceString(html, "__PATIENT_INFO__", patInfo);
        return html;
    }

    private static String getHtmlFileTemplate(String fileName) throws Exception {
        return Application.get().getResourceDelegate().readAsString(fileName, StandardCharsets.UTF_8);
    }

    private static String replaceString(String base, String pathern, String newString) {
        int index = base.indexOf(pathern);
        if (index != -1) {
            String s = base.substring(0, index);
            s = s + newString;
            s = s + base.substring(index + pathern.length());
            return s;
        }
        return base;
    }

    private void dsqRequest(CDsqRequest r, IWebSocketChannel wsChannel) throws Exception {
        PatientDsqControllers dsqCtrl = this.getPatientCtrls(r, wsChannel);
        if (r.method.equals("getConsent")) {
            dsqCtrl.getConsentController().getConsent();
        } else if (r.method.equals("listPrescriptionsOE")) {
            dsqCtrl.getOePrescriptionController().listSummary();
        } else if (r.method.equals("listPrescriptionsDM")) {
            dsqCtrl.getDmPrescriptionController().listSummary();
        } else if (r.method.equals("listMedicationsDM")) {
            dsqCtrl.getDmMedicationController().listSummary();
        } else if (r.method.equals("listDispenses")) {
            dsqCtrl.getDispenseController().listSummary();
        } else if (r.method.equals("GDDispenses")) {
            dsqCtrl.getDispenseController().getDetail(r.dispenseId);
        } else if (r.method.equals("GDDrugDispenses")) {
            dsqCtrl.getDispenseController().listSummaryForPrescription(new NIU_PRESCRIPTION_DM(r.value, r.version), r.context);
        } else if (r.method.equals("listMedication_GDMedication")) {
            dsqCtrl.getDmMedicationController().getMedicationDetail(new NIU_OTHER_MEDICATION_DM(r.value, r.version));
        } else if (r.method.equals("listMedication_GDPrescription")) {
            dsqCtrl.getDmMedicationController().getPrescriptionDetail(new NIU_PRESCRIPTION_DM(r.value, r.version), r.context);
        } else if (r.method.equals("GDDrug")) {
            dsqCtrl.getDmPrescriptionController().getDetail(new NIU_PRESCRIPTION(r.value, r.version), r.context);
        } else if (r.method.equals("GDDrugOE")) {
            dsqCtrl.getOePrescriptionController().getDrugDetail(new NIU_PRESCRIPTION(r.value, r.version));
        } else if (r.method.equals("updateParameter")) {
            dsqCtrl.update(r);
        } else if (r.method.equals("getDDevice")) {
            dsqCtrl.getOePrescriptionController().getDeviceDetail(new NIU_PRESCRIPTION(r.value, r.version));
        } else if (r.method.equals("retractDrug")) {
            dsqCtrl.getOeRetractController().retract(new NIU_PRESCRIPTION(r.value, r.version));
        }
    }

    private void getDischargeCareDetail(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        PatientDsqControllers controllers = this.getPatientCtrls(dsqRequest, wsChannel);
        GetDischargeCareDetailControllerWeb controller = controllers.getGetDischargeCareDetailControllerWeb();
        controller.get(dsqRequest);
    }

    private void searchDischargeCareSummary(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        PatientDsqControllers controllers = this.getPatientCtrls(dsqRequest, wsChannel);
        ListDischargeCareSummaryControllerWeb controller = controllers.getListDischargeCareSummaryController();
        controller.list(dsqRequest);
    }

    public void searchLab(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        PatientDsqControllers controllers = this.getPatientCtrls(dsqRequest, wsChannel);
        GetLaboListControllerWeb controller = controllers.getGetLaboListController();
        controller.list(dsqRequest);
    }

    public void sendDsqListLabo(IWebSocketChannel wsChannel, CDsqDmeObjectList ol) throws Exception {
        XPatient patient = this.patientController.getPatient(ol.idPatient);
        PatientDsqControllers controllers = this.getPatientCtrls((IPatient)patient, wsChannel);
        controllers.getGetLaboListController().sendDsqListLabo(wsChannel, ol);
    }

    public void getLab(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        PatientDsqControllers controllers = this.getPatientCtrls(dsqRequest, wsChannel);
        GetLaboReportControllerWeb controller = controllers.getGetLaboReportController();
        controller.get(dsqRequest);
    }

    public void resolveCandidateNiu(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        String channelName = "dsq.candidate.search";
        try {
            boolean forceResolutionDialog = false;
            boolean forceResolution = true;
            PatientDsqControllers controllers = this.getPatientCtrls(dsqRequest, wsChannel);
            String niu = controllers.getFindCandidateController().getNiu(forceResolution, forceResolutionDialog, null);
            if (StringUtils.isNotEmpty((String)niu)) {
                ReturnObject ro = new ReturnObject(Messages.getString((String)"CANDIDAT_ID_DSQ_SUCCES", (String[])new String[0]));
                ro.setObj((Object)niu);
                ServerResponses.sendJsonToClient(wsChannel, "dsq.candidate.search", ro);
            }
        }
        catch (StatusException e) {
            MultiStatus status = new MultiStatus();
            status.setMessage(e.getStatus().getMessage());
            status.setSeverity(e.getStatus().getSeverity());
            ReturnObject ro = new ReturnObject(status);
            ServerResponses.sendJsonToClient(wsChannel, "dsq.candidate.search", ro);
        }
        catch (AbortException | CancelException | InterruptedException e) {
            MultiStatus status = new MultiStatus();
            status.setMessage(e.getMessage());
            status.setSeverity(IStatus.Severity.ERROR);
            ReturnObject ro = new ReturnObject(status);
            ServerResponses.sendJsonToClient(wsChannel, "dsq.candidate.search", ro);
        }
    }

    public ReturnObject findCandidate(IServerRequest req) throws Exception {
        CFindCandidateCriteria criteria = this.getPayload(req, CFindCandidateCriteria.class);
        try {
            FindCandidateController controller = new FindCandidateController();
            Candidate candidate = controller.findCandidate(criteria);
            return ServerResponses.OKReturnObject(candidate);
        }
        catch (StatusException e) {
            MultiStatus status = new MultiStatus();
            status.setMessage(e.getStatus().getMessage());
            status.setSeverity(e.getStatus().getSeverity());
            ReturnObject ro = new ReturnObject(status);
            return ro;
        }
        catch (AbortException | CancelException | InterruptedException e) {
            MultiStatus status = new MultiStatus();
            status.setMessage(e.getMessage());
            status.setSeverity(IStatus.Severity.ERROR);
            ReturnObject ro = new ReturnObject(status);
            return ro;
        }
    }

    public ActionResult findCandidateWs(IServerRequest req) throws Exception {
        IWebSocketChannel wsChannel = this.getClientUid(req);
        String channelName = "dsq.candidate.find";
        ReturnObject ro = this.findCandidate(req);
        ServerResponses.sendJsonToClient(wsChannel, "dsq.candidate.find", ro);
        return ServerResponses.SUCCESS();
    }

    public void searchAll(final CDsqRequest dsqRequest, final IWebSocketChannel wsChannel) throws Exception {
        Application.get().getDsqPluginController().checkIfDsqFunctionnalitiesAreActive();
        XBaseProfessionnal sessionProfessionnal = this.personPluginController.getSessionProfessionnal();
        if (sessionProfessionnal != null && sessionProfessionnal.isUseAppointment()) {
            String channelName;
            List<XAppointment> appointments = this.appointmentAccessor.findAppointmentsByProfessional(sessionProfessionnal.getId(), LocalDate.today());
            String string = channelName = dsqRequest.whatToDo == 1 ? "dsq.all.search" : "dsq.gestion.signatures";
            if (appointments != null && appointments.size() > 0) {
                LocalDate end;
                final List<XAppointment> apptsOrderByStartTime = AppointmentController.orderByStartTime(appointments);
                LocalDate start = StringUtils.isNotEmpty((String)dsqRequest.start) ? Utils.strToLocalDate(dsqRequest.start) : LocalDate.today().plusYear(-2);
                LocalDate localDate = end = StringUtils.isNotEmpty((String)dsqRequest.end) ? Utils.strToLocalDate(dsqRequest.end) : LocalDate.today();
                if (end == null) {
                    end = LocalDate.today();
                }
                if (start == null) {
                    start = LocalDate.today().plusYear(-2);
                }
                if (end.before((IPartialDate)start)) {
                    ReturnObject ro = new ReturnObject();
                    MultiStatus status = new MultiStatus();
                    status.setMessage("La date de d\u00e9but doit \u00eatre avant la date de fin");
                    ro.setStatus(status);
                    status.setSeverity(IStatus.Severity.ERROR);
                    ServerResponses.sendJsonToClient(wsChannel, channelName, ro);
                    return;
                }
                final LocalDate fStart = start;
                final LocalDate fEnd = end;
                Job job = new Job("Signatures en cours..."){

                    @Override
                    public void runWithException() {
                        ReturnObject r = new ReturnObject();
                        try {
                            HashMap<Pair<Integer, String>, Pair<Pkcs7SignatureI, XmlSignatureI>> mapPatSign = new HashMap<Pair<Integer, String>, Pair<Pkcs7SignatureI, XmlSignatureI>>(apptsOrderByStartTime.size());
                            DSQController.this.searchAll(apptsOrderByStartTime, wsChannel, dsqRequest, channelName, fStart, fEnd, this, r, mapPatSign);
                        }
                        catch (Exception e) {
                            r.setStatus(ServerResponses.ErrorMultiStatus(e.getMessage()));
                        }
                        ServerResponses.sendJsonToClient(wsChannel, channelName, r);
                    }
                };
                if (job.getState() != JobStatus.RUNNING) {
                    job.schedule();
                }
            } else {
                ReturnObject ro = new ReturnObject();
                ro.setStatus(ServerResponses.WarningMultiStatus("Aucun patient dans l'horaire de la journ\u00e9e."));
                ServerResponses.sendJsonToClient(wsChannel, channelName, ro);
            }
        }
    }

    protected void searchAll(List<? extends IAppointment> appointments, IWebSocketChannel wsChannel, CDsqRequest dsqRequest, String channelName, LocalDate fStart, LocalDate fEnd, IProgressMonitor monitor, ReturnObject r, HashMap<Pair<Integer, String>, Pair<Pkcs7SignatureI, XmlSignatureI>> mapPatSign) throws AbortException, CancelException {
        HashMap<Integer, XmlSignatureI> xmlSignatureIForCache = null;
        if (Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
            Alias alias = this.dsq.getAlias(monitor);
            this.dsq.checkIfActionWasCanceled(monitor);
            xmlSignatureIForCache = this.dsq.getXmlSignatureIForCache(monitor, alias);
            for (IAppointment iAppointment : appointments) {
                if (XPatientStatus.CANCEL.equals((Object)iAppointment.getPatientStatus()) || XPatientStatus.CANCEL_LESS_24H.equals((Object)iAppointment.getPatientStatus()) || !Boolean.FALSE.equals(iAppointment.getIsDeleted())) continue;
                List patients = iAppointment.getPatients();
                Iterator iterator = patients.iterator();
                while (iterator.hasNext()) {
                    IPatient iPatient = (IPatient)iterator.next();
                    if (!StringUtils.isNotEmpty((String)iPatient.getNiu())) continue;
                    XmlSignatureI xmlSignature = this.dsq.getXmlSignatureI(monitor, alias, iPatient.getNiu());
                    Pkcs7SignatureI pkcs7Signature = (Pkcs7SignatureI)this.dsq.getPkcs7SignatureI(monitor, alias, iPatient.getNiu());
                    Pair pair = new Pair((Object)pkcs7Signature, (Object)xmlSignature);
                    Pair key = new Pair((Object)iPatient.getId(), (Object)iPatient.getNiu());
                    mapPatSign.put((Pair<Integer, String>)key, (Pair<Pkcs7SignatureI, XmlSignatureI>)pair);
                }
            }
        } else {
            for (IAppointment iAppointment : appointments) {
                if (XPatientStatus.CANCEL.equals((Object)iAppointment.getPatientStatus()) || XPatientStatus.CANCEL_LESS_24H.equals((Object)iAppointment.getPatientStatus()) || !Boolean.FALSE.equals(iAppointment.getIsDeleted())) continue;
                List list = iAppointment.getPatients();
                for (IPatient iPatient : list) {
                    if (!StringUtils.isNotEmpty((String)iPatient.getNiu())) continue;
                    Object xmlSignature = null;
                    Object pkcs7Signature = null;
                    Pair pair = new Pair(pkcs7Signature, xmlSignature);
                    Pair key = new Pair((Object)iPatient.getId(), (Object)iPatient.getNiu());
                    mapPatSign.put((Pair<Integer, String>)key, (Pair<Pkcs7SignatureI, XmlSignatureI>)pair);
                }
            }
        }
        if (mapPatSign.isEmpty()) {
            ReturnObject ro = new ReturnObject("Aucun patient n'est identifi\u00e9 au DSQ dans l'horaire de la journ\u00e9e.");
            ServerResponses.sendJsonToClient(wsChannel, channelName, ro);
        }
        try {
            int limit2 = 50;
            ReturnObject returnObject = this.dsqAccessorClient.dsqSignatureAndDataByPatient(xmlSignatureIForCache, mapPatSign, fStart, fEnd, limit2, dsqRequest.whatToDo, wsChannel, channelName);
            if (returnObject == null) {
                throw new AbortException("Erreur lors de l'appel pour obtenir toutes les donn\u00e9es des patients");
            }
            MultiStatus multiStatus = new MultiStatus();
            IStatus.Severity severity = IStatus.Severity.OK;
            JoinList messages = new JoinList("\n\n");
            List nonOkStatuses = returnObject.getStatus().getFlattenedNonOKChildren();
            for (IStatus status : nonOkStatuses) {
                if (severity.ordinal() < status.getSeverity().ordinal()) {
                    severity = status.getSeverity();
                }
                messages.add("- ", status.getMessage());
            }
            multiStatus.setSeverity(severity);
            multiStatus.setMessage(messages.toString());
            r.setStatus(multiStatus);
        }
        catch (Exception e) {
            throw new AbortException("Erreur: Exception\n" + e.getMessage());
        }
    }

    public void removeSignatures(final CDsqRequest dsqRequest, final IWebSocketChannel wsChannel) throws Exception {
        Application.get().getDsqPluginController().checkIfDsqFunctionnalitiesAreActive();
        String channel = "dsq.gestion.signatures";
        final LocalDate fStart = LocalDate.today().plusYear(-1);
        final LocalDate fEnd = LocalDate.today();
        Job job = new Job("Retrait des signatures..."){

            @Override
            public void runWithException() {
                ReturnObject r = new ReturnObject();
                try {
                    try {
                        ReturnObject ro = DSQController.this.dsqAccessorClient.dsqSignatureAndDataByPatient(null, null, fStart, fEnd, null, dsqRequest.whatToDo, wsChannel, null);
                        if (ro == null) {
                            throw new AbortException("Erreur lors de l'appel pour retirer les signatures de la cache serveur.");
                        }
                        DSQController.this.dsq.manageDsqStatus(r.getStatus());
                        r.setStatus(ro.getStatus());
                        r.setObj(ro.getObj());
                    }
                    catch (InterruptedException e) {
                        throw new AbortException("Erreur: InterruptedException\n" + e.getMessage());
                    }
                    catch (StatusException e) {
                        r.setStatus(ServerResponses.MultiStatus(e.getStatus()));
                    }
                    catch (Exception e) {
                        throw new AbortException("Erreur: Exception\n" + e.getMessage());
                    }
                }
                catch (Exception e) {
                    r.setStatus(ServerResponses.ErrorMultiStatus(e.getMessage()));
                }
                ServerResponses.sendJsonToClient(wsChannel, "dsq.gestion.signatures", r);
            }
        };
        if (job.getState() != JobStatus.RUNNING) {
            job.schedule();
        }
    }

    public void sendDsqListDischargeCareSummary(IWebSocketChannel wsChannel, CDsqDmeObjectList ol) {
        if (ol != null && ol.result != null) {
            List list = ol.result.dischargeCareSummaries;
            ReturnObject ro = new ReturnObject();
            MultiStatus ms = new MultiStatus();
            for (String warning : ol.result.dischargeCareSummariesWarnings) {
                ms.add((IStatus)new Status(IStatus.Severity.WARNING, warning));
            }
            Collections.sort(list, new Comparator<PatientDischargeCareSummary>(){

                @Override
                public int compare(PatientDischargeCareSummary o1, PatientDischargeCareSummary o2) {
                    return -o1.effectiveTimeEnd.compareTo((IPartialDate)o2.effectiveTimeEnd);
                }
            });
            String timeOfRequest = null;
            if (ol.timeOfDsqRequest > 0L) {
                timeOfRequest = Utils.longTodateStr(ol.timeOfDsqRequest, "yyyy-MM-dd HH:mm:ss");
            }
            ArrayList<CPatientDischargeCareSummary> clist = new ArrayList<CPatientDischargeCareSummary>(list.size());
            for (PatientDischargeCareSummary d : list) {
                clist.add(new CPatientDischargeCareSummary(d, timeOfRequest));
            }
            CDSQResult<CPatientDischargeCareSummary> r = new CDSQResult<CPatientDischargeCareSummary>();
            r.setCriteria(ol);
            r.setList(clist);
            ro.setObj(r);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
            ServerResponses.sendJsonToClient(wsChannel, "dsq.sommhosp.search", ro);
        }
    }

    public void searchPtAll(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        Integer idPatient;
        LocalDate fEnd;
        LocalDate fStart;
        LocalDate end;
        Application.get().getDsqPluginController().checkIfDsqFunctionnalitiesAreActive();
        String channelName = "dsq.pt.all.search";
        LocalDate start = StringUtils.isNotEmpty((String)dsqRequest.start) ? Utils.strToLocalDate(dsqRequest.start) : LocalDate.today().plusYear(-2);
        LocalDate localDate = end = StringUtils.isNotEmpty((String)dsqRequest.end) ? Utils.strToLocalDate(dsqRequest.end) : LocalDate.today();
        if (end == null) {
            end = LocalDate.today();
        }
        if (start == null) {
            start = LocalDate.today().plusYear(-2);
        }
        if (end.before((IPartialDate)start)) {
            ReturnObject ro = new ReturnObject();
            MultiStatus status = new MultiStatus();
            status.setMessage("La date de d\u00e9but doit \u00eatre avant la date de fin");
            ro.setStatus(status);
            status.setSeverity(IStatus.Severity.ERROR);
            ServerResponses.sendJsonToClient(wsChannel, "dsq.pt.all.search", ro);
            return;
        }
        XPatient patient = this.patientController.getPatient(dsqRequest.patientId);
        Job job = new Job("Signatures en cours...", (IPatient)patient, fStart = start, fEnd = end, dsqRequest, wsChannel, idPatient = patient.getId()){
            final /* synthetic */ IPatient val$patient;
            final /* synthetic */ LocalDate val$fStart;
            final /* synthetic */ LocalDate val$fEnd;
            final /* synthetic */ CDsqRequest val$dsqRequest;
            final /* synthetic */ IWebSocketChannel val$wsChannel;
            final /* synthetic */ Integer val$idPatient;
            {
                this.val$patient = iPatient;
                this.val$fStart = localDate;
                this.val$fEnd = localDate2;
                this.val$dsqRequest = cDsqRequest;
                this.val$wsChannel = iWebSocketChannel;
                this.val$idPatient = n;
                super(name);
            }

            @Override
            public void runWithException() {
                ReturnObject r;
                block17: {
                    4 monitor = this;
                    r = new ReturnObject();
                    try {
                        CDsqDmeObjectList ol;
                        HashMap<Integer, XmlSignatureI> xmlSignatureIForCache = null;
                        HashMap<Pair<Integer, String>, Pair<Pkcs7SignatureI, XmlSignatureI>> mapPatSign = new HashMap<Pair<Integer, String>, Pair<Pkcs7SignatureI, XmlSignatureI>>(1);
                        if (Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                            Alias alias = DSQController.this.dsq.getAlias(monitor);
                            DSQController.this.dsq.checkIfActionWasCanceled(monitor);
                            XmlSignatureI xmlSignature = null;
                            Pkcs7SignatureI pkcs7Signature = null;
                            xmlSignatureIForCache = DSQController.this.dsq.getXmlSignatureIForCache(monitor, alias);
                            if (StringUtils.isNotEmpty((String)this.val$patient.getNiu())) {
                                xmlSignature = DSQController.this.dsq.getXmlSignatureI(monitor, alias, this.val$patient.getNiu());
                                pkcs7Signature = (Pkcs7SignatureI)DSQController.this.dsq.getPkcs7SignatureI(monitor, alias, this.val$patient.getNiu());
                                Pair pair = new Pair((Object)pkcs7Signature, (Object)xmlSignature);
                                Pair key = new Pair((Object)this.val$patient.getId(), (Object)this.val$patient.getNiu());
                                mapPatSign.put((Pair<Integer, String>)key, (Pair<Pkcs7SignatureI, XmlSignatureI>)pair);
                            }
                        } else if (StringUtils.isNotEmpty((String)this.val$patient.getNiu())) {
                            Pair pair = new Pair(null, null);
                            Pair key = new Pair((Object)this.val$patient.getId(), (Object)this.val$patient.getNiu());
                            mapPatSign.put(key, pair);
                        }
                        ReturnObject ro = null;
                        int limit2 = 50;
                        ro = DSQController.this.dsqAccessorClient.dsqSignatureAndDataByPatient(xmlSignatureIForCache, mapPatSign, this.val$fStart, this.val$fEnd, limit2, this.val$dsqRequest.whatToDo, this.val$wsChannel, "dsq.pt.all.search");
                        if (ro == null) {
                            throw new AbortException("Erreur lors de l'appel pour obtenir toutes les donn\u00e9es des patients");
                        }
                        DSQController.this.dsq.manageDsqStatus(r.getStatus());
                        r.setStatus(ro.getStatus());
                        if (!ro.getStatus().isOkToProceed() || ro.getObj() == null || !(ro.getObj() instanceof HashMap)) break block17;
                        PatientDsqControllers controllers = DSQController.this.getPatientCtrls(this.val$patient, this.val$wsChannel);
                        HashMap map = (HashMap)ro.getObj();
                        try {
                            ol = (CDsqDmeObjectList)map.get(CDsqDmeObjectList.METHODS.listImagingExam.name());
                            controllers.getListImagingExamController().sendDsqListImagingExam(ol);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to sendDsqListImagingExam to wsChannel " + this.val$wsChannel, e);
                        }
                        try {
                            ol = (CDsqDmeObjectList)map.get(CDsqDmeObjectList.METHODS.getLaboList.name());
                            controllers.getGetLaboListController().sendDsqListLabo(this.val$wsChannel, ol);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to sendDsqListLabo to wsChannel " + this.val$wsChannel, e);
                        }
                        try {
                            ol = (CDsqDmeObjectList)map.get(CDsqDmeObjectList.METHODS.listPatientDischargeCareSummary.name());
                            DSQController.this.sendDsqListDischargeCareSummary(this.val$wsChannel, ol);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to sendDsqListDischargeCareSummary to wsChannel " + this.val$wsChannel, e);
                        }
                    }
                    catch (CancelException e) {
                        r.setStatus(ServerResponses.ErrorMultiStatus("L'utilisateur a annul\u00e9"));
                    }
                    catch (InterruptedException e) {
                        r.setStatus(ServerResponses.ErrorMultiStatus("Erreur: InterruptedException\n" + e.getMessage()));
                    }
                    catch (AbortException e) {
                        r.setStatus(ServerResponses.ErrorMultiStatus(e.getMessage()));
                    }
                    catch (StatusException e) {
                        r.setStatus(ServerResponses.MultiStatus(e.getStatus()));
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, String.format("Failed to call dsqSignatureAndDataByPatient idPatient=%s, start=%s, end=%s", StringUtils.safeToString((Logger)logger, (Object)this.val$idPatient), this.val$fStart, this.val$fEnd), e);
                        r.setStatus(ServerResponses.ErrorMultiStatus("Erreur: Exception\n" + e.getMessage()));
                    }
                }
                ServerResponses.sendJsonToClient(this.val$wsChannel, "dsq.pt.all.search", r);
            }
        };
        if (job.getState() != JobStatus.RUNNING) {
            job.schedule();
        }
    }

    public void searchProv(final CProfessional prof, final IWebSocketChannel wsChannel) throws Exception {
        Application.get().getDsqPluginController().checkIfDsqFunctionnalitiesAreActive();
        String channelName = "dsq.prof.search";
        final XProfessionnal professionnal = prof.x();
        Job job = new Job("Signatures en cours..."){

            @Override
            public void runWithException() {
                5 monitor = this;
                ReturnObject r = new ReturnObject();
                try {
                    Calendar c = DateUtil.newCalendar();
                    HashMap<Integer, XmlSignatureI> xmlSignatureIForCache = null;
                    HashMap mapPatSign = new HashMap(1);
                    XmlSignature signature = null;
                    if (Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                        Alias alias = DSQController.this.dsq.getAlias(monitor);
                        DSQController.this.dsq.checkIfActionWasCanceled(monitor);
                        Object xmlSignature = null;
                        Object pkcs7Signature = null;
                        xmlSignatureIForCache = DSQController.this.dsq.getXmlSignatureIForCache(monitor, alias);
                        Integer hour = new Integer(c.get(11));
                        signature = (XmlSignature)xmlSignatureIForCache.get(hour);
                    }
                    ReturnObject ro = null;
                    FindProviderCriteria criteria = new FindProviderCriteria("qc");
                    if (StringUtils.isNotBlank((String)professionnal.getFirstName())) {
                        criteria.setFirstName(professionnal.getFirstName());
                    }
                    if (StringUtils.isNotBlank((String)professionnal.getLastName())) {
                        criteria.setLastName(professionnal.getLastName());
                    }
                    if (StringUtils.isNotBlank((String)professionnal.getGender())) {
                        criteria.setGender(GetCandidateController.getDsqGender(professionnal.getGender()));
                    }
                    if (professionnal.getBirthDate() != null) {
                        criteria.setBirthdateUTC(Long.valueOf(professionnal.getBirthDate().toTimeInMillisUTC()));
                    }
                    if (StringUtils.isNotBlank((String)professionnal.getCode())) {
                        String oid = DSQController.getCollegeFromProfessionnalType(professionnal);
                        String code = professionnal.getCode();
                        if (College.College_de_medecins_du_Quebec.codeOID.equals(oid)) {
                            criteria = new FindProviderCriteria("qc");
                            criteria.setNiuCollege(new NIU_COLLEGE(oid, code));
                        } else {
                            criteria = new FindProviderCriteria("qc");
                            criteria.setNiuCollege(new NIU_COLLEGE(oid, code));
                        }
                    }
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    ro = DSQController.this.dsqAccessorClient.findProvider((Signature)signature, prof.id, criteria);
                    if (ro == null) {
                        throw new AbortException("Erreur lors de l'appel pour identifier le prof. au DSQ");
                    }
                    DSQController.this.dsq.manageDsqStatus(r.getStatus());
                    r.setStatus(ro.getStatus());
                    if (ro.getStatus().isOkToProceed()) {
                        IProvider provider = (IProvider)ro.getObj();
                        if (provider != null) {
                            CProfessional prof2 = new CProfessional();
                            prof2.firstName = provider.getFirstName();
                            prof2.lastName = provider.getLastName();
                            NIU niu_COLLEGE = provider.getNIU_COLLEGE();
                            if (niu_COLLEGE != null) {
                                prof2.code = niu_COLLEGE.value();
                            }
                            r.setObj((Object)prof2);
                        }
                    } else if (ro.getStatus().getStatus("DSQ_SERVICE_UNAVAILABLE") != null) {
                        r.setStatus(ServerResponses.ErrorMultiStatus("DSQ_SERVICE_UNAVAILABLE"));
                    }
                }
                catch (CancelException e) {
                    r.setStatus(ServerResponses.ErrorMultiStatus("L'utilisateur a annul\u00e9"));
                }
                catch (InterruptedException e) {
                    r.setStatus(ServerResponses.ErrorMultiStatus("Erreur: InterruptedException\n" + e.getMessage()));
                }
                catch (AbortException e) {
                    r.setStatus(ServerResponses.ErrorMultiStatus(e.getMessage()));
                }
                catch (StatusException e) {
                    r.setStatus(ServerResponses.MultiStatus(e.getStatus()));
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, String.format("Failed to call dsqSignatureAndDataByPatient idPatient=%s", StringUtils.safeToString((Logger)logger, (Object)prof.id)), e);
                    r.setStatus(ServerResponses.ErrorMultiStatus("Erreur: Exception\n" + e.getMessage()));
                }
                ServerResponses.sendJsonToClient(wsChannel, "dsq.prof.search", r);
            }
        };
        if (job.getState() != JobStatus.RUNNING) {
            job.schedule();
        }
    }

    private Boolean sendSqimServerCacheIfHasResults(IWebSocketChannel wsChannel, ReturnObject ro) {
        if (ro == null || ro.getObj() == null || ((Map)ro.getObj()).size() == 0) {
            MultiStatus st = new MultiStatus("Cache yielded no results");
            st.setSeverity(IStatus.Severity.ERROR);
            ro.setStatus(st);
            ServerResponses.sendJsonToClient(wsChannel, "dsq.sqim.cache.response", ro);
            return false;
        }
        return true;
    }

    public void getSqimFromServerCache(CDsqRequest r, IWebSocketChannel wsChannel) {
        if (r.patientId != null) {
            try {
                PatientDsqControllers ctrls = this.getPatientCtrls(r, wsChannel);
                ReturnObject ro = this.dsqAccessorClient.getCacheSqimDataByPatient(r.patientId);
                if (this.sendSqimServerCacheIfHasResults(wsChannel, ro).booleanValue()) {
                    Map map = (Map)ro.getObj();
                    ReturnObject roHeader = new ReturnObject();
                    roHeader.setStatus(new MultiStatus());
                    boolean hasDDS = map.containsKey(CDsqDmeObjectList.METHODS.getDrugDispensesSummary.name());
                    boolean hasMSSDM = map.containsKey(CDsqDmeObjectList.METHODS.getMedicationSummaryServiceDM.name());
                    boolean hasPOSSOE = map.containsKey(CDsqDmeObjectList.METHODS.getPrescriptionOrderSummaryServiceOE.name());
                    HashMap<String, String> dateList = new HashMap<String, String>();
                    if (hasDDS) {
                        dateList.put("dispenses", Utils.longTodateStr(((CDsqDmeObjectList)map.get((Object)CDsqDmeObjectList.METHODS.getDrugDispensesSummary.name())).timeOfDsqRequest, "yyyy-MM-dd HH:mm:ss"));
                    }
                    if (hasMSSDM) {
                        dateList.put("listMedicationsDM", Utils.longTodateStr(((CDsqDmeObjectList)map.get((Object)CDsqDmeObjectList.METHODS.getMedicationSummaryServiceDM.name())).timeOfDsqRequest, "yyyy-MM-dd HH:mm:ss"));
                    }
                    if (hasPOSSOE) {
                        dateList.put("listPrescriptionsOE", Utils.longTodateStr(((CDsqDmeObjectList)map.get((Object)CDsqDmeObjectList.METHODS.getPrescriptionOrderSummaryServiceOE.name())).timeOfDsqRequest, "yyyy-MM-dd HH:mm:ss"));
                    }
                    roHeader.setObj(dateList);
                    ServerResponses.sendJsonToClient(wsChannel, "dsq.sqim.cache.response", roHeader);
                    if (hasDDS) {
                        ctrls.getDispenseController().listSummaryCallback(((CDsqDmeObjectList)map.get((Object)CDsqDmeObjectList.METHODS.getDrugDispensesSummary.name())).result);
                    } else {
                        ctrls.getDispenseController().listSummary();
                    }
                    if (hasMSSDM) {
                        ctrls.getDmMedicationController().listSummaryCallback(((CDsqDmeObjectList)map.get((Object)CDsqDmeObjectList.METHODS.getMedicationSummaryServiceDM.name())).result);
                    } else {
                        ctrls.getDmMedicationController().listSummary();
                    }
                    if (hasPOSSOE) {
                        ctrls.getOePrescriptionController().listSummaryCallback(((CDsqDmeObjectList)map.get((Object)CDsqDmeObjectList.METHODS.getPrescriptionOrderSummaryServiceOE.name())).result);
                    } else {
                        ctrls.getOePrescriptionController().listSummary();
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error", e);
            }
        }
    }

    public void searchImaging(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        PatientDsqControllers controllers = this.getPatientCtrls(dsqRequest, wsChannel);
        ListImagingExamControllerWeb listImagingExamController = controllers.getListImagingExamController();
        listImagingExamController.list(dsqRequest);
    }

    public void sendDsqListImagingExam(IWebSocketChannel wsChannel, CDsqDmeObjectList c) throws Exception {
        XPatient patient = this.patientController.getPatient(c.idPatient);
        PatientDsqControllers controllers = this.getPatientCtrls((IPatient)patient, wsChannel);
        controllers.getListImagingExamController().sendDsqListImagingExam(c);
    }

    public ActionResult printImagingList(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        ListImagingExamWebControllerPrint controller = new ListImagingExamWebControllerPrint(dsqRequest);
        byte[] pdf = controller.print();
        IWebResource resource = WebApplication.get().getWebResourcesDelegate().newHtmlPdfResource(pdf);
        return ServerResponses.toJsonActionResult(resource.getUrl());
    }

    public ReturnObject printDoc(CDsqRequest dsqRequest) {
        XImagingResultExamWrapper wrapper = new XImagingResultExamWrapper();
        wrapper.idPatient = dsqRequest.patientId;
        wrapper.imagingResultExam = dsqRequest.dsqImagingResultExam.res;
        wrapper.reportIndex = dsqRequest.index;
        wrapper.viewMode = false;
        IPrintController printController = Application.get().getPrintControllerFactory().newPrintController((Serializable)wrapper);
        printController.getSelection().add((IReport)new LightweightReport("imaging_result_exam", "Rapport d'imagerie m\u00e9dicale", PrintMode.ACTUAL_SIZE));
        return ServerResponses.print(printController);
    }

    public void getDoc(CDsqRequest dsqRequest, IWebSocketChannel wsChannel) throws Exception {
        PatientDsqControllers controllers = this.getPatientCtrls(dsqRequest, wsChannel);
        GetImagingResultExamReportControllerWeb controller = controllers.getGetImagingResultExamReportControllerWeb();
        controller.get(dsqRequest);
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard/dsq/ws", RouterFunctions.routeAction("/html", req -> {
            this.getHtml(this.getCDsqRequest(req), this.getClientUid(req));
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/request", req -> {
            this.dsqRequest(this.getCDsqRequest(req), this.getClientUid(req));
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/candidate/resolveNiu", req -> {
            this.resolveCandidateNiu(this.getCDsqRequest(req), this.getClientUid(req));
            return ServerResponses.SUCCESS();
        }), RouterFunctions.route(new POSTPredicate("/candidate/find", PathPredicate.PathStrategy.EXACT), this::findCandidate, ReturnObject.class), RouterFunctions.route(new WSPredicate("/candidate/find", PathPredicate.PathStrategy.EXACT), this::findCandidateWs, ActionResult.class), RouterFunctions.routeAction("/pt/search", req -> {
            IWebSocketChannel wsChannel = req.getWebSocketRequest().getChannel();
            String channelName = "dsq.pt.all.search";
            try {
                this.searchPtAll(this.getCDsqRequest(req), this.getClientUid(req));
            }
            catch (StatusException e) {
                ReturnObject ret = new ReturnObject();
                ret.getStatus().add(e.getStatus());
                ServerResponses.sendJsonToClient(wsChannel, "dsq.pt.all.search", ret);
            }
            catch (Exception e) {
                ReturnObject ret = new ReturnObject();
                if (StringUtils.isNotBlank((String)e.getMessage())) {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getMessage()));
                } else {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getClass().getName()));
                }
                ServerResponses.sendJsonToClient(wsChannel, "dsq.pt.all.search", ret);
            }
            return null;
        }), RouterFunctions.routeAction("/prof/search", req -> {
            IWebSocketChannel wsChannel = req.getWebSocketRequest().getChannel();
            String channelName = "dsq.prof.search";
            try {
                CProfessional prof = this.getProfRequest(req);
                this.searchProv(prof, this.getClientUid(req));
            }
            catch (StatusException e) {
                ReturnObject ret = new ReturnObject();
                ret.getStatus().add(e.getStatus());
                ServerResponses.sendJsonToClient(wsChannel, "dsq.prof.search", ret);
            }
            catch (Exception e) {
                ReturnObject ret = new ReturnObject();
                if (StringUtils.isNotBlank((String)e.getMessage())) {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getMessage()));
                } else {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getClass().getName()));
                }
                ServerResponses.sendJsonToClient(wsChannel, "dsq.prof.search", ret);
            }
            return null;
        }), RouterFunctions.routeAction("/all/search", req -> {
            IWebSocketChannel wsChannel = req.getWebSocketRequest().getChannel();
            String channelName = "dsq.all.search";
            try {
                CDsqRequest dsqRequest = this.getCDsqRequest(req);
                channelName = dsqRequest.whatToDo == 1 ? "dsq.all.search" : "dsq.gestion.signatures";
                this.searchAll(dsqRequest, this.getClientUid(req));
            }
            catch (StatusException e) {
                ReturnObject ret = new ReturnObject();
                ret.getStatus().add(e.getStatus());
                ServerResponses.sendJsonToClient(wsChannel, channelName, ret);
            }
            catch (Exception e) {
                ReturnObject ret = new ReturnObject();
                if (StringUtils.isNotBlank((String)e.getMessage())) {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getMessage()));
                } else {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getClass().getName()));
                }
                ServerResponses.sendJsonToClient(wsChannel, channelName, ret);
            }
            return null;
        }), RouterFunctions.routeAction("/all/removeSignatures", req -> {
            String channelName = "dsq.gestion.signatures";
            IWebSocketChannel wsChannel = req.getWebSocketRequest().getChannel();
            try {
                this.removeSignatures(this.getCDsqRequest(req), this.getClientUid(req));
            }
            catch (StatusException e) {
                ReturnObject ret = new ReturnObject();
                ret.getStatus().add(e.getStatus());
                ServerResponses.sendJsonToClient(wsChannel, "dsq.gestion.signatures", ret);
            }
            catch (Exception e) {
                ReturnObject ret = new ReturnObject();
                if (StringUtils.isNotBlank((String)e.getMessage())) {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getMessage()));
                } else {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getClass().getName()));
                }
                ServerResponses.sendJsonToClient(wsChannel, "dsq.gestion.signatures", ret);
            }
            return null;
        }), RouterFunctions.routeAction("/sqim/search", req -> {
            this.getSqimFromServerCache(this.getCDsqRequest(req), this.getClientUid(req));
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/doc/search", req -> {
            IWebSocketChannel wsChannel = req.getWebSocketRequest().getChannel();
            String channelName = "dsq.doc.search";
            try {
                this.searchImaging(this.getCDsqRequest(req), this.getClientUid(req));
            }
            catch (StatusException e) {
                ReturnObject ret = new ReturnObject();
                ret.getStatus().add(e.getStatus());
                ServerResponses.sendJsonToClient(wsChannel, "dsq.doc.search", ret);
            }
            catch (Exception e) {
                ReturnObject ret = new ReturnObject();
                if (StringUtils.isNotBlank((String)e.getMessage())) {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getMessage()));
                } else {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getClass().getName()));
                }
                ServerResponses.sendJsonToClient(wsChannel, "dsq.doc.search", ret);
            }
            return null;
        }), RouterFunctions.routeAction("/doc/printSearch", req -> {
            this.printImagingList(this.getCDsqRequest(req), this.getClientUid(req));
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/doc/get", req -> {
            this.getDoc(this.getCDsqRequest(req), this.getClientUid(req));
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeReturnObject("/doc/printDoc", req -> this.printDoc(this.getCDsqRequest(req))), RouterFunctions.routeAction("/lab/search", req -> {
            IWebSocketChannel wsChannel = req.getWebSocketRequest().getChannel();
            String channelName = "dsq.lab.search";
            try {
                this.searchLab(this.getCDsqRequest(req), this.getClientUid(req));
            }
            catch (StatusException e) {
                ReturnObject ret = new ReturnObject();
                ret.getStatus().add(e.getStatus());
                ServerResponses.sendJsonToClient(wsChannel, "dsq.lab.search", ret);
            }
            catch (Exception e) {
                ReturnObject ret = new ReturnObject();
                if (StringUtils.isNotBlank((String)e.getMessage())) {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getMessage()));
                } else {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getClass().getName()));
                }
                ServerResponses.sendJsonToClient(wsChannel, "dsq.lab.search", ret);
            }
            return null;
        }), RouterFunctions.routeAction("/lab/get", req -> {
            this.getLab(this.getCDsqRequest(req), this.getClientUid(req));
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/sommhosp/search", req -> {
            IWebSocketChannel wsChannel = req.getWebSocketRequest().getChannel();
            String channelName = "dsq.sommhosp.search";
            try {
                this.searchDischargeCareSummary(this.getCDsqRequest(req), this.getClientUid(req));
            }
            catch (StatusException e) {
                ReturnObject ret = new ReturnObject();
                ret.getStatus().add(e.getStatus());
                ServerResponses.sendJsonToClient(wsChannel, "dsq.sommhosp.search", ret);
            }
            catch (Exception e) {
                ReturnObject ret = new ReturnObject();
                if (StringUtils.isNotBlank((String)e.getMessage())) {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getMessage()));
                } else {
                    ret.getStatus().add((IStatus)new Status(IStatus.Severity.BUG, e.getClass().getName()));
                }
                ServerResponses.sendJsonToClient(wsChannel, "dsq.sommhosp.search", ret);
            }
            return null;
        }), RouterFunctions.routeAction("/sommhosp/get", req -> {
            this.getDischargeCareDetail(this.getCDsqRequest(req), this.getClientUid(req));
            return ServerResponses.SUCCESS();
        }));
    }

    protected CDsqRequest getCDsqRequest(IServerRequest req) throws Exception {
        if ("POST".equals(req.getMethod())) {
            return req.getPostBody(CDsqRequest.class);
        }
        return req.getWebSocketRequest().getJsonData(CDsqRequest.class);
    }

    protected <T> T getPayload(IServerRequest req, Class<T> payloadType) throws Exception {
        if ("POST".equals(req.getMethod())) {
            return req.getPostBody(payloadType);
        }
        return req.getWebSocketRequest().getJsonData(payloadType);
    }

    protected CProfessional getProfRequest(IServerRequest req) throws Exception {
        if ("POST".equals(req.getMethod())) {
            return req.getPostBody(CProfessional.class);
        }
        return req.getWebSocketRequest().getJsonData(CProfessional.class);
    }

    protected IWebSocketChannel getClientUid(IServerRequest req) {
        if ("POST".equals(req.getMethod())) {
            return null;
        }
        return req.getWebSocketRequest().getChannel();
    }

    public void exportPrescriptions(XEncounterModificationRequest req, IWebSocketChannel wsChannel) {
        IPatient pat = null;
        try {
            pat = req.getPatient();
            if (Application.get().getDsqPluginController().isDsqEnabled() && Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                XPatient patient = this.patientController.getPatient(req.getIdPatient());
                PatientDsqControllers controllers = this.getPatientCtrls((IPatient)patient, wsChannel);
                ExportPrescriptionToDsqControllerWeb controller = controllers.getExportPrescriptionToDsqController();
                controller.export(req);
            }
        }
        catch (CancelException patient) {
        }
        catch (Exception e) {
            ServerResponses.sendWarningMessageToClient(wsChannel, e.getMessage());
            logger.log(Level.SEVERE, "Error in savePrescriptionToDsq\nsavedEncountModReq=" + StringUtils.safeToString((Logger)logger, (Object)req) + "\npat=" + StringUtils.safeToString((Logger)logger, (Object)pat), e);
        }
    }

    public void exportPrescriptionsAsync(XEncounterModificationRequest req, IWebSocketChannel wsChannel) {
        IPatient pat = null;
        try {
            pat = req.getPatient();
            if (Application.get().getDsqPluginController().isDsqEnabled() && Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                Job exportJob = new Job("DSQ", monitor -> this.exportPrescriptions(req, wsChannel));
                exportJob.scheduleAfter(2L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in savePrescriptionToDsq\nsavedEncountModReq=" + StringUtils.safeToString((Logger)logger, (Object)req) + "\npat=" + StringUtils.safeToString((Logger)logger, (Object)pat), e);
        }
    }

    private static String getCollegeFromProfessionnalType(XProfessionnal prof) {
        XProfessionnalType type = prof.type;
        if (type == null) {
            throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Un professionnel de type non-d\u00e9fini ne peut acc\u00e9der au dsq"));
        }
        switch (type) {
            case NONDEFINI: {
                throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Un professionnel de type non-d\u00e9fini ne peut acc\u00e9der au dsq"));
            }
            case MD_OMNIPRATICIEN: 
            case MD_SPECIALISTE: 
            case RESIDENT: {
                return College.College_de_medecins_du_Quebec.codeOID;
            }
            case PHARMACIEN: {
                return College.Ordre_des_pharmaciens_du_Quebec.codeOID;
            }
            case DENTISTE: {
                return College.Ordre_des_dentistes_du_Quebec.codeOID;
            }
            case OPTOMETRISTE: {
                return College.Ordre_des_optometristes_du_Quebec.codeOID;
            }
            case SAGE_FEMME: {
                return College.Ordre_des_sages_femmes_du_Quebec.codeOID;
            }
            case INFIRMIERE: 
            case INFIRMIERE_PRATICIENNE: {
                return College.Ordre_des_infirmieres_du_Quebec.codeOID;
            }
            case NUTRITIONIST: {
                return College.Dietetistes.codeOID;
            }
            case TRAVAILLEUR_SOCIAL: {
                return College.Travailleur_social.codeOID;
            }
            case PSYCHOLOGUE: {
                return College.Psychologues.codeOID;
            }
            case PHYSIOTHERAPEUTE: {
                return College.Physiotherapeute.codeOID;
            }
            case ERGOTHERAPEUTE: {
                return College.Ergotherapeute.codeOID;
            }
            case AUTRES: {
                throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Un professionnel de type autre ne peut acc\u00e9der au dsq"));
            }
        }
        throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Un professionnel de type " + type + " ne peut acc\u00e9der au dsq"));
    }
}

