/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.person.INamValidatorService;
import ca.infodata.ofys.client.modules.person.IPersonPluginController;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XBasePerson;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XPersonReplacement;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public abstract class AbstractPersonPluginController
implements IPersonPluginController {
    private static final Logger logger = Logger.getLogger(AbstractPersonPluginController.class.getName());

    @Override
    public String getUserCompleteName(Integer idUser) {
        XBaseUser user = this.getUser(idUser);
        if (user == null) {
            return "infodata";
        }
        return user.getPersonName() + " [" + user.getText() + "]";
    }

    @Override
    public String getUserName(Integer idUser) {
        XBaseUser user = this.getUser(idUser);
        if (user == null) {
            return "infodata";
        }
        return user.str;
    }

    @Override
    public String getUserPersonName(Integer idUser) {
        XBaseUser user = this.getUser(idUser);
        if (user == null) {
            return "infodata";
        }
        return user.getPersonName();
    }

    @Override
    public abstract XBaseUser getUser(Integer var1);

    @Override
    public abstract XBaseUser getUserByIdPerson(Integer var1);

    @Override
    public XBasePerson getBasePersonByIdPerson(Integer id) {
        if (id == null) {
            return null;
        }
        XBaseProfessionnal prof = this.getBaseProfessionnalByIdPerson(id, false, false);
        if (prof != null) {
            return prof;
        }
        XBaseEmployee employee = this.getBaseEmployeeByIdPerson(id, false, false);
        if (employee != null) {
            return employee;
        }
        prof = this.getBaseProfessionnalByIdPerson(id, false, true);
        if (prof != null) {
            return prof;
        }
        employee = this.getBaseEmployeeByIdPerson(id, false, true);
        if (employee != null) {
            return employee;
        }
        logger.log(Level.SEVERE, "Unable to resolve idPerson " + id + " as an employee or as a professionnal. returning null.");
        return null;
    }

    @Override
    public abstract Set<XBaseUser> getUsers();

    @Override
    public XBaseProfessionnal getSessionProfessionnal() {
        Integer idPerson = Application.get().getGlobalInstances().getSessionPerson();
        return this.getBaseProfessionnalByIdPerson(idPerson, false);
    }

    @Override
    public XBaseProfessionnal getSessionSuperviseur() {
        Integer vi;
        Object v = Application.get().getPreferencesPluginController().getUserProp("superviseurId");
        if (v != null && v instanceof Integer && (vi = (Integer)v) != -1) {
            return this.getBaseProfessionnal(vi);
        }
        return null;
    }

    @Override
    public void setSessionSuperviseur(Integer id) {
    }

    @Override
    public void setDirectPrint(boolean b) {
    }

    @Override
    public boolean getDirectPrint() {
        Object v = Application.get().getPreferencesPluginController().getUserProp("user_settings_DirectPrint");
        boolean b = v instanceof Integer ? new Integer(1).equals((Integer)v) : Boolean.TRUE.equals((Boolean)v);
        return b;
    }

    @Override
    public void setPrintRxDevSep(boolean b) {
    }

    @Override
    public boolean getPrintRxDevSep() {
        Object v = Application.get().getPreferencesPluginController().getUserProp("user_settings_PrintRxDevSep");
        boolean b = v instanceof Integer ? new Integer(1).equals((Integer)v) : Boolean.TRUE.equals((Boolean)v);
        return b;
    }

    @Override
    public abstract XBaseProfessionnal getProfessionnalByNoProf(String var1);

    @Override
    public XBaseProfessionnal getBaseProfessionnalByIdPerson(Integer idPerson) {
        if (idPerson == null) {
            return null;
        }
        return this.getBaseProfessionnalByIdPerson(idPerson, true, true);
    }

    @Override
    public XBaseProfessionnal getBaseProfessionnalByIdPerson(Integer idPerson, boolean logIfNotFound) {
        if (idPerson == null) {
            return null;
        }
        return this.getBaseProfessionnalByIdPerson(idPerson, logIfNotFound, true);
    }

    @Override
    public abstract XBaseProfessionnal getBaseProfessionnalByIdPerson(Integer var1, boolean var2, boolean var3);

    @Override
    public abstract Stream<XBaseProfessionnal> getTreatingProfessionnals();

    @Override
    public abstract XBaseProfessionnal getBaseProfessionnal(Integer var1);

    @Override
    public XBaseEmployee getSessionEmployee() {
        Integer idPerson = Application.get().getGlobalInstances().getSessionPerson();
        return this.getBaseEmployeeByIdPerson(idPerson, false);
    }

    @Override
    public XBaseEmployee getBaseEmployeeByIdPerson(Integer idPerson) {
        if (idPerson == null) {
            return null;
        }
        return this.getBaseEmployeeByIdPerson(idPerson, true, true);
    }

    @Override
    public XBaseEmployee getBaseEmployeeByIdPerson(Integer idPerson, boolean mustLogFailed) {
        if (idPerson == null) {
            return null;
        }
        return this.getBaseEmployeeByIdPerson(idPerson, mustLogFailed, true);
    }

    @Override
    public abstract XBaseEmployee getBaseEmployeeByIdPerson(Integer var1, boolean var2, boolean var3);

    @Override
    public abstract INamValidatorService getNamValidatorService();

    @Override
    public abstract Stream<XPersonReplacement> findAllReplacements();

    @Override
    public Stream<XBaseProfessionnal> getWhoProfReplace(Integer id, LocalDate baseDate) {
        if (id < 0) {
            return new ArrayList().stream();
        }
        XBaseProfessionnal prof = this.getBaseProfessionnal(id);
        LocalDateRange range = new LocalDateRange();
        range.notation = RangeNotation.CLOSED;
        return this.findAllReplacements().map(r -> {
            if (!Boolean.TRUE.equals(r.getIsDeletedB()) && r.getIdReplacementPerson().equals(prof.getIdPerson())) {
                range.start = r.getStartDate();
                range.end = r.getEndDate();
                if (range.contains((Comparable)baseDate)) {
                    return this.getBaseProfessionnalByIdPerson(r.getIdReplacedPerson());
                }
            }
            return null;
        }).filter(e -> e != null);
    }

    @Override
    public boolean doesProfReplace(Integer id, LocalDate baseDate) {
        if (id < 0) {
            return false;
        }
        XBaseProfessionnal prof = this.getBaseProfessionnal(id);
        LocalDateRange range = new LocalDateRange();
        range.notation = RangeNotation.CLOSED;
        return this.findAllReplacements().filter(r -> {
            if (!Boolean.TRUE.equals(r.getIsDeletedB()) && r.getIdReplacementPerson().equals(prof.getIdPerson())) {
                range.start = r.getStartDate();
                range.end = r.getEndDate();
                if (range.contains((Comparable)baseDate)) {
                    return true;
                }
            }
            return false;
        }).findAny().isPresent();
    }

    @Override
    public Stream<XBaseProfessionnal> getWhoProfReplace(Integer id, LocalDateRange baseRange) {
        if (id < 0) {
            return new ArrayList().stream();
        }
        XBaseProfessionnal prof = this.getBaseProfessionnal(id);
        LocalDateRange range = new LocalDateRange();
        range.notation = RangeNotation.CLOSED;
        return this.findAllReplacements().filter(r -> {
            if (!Boolean.TRUE.equals(r.getIsDeletedB()) && r.getIdReplacementPerson().equals(prof.getIdPerson())) {
                range.start = r.getStartDate();
                range.end = r.getEndDate();
                if (baseRange.intersect((Range)range)) {
                    return true;
                }
            }
            return false;
        }).map(r -> this.getBaseProfessionnalByIdPerson(r.getIdReplacedPerson()));
    }

    @Override
    public XBaseProfessionnal getWhoReplaceProf(Integer id, LocalDate baseDate) {
        if (id < 0) {
            return null;
        }
        XBaseProfessionnal prof = this.getBaseProfessionnal(id);
        LocalDateRange range = new LocalDateRange();
        range.notation = RangeNotation.CLOSED;
        return this.findAllReplacements().filter(r -> {
            if (!Boolean.TRUE.equals(r.getIsDeletedB()) && r.getIdReplacedPerson().equals(prof.getIdPerson())) {
                range.start = r.getStartDate();
                range.end = r.getEndDate();
                if (range.contains((Comparable)baseDate)) {
                    return true;
                }
            }
            return false;
        }).map(r -> this.getBaseProfessionnalByIdPerson(r.getIdReplacementPerson())).findFirst().orElse(null);
    }

    @Override
    public void checkAgainstPatientSensibleMarker(IPatient patient) throws StatusException {
        if (!this.isPatientClinicalFileAccessGrantedForSessionProfessionnal(patient)) {
            throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, Messages.getString((String)"CE_PATIENT_A_DES_RESTRICTIONS_SUR_LACCES_A_SES_DONNEES_CLINIQUES", (String[])new String[0])));
        }
    }

    @Override
    public boolean isPatientClinicalFileAccessGrantedForSessionProfessionnal(IPatient patient) {
        if (patient == null) {
            return false;
        }
        if (!Boolean.TRUE.equals(patient.getIsSensible())) {
            return true;
        }
        if (patient.getTreatingProfessionnal() == null) {
            return true;
        }
        XBaseProfessionnal sessionProfessionnal = this.getSessionProfessionnal();
        if (sessionProfessionnal == null) {
            return false;
        }
        return sessionProfessionnal.equals((Object)patient.getTreatingProfessionnal());
    }
}

