/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.eform.metadata;

import ca.infodata.ofys.client.modules.eform.metadata.MetaData;
import ca.infodata.ofys.client.modules.eform.metadata.MetaDataFactory;
import ca.infodata.ofys.client.modules.eform.metadata.MetaDataType;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MetaDataContainer {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.eform.metadata.MetaDataContainer");
    public MetaData metaData;
    public boolean extracted = false;
    public long extractedDate = 0L;
    public Exception exception;

    public void buildEncounterObject() {
        if (this.metaData != null) {
            try {
                this.metaData.buildEncounterObject();
            }
            catch (MetaDataFactory.DataTransformationException e) {
                this.exception = e;
            }
        }
    }

    public String toString() {
        return this.metaData == null ? "no metadata" : this.metaData.id;
    }

    public JsonObject toJson() {
        Gson gs = new Gson();
        JsonObject jObjMain = new JsonObject();
        JsonObject jObjMeta = new JsonObject();
        if (this.metaData != null) {
            if (this.metaData.id != null) {
                jObjMeta.addProperty("id", this.metaData.id);
            }
            if (this.metaData.dataType != null) {
                jObjMeta.addProperty("dataType", (Number)this.metaData.dataType.getValue());
            }
            if (this.metaData.datas != null) {
                JsonArray ja = new JsonArray();
                for (Object o : this.metaData.datas) {
                    JsonObject j = new JsonObject();
                    if (o == null) {
                        j.add("value", (JsonElement)JsonNull.INSTANCE);
                    } else if (o instanceof String) {
                        j.addProperty("value", (String)o);
                    } else {
                        j.addProperty("value", gs.toJson(o));
                    }
                    j.addProperty("class", o == null ? "" : o.getClass().getName());
                    ja.add((JsonElement)j);
                }
                jObjMeta.add("datas", (JsonElement)ja);
            }
        }
        jObjMain.add("metadata", (JsonElement)jObjMeta);
        jObjMain.addProperty("extracted", Boolean.valueOf(this.extracted));
        jObjMain.addProperty("extractedDate", (Number)this.extractedDate);
        return jObjMain;
    }

    public static String toJsonString(List<MetaDataContainer> list) {
        return MetaDataContainer.toJsonString(list, null);
    }

    public static String toJsonString(List<MetaDataContainer> list, String oldMetaData) {
        JsonArray jarr = MetaDataContainer.toJsonArr(list);
        if (StringUtils.isNotBlank((CharSequence)oldMetaData)) {
            JsonParser parser = new JsonParser();
            JsonArray jold = parser.parse(oldMetaData).getAsJsonArray();
            if (jarr == null) {
                jarr = jold;
            } else {
                for (JsonElement o : jold) {
                    jarr.add(o);
                }
            }
        }
        if (jarr != null) {
            return jarr.toString();
        }
        return null;
    }

    private static JsonArray toJsonArr(List<MetaDataContainer> list) {
        if (list != null) {
            JsonArray jarr = new JsonArray();
            for (MetaDataContainer mdc : list) {
                JsonObject j;
                if (mdc == null || (j = mdc.toJson()) == null) continue;
                jarr.add((JsonElement)j);
            }
            return jarr;
        }
        return null;
    }

    public static String toJsonString(MetaDataContainer obj) {
        JsonObject j;
        if (obj != null && (j = obj.toJson()) != null) {
            return j.toString();
        }
        return null;
    }

    public static List<MetaDataContainer> extractMetaDataFrom(String jsonString) {
        ArrayList<MetaDataContainer> iers = new ArrayList<MetaDataContainer>();
        JsonParser parser = new JsonParser();
        JsonArray jarr = parser.parse(jsonString).getAsJsonArray();
        for (JsonElement je : jarr) {
            JsonObject jo = je.getAsJsonObject();
            JsonObject mdata = jo.get("metadata").getAsJsonObject();
            boolean extracted = jo.get("extracted").getAsBoolean();
            long extractDate = jo.get("extractedDate").getAsLong();
            JsonArray datasArr = mdata.get("datas").getAsJsonArray();
            String id = mdata.get("id").getAsString();
            int idType = mdata.get("dataType").getAsInt();
            MetaData md = new MetaData();
            md.dataType = MetaDataType.fromValue(idType);
            md.id = id;
            MetaDataContainer mdc = new MetaDataContainer();
            mdc.extracted = extracted;
            mdc.extractedDate = extractDate;
            mdc.metaData = md;
            Object[] objs = new Object[datasArr.size()];
            int i = 0;
            for (JsonElement js : datasArr) {
                JsonObject jso = js.getAsJsonObject();
                String className = jso.get("class").getAsString();
                if (jso.get("value").isJsonNull()) {
                    objs[i] = null;
                } else if (String.class.getName().equals(className)) {
                    objs[i] = jso.get("value").getAsString();
                } else if (Double.class.getName().equals(className)) {
                    objs[i] = jso.get("value").getAsDouble();
                } else if (Boolean.class.getName().equals(className)) {
                    objs[i] = jso.get("value").getAsBoolean();
                } else {
                    logger.log(Level.SEVERE, "Impossible de reconstituer l'objet datas de la metadata.  Type " + className + " ind\u00e9fini.");
                    objs[i] = jso.get("value").getAsString();
                }
                ++i;
            }
            md.datas = objs;
            iers.add(mdc);
        }
        return iers;
    }

    public static boolean haveSomethingToImport(String metadata) {
        try {
            List<MetaDataContainer> list = MetaDataContainer.extractMetaDataFrom(metadata);
            for (MetaDataContainer mdc : list) {
                if (mdc.extracted) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "unable to validate metadata :: " + metadata, e);
        }
        return false;
    }
}

