/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.eform.autocomplete;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergy;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBloodPressure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBodyTemperature;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCustomMeasure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnostic;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocuments;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XFrequency;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XImmunization;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XIntervention;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabit;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XMeasurement;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPhysicalExamination;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPlan;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPrevent;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XRappel;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XRappelResolvedStatus;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XPatientIdentifier;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;

public class ObjectFormatter {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.eform.autocomplete.ObjectFormatter");

    public static String format(Object o) {
        String st = null;
        if (o == null) {
            Exception exception = new Exception();
            exception.fillInStackTrace();
            logger.log(Level.SEVERE, "Tried to format for eform a null object!", exception);
            return "";
        }
        if (o instanceof XAllergy) {
            XAllergy a = (XAllergy)o;
            st = (a.getSinceDate() != null ? a.getSinceDate().formatSlash() + " " : "") + (a.getSeverity() != null ? a.getSeverity() + " - " : "") + (a.getDrugrefDesc() != null ? a.getDrugrefDesc() + " | " : "") + (a.getNote() != null ? a.getNote() + " | " : "") + (a.getReaction() != null ? a.getReaction() + " " : "");
        } else if (o instanceof XBloodPressure) {
            XBloodPressure a = (XBloodPressure)o;
            st = (a.getTimeVitalSign() != null ? FastDateFormat.getInstance((String)(FormatDateProvider.getFormatDate().toString() + " HH:mm")).format(new Date(a.getTimeVitalSign())) + " " : "") + (a.getSystolic() != null ? a.getSystolic() + "/" : "?/") + (a.getDiastolic() != null ? a.getDiastolic() + "" : "?") + (a.getPulse() != null ? " | " + a.getPulse() + "p/m" : "") + (a.getNote() != null ? " | " + a.getNote() : "");
        } else if (o instanceof XPatientIdentifier) {
            XPatientIdentifier a = (XPatientIdentifier)o;
            st = (a.getType() != null ? (a.getType().getName() != null ? a.getType().getName() + ": " : "") : "") + (a.getIdentifier() != null ? a.getIdentifier() : "");
        } else if (o instanceof XPrescription) {
            String drugName;
            String strength;
            XPrescription prescription = (XPrescription)o;
            String nodata = "?";
            String space = " ";
            boolean isDrug = prescription.getStrength() == null || prescription.getStrength().getDrugType() != XDrugType.FOURNITURE;
            String string = strength = prescription.getStrength() == null ? nodata : prescription.getStrength().getText();
            if (prescription.getStrength().getDrugType() != XDrugType.FOURNITURE && prescription.getStrength() != null && !StringUtils.isBlank((CharSequence)prescription.getStrength().getCommercialName()) && (drugName = prescription.getStrength().getCommercialName()).indexOf(strength) != -1) {
                strength = "";
            }
            String posology = "";
            String format = "";
            String frequency = "";
            String quantity = "";
            posology = prescription.getPosology() == null ? "" : prescription.getPosology();
            frequency = prescription.getFrequency() == null ? "" : prescription.getFrequency();
            String string2 = format = prescription.getFormat() == null ? "" : prescription.getFormat().description();
            if (prescription.getQuantity() == null || prescription.getQuantity() == 0) {
                if (prescription.getTreatmentDuration() != null) {
                    quantity = prescription.getTreatmentDuration().toString() + space + Messages.getString((String)"JRS.", (String[])new String[0]);
                }
            } else {
                quantity = prescription.getQuantity().toString();
                quantity = quantity + space;
                if (isDrug && prescription.getFormat() != null) {
                    quantity = quantity + prescription.getFormat().description();
                }
            }
            String rx = "";
            String startdate = "";
            String note = "";
            rx = prescription.getRx() == null ? "" : prescription.getRx().toString();
            startdate = prescription.getStartDate() == null ? "" : LocalDateFormat.format((LocalDate)prescription.getStartDate(), (String)FormatDateProvider.getFormatDate().toString());
            note = prescription.getNote() == null ? "" : prescription.getNote();
            note = note.length() > 50 ? note.substring(0, 50) : note;
            StringBuilder b = new StringBuilder(100);
            if (isDrug && strength.length() > 0) {
                b.append(strength);
                b.append(space);
            }
            if (posology.length() > 0) {
                b.append(posology);
                b.append(space);
            }
            if (format != null && format.length() > 0) {
                b.append(format);
                b.append(space);
            }
            if (frequency != null && frequency.length() > 0) {
                b.append(frequency);
                b.append(space);
            }
            if (quantity != null && quantity.length() > 0) {
                b.append(quantity);
            }
            if (rx != null && rx.length() > 0) {
                b.append(", R x ");
                b.append(rx);
                b.append(space);
                b.append(Messages.getString((String)"LE", (String[])new String[0]));
                b.append(space);
                b.append(startdate);
            }
            if (note.length() > 0) {
                b.append(space);
                b.append(note);
            }
            st = b.toString();
        } else if (o instanceof XBodyTemperature) {
            XBodyTemperature a = (XBodyTemperature)o;
            st = (a.getTimeVitalSign() != null ? FastDateFormat.getInstance((String)(FormatDateProvider.getFormatDate().toString() + " HH:mm")).format(new Date(a.getTimeVitalSign())) + " " : "") + (a.getBodyTemperature() != null ? a.getBodyTemperature() + "\u00b0C/" : "") + (a.getBodyTemperatureType() != null ? a.getBodyTemperatureType() + "" : "") + (a.getNote() != null ? " | " + a.getNote() : "");
        } else if (o instanceof XCustomMeasure) {
            XCustomMeasure a = (XCustomMeasure)o;
            st = (a.getEntryDatetime() != null ? LocalDate.fromTimeInMillisLOCAL((Long)a.getEntryDatetime()).formatSlash() + " " : "") + (a.getValue() != null ? a.getValue() : "") + (a.getTypeUnit() != null ? a.getTypeUnit() : "") + ", " + (a.getTypeCode() != null ? a.getTypeCode() : "") + (a.getTypeInterval() != null ? " (" + a.getTypeInterval() + ")" : "") + (a.getNote() != null ? a.getNote() : "");
        } else if (o instanceof XDiagnostic) {
            XDiagnostic a = (XDiagnostic)o;
            XCode c = a.getDiagnosticCode();
            st = (a.getSinceDate() != null ? a.getSinceDate().formatSlash() + " " : "") + (c != null && c.getCode() != null ? c.getCode() : "") + (c != null && c.getDescription() != null ? (c.getCode() != null ? " - " + c.getDescription() : c.getDescription()) : "") + (a.getIsProblem() != null ? (a.getIsProblem().booleanValue() ? "(Probl\u00e8me)" : "") : "") + (a.getNote() != null ? a.getNote() : "");
        } else if (o instanceof XDocuments) {
            XDocuments a = (XDocuments)o;
            st = (a.getEntryDate() != null ? a.getEntryDate().formatSlash() + " " : "") + (a.getCacheName() != null ? a.getCacheName() : "") + (a.getType() != null ? "(" + a.getType() + ") " : "") + (a.getDescription() != null ? a.getDescription() : "");
        } else if (o instanceof XFrequency) {
            XFrequency a = (XFrequency)o;
            st = (a.getTimeVitalSign() != null ? FastDateFormat.getInstance((String)(FormatDateProvider.getFormatDate().toString() + " HH:mm")).format(new Date(a.getTimeVitalSign())) + " " : "") + (a.getRespiration() != null ? " | " + a.getRespiration() + " resp./s" : "") + (a.getNote() != null ? a.getNote() : "");
        } else if (o instanceof XImmunization) {
            XImmunization a = (XImmunization)o;
            JoinList joinList = new JoinList(" ");
            joinList.setTrim(true);
            joinList.add(a.getVaccinationDate() == null ? null : a.getVaccinationDate().formatSlash());
            if (a.getCode() != null) {
                joinList.add((CharSequence)a.getCode().getCode());
            }
            joinList.add(": ", a.getVaccineName());
            joinList.add((CharSequence)a.getNote());
            st = joinList.toString();
        } else if (o instanceof XIntervention) {
            XIntervention a = (XIntervention)o;
            XCode c = a.getInterventionCode();
            st = (a.getDate() != null ? a.getDate().formatSlash() + " " : "") + (c != null ? c.getCode() : " ") + (c.getDescription() != null ? (c != null ? "- " + c.getDescription() : c.getDescription() + " ") : "") + (a.getNote() != null ? a.getNote() : "");
        } else if (o instanceof XLifeHabit) {
            XLifeHabit a = (XLifeHabit)o;
            st = (a.getEntryDate() != null ? a.getEntryDate().formatSlash() + " " : "") + (a.getType() != null ? a.getType() + " " : "") + (a.getFrequency() != null ? (a.getType() != null ? "- " + a.getFrequency() + " " : a.getFrequency() + " ") : "") + (a.getNote() != null ? a.getNote() : "");
        } else if (o instanceof XMeasurement) {
            XMeasurement a = (XMeasurement)o;
            st = (a.getEncounter() != null && a.getEncounter().getDatetime() != null ? FastDateFormat.getInstance((String)FormatDateProvider.getFormatDate().toString()).format(new Date(a.getEncounter().getDatetime())) : "") + (a.getHeadCirc() != null ? ", t\u00eate: " + a.getHeadCirc() + " cm" : "") + (a.getHeight() != null ? ", grandeur: " + a.getHeight() + " cm" : "") + (a.getWaistMeasurement() != null ? ", taille: " + a.getWaistMeasurement() + " cm" : "") + (a.getWeight() != null ? ", poids: " + a.getWeight() + " kg" : "") + (a.getNote() != null ? " " + a.getNote() : "");
        } else if (o instanceof XPhysicalExamination) {
            XPhysicalExamination a = (XPhysicalExamination)o;
            st = (a.getEncounter() != null && a.getEncounter().getDatetime() != null ? FastDateFormat.getInstance((String)FormatDateProvider.getFormatDate().toString()).format(new Date(a.getEncounter().getDatetime())) : "") + (a.getNote() != null ? " " + a.getNote() : "");
        } else if (o instanceof XPlan) {
            XPlan a = (XPlan)o;
            st = (a.getEntryDate() != null ? FastDateFormat.getInstance((String)FormatDateProvider.getFormatDate().toString()).format(new Date(a.getEntryDate())) : "") + (a.getIsDone() != null && a.getIsDone() != false ? " Fait:" : "") + (a.getNote() != null ? " " + a.getNote() : "");
        } else if (o instanceof XPrevent) {
            XPrevent a = (XPrevent)o;
            st = (a.getDatePrevent() != null ? a.getDatePrevent().formatSlash() : "") + (a.getActionType() != null ? " " + a.getActionType() + (a.getLevel() != null ? " - " + a.getLevel() : "") : "") + (a.getType() != null ? ", " + a.getType() : "") + (a.getNote() != null ? " " + a.getNote() : "");
        } else if (o instanceof XRappel) {
            XRappel a = (XRappel)o;
            st = (a.getDateRappel() != null ? a.getDateRappel().formatSlash() : "") + (a.getResolvedStatus().contains(XRappelResolvedStatus.REGLE) ? ", R\u00e9solu :" : "") + (a.getNote() != null ? " " + a.getNote() : "");
        } else {
            logger.log(Level.SEVERE, "Couldn't format well for eform " + o.getClass().getName());
            st = o.toString();
        }
        return st;
    }

    public static String format10DigitPhoneNumber(String s) {
        if (StringUtils.isNotBlank((String)s) && s.length() == 10) {
            s = "(" + s.substring(0, 3) + ")" + s.substring(3, 6) + "-" + s.substring(6, 10);
        }
        return s;
    }
}

