/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.imaging.ImagingResultExam;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.ListImagingExamController;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.data.middle.dataobjects.CDsqDmeObjectList;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.dashboard.models.CDSQResult;
import ca.infodata.ofys.ui.dashboard.models.CDsqRequest;
import ca.infodata.ofys.ui.dashboard.models.CImagingResultExam;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListImagingExamControllerWeb {
    private static final Logger logger = Logger.getLogger(ListImagingExamController.class.getName());
    private static final String channelName = "dsq.doc.search";
    private Integer idPatient;
    private ListImagingExamController controller;
    private IWebSocketChannel wsChannel;

    public ListImagingExamControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateAction) {
        this.idPatient = idPatient;
        this.wsChannel = channel;
        this.controller = new ListImagingExamController(idPatient, findCandidateAction){

            @Override
            public void callback(DsqCallback<QueryContinuationResult> dsqCallback) {
                ListImagingExamControllerWeb.this.callback(dsqCallback);
            }
        };
    }

    public void list(CDsqRequest dsqRequest) {
        if (dsqRequest == null) {
            throw new NullPointerException("dsqRequest");
        }
        if (dsqRequest.patientId == null) {
            throw new NullPointerException("dsqRequest.patientId");
        }
        if (!dsqRequest.patientId.equals(this.idPatient)) {
            throw new IllegalArgumentException("dsqRequest.patientId != controller.patient.id");
        }
        try {
            this.controller.setStart(CDsqRequest.parseLocalDateSafe(dsqRequest.start));
            this.controller.setEnd(CDsqRequest.parseLocalDateSafe(dsqRequest.end));
            MultiStatus status = this.controller.valid();
            if (status.isOK()) {
                this.controller.list();
            } else {
                ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject(status));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while listing SH", e);
            Status status = new Status(IStatus.Severity.ERROR, Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]));
            ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject((Serializable)status));
        }
    }

    protected void callback(DsqCallback<QueryContinuationResult> callback) {
        LocalDate start = this.controller.getStart();
        LocalDate end = this.controller.getEnd();
        CDsqDmeObjectList ol = new CDsqDmeObjectList.Builder().setIdPatient(this.idPatient.intValue()).setStartdate(start == null ? null : Integer.valueOf(start.dayFrom1970)).setEnddate(end == null ? null : Integer.valueOf(end.dayFrom1970)).setMethod(CDsqDmeObjectList.METHODS.listImagingExam).setResult((QueryContinuationResult)callback.result).build();
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        CDSQResult<CImagingResultExam> r = new CDSQResult<CImagingResultExam>();
        r.setCriteria(ol);
        if (ol.result != null) {
            for (String warning : ol.result.imagingResultsWarnings) {
                ms.add((IStatus)new Status(IStatus.Severity.WARNING, warning));
            }
            List<ImagingResultExam> list = this.orderImagingResultSearchResults(ol.result);
            String timeOfRequest = null;
            if (ol.timeOfDsqRequest > 0L) {
                timeOfRequest = Utils.longTodateStr(ol.timeOfDsqRequest, "yyyy-MM-dd HH:mm:ss");
            }
            r.setList(this.toCImagingResultExam(list, timeOfRequest));
        }
        ro.setObj(r);
        String message = callback.message;
        if (callback.exception != null) {
            if (StringUtils.isBlank((CharSequence)message)) {
                message = StringUtils.isNotBlank((String)callback.exception.getMessage()) ? callback.exception.getMessage() : callback.exception.getClass().getSimpleName();
            }
            if (callback.exception instanceof StatusException) {
                StatusException statusException = (StatusException)((Object)callback.exception);
                ms.setSeverity(statusException.getStatus().getSeverity());
            } else {
                ms.setSeverity(IStatus.Severity.ERROR);
            }
        } else {
            ms.setSeverity(IStatus.Severity.OK);
        }
        if (StringUtils.isNotBlank((String)message)) {
            ms.setMessage(message);
        }
        ro.setStatus(ms);
        ServerResponses.sendJsonToClient(this.wsChannel, channelName, ro);
    }

    public void sendDsqListImagingExam(CDsqDmeObjectList ol) {
        if (ol != null && ol.result != null) {
            ReturnObject ro = new ReturnObject();
            MultiStatus ms = new MultiStatus();
            for (String warning : ol.result.imagingResultsWarnings) {
                ms.add((IStatus)new Status(IStatus.Severity.WARNING, warning));
            }
            List<ImagingResultExam> list = this.orderImagingResultSearchResults(ol.result);
            String timeOfRequest = null;
            if (ol.timeOfDsqRequest > 0L) {
                timeOfRequest = Utils.longTodateStr(ol.timeOfDsqRequest, "yyyy-MM-dd HH:mm:ss");
            }
            CDSQResult<CImagingResultExam> r = new CDSQResult<CImagingResultExam>();
            r.setCriteria(ol);
            r.setList(this.toCImagingResultExam(list, timeOfRequest));
            ro.setObj(r);
            ms.setSeverity(IStatus.Severity.OK);
            ro.setStatus(ms);
            ServerResponses.sendJsonToClient(this.wsChannel, channelName, ro);
        }
    }

    private List<CImagingResultExam> toCImagingResultExam(List<ImagingResultExam> l, String timeOfRequest) {
        ArrayList<CImagingResultExam> cl = new ArrayList<CImagingResultExam>();
        for (ImagingResultExam i : l) {
            CImagingResultExam res = new CImagingResultExam(i);
            if (timeOfRequest != null) {
                res.timeOfDsqRequest = timeOfRequest;
            }
            cl.add(res);
        }
        return cl;
    }

    private List<ImagingResultExam> orderImagingResultSearchResults(QueryContinuationResult result) {
        List<ImagingResultExam> list = result == null || result.imagingResults == null ? new ArrayList() : result.imagingResults;
        Collections.sort(list, new Comparator<ImagingResultExam>(){

            @Override
            public int compare(ImagingResultExam o1, ImagingResultExam o2) {
                return -o1.effectiveTime.compareTo(o2.effectiveTime);
            }
        });
        for (ImagingResultExam e : list) {
            Collections.sort(e.modality, new Comparator<Code>(){

                @Override
                public int compare(Code o1, Code o2) {
                    return o1.code.compareTo(o2.code);
                }
            });
        }
        return list;
    }
}

