/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.Id;
import ca.infodata.dsq.domain.NAM;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_U;
import ca.infodata.dsq.domain.labo.getreport.LaboReport;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.Job;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.ofys.client.job.NullProgressMonitor;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetLaboReportController {
    private static final String OBTENTION_DU_RAPPORT = "Obtention du rapport";
    private static final Logger logger = Logger.getLogger(GetLaboReportController.class.getName());
    private Integer idPatient;
    private Id idRequest;
    private Code reportType;
    private LaboReport result;
    private Job get;
    private GetCandidateController findCandidateAction;
    private XPatientImage patientImage;
    private Candidate candidate;
    private final IDSQPluginController dsq;
    private final IDSQAccessor dsqAccessor;

    public GetLaboReportController(Integer idPatient, GetCandidateController findCandidateAction) {
        if (findCandidateAction == null) {
            throw new NullPointerException("findCandidateAction");
        }
        if (idPatient == null) {
            throw new NullPointerException("idPatient");
        }
        this.idPatient = idPatient;
        this.dsq = Application.get().getDsqPluginController();
        this.dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();
        this.findCandidateAction = findCandidateAction;
    }

    public void callback(DsqCallback<LaboReport> dsqCallback) {
    }

    public void get() throws Exception {
        if (this.get == null) {
            this.get = new Job(OBTENTION_DU_RAPPORT, this::get2);
        }
        if (this.get.getState() == JobStatus.RUNNING) {
            this.callback(new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.get.schedule();
        }
    }

    public void get2(IProgressMonitor monitor) {
        if (this.result == null) {
            DsqCallback<LaboReport> r = this.get3(monitor);
            if (r.result != null) {
                this.result = (LaboReport)r.result;
            }
            this.callback(r);
        } else {
            this.callback(new DsqCallback<LaboReport>(this.result));
        }
    }

    public MultiStatus valid() {
        return new MultiStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DsqCallback<LaboReport> get3(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        DsqCallback<LaboReport> callback = new DsqCallback<LaboReport>();
        try {
            monitor.beginTask(OBTENTION_DU_RAPPORT, 2);
            Alias alias = null;
            XmlSignatureI signature = null;
            Signature signatureNiu = null;
            this.dsq.checkIfActionWasCanceled(monitor);
            this.candidate = this.findCandidateAction.getCandidate(monitor.subMonitor(1));
            String niu = this.candidate.getNiu().value();
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                alias = this.dsq.getAlias(monitor);
                this.dsq.checkIfActionWasCanceled(monitor);
                signature = this.dsq.getSignatureI(monitor, alias);
                this.dsq.checkIfActionWasCanceled(monitor);
                signatureNiu = this.dsq.getPkcs7SignatureI(monitor, alias, niu);
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            monitor.worked(1);
            this.dsq.checkIfActionWasCanceled(monitor);
            monitor.subTask("Recherche");
            ReturnObject r = this.dsqAccessor.getLaboReport((Signature)signature, signatureNiu, this.idPatient, this.reportType, this.idRequest);
            if (r == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DU_RAPPORT.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (LaboReport)r.getObj();
            this.dsq.checkIfActionWasCanceled(monitor);
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = e.getMessage();
            logger.log(Level.SEVERE, String.format("Failed to list labo %s, %s, %s", this.idPatient, this.idRequest, this.reportType), e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void clear() {
        this.result = null;
        this.candidate = null;
    }

    public void setXImage(XPatientImage x) {
        Integer idPatient2;
        this.clear();
        this.patientImage = x;
        Integer idPatient1 = this.idPatient;
        Integer n = idPatient2 = x == null ? null : x.idPatient;
        if (!MiscUtil.areObjectsEquals((Object)idPatient1, (Object)idPatient2)) {
            throw new IllegalArgumentException("patient.getId() should match e.idPatient");
        }
        if (x == null || x.valDsq == null) {
            this.idRequest = null;
            this.reportType = null;
        } else {
            this.idRequest = x.valDsq.laboRequest.id;
            this.reportType = x.valDsq.laboReportHeader.reportType;
        }
        IPatient patient = this.getPatient();
        if (StringUtils.isNotEmpty((String)patient.getNiu())) {
            this.candidate = new Candidate(new NIU_U(patient.getNiu()), StringUtils.isBlank((CharSequence)patient.getHealthInsuranceNumber()) ? null : new NAM(patient.getHealthInsuranceNumber()), patient.getFirstName(), patient.getLastName(), GetCandidateController.getDsqGender(patient.getGender()), Long.valueOf(patient.getBirthDate().toTimeInMillisUTC()), null);
        }
    }

    public XPatientImage getPatientImage() {
        return this.patientImage;
    }

    public static String toString(Id id) {
        return id == null ? null : id.root + ";" + id.extension;
    }

    public static String toString(Code code) {
        return code == null ? null : code.codeSystem + ";" + code.code;
    }

    public static String toString(NIU niu) {
        return niu == null ? null : niu.oid() + ";" + niu.value();
    }

    public IPatient getPatient() {
        return Application.get().getCache().getPatientCache().get(this.idPatient);
    }

    public LaboReport getLaboReport() {
        return this.result;
    }

    public Candidate getCandidate() {
        return this.candidate;
    }
}

