/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.fco.CandidateConsentDirective;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IMessageService;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.Job;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.modules.dsq.internal.ConsentControllerCallback;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsentController {
    private static final Logger logger = Logger.getLogger(ConsentController.class.getName());
    private Integer idPatient;
    private CandidateConsentDirective consent;
    public ConsentControllerCallback callback;
    private final IDSQPluginController dsq;
    private final IDSQAccessor dsqAccessor;
    private final IMessageService messageService;
    private Job getConsentJob;

    public ConsentController(Integer idPatient, ConsentControllerCallback callback) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        this.idPatient = idPatient;
        this.callback = callback;
        this.dsq = Application.get().getDsqPluginController();
        this.dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();
        this.messageService = Application.get().getMessageService();
    }

    public void getConsent() throws Exception {
        if (this.idPatient == null) {
            return;
        }
        if (this.getConsentJob == null) {
            this.getConsentJob = new Job("Obtention du consentement", this::getConsent2);
        }
        if (this.getConsentJob.getState() == JobStatus.RUNNING) {
            this.callback.getConsent(new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getConsentJob.schedule();
        }
    }

    public DsqCallback<CandidateConsentDirective> getConsent2(IProgressMonitor monitor) {
        DsqCallback<CandidateConsentDirective> r;
        if (this.consent == null) {
            r = this.getConsent3(monitor);
            this.consent = (CandidateConsentDirective)r.result;
            this.callback.getConsent(r);
        } else {
            r = new DsqCallback<CandidateConsentDirective>(this.consent);
            this.callback.getConsent(r);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DsqCallback<CandidateConsentDirective> getConsent3(IProgressMonitor monitor) {
        DsqCallback<CandidateConsentDirective> callback = new DsqCallback<CandidateConsentDirective>();
        try {
            ReturnObject r;
            if (monitor != null) {
                monitor.beginTask("Obtention du consentement", 3);
            }
            XmlSignatureI signature = null;
            if (!this.dsq.hasSignatures(null)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.dsq.getAlias(monitor);
                signature = this.dsq.getSignatureI(monitor, alias);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask("Recherche");
            }
            if ((r = this.dsqAccessor.hasPatientConsented((Signature)signature, this.idPatient)) == null) {
                throw new AbortException("Erreur lors de l'obtention du consentement du patient");
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (CandidateConsentDirective)r.getObj();
            if (callback.result != null && !((CandidateConsentDirective)callback.result).hasAccepted()) {
                callback.message = "Le patient a refus\u00e9 l'acc\u00e8s \u00e0 ses donn\u00e9es.";
            }
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? this.messageService.getUNEXPECTED_ERROR_MESSAGE() : e.getMessage();
            logger.log(Level.SEVERE, String.format("Failed to get consent for patient %s", StringUtils.safeToString((Logger)logger, (Object)this.idPatient)), e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public ConsentControllerCallback getCallback() {
        return this.callback;
    }
}

