/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.Annotation;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.College;
import ca.infodata.dsq.domain.DetectedIssueEvent;
import ca.infodata.dsq.domain.DetectedIssueManagement;
import ca.infodata.dsq.domain.Device;
import ca.infodata.dsq.domain.DispenseDetails;
import ca.infodata.dsq.domain.DispenseStatusChange;
import ca.infodata.dsq.domain.DispenseSummary;
import ca.infodata.dsq.domain.DosageInstruction;
import ca.infodata.dsq.domain.Duration;
import ca.infodata.dsq.domain.HistoryStatusChange;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.Ingredient;
import ca.infodata.dsq.domain.Medication;
import ca.infodata.dsq.domain.MedicationDispense;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_COLLEGE;
import ca.infodata.dsq.domain.OtherMedicationDetail;
import ca.infodata.dsq.domain.OtherMedicationSummary;
import ca.infodata.dsq.domain.PrescriptionDeviceDetails;
import ca.infodata.dsq.domain.PrescriptionDeviceSummary;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.domain.PrescriptionDrugSummary;
import ca.infodata.dsq.domain.ReferenceProtocol;
import ca.infodata.dsq.domain.Refusal;
import ca.infodata.dsq.domain.RefusalReason;
import ca.infodata.dsq.domain.SubstanceAdministration;
import ca.infodata.dsq.domain.SubstitutionMade;
import ca.infodata.dsq.domain.SupplyEventSummary;
import ca.infodata.dsq.domain.SupplyRequestItem;
import ca.infodata.dsq.domain.TherapeuticIntent;
import ca.infodata.dsq.domain.fco.CandidateConsentDirective;
import ca.infodata.dsq.domain.fco.CandidateConsentRefusalEvent;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.modules.dsq.DsqFormatter;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyHumanSubstanceAdministrationSite;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyRouteOfAdministration;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import com.googlecode.jatl.Html;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public class SqimHtmlFormatter {
    private static long counter = 0L;
    private static final Comparator<Object> sequenceSorter = new ComparatorImplementation();
    private static final String DEBUT = Messages.getString((String)"DEBUT", (String[])new String[0]);
    private static final String FIN = Messages.getString((String)"FIN", (String[])new String[0]);
    private static final String STATUS = Messages.getString((String)"STATUS", (String[])new String[0]);
    private static final String RAISON = Messages.getString((String)"RAISON", (String[])new String[0]);
    private static final String LIST_REFUS_CONS = Messages.getString((String)"LIST_REFUS_CONS", (String[])new String[0]);
    private static final String LIST_REFUS_CONS_WARN = "Lorsqu'une directive de refus est trouv\u00e9e dans le pass\u00e9, bien qu'il puisse exister des ordonnaces au DSQ avant cette date, seules celles post\u00e9rieures \u00e0 la date de fin de refus seront affich\u00e9es.";
    private static final String AUCUN_REFUS_CONS = Messages.getString((String)"AUCUN_REFUS_CONS", (String[])new String[0]);
    private static final String ORDONNANCE = Messages.getString((String)"ORDONNANCE", (String[])new String[0]);
    private static final String SOMMAIRE_ORD_DEL = Messages.getString((String)"SOMMAIRE_ORD_DEL", (String[])new String[0]);
    private static final String NUMERO = Messages.getString((String)"NUMERO", (String[])new String[0]);
    private static final String NOM = Messages.getString((String)"NOM", (String[])new String[0]) + " : ";
    private static final String FORMAT = Messages.getString((String)"FORMAT", (String[])new String[0]) + " ";
    private static final String DESCRIPTION = Messages.getString((String)"DESCRIPTION", (String[])new String[0]) + " : ";
    private static final String INSTRUCTIONS = Messages.getString((String)"INSTRUCTIONS", (String[])new String[0]);
    private static final String DATE_ORDONNANCE = Messages.getString((String)"DATE_ORDONNANCE", (String[])new String[0]);
    private static final String DATE_RAMASSAGE = Messages.getString((String)"DATE_RAMASSAGE", (String[])new String[0]);
    private static final String AUTEUR = Messages.getString((String)"AUTEUR", (String[])new String[0]);
    private static final String DISP_TOTAL = Messages.getString((String)"DISP_TOTAL", (String[])new String[0]);
    private static final String QTE = Messages.getString((String)"QTE", (String[])new String[0]);
    private static final String DUREE_PREVU = Messages.getString((String)"DUREE_PREVU", (String[])new String[0]);
    private static final String PERFORMER = Messages.getString((String)"PERFORMER", (String[])new String[0]);
    private static final String LOCATION = Messages.getString((String)"LOCATION", (String[])new String[0]);
    private static final String CONTIENT_EVENTS = Messages.getString((String)"CONTIENT_EVENTS", (String[])new String[0]);
    private static final String CONTIENT_ANNOT = Messages.getString((String)"CONTIENT_ANNOT", (String[])new String[0]);
    static final String red = "#FF3300";
    static final String yellow = "#FFFF00";
    static final String orange = "#FF9900";
    static final String bleu = "#99FFFF";
    static final String white = "#FFFFFF";
    private static final String RED = "rgb(255,0,0)";
    private static final String YELLOW = "rgb(255,255,0)";
    private static final String ORANGE = "rgb(235,144,16)";
    private static final String BLUE = "rgb(0,122,209)";
    private static final String NORMAL = "rgb(255,255,255)";

    private static long getNextCount() {
        return counter++;
    }

    public static String formatDispenseSummaryQuery(QueryContinuationResult qcr) {
        if (qcr != null && qcr.dispenses != null) {
            return SqimHtmlFormatter.formatListPrescriptionsDispensed(qcr.dispenses);
        }
        return null;
    }

    public static String formatConsentRefusal(List<CandidateConsentRefusalEvent> refusals) {
        FastDateFormat sdf = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm", (TimeZone)TimeZone.getTimeZone("UTC"));
        StringWriter writer = new StringWriter();
        Html html = new Html((Writer)writer);
        ((Html)((Html)((Html)((Html)html.table()).width("100%")).border("1")).cellpadding("5px")).tbody();
        ((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).th()).classAttr("refusal-header")).colspan("4")).text(LIST_REFUS_CONS)).end()).end();
        if (refusals.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).th()).classAttr("refusal-header")).style("background-color: white; font-style: italic; color: rgb(99,2,2);")).colspan("4")).text(LIST_REFUS_CONS_WARN)).end()).end();
        }
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).th()).align("left")).width("20%")).font()).text(DEBUT)).end()).th()).align("left")).width("20%")).text(FIN)).end()).th()).align("left")).width("20%")).text(STATUS)).end()).th()).align("left")).width("40%")).text(RAISON)).end()).end();
        boolean foundOne = false;
        if (refusals != null) {
            for (CandidateConsentRefusalEvent ref : refusals) {
                foundOne = true;
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).text(ref.effectiveTimeLow == null ? "" : sdf.format(new Date(ref.effectiveTimeLow)))).end()).td()).text(ref.effectiveTimeHigh == null ? "" : sdf.format(new Date(ref.effectiveTimeHigh)))).end()).td()).text(SqimHtmlFormatter.formatCode(ref.statusCode))).end()).td()).text(SqimHtmlFormatter.formatCode(ref.reasonCode))).end()).end();
            }
        }
        if (!foundOne) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("4")).h3()).text(AUCUN_REFUS_CONS)).end()).end()).end()).end();
        }
        html.endAll();
        return writer.toString();
    }

    public static String formatListPrescriptionsDispensed(List<DispenseSummary> r) {
        if (r == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        Html html = new Html((Writer)writer);
        ((Html)((Html)((Html)((Html)((Html)((Html)html.table()).classAttr("dsq-list-table")).width("100%")).border("0")).cellspacing("2px")).cellpadding("2px")).tbody();
        boolean firstDrugs = true;
        Iterator<DispenseSummary> iterator = r.iterator();
        while (iterator.hasNext()) {
            if (firstDrugs) {
                firstDrugs = false;
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).classAttr("dsq-list-th")).th()).align("left")).width("80px")).text("Date")).end()).th()).align("left")).width("80px")).text("Statut")).end()).th()).align("left")).width("80px")).text("Re-Rx")).end()).th()).align("left")).text(ORDONNANCE)).end()).end();
            }
            DispenseSummary s = iterator.next();
            boolean notCompleted = !"completed".equalsIgnoreCase(s.status);
            boolean inactive = !"active".equalsIgnoreCase(s.prescriptionStatus);
            boolean hasEvent = Boolean.TRUE.equals(s.hasIssues);
            boolean hasAnnotation = Boolean.TRUE.equals(s.hasAnnotations);
            String availableOverAuth = "";
            String name = StringUtils.removeAccents((String)s.drugName);
            String description = StringUtils.removeAccent((String)StringUtils.defaultString((String)s.drugDescription));
            String dosage = "";
            String dosageInstructions = StringUtils.defaultString((String)s.dosageInstructions);
            String[] dd = dosageInstructions.split(":::");
            if (dd.length > 1) {
                availableOverAuth = dd[0];
                dosage = dd[1];
            } else {
                dosage = dosageInstructions;
            }
            dosage = StringUtils.removeAccents((String)dosage);
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).bgcolor(notCompleted ? red : (inactive ? yellow : (hasEvent ? orange : (hasAnnotation ? bleu : white))))).td()).text(DateUtil.format((Long)s.date, (String)"yyyy-MM-dd"))).end()).td()).a()).href("javascript:void(0);")).onclick("showHideDiv('DS" + s.id + "');showHideDiv('DDS" + s.id + "')")).text(s.drugName)).end()).end()).end()).tr()).td()).colspan("4")).div()).id("DDS" + s.id)).style("display:none; border:2px outset red;")).end()).end()).end()).tr()).td()).colspan("4")).div()).id("DS" + s.id)).style("display:none; border:2px outset blue;")).table()).width("100%")).border("0")).cellpadding("1px")).style("background-color:#F0F0F0; color: black; text-align: left;")).tbody()).tr()).th()).align("left")).width("50%")).end()).th()).align("left")).width("50%")).end()).end()).tr()).td()).b()).text(SOMMAIRE_ORD_DEL)).end()).end()).td()).align("right")).a()).href("javascript:void(0);")).onclick("showDsqQuestion('DDS" + s.id + "');getDrugDispensedDetail('" + s.id + "','DDS" + s.id + "')")).text("Voir d\u00e9tails")).end()).text("-")).a()).href("javascript:void(0);")).onclick("hideDsqQuestion('DS" + s.id + "');")).text("X")).end()).end()).end()).tr()).end()).tr()).td()).b()).text(NUMERO)).end()).text(StringUtils.defaultString((String)SqimHtmlFormatter.formatCode(s.drugCode)))).end()).td()).b()).text(NOM)).end()).u()).text(StringUtils.defaultString((String)s.drugName))).end()).end()).end()).tr()).td()).b()).text(FORMAT)).end()).text(SqimHtmlFormatter.formatCode(s.drugFormCode))).end()).td()).b()).text(DESCRIPTION)).end()).text(StringUtils.defaultString((String)s.drugDescription))).end()).end();
            SqimHtmlFormatter.medicationDispensed(s, html);
            ((Html)html.tr()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text(INSTRUCTIONS)).end()).u()).text(dosage)).end()).end()).end();
            ((Html)html.tr()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).b()).text(DATE_ORDONNANCE)).end()).text(DateUtil.format((Long)s.date, (String)"yyyy-MM-dd"))).end()).td()).b()).text("Statut ")).end()).text(s.status)).end()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).b()).text(DATE_RAMASSAGE)).end()).text(StringUtils.defaultString((String)DateUtil.dtoc((long)(s.prescriptionDate == null ? 0L : s.prescriptionDate))))).end()).td()).text("Rx")).text(" " + s.prescriptionStatus)).end()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text(AUTEUR)).end()).text(SqimHtmlFormatter.formatAuthor(s.prescriber))).end()).end()).tr()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).b()).text(DISP_TOTAL)).end()).text(availableOverAuth)).end()).td()).text("ID ")).text(StringUtils.defaultString((String)s.prescriptionId))).end()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).b()).text(QTE)).end()).text(StringUtils.defaultString((String)(s.quantity == null ? "" : s.quantity.toString())))).end()).td()).b()).text(DUREE_PREVU)).end()).text(SqimHtmlFormatter.formatDuration(null, null, s.expectedUseTime))).end()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text(PERFORMER)).end()).text(StringUtils.defaultString((String)(s.performer == null ? "" : s.performer.getFirstName() + " " + s.performer.getLastName())))).end()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text(LOCATION)).end()).text(StringUtils.defaultString((String)(s.location == null ? "" : s.location.getName())))).end()).end();
            ((Html)((Html)((Html)((Html)html.tr()).td()).text(CONTIENT_EVENTS)).text(SqimHtmlFormatter.nvlb(s.hasIssues))).end();
            ((Html)((Html)((Html)((Html)html.td()).text(CONTIENT_ANNOT)).text(SqimHtmlFormatter.nvlb(s.hasAnnotations))).end()).end();
            ((Html)((Html)((Html)((Html)html.end()).end()).end()).end()).end();
        }
        html.endAll();
        return writer.toString();
    }

    public static String formatGetPrescriptionsDispensedDetails(DispenseDetails d, XPrescription s) {
        if (s == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        Html h = new Html((Writer)writer);
        SqimHtmlFormatter.formatGetPrescriptionsDispensedDetails(d, s, h);
        h.endAll();
        return writer.toString();
    }

    public static void formatGetPrescriptionsDispensedDetails(DispenseDetails d, XPrescription s, Html h) {
        if (s != null) {
            ((Html)((Html)((Html)h.table()).classAttr("dsq-detail-box")).attr(new String[]{"idObj", "" + d.id, "idRx", d.prescriptionId})).style("width:100%;");
            ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).b()).text(s.getDsqPrescriptionDispenseId())).end()).end()).end();
            SqimHtmlFormatter.medicationGood(h, d.medication, s);
            h.tr();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Prescrit le: ")).end()).text(s.getStartDate() != null ? s.getStartDate().formatSlash() : " - ")).end();
            h.end();
            h.tr();
            if (s.getStrength() != null) {
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).style("width:33%;")).b()).text("Force: ")).end()).text(s.getStrength().strength)).end();
            }
            if (s.getQuantity() != null) {
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).style("width:33%;")).b()).text("Qt\u00e9.: ")).end()).text(s.getQuantity().toString() + " unit\u00e9(s)")).end();
            }
            if (s.getTreatmentDuration() != null) {
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).style("width:33%;")).b()).text("Dur\u00e9e: ")).end()).text(s.getTreatmentDuration().toString() + " jour(s)")).end();
            }
            h.end();
            if (s.getSite() != XMyHumanSubstanceAdministrationSite.SO_NA) {
                h.tr();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("3")).style("width:100%;")).b()).text("Site: ")).end()).text(s.getSite().name() + " - " + s.getSite().description())).end();
                h.end();
            }
            if (s.getRoute() != XMyRouteOfAdministration.SO_NA) {
                h.tr();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("3")).style("width:100%;")).b()).text("Route: ")).end()).text(s.getRoute().name() + " - " + s.getRoute().description())).end();
                h.end();
            }
            if (s.getFrequency() != null) {
                h.tr();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("3")).style("width:100%;")).b()).text("Fr\u00e9quence: ")).end()).text(s.getFrequency())).end();
                h.end();
            }
            ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("3")).style("width:100%;")).style("border-bottom: 1px solid rgb(200,200,200);")).end()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("3")).style("width:100%;")).b()).text("Posologie")).end()).end()).end();
            SqimHtmlFormatter.dosageInstructions2(d.dosageInstructions, s, h);
            if (StringUtils.isNotBlank((String)s.getNote())) {
                ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("3")).style("width:100%;")).style("border-bottom: 1px solid rgb(200,200,200);")).end()).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("3")).style("width:100%;")).b()).text("Note")).end()).end()).end();
                h.tr();
                ((Html)((Html)((Html)((Html)h.td()).style("width:100%;")).colspan("3")).raw(s.getNote().replaceAll("\n", "<br/>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;"))).end();
                h.end();
            }
        }
    }

    public static void formatGetPrescriptionsDispensedDetails(DispenseDetails s, Html h) {
        if (s != null) {
            ((Html)((Html)h.table()).classAttr("dsq-detail-box")).attr(new String[]{"idObj", "" + s.id});
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).b()).text("D\u00e9tails d'une d\u00e9livrance de m\u00e9dicament")).end()).end()).td()).text("X")).end()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).b()).text(s.id)).end()).end()).td()).b()).text("Rx. No.: ")).end()).text(s.prescriptionId)).end()).end();
            h.tr();
            ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).b()).text("Type: ")).end()).text(s.type != null ? SqimHtmlFormatter.formatCode(s.type) : " - ")).end();
            h.end();
            h.tr();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Fournisseur: ")).end()).text(s.performer != null ? SqimHtmlFormatter.formatAuthor(s.performer) : " - ")).end();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Date: ")).end()).text(s.date != null ? LocalDate.fromTimeInMillisLOCAL((Long)s.date).formatSlash() : " - ")).end();
            h.end();
            h.tr();
            ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).b()).text("Lieu: ")).end()).text(s.location != null ? SqimHtmlFormatter.formatLocation(s.location, null) : " - ")).end();
            h.end();
            h.tr();
            ((Html)((Html)((Html)h.td()).colspan("2")).style("border-bottom: 1px solid rgb(200,200,200);")).end();
            h.end();
            SqimHtmlFormatter.medicationGood(h, s.medication);
            h.tr();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Status: ")).end()).text(s.status != null ? s.status : " - ")).end();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Qt\u00e9.: ")).end()).text(s.quantity != null ? s.quantity.toString() : " - ")).end();
            h.end();
            SqimHtmlFormatter.dosageInstructions2(s.dosageInstructions, h);
            if (s.annotations != null && s.annotations.size() > 0) {
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("2")).b()).text("Annotations : ")).end()).end()).end();
                SqimHtmlFormatter.annotations(s.annotations, h);
            }
            if (s.detectedIssueEvents != null && s.detectedIssueEvents.size() > 0) {
                h.tr();
                ((Html)((Html)((Html)h.td()).colspan("2")).style("border-bottom: 1px solid rgb(200,200,200);")).end();
                h.end();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("2")).b()).text("\u00c9v\u00e9nements : ")).end()).end()).end();
                SqimHtmlFormatter.issues(s.detectedIssueEvents, h);
            }
            h.tr();
            ((Html)((Html)((Html)h.td()).colspan("2")).style("border-bottom: 1px solid rgb(200,200,200);")).end();
            h.end();
            h.tr();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Prescripteur: ")).end()).text(s.prescriptionPrescriber != null ? SqimHtmlFormatter.formatAuthor(s.prescriptionPrescriber) : " - ")).end();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Date: ")).end()).text(s.prescriptionDate != null ? LocalDate.fromTimeInMillisLOCAL((Long)s.prescriptionDate).formatSlash() : " - ")).end();
            h.end();
            h.tr();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Code: ")).end()).text(s.prescriptionCode != null ? SqimHtmlFormatter.formatCode(s.prescriptionCode) : " - ")).end();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Version: ")).end()).text(s.prescriptionVersion != null ? s.prescriptionVersion : " - ")).end();
            h.end();
            h.tr();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Status: ")).end()).text(s.prescriptionStatus != null ? s.prescriptionStatus : " - ")).end();
            ((Html)((Html)((Html)((Html)((Html)h.td()).b()).text("Dur\u00e9e: ")).end()).text(s.expectedUseTime != null ? SqimHtmlFormatter.formatDuration(null, null, s.expectedUseTime) : " - ")).end();
            h.end();
            if (s.substitutionMade != null) {
                h.tr();
                ((Html)((Html)((Html)h.td()).colspan("2")).style("border-bottom: 1px solid rgb(200,200,200);")).end();
                h.end();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("2")).b()).text("Substitution : ")).end()).end()).end();
                SqimHtmlFormatter.substitutionMadeFormat(h, s.substitutionMade);
            }
            if (s.dispenseStatusChanges != null) {
                h.tr();
                ((Html)((Html)((Html)h.td()).colspan("2")).style("border-bottom: 1px solid rgb(200,200,200);")).end();
                h.end();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("2")).b()).text("Changement de status : ")).end()).end()).end();
                SqimHtmlFormatter.dispensedStatusChanges(s.dispenseStatusChanges, h);
            }
        }
    }

    public static String formatGetPrescriptionsDispensedDetails(DispenseDetails s) {
        if (s == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        Html h = new Html((Writer)writer);
        SqimHtmlFormatter.formatGetPrescriptionsDispensedDetails(s, h);
        h.endAll();
        return writer.toString();
    }

    public static void formatIngredient(Html h, Ingredient ing) {
        ((Html)((Html)h.tr()).td()).colspan("2");
        ((Html)h.table()).tr();
        h.td();
        h.style("font-weigth: bold; color: " + (ing.drugDoesNotContains == null ? "orange" : (ing.drugDoesNotContains != false ? "green" : "red")) + ";");
        h.text(ing.drugDoesNotContains == null ? "Peu contenir" : (ing.drugDoesNotContains != false ? "Ne contient pas" : "Contient"));
        ((Html)h.end()).td();
        h.text(SqimHtmlFormatter.formatCode(ing.code));
        ((Html)h.end()).td();
        h.text(ing.name == null ? "" : ing.name);
        ((Html)h.end()).td();
        h.text(ing.quantity == null ? "" : ing.quantity.toString());
        ((Html)h.end()).td();
        h.text(ing.referenceProtocolId == null ? "" : ing.referenceProtocolId);
        h.end();
        ((Html)h.end()).end();
        ((Html)h.end()).end();
    }

    public static void tdBoolean(Html h, Boolean bool, String strue, String sfalse, String styleTrue, String styleFalse) {
        if (bool != null && strue != null && sfalse != null) {
            h.td();
            if (bool.booleanValue()) {
                h.style(styleTrue == null ? "" : styleTrue);
                h.text(strue);
            } else {
                h.style(styleFalse == null ? "" : styleFalse);
                h.text(sfalse);
            }
            h.end();
        }
    }

    public static void formatDrugDispenseSummary(DispenseSummary s, Html h) {
        ((Html)h.div()).id("summary-dispense-" + s.id);
        ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("2px")).bgcolor("#F0F0F0")).color("#000000");
        SqimHtmlFormatter.trbold(h, s.drugName);
        SqimHtmlFormatter.tr(h, s.drugDescription);
        SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(s.drugCode));
        SqimHtmlFormatter.tr(h, "Version", s.prescriptionVersion);
        if (s.drugFormCode != null) {
            SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(s.drugFormCode));
        }
        SqimHtmlFormatter.tr(h, "Auteur", SqimHtmlFormatter.formatAuthor(s.prescriber));
        if (s.prescriptionDate != null) {
            SqimHtmlFormatter.tr(h, "Date de prescription", LocalDate.fromTimeInMillisLOCAL((Long)s.prescriptionDate).formatSlash());
        }
        SqimHtmlFormatter.tr(h, "No. identification prescription", s.prescriptionId);
        SqimHtmlFormatter.tr(h, "Status prescription", s.prescriptionStatus);
        SqimHtmlFormatter.tr(h, "Dur\u00e9e d'usage pr\u00e9vu", SqimHtmlFormatter.formatDuration(null, null, s.expectedUseTime));
        SqimHtmlFormatter.tr(h, "Quantit\u00e9", s.quantity == null ? null : s.quantity.toString());
        SqimHtmlFormatter.tr(h, "Instruction de dosage", s.dosageInstructions);
        if (s.drugIngredients != null && s.drugIngredients.size() > 0) {
            SqimHtmlFormatter.trbold(h, "Ingr\u00e9dients");
            for (Ingredient ing : s.drugIngredients) {
                SqimHtmlFormatter.formatIngredient(h, ing);
            }
        }
        if (s.hasAnnotations != null || s.hasIssues != null) {
            h.tr();
            if (s.hasAnnotations != null) {
                SqimHtmlFormatter.tdBoolean(h, s.hasAnnotations, "Avec annotations", "Sans annotation", "color: orange;", "color: green;");
            }
            if (s.hasIssues != null) {
                SqimHtmlFormatter.tdBoolean(h, s.hasAnnotations, "Avec probl\u00e9mes", "Sans probl\u00e9me", "color: orange;", "color: green;");
            }
            h.end();
        }
        SqimHtmlFormatter.tr(h, "Ex\u00e9cutant", SqimHtmlFormatter.formatAuthor(s.performer));
        SqimHtmlFormatter.tr(h, "Lieu de d\u00e9livrance", SqimHtmlFormatter.formatLocation(s.location, null));
        SqimHtmlFormatter.tr(h, "Date de d\u00e9livrance", s.date == null ? null : LocalDate.fromTimeInMillisLOCAL((Long)s.date).formatSlash());
        h.end();
        h.end();
    }

    public static void formatPrescriptionSummary(IPrescriptionSummary d, Html h) {
        if (d instanceof PrescriptionDeviceSummary) {
            SqimHtmlFormatter.formatPrescriptionDeviceSummary((PrescriptionDeviceSummary)d, h);
        } else if (d instanceof PrescriptionDrugSummary) {
            SqimHtmlFormatter.formatPrescriptionDrugSummary((PrescriptionDrugSummary)d, h);
        }
    }

    public static void formatPrescriptionDeviceSummary(PrescriptionDeviceSummary s, Html h) {
        h.hr();
        ((Html)h.div()).id("summary-oe-" + s.id);
        ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("2px")).bgcolor("#F0F0F0")).color("#000000");
        SqimHtmlFormatter.device(h, s.device);
        SqimHtmlFormatter.tr(h, "Date", DateUtil.format((Long)s.datetime, (String)"yyyy-MM-dd"));
        SqimHtmlFormatter.tr(h, "Statut", SqimHtmlFormatter.formatCode(s.status));
        if (Boolean.TRUE.equals(s.hasIssues)) {
            SqimHtmlFormatter.tr(h, "Contient des \u00e9v\u00e9nements", "oui");
        }
        if (Boolean.TRUE.equals(s.hasAnnotations)) {
            SqimHtmlFormatter.tr(h, "Contient des annotations", "oui");
        }
        SqimHtmlFormatter.tr(h, "Auteur", SqimHtmlFormatter.formatAuthor(s.prescriber));
        SqimHtmlFormatter.tr(h, "Num\u00e9ro", s.id + ", " + s.version);
        SqimHtmlFormatter.tr(h, "Autorit\u00e9 de la version \u00e9lectronique", SqimHtmlFormatter.nvlb(s.electronicVersionHasAuthority));
        SqimHtmlFormatter.formatIntentionsTherapeuticsTR(s.reasons, h);
        if (s.usageInstructions != null && !s.usageInstructions.isEmpty()) {
            SqimHtmlFormatter.tr(h, "Usage instruction", s.usageInstructions);
        }
        h.end();
        if (s.refusalsToFill != null && s.refusalsToFill.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Refus de d\u00e9livrance")).end()).end()).end();
            Collections.sort(s.refusalsToFill, new Comparator<Refusal>(){

                @Override
                public int compare(Refusal o1, Refusal o2) {
                    return o1.date.compareTo(o2.date);
                }
            });
            for (Refusal r : s.refusalsToFill) {
                ((Html)((Html)h.tr()).td()).colspan("2");
                ((Html)((Html)((Html)((Html)h.table()).border("0")).cellpadding("2px")).bgcolor("#A0F0F0")).color("#000000");
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).text("Date : ")).text(SqimHtmlFormatter.nvlt(r.date))).end()).td()).text("Auteur : ")).text(SqimHtmlFormatter.formatAuthor(r.author))).end()).end()).tr()).td()).colspan("2")).text("Lieu : ")).text(SqimHtmlFormatter.formatLocation(r.location, null))).end()).end();
                for (RefusalReason reason : r.reasons) {
                    h.tr();
                    String text = SqimHtmlFormatter.formatCode(reason.code);
                    if (StringUtils.isNotBlank((String)reason.text)) {
                        text = text + " - " + reason.text;
                    }
                    ((Html)((Html)((Html)h.td()).colspan("2")).text(text)).end();
                    h.end();
                }
                h.end();
                ((Html)h.end()).end();
            }
            h.end();
        }
        h.end();
    }

    public static void formatPrescriptionDrugSummaryDM(PrescriptionDrugSummary s, Html h) {
        ((Html)h.div()).id("summary-dm-" + s.id);
        SqimHtmlFormatter.formatPrescriptionDrugSummary(s, h);
        h.end();
    }

    public static void formatPrescriptionDrugSummaryOE(PrescriptionDrugSummary s, Html h) {
        ((Html)h.div()).id("summary-oe-" + s.id);
        SqimHtmlFormatter.formatPrescriptionDrugSummary(s, h);
        h.end();
    }

    public static void formatPrescriptionDrugSummary(PrescriptionDrugSummary s, Html h) {
        ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("2px")).bgcolor("#F0F0F0")).color("#000000");
        SqimHtmlFormatter.medicationGood(h, s.medication);
        SqimHtmlFormatter.tr(h, "Date", DateUtil.format((Long)s.datetime, (String)"yyyy-MM-dd"));
        SqimHtmlFormatter.tr(h, "Statut", SqimHtmlFormatter.formatCode(s.status));
        if (Boolean.TRUE.equals(s.hasIssues)) {
            SqimHtmlFormatter.tr(h, "Contient des \u00e9v\u00e9nements", "oui");
        }
        if (Boolean.TRUE.equals(s.hasAnnotations)) {
            SqimHtmlFormatter.tr(h, "Contient des annotations", "oui");
        }
        SqimHtmlFormatter.tr(h, "Auteur", SqimHtmlFormatter.formatAuthor(s.prescriber));
        SqimHtmlFormatter.tr(h, "Num\u00e9ro", s.id + ", " + s.version);
        SqimHtmlFormatter.tr(h, "Autorit\u00e9 de la version \u00e9lectronique", SqimHtmlFormatter.nvlb(s.electronicVersionHasAuthority));
        SqimHtmlFormatter.formatIntentionsTherapeuticsTR(s.reasons, h);
        if (s.treatmentTypeCode != null) {
            SqimHtmlFormatter.tr(h, "Type de traitement", SqimHtmlFormatter.formatCode(s.treatmentTypeCode));
        }
        SqimHtmlFormatter.trbold(h, "Instruction de dosage");
        SqimHtmlFormatter.tr(h, s.dosageText);
        SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(s.dosageCode));
        h.end();
        ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("2px")).bgcolor("#F0F0F0")).color("#000000");
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Demandes de d\u00e9livrance")).end()).end()).end();
        SqimHtmlFormatter.tr(h, "Statut", SqimHtmlFormatter.formatCode(s.supplyRequestStatusCode));
        if (s.supplyRequestQuantity != null) {
            SqimHtmlFormatter.tr(h, "Quantit\u00e9", s.supplyRequestQuantity.toString());
        }
        SqimHtmlFormatter.tr(h, "Lieu de ramassage", SqimHtmlFormatter.formatLocation(s.supplyRequestLocation, null));
        SqimHtmlFormatter.tr(h, "Condition de substitution du lieu de ramassage", SqimHtmlFormatter.formatCode(s.supplyRequestSubstitutionConditionCode));
        h.end();
        SqimHtmlFormatter.supplyEventSummary(s.supplyEventSummary, h);
        if (s.refusalsToFill != null && s.refusalsToFill.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Refus de d\u00e9livrance")).end()).end()).end();
            Collections.sort(s.refusalsToFill, new Comparator<Refusal>(){

                @Override
                public int compare(Refusal o1, Refusal o2) {
                    return o1.date.compareTo(o2.date);
                }
            });
            for (Refusal r : s.refusalsToFill) {
                ((Html)((Html)h.tr()).td()).colspan("2");
                ((Html)((Html)((Html)((Html)h.table()).border("0")).cellpadding("2px")).bgcolor("#A0F0F0")).color("#000000");
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).text("Date : ")).text(SqimHtmlFormatter.nvlt(r.date))).end()).td()).text("Auteur : ")).text(SqimHtmlFormatter.formatAuthor(r.author))).end()).end()).tr()).td()).colspan("2")).text("Lieu : ")).text(SqimHtmlFormatter.formatLocation(r.location, null))).end()).end();
                for (RefusalReason reason : r.reasons) {
                    h.tr();
                    String text = SqimHtmlFormatter.formatCode(reason.code);
                    if (StringUtils.isNotBlank((String)reason.text)) {
                        text = text + " - " + reason.text;
                    }
                    ((Html)((Html)((Html)h.td()).colspan("2")).text(text)).end();
                    h.end();
                }
                h.end();
                ((Html)h.end()).end();
            }
            h.end();
        }
    }

    private static void supplyEventSummary(SupplyEventSummary ses, Html h) {
        if (ses != null && (ses.firstDispensedQuantity != null || ses.firstDispensePickupDate != null || ses.lastDispensedQuantity != null || ses.lastDispensePickupDate != null || ses.numberOfFillMadeAgainstRx != null || ses.totalSuppliedAmount != null || ses.fillsRemaining != null || ses.remainingTotalQuantity != null)) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("2px")).bgcolor("#F0F0F0")).color("#000000");
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Sommaire des d\u00e9livrances")).end()).end()).end();
            if (ses.firstDispensedQuantity != null || ses.firstDispensePickupDate != null) {
                SqimHtmlFormatter.tr(h, "Premi\u00e8re d\u00e9livrance", new JoinList(" le ", new Object[]{ses.firstDispensedQuantity, SqimHtmlFormatter.date(ses.firstDispensePickupDate)}).toString());
            }
            if (ses.lastDispensedQuantity != null || ses.lastDispensePickupDate != null) {
                SqimHtmlFormatter.tr(h, "Derni\u00e8re d\u00e9livrance", new JoinList(" le ", new Object[]{ses.lastDispensedQuantity, SqimHtmlFormatter.date(ses.lastDispensePickupDate)}).toString());
            }
            if (ses.numberOfFillMadeAgainstRx != null || ses.totalSuppliedAmount != null) {
                SqimHtmlFormatter.tr(h, "Nombre d\u00e9livrances faites", new JoinList(" totalisant ", new Object[]{ses.numberOfFillMadeAgainstRx, ses.totalSuppliedAmount}).toString());
            }
            if (ses.fillsRemaining != null || ses.remainingTotalQuantity != null) {
                SqimHtmlFormatter.tr(h, "Nombre d\u00e9livrances restantes", new JoinList(" totalisant ", new Object[]{ses.fillsRemaining, ses.remainingTotalQuantity}).toString());
            }
            h.end();
        }
    }

    public static String formatPrescriptionDrugDetails(PrescriptionDrugDetails s) {
        if (s == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        Html h = new Html((Writer)writer);
        ((Html)h.div()).attr(new String[]{"idObj", "" + s.id});
        ((Html)h.table()).classAttr("dsq-detail-box");
        SqimHtmlFormatter.medicationGood(h, s.medication);
        SqimHtmlFormatter.tr(h, "Date", DateUtil.format((Long)s.datetime, (String)"yyyy-MM-dd"));
        SqimHtmlFormatter.tr(h, "Statut", SqimHtmlFormatter.formatCode(s.status));
        SqimHtmlFormatter.tr(h, "Auteur", SqimHtmlFormatter.formatAuthor(s.prescriber));
        SqimHtmlFormatter.tr(h, "Num\u00e9ro", s.id + ", " + s.version);
        SqimHtmlFormatter.tr(h, "Autorit\u00e9 de la version \u00e9lectronique", SqimHtmlFormatter.nvlb(s.electronicVersionHasAuthority));
        if (s.previousPrescriptionId != null && s.previousPrescriptionVersion != null) {
            SqimHtmlFormatter.tr(h, "Remplace la prescr. no ", s.previousPrescriptionId + ", " + s.previousPrescriptionVersion);
        }
        if (s.location != null) {
            SqimHtmlFormatter.tr(h, "Lieu d'origine", SqimHtmlFormatter.formatLocation(s.location, null));
        }
        SqimHtmlFormatter.formatIntentionsTherapeuticsTR(s.reasons, h);
        if (s.treatmentTypeCode != null) {
            SqimHtmlFormatter.tr(h, "Type de traitement", SqimHtmlFormatter.formatCode(s.treatmentTypeCode));
        }
        if (s.referenceProtocols != null) {
            for (Object ref : s.referenceProtocols) {
                SqimHtmlFormatter.tr(h, "Protocol de r\u00e9f\u00e9rence", SqimHtmlFormatter.formatReferenceProtocole((ReferenceProtocol)ref));
            }
        }
        if (!Boolean.TRUE.equals(s.notEligibleForTrial)) {
            SqimHtmlFormatter.tr(h, "\u00c9ligible pour des \u00e9chantillons ?", SqimHtmlFormatter.nvlb(!Boolean.TRUE.equals(s.notEligibleForTrial)) + ", " + SqimHtmlFormatter.formatCode(s.trialSupplyPermissionCode));
        } else {
            SqimHtmlFormatter.tr(h, "\u00c9ligible pour des \u00e9chantillons ?", SqimHtmlFormatter.nvlb(!Boolean.TRUE.equals(s.notEligibleForTrial)));
        }
        if (Boolean.TRUE.equals(s.substitutionNotAllowedIndicator)) {
            SqimHtmlFormatter.tr(h, "Pas de substitution", SqimHtmlFormatter.formatCode(s.substitutionNotAllowedReasonCode));
        } else if (s.substitutionPermissionCode != null) {
            SqimHtmlFormatter.tr(h, "Substitution permise", SqimHtmlFormatter.formatCode(s.substitutionPermissionCode));
        }
        SqimHtmlFormatter.dosageInstructions2(s.dosageInstructions, h);
        h.end();
        ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Demandes de d\u00e9livrance")).end()).end()).end();
        SqimHtmlFormatter.tr(h, "Statut", s.supplyRequestStatusCode);
        if (s.supplyRequestAllowedPeriodDuration != null || s.supplyRequestAllowedPeriodLowDate != null || s.supplyRequestAllowedPeriodHighDate != null) {
            SqimHtmlFormatter.tr(h, "P\u00e9riode de validit\u00e9", SqimHtmlFormatter.formatDuration(s.supplyRequestAllowedPeriodLowDate, s.supplyRequestAllowedPeriodHighDate, s.supplyRequestAllowedPeriodDuration));
        }
        if (s.supplyRequestItems != null && s.supplyRequestItems.size() > 0) {
            ((Html)((Html)h.tr()).td()).colspan("2");
            ((Html)((Html)((Html)((Html)((Html)h.table()).style("float:left;")).border("0")).cellpadding("1px")).bgcolor("#F0F0F0")).color("#000000");
            int i = 0;
            for (SupplyRequestItem d : s.supplyRequestItems) {
                SqimHtmlFormatter.trbold(h, "Demande " + ++i);
                if (d.totalDaysSupply != null) {
                    SqimHtmlFormatter.tr(h, "Dur\u00e9e totale prescrite", SqimHtmlFormatter.nvl(d.totalDaysSupply) + " (jrs)");
                }
                SqimHtmlFormatter.tr(h, "Quantit\u00e9 totale prescrite", SqimHtmlFormatter.nvl(d.totalQuantity));
                if (d.numberOfFills != null) {
                    SqimHtmlFormatter.tr(h, "Nombre de d\u00e9livrances", String.valueOf(d.numberOfFills.intValue() - 1));
                }
                if (d.fillQuantity != null) {
                    SqimHtmlFormatter.tr(h, "Quantit\u00e9 d'une d\u00e9livrance", String.valueOf(d.fillQuantity));
                }
                if (d.fillExpectedUseTime != null) {
                    SqimHtmlFormatter.tr(h, "Dur\u00e9e d'une d\u00e9livrance", String.valueOf(d.fillExpectedUseTime));
                }
                if (d.dispenseInterval != null) {
                    SqimHtmlFormatter.tr(h, "Intervalle entre les d\u00e9livrance", String.valueOf(d.dispenseInterval));
                }
                if (d.firstFillExpectedUseTime != null || d.firstFillQuantity != null || d.firstFillExpiryDate != null) {
                    if (d.firstFillQuantity != null) {
                        SqimHtmlFormatter.tr(h, "Quantit\u00e9 de la premi\u00e8re d\u00e9livrance", String.valueOf(d.firstFillQuantity));
                    }
                    if (d.firstFillExpectedUseTime != null) {
                        SqimHtmlFormatter.tr(h, "Dur\u00e9e de la premi\u00e8re d\u00e9livrance", String.valueOf(d.fillExpectedUseTime));
                    }
                    if (d.firstFillExpiryDate != null) {
                        SqimHtmlFormatter.tr(h, "Date d'expiration de l'ordonnance", SqimHtmlFormatter.nvld(d.firstFillExpiryDate));
                    }
                }
                if (d.medication == null) continue;
                SqimHtmlFormatter.trbold(h, "M\u00e9dication");
                SqimHtmlFormatter.medicationGood(h, d.medication);
            }
            h.end();
            ((Html)h.end()).end();
        }
        SqimHtmlFormatter.tr(h, "Lieu de ramassage", SqimHtmlFormatter.formatLocation(s.supplyRequestLocation, null));
        SqimHtmlFormatter.tr(h, "Condition de substitution du lieu de ramassage", SqimHtmlFormatter.formatCode(s.supplyRequestLocationSubstitutionConditionCode));
        SqimHtmlFormatter.tr(h, "Date du ramassage", SqimHtmlFormatter.nvld(s.supplyRequestLocationPickupDate));
        h.end();
        SqimHtmlFormatter.supplyEventSummary(s.supplyEventSummary, h);
        if (s.refusalsToFill != null && s.refusalsToFill.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Refus de d\u00e9livrance")).end()).end()).end();
            Collections.sort(s.refusalsToFill, new Comparator<Refusal>(){

                @Override
                public int compare(Refusal o1, Refusal o2) {
                    return o1.date.compareTo(o2.date);
                }
            });
            for (Refusal r : s.refusalsToFill) {
                ((Html)((Html)h.tr()).td()).colspan("2");
                ((Html)((Html)((Html)((Html)h.table()).border("0")).cellpadding("2px")).bgcolor("#A0F0F0")).color("#000000");
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).text("Date : ")).text(SqimHtmlFormatter.nvlt(r.date))).end()).td()).text("Auteur : ")).text(SqimHtmlFormatter.formatAuthor(r.author))).end()).end()).tr()).td()).colspan("2")).text("Lieu : ")).text(SqimHtmlFormatter.formatLocation(r.location, null))).end()).end();
                for (RefusalReason reason : r.reasons) {
                    h.tr();
                    String text = SqimHtmlFormatter.formatCode(reason.code);
                    if (StringUtils.isNotBlank((String)reason.text)) {
                        text = text + " - " + reason.text;
                    }
                    ((Html)((Html)((Html)h.td()).colspan("2")).text(text)).end();
                    h.end();
                }
                h.end();
                ((Html)h.end()).end();
            }
            h.end();
        }
        SqimHtmlFormatter.issues(s.detectedIssueEvents, h);
        if (s.annotations != null && s.annotations.size() > 0) {
            SqimHtmlFormatter.annotations(s.annotations, h);
        }
        if (s.medicationDispense != null) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Derni\u00e8re m\u00e9dication d\u00e9livr\u00e9e")).end()).end()).end();
            MedicationDispense md = s.medicationDispense;
            ((Html)((Html)h.tr()).td()).colspan("2");
            ((Html)((Html)((Html)((Html)h.table()).border("0")).cellpadding("2px")).bgcolor("#F0F0F0")).color("#000000");
            SqimHtmlFormatter.tr(h, "Num\u00e9ro de d\u00e9livrance", md.dispenseNumber);
            SqimHtmlFormatter.tr(h, "Date", SqimHtmlFormatter.date(md.dispenseProcessingAndPickupDate));
            SqimHtmlFormatter.tr(h, "Ex\u00e9cutant", SqimHtmlFormatter.formatAuthor(md.performer));
            SqimHtmlFormatter.tr(h, "Lieu", SqimHtmlFormatter.formatLocation(md.location, null));
            SqimHtmlFormatter.tr(h, "Type", SqimHtmlFormatter.formatCode(md.dispenseType));
            SqimHtmlFormatter.tr(h, "Quantit\u00e9", SqimHtmlFormatter.nvl(md.dispensedQuantity));
            SqimHtmlFormatter.tr(h, "Dur\u00e9e", SqimHtmlFormatter.nvl(md.dispensedDaysSupply));
            if (md.substitutionMade != null) {
                SqimHtmlFormatter.substitutionMadeFormat(h, md.substitutionMade);
            }
            SqimHtmlFormatter.medicationGood(h, md.medication);
            SqimHtmlFormatter.dosageInstructions2(md.dosageInstructions, h);
            h.end();
            h.end();
            h.end();
        }
        if (s.historyStatusChanges != null && s.historyStatusChanges.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Historique des \u00e9v\u00e9nements")).end()).end()).end();
            Collections.sort(s.historyStatusChanges, new Comparator<HistoryStatusChange>(){

                @Override
                public int compare(HistoryStatusChange o1, HistoryStatusChange o2) {
                    return -o1.changeTimestamp.compareTo(o2.changeTimestamp);
                }
            });
            for (HistoryStatusChange e : s.historyStatusChanges) {
                ((Html)((Html)((Html)h.tr()).td()).colspan("2")).border("1");
                ((Html)((Html)((Html)((Html)h.table()).border("0")).cellpadding("2px")).bgcolor("#A0A0A0")).color("#000000");
                SqimHtmlFormatter.tr(h, "Date", SqimHtmlFormatter.datetime(e.changeTimestamp));
                SqimHtmlFormatter.tr(h, "P\u00e9riode d'effet", SqimHtmlFormatter.formatDuration(e.changeEffectivePeriodStart, e.changeEffectivePeriodEnd, null));
                SqimHtmlFormatter.tr(h, "Type", SqimHtmlFormatter.formatCode(e.changeType));
                SqimHtmlFormatter.tr(h, "Raison", SqimHtmlFormatter.formatCode(e.changeReason));
                SqimHtmlFormatter.tr(h, "Auteur", SqimHtmlFormatter.formatAuthor(e.changeBy));
                SqimHtmlFormatter.tr(h, "Application", e.applicationName);
                h.end();
                h.end();
            }
            h.end();
        }
        h.end();
        return writer.toString();
    }

    public static String formatReferenceProtocole(ReferenceProtocol referenceProtocol) {
        String s = "";
        if (referenceProtocol != null) {
            String id;
            String c = null;
            if (referenceProtocol.code != null && !"DRUG".equals(referenceProtocol.code.code)) {
                c = SqimHtmlFormatter.formatCode(referenceProtocol.code);
            }
            if ((id = referenceProtocol.id.extension) != null) {
                s = s + id;
                if (c != null) {
                    s = s + " - ";
                }
            }
            if (c != null) {
                s = s + c;
            }
        }
        return s;
    }

    private static void substitutionMadeFormat(Html h, SubstitutionMade substitutionMade) {
        SqimHtmlFormatter.tr(h, "Substitution", substitutionMade.substitutionCode == null ? "" : DsqFormatter.formatCode(substitutionMade.substitutionCode));
        if (substitutionMade.productSelectionReasonCode != null) {
            SqimHtmlFormatter.tr(h, "Raison", substitutionMade.productSelectionReasonCode == null ? "" : DsqFormatter.formatCode(substitutionMade.productSelectionReasonCode));
        }
        if (substitutionMade.substitutingPersonIdentifier != null) {
            if (substitutionMade.substitutingCandidate != null) {
                SqimHtmlFormatter.tr(h, "Auteur", "Patient");
            } else if (substitutionMade.substitutingProvider != null) {
                IProvider provider = substitutionMade.substitutingProvider;
                NIU niu = provider.getNIU_COLLEGE();
                if (niu instanceof NIU_COLLEGE) {
                    NIU_COLLEGE niu_COLLEGE = (NIU_COLLEGE)niu;
                    if (niu_COLLEGE.college() == College.College_de_medecins_du_Quebec) {
                        SqimHtmlFormatter.tr(h, "Auteur", "M\u00e9decin");
                    } else if (niu_COLLEGE.college() == College.Ordre_des_pharmaciens_du_Quebec) {
                        SqimHtmlFormatter.tr(h, "Auteur", "Pharmacien");
                    } else {
                        SqimHtmlFormatter.tr(h, "Auteur", "Autre intervenant");
                    }
                } else {
                    SqimHtmlFormatter.tr(h, "Auteur", "Autre intervenant");
                }
            } else {
                SqimHtmlFormatter.tr(h, "Auteur", "non-r\u00e9solu (" + substitutionMade.substitutingPersonIdentifier.value() + ")");
            }
        }
    }

    private static void dosageInstructions2(ArrayList<DosageInstruction> dosageInstructions, XPrescription s, Html h) {
        if (dosageInstructions != null && dosageInstructions.size() > 0 && StringUtils.isNotBlank((String)s.getPosology())) {
            h.tr();
            String p = s.getPosology().replaceAll("\n", "<br/>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            ((Html)((Html)((Html)h.td()).colspan("3")).raw(p)).end();
            h.end();
        }
    }

    private static void dosageInstructions2(ArrayList<DosageInstruction> dosageInstructions, Html h) {
        if (dosageInstructions != null && dosageInstructions.size() > 0) {
            h.tr();
            ((Html)h.td()).colspan("2");
            int i = 0;
            for (DosageInstruction di : dosageInstructions) {
                ((Html)((Html)((Html)((Html)((Html)h.table()).style("float:left; margin: 2px;")).border("0")).cellpadding("0px")).bgcolor("#F0F0F0")).color("#000000");
                SqimHtmlFormatter.trbold(h, "Instruction " + ++i);
                if (StringUtils.isNotBlank((String)di.additionnalInstructions)) {
                    SqimHtmlFormatter.tr(h, di.text);
                    h.tr();
                    ((Html)((Html)((Html)((Html)h.td()).colspan("2")).style("border-bottom:1px solid black;")).text(di.additionnalInstructions)).end();
                    h.end();
                } else if (StringUtils.isNotBlank((String)di.text)) {
                    h.tr();
                    ((Html)((Html)((Html)((Html)h.td()).colspan("2")).style("border-bottom:1px solid black;")).text(di.text)).end();
                    h.end();
                }
                if (di.fromDate != null || di.toDate != null || di.duration != null) {
                    SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatDuration(di.fromDate, di.toDate, di.duration));
                }
                if (di.administrationUnitCode != null) {
                    SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(di.administrationUnitCode));
                }
                if (di.routeCode != null) {
                    SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(di.routeCode));
                }
                if (di.maxDoseNumerators != null && di.maxDoseDenominators != null) {
                    Iterator dose1 = di.maxDoseNumerators.iterator();
                    Iterator dose2 = di.maxDoseDenominators.iterator();
                    while (dose1.hasNext() && dose2.hasNext()) {
                        SqimHtmlFormatter.tr(h, "Dose maximale", dose1.next() + " / " + dose2.next());
                    }
                }
                if (di.approachSiteCodes != null && di.approachSiteCodes.size() > 0) {
                    for (Code code : di.approachSiteCodes) {
                        SqimHtmlFormatter.tr(h, "Site", SqimHtmlFormatter.formatCode(code));
                    }
                }
                if (di.consumable != null) {
                    ((Html)((Html)((Html)h.tr()).td()).style("border-top: 1px solid black;")).colspan("2");
                    SqimHtmlFormatter.medicationGood(h, di.consumable);
                    ((Html)h.end()).end();
                }
                h.end();
            }
            h.end();
            h.end();
        }
    }

    public static String formatDuration(Long fromDate, Long toDate, Duration duration) {
        if (fromDate != null && toDate != null) {
            return DateUtil.format((Long)fromDate, (String)"yyyy-MM-dd") + " au " + DateUtil.format((Long)toDate, (String)"yyyy-MM-dd");
        }
        if (fromDate != null && duration != null) {
            return "Pour " + duration + " \u00e0 partir du " + DateUtil.format((Long)fromDate, (String)"yyyy-MM-dd");
        }
        if (duration != null) {
            return "Pour " + duration;
        }
        if (fromDate != null) {
            return "\u00c0 partir du " + DateUtil.format((Long)fromDate, (String)"yyyy-MM-dd");
        }
        if (toDate != null) {
            return "Jusqu'au " + DateUtil.format((Long)toDate, (String)"yyyy-MM-dd");
        }
        return null;
    }

    public static String formatDuration2(String fromDate, String toDate, Duration duration) {
        if (fromDate != null && toDate != null) {
            return fromDate + " au " + toDate;
        }
        if (fromDate != null && duration != null) {
            return "Pour " + duration + " \u00e0 partir du " + fromDate;
        }
        if (duration != null) {
            return "Pour " + duration;
        }
        if (fromDate != null) {
            return "\u00c0 partir du " + fromDate;
        }
        if (toDate != null) {
            return "Jusqu'au " + toDate;
        }
        return null;
    }

    private static void tr(Html h, String col) {
        if (StringUtils.isNotBlank((String)col)) {
            h.tr();
            ((Html)((Html)((Html)h.td()).colspan("2")).text(col)).end();
            h.end();
        }
    }

    private static void trbold(Html h, String col) {
        if (StringUtils.isNotBlank((String)col)) {
            h.tr();
            ((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).b()).text(col)).end()).end();
            h.end();
        }
    }

    private static void trboldFirstOnly(Html h, String ... cols) {
        if (cols != null && cols.length > 0) {
            h.tr();
            for (int i = 0; i < cols.length; ++i) {
                String c = cols[i];
                if (i == 0) {
                    ((Html)((Html)((Html)((Html)((Html)h.td()).align("left")).b()).text(c == null ? "" : c)).end()).end();
                    continue;
                }
                ((Html)((Html)((Html)h.td()).align("left")).text(c == null ? "" : c)).end();
            }
            h.end();
        }
    }

    private static void tr(Html h, String col1, String col2) {
        if (StringUtils.isNotBlank((String)col2)) {
            h.tr();
            ((Html)((Html)((Html)h.td()).align("left")).text(col1)).end();
            ((Html)((Html)((Html)h.td()).align("left")).text(col2)).end();
            h.end();
        }
    }

    private static void tr(Html h, String ... cols) {
        if (cols != null && cols.length > 0) {
            h.tr();
            for (String c : cols) {
                ((Html)((Html)h.td()).text(c == null ? "" : c)).end();
            }
            h.end();
        }
    }

    private static void medicationGood(Html h, Medication m, XPrescription s) {
        if (m != null) {
            String din;
            String commercialName = s.getStrength().getCommercialName();
            String genericName = s.getStrength().getGenericName();
            String string = din = s.getDin() == null ? null : s.getDin().toString();
            if (m.ingredients == null || m.ingredients.size() <= 1) {
                h.tr();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).b()).text(commercialName)).end()).i()).text(" (commercial)")).end()).end();
                h.end();
                h.tr();
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).text(genericName)).i()).text(" (g\u00e9n\u00e9rique)")).end()).end();
                h.end();
                h.tr();
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).text(din)).i()).text(" (din)")).end()).end();
                h.end();
                if (m.formCode != null) {
                    h.tr();
                    String text = s.getFormat().name() + " - " + s.getFormat().description();
                    ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).text(text)).i()).text(" (format)")).end()).end();
                    h.end();
                }
            } else {
                h.tr();
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).b()).text(commercialName)).end()).i()).text(" (commercial)")).end()).end();
                h.end();
                h.tr();
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).text(genericName)).i()).text(" (g\u00e9n\u00e9rique)")).end()).end();
                h.end();
                if (m.formCode != null && !SqimHtmlFormatter.formatCode(m.formCode).isEmpty()) {
                    h.tr();
                    String text = s.getFormat().name() + " - " + s.getFormat().description();
                    ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).text(text)).i()).text(" (format)")).end()).end();
                    h.end();
                }
            }
        }
    }

    private static void medicationGood(Html h, Medication m) {
        if (m != null) {
            if (m.ingredients == null || m.ingredients.size() == 0) {
                SqimHtmlFormatter.trbold(h, m.name);
                SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(m.code));
                if (m.formCode != null) {
                    SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(m.formCode));
                }
                if (m.packageContainerFormCode != null && m.packageQuantity != null) {
                    SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(m.packageContainerFormCode) + ", " + m.packageQuantity);
                }
                if (m.description != null && !m.description.isEmpty()) {
                    SqimHtmlFormatter.tr(h, m.description);
                }
            } else {
                if (StringUtils.isBlank((CharSequence)m.name)) {
                    SqimHtmlFormatter.trbold(h, "Magistrale");
                } else {
                    SqimHtmlFormatter.trbold(h, m.name);
                }
                if (m.description != null && !m.description.isEmpty()) {
                    SqimHtmlFormatter.tr(h, "Description", m.description);
                }
                if (m.formCode != null && !SqimHtmlFormatter.formatCode(m.formCode).isEmpty()) {
                    SqimHtmlFormatter.tr(h, "Format", SqimHtmlFormatter.formatCode(m.formCode));
                }
                if (m.packageContainerFormCode != null && m.packageQuantity != null) {
                    SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(m.packageContainerFormCode) + ", " + m.packageQuantity);
                }
                Collections.sort(m.ingredients, new Comparator<Ingredient>(){

                    @Override
                    public int compare(Ingredient o1, Ingredient o2) {
                        if (o1.code == o2.code) {
                            return 0;
                        }
                        if (o1.code == null) {
                            return -1;
                        }
                        if (o2.code == null) {
                            return 1;
                        }
                        if (o1.code.code == o2.code.code) {
                            return 0;
                        }
                        if (o1.code.code == null) {
                            return -1;
                        }
                        if (o2.code.code == null) {
                            return 1;
                        }
                        return o1.code.code.compareTo(o2.code.code);
                    }
                });
                ((Html)((Html)h.tr()).td()).colspan("2");
                ((Html)((Html)((Html)((Html)h.table()).border("0")).cellpadding("2px")).bgcolor("#F0F0F0")).color("#000000");
                int i = 0;
                for (Ingredient e : m.ingredients) {
                    String name = ++i + ".  " + e.name + (e.code == null ? "" : "  (" + SqimHtmlFormatter.formatCode(e.code) + ")");
                    String qty = (e.quantity == null ? "" : e.quantity).toString();
                    String protocol = e.referenceProtocolId == null ? "" : " " + e.referenceProtocolId;
                    SqimHtmlFormatter.tr(h, name, qty, protocol);
                }
                h.end();
                ((Html)h.end()).end();
            }
            SqimHtmlFormatter.tr(h, "Num\u00e9ro de lot", m.lotNumberText);
            SqimHtmlFormatter.tr(h, "Date d'expiration", m.expirationTime);
        }
    }

    private static void device(Html h, Device d) {
        if (d != null) {
            if (d.name != null) {
                SqimHtmlFormatter.trbold(h, d.name);
            }
            if (d.devicePackageQuantity != null) {
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("2")).b()).text("Qt\u00e9.:")).end()).text("" + d.devicePackageQuantity)).end()).end();
            }
            if (SqimHtmlFormatter.formatCode(d.code) != null && !SqimHtmlFormatter.formatCode(d.code).isEmpty()) {
                SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(d.code));
            }
            if (d.desc != null && !d.desc.isEmpty()) {
                SqimHtmlFormatter.tr(h, d.desc);
            }
        }
    }

    public static String formatGetDevicePrescriptionDetails(PrescriptionDeviceDetails s) {
        StringWriter writer = new StringWriter();
        Html html = new Html((Writer)writer);
        if (s == null) {
            return "";
        }
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.table()).attr(new String[]{"idObj", s.id})).classAttr("dsq-detail-box")).tr()).th()).align("left")).width("50%")).end()).th()).align("left")).width("50%")).end()).end()).tr()).td()).b()).text("D\u00e9tails - Prescription de Fourniture")).end()).end()).end()).tr()).end()).tr()).td()).b()).text("Num\u00e9ro ")).end()).text(s.id)).end()).td()).b()).text("Version ")).end()).text(s.version)).end()).end();
        if (s.previousPrescriptionId != null && s.previousPrescriptionVersion != null) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).text("En remplacement de la prescription num\u00e9ro ")).text(s.previousPrescriptionId)).text(", ")).text("version ")).text(s.previousPrescriptionVersion)).end()).end();
        }
        ((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Lieu d'origine : ")).end();
        SqimHtmlFormatter.formatLocation(s.location, html);
        ((Html)html.end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Autorit\u00e9 de la version \u00e9lectronique : ")).end()).text(SqimHtmlFormatter.nvlb(s.electronicVersionHasAuthority))).end()).end()).tr()).end()).tr()).td()).colspan("2")).b()).text("Intentions th\u00e9rapeutiques : ")).end();
        List<String> reasons = SqimHtmlFormatter.formatIntentionsTherapeutics(s.reasons);
        for (String reason : reasons) {
            ((Html)html.p()).style("margin: 0px; text-indent: 1em;");
            html.text(reason);
            html.end();
        }
        html.end();
        html.end();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Fourniture : ")).end()).end()).end();
        SqimHtmlFormatter.device(html, s.device);
        if (s.usageInstructions != null) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Instructions : ")).end()).text(s.usageInstructions)).end()).end();
        }
        if (s.supplyRequestLocation != null) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Lieu de ramassage : ")).end()).text(SqimHtmlFormatter.formatLocation(s.supplyRequestLocation, null))).end()).end();
        }
        if (s.supplyRequestLocationPickupDate != null) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Date du ramassage : ")).end()).text(SqimHtmlFormatter.nvld(s.supplyRequestLocationPickupDate))).end()).end();
        }
        if (s.supplyRequestFillQuantity != null) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Qt\u00e9. ramassage : ")).end()).text(s.supplyRequestFillQuantity.toString())).end()).end();
        }
        if (s.supplyRequestTotalQuantity != null) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Qt\u00e9. total de ramassage : ")).end()).text(s.supplyRequestTotalQuantity.toString())).end()).end();
        }
        if (s.supplyRequestNumberOfFills != null) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Nb. ramassage : ")).end()).text(s.supplyRequestNumberOfFills + "")).end()).end();
        }
        if (s.supplyRequestTotalDaysSupply != null) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Nb. jour total de ramassage : ")).end()).text(SqimHtmlFormatter.formatDuration(null, null, s.supplyRequestTotalDaysSupply))).end()).end();
        }
        if (s.refusalsToFill != null && s.refusalsToFill.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("Refus de d\u00e9livrance : ")).end()).end()).end();
            SqimHtmlFormatter.refusal(s.refusalsToFill, html);
        }
        if (s.detectedIssueEvents != null && s.detectedIssueEvents.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).b()).text("\u00c9v\u00e9nements : ")).end()).end()).end();
            SqimHtmlFormatter.issues(s.detectedIssueEvents, html);
        }
        if (s.annotations != null && s.annotations.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).text("Annotations : ")).end()).end();
            SqimHtmlFormatter.annotations(s.annotations, html);
        }
        html.endAll();
        return writer.toString();
    }

    private static String formatCode(String code) {
        if (code == null) {
            return "";
        }
        if (code.startsWith("PORX")) {
            return "";
        }
        return code;
    }

    public static String formatCode(Code code) {
        if (code == null) {
            return "";
        }
        if (!(StringUtils.isBlank((CharSequence)code.code) || StringUtils.isBlank((CharSequence)code.text) || code.code.startsWith("PORX"))) {
            return code.code + " - " + code.text;
        }
        if (!StringUtils.isBlank((CharSequence)code.text)) {
            return code.text;
        }
        if (!StringUtils.isBlank((CharSequence)code.code) && !code.code.startsWith("PORX")) {
            return code.code;
        }
        return "";
    }

    protected static String nvlt(Long s) {
        return DsqFormatter.nvlt(s);
    }

    protected static String nvld(Long s) {
        return DsqFormatter.nvld(s);
    }

    protected static String nvlb(Boolean s) {
        return DsqFormatter.nvlb(s);
    }

    protected static String nvl(Object s) {
        return DsqFormatter.nvl(s);
    }

    protected static String nvl(String s, String df) {
        return DsqFormatter.nvl(s, df);
    }

    protected static String nvl(Long s, String df) {
        return DsqFormatter.nvl(s, df);
    }

    private static String formatAuthor(IProvider p) {
        if (p == null) {
            return "";
        }
        String s = p.getFirstName() + " " + p.getLastName();
        if (p.getNIU_COLLEGE() != null || p.getCode() != null || p.getNIU_I() != null) {
            s = s + " (";
            if (p.getCode() != null) {
                s = s + SqimHtmlFormatter.formatCode(p.getCode());
                if (p.getNIU_COLLEGE() != null || p.getNIU_I() != null) {
                    s = s + " - ";
                }
            }
            if (p.getNIU_COLLEGE() != null) {
                s = s + p.getNIU_COLLEGE().value();
                if (p.getNIU_I() != null) {
                    s = s + " - ";
                }
            }
            if (p.getNIU_I() != null) {
                s = s + p.getNIU_I().value();
            }
            s = s + ")";
        }
        return s;
    }

    private static void formatIntentionsTherapeuticsTR(ArrayList<TherapeuticIntent> list, Html h) {
        List<String> reasons = SqimHtmlFormatter.formatIntentionsTherapeutics(list);
        if (reasons.size() > 0) {
            h.tr();
            ((Html)((Html)h.td()).text("Intentions th\u00e9rapeutiques")).end();
            h.td();
            boolean first = true;
            for (String reason : reasons) {
                if (first) {
                    first = false;
                } else {
                    h.br();
                }
                h.text(reason);
            }
            h.end();
            h.end();
        }
    }

    private static List<String> formatIntentionsTherapeutics(ArrayList<TherapeuticIntent> reasons) {
        ArrayList<String> list = new ArrayList<String>();
        if (reasons != null && reasons.size() > 0 && !"N/A".equals(reasons.get((int)0).otherIndicationText)) {
            Collections.sort(reasons, new Comparator<TherapeuticIntent>(){

                @Override
                public int compare(TherapeuticIntent a, TherapeuticIntent b) {
                    if (a == null && b == null) {
                        return 0;
                    }
                    if (a == null) {
                        return -1;
                    }
                    if (b == null) {
                        return 1;
                    }
                    if (a.priority == null && b.priority == null) {
                        return 0;
                    }
                    if (a.priority == null) {
                        return -1;
                    }
                    if (b.priority == null) {
                        return 1;
                    }
                    return a.priority - b.priority;
                }
            });
            for (TherapeuticIntent reason : reasons) {
                if (reason == null || "N/A".equals(reason.otherIndicationText)) continue;
                String s = "";
                if (reason.priority != null) {
                    s = s + reason.priority.toString() + ". ";
                }
                s = s + new JoinList(", ", new Object[]{SqimHtmlFormatter.formatCode(reason.observationProblemType), SqimHtmlFormatter.formatCode(reason.observationProblemCode), SqimHtmlFormatter.formatCode(reason.otherIndicationCode), reason.otherIndicationText}).toString();
                list.add(s);
            }
        }
        return list;
    }

    private static void medicationDispensed(DispenseSummary m, Html html) {
        if (m != null && m.drugIngredients != null) {
            for (Ingredient i : m.drugIngredients) {
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).text("Ingr\u00e9dient " + (i.code == null ? "" : SqimHtmlFormatter.formatCode(i.code) + " "))).end()).end()).tr()).td()).colspan("2")).text(i.name)).text(" " + (i.quantity == null ? "" : i.quantity))).text(i.referenceProtocolId == null ? "" : " " + i.referenceProtocolId)).text(i.drugDoesNotContains == null ? "(peut contenir)" : (i.drugDoesNotContains != false ? "" : "(ne contient pas)"))).end()).end();
            }
        }
    }

    public static String formatLocation(ILocation location, Html html) {
        if (location != null) {
            JoinList list = new JoinList(", ");
            list.setTrim(true);
            list.add((CharSequence)SqimHtmlFormatter.nvl(location.getCode()));
            list.add((CharSequence)SqimHtmlFormatter.nvl(location.getName()));
            Address address = location.getAddress();
            if (address != null) {
                list.add((CharSequence)address.street);
                list.add((CharSequence)address.city);
                list.add((CharSequence)address.state);
                list.add((CharSequence)address.country);
                list.add((CharSequence)address.postalCode);
                String telecom = address.telecom;
                if (telecom != null) {
                    String lookfor = "0123456789";
                    String newNum = "";
                    while (telecom.length() > 0) {
                        String c = telecom.substring(0, 1);
                        telecom = telecom.substring(1);
                        if (lookfor.indexOf(c) < 0) continue;
                        newNum = newNum + c;
                    }
                    telecom = newNum.length() == 11 ? newNum.substring(0, 1) + " (" + newNum.substring(1, 4) + ") " + newNum.substring(4, 8) + "-" + newNum.substring(8) : (newNum.length() == 10 ? "(" + newNum.substring(0, 3) + ") " + newNum.substring(3, 7) + "-" + newNum.substring(7) : (newNum.length() == 7 ? newNum.substring(0, 4) + "-" + newNum.substring(4) : address.telecom));
                    list.add((CharSequence)telecom);
                }
                JoinList list2 = new JoinList(" ");
                if (location.getNIU() != null) {
                    String state;
                    list2.add((CharSequence)location.getNIU().value());
                    if (location.getNIU().value().equals("8888888888")) {
                        list2.add((CharSequence)"(Lieu inconnu au Qu\u00e9bec)");
                    } else if (location.getNIU().value().equals("9999999999")) {
                        list2.add((CharSequence)"(Lieu inconnu hors Qu\u00e9bec)");
                    } else if (address != null && (state = StringUtils.NormalizeToUppercase((String)address.state)) != null && !"QUEBEC".equals(state)) {
                        list2.add((CharSequence)"(Lieu hors Qu\u00e9bec)");
                    }
                    list.add((CharSequence)list2.toString());
                }
            }
            if (html != null) {
                html.text(list.toString());
            } else {
                return list.toString();
            }
        }
        return "";
    }

    private static void refusal(List<Refusal> list, Html html) {
        if (list != null) {
            for (Refusal r : list) {
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).text("Refus - ")).text("Date : ")).text(SqimHtmlFormatter.nvlt(r.date))).end()).td()).text("Auteur : ")).text(SqimHtmlFormatter.formatAuthor(r.author))).end()).end()).tr()).td()).colspan("2")).text("Lieu : ")).text(SqimHtmlFormatter.formatLocation(r.location, null))).end()).end()).tr()).td()).colspan("2")).b()).text("Raisons : ")).text(SqimHtmlFormatter.refusalReason(r.reasons))).end()).end()).end();
            }
        }
    }

    private static void dispensedStatusChanges(List<DispenseStatusChange> list, Html html) {
        if (list != null) {
            for (DispenseStatusChange r : list) {
                ((Html)((Html)((Html)((Html)((Html)((Html)html.tr()).td()).colspan("2")).text("Auteur ")).text(SqimHtmlFormatter.formatAuthor(r.author))).text(" (")).text(DateUtil.format((Long)r.startdate, (String)"yyyy-MM-dd"));
                if (r.enddate != null) {
                    ((Html)((Html)((Html)((Html)html.text(" au ")).text(DateUtil.format((Long)r.enddate, (String)"yyyy-MM-dd"))).text(")")).end()).end();
                } else {
                    ((Html)((Html)html.text(")")).end()).end();
                }
                if (r.code == null && r.reasonCode == null) continue;
                ((Html)((Html)html.tr()).td()).colspan("2");
                if (r.code != null) {
                    ((Html)html.text("Code : ")).text(SqimHtmlFormatter.formatCode(r.code));
                }
                if (r.reasonCode != null) {
                    ((Html)html.text(" - Raison : ")).text(SqimHtmlFormatter.formatCode(r.reasonCode));
                }
                ((Html)html.end()).end();
            }
        }
    }

    private static String refusalReason(Collection<RefusalReason> list) {
        StringBuilder b = new StringBuilder();
        for (RefusalReason r : list) {
            b.append("\n\t").append(SqimHtmlFormatter.formatCode(r.code) + " - " + SqimHtmlFormatter.nvl(r.text));
        }
        return b.toString();
    }

    private static void issues(ArrayList<DetectedIssueEvent> detectedIssueEvents, Html h) {
        if (detectedIssueEvents != null && detectedIssueEvents.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
            int number = 1;
            for (DetectedIssueEvent a : detectedIssueEvents) {
                JoinList line1 = new JoinList(", ", new Object[]{SqimHtmlFormatter.formatCode(a.code), SqimHtmlFormatter.formatCode(a.priority), SqimHtmlFormatter.formatCode(a.severityObeservationValue)});
                SqimHtmlFormatter.trboldFirstOnly(h, "\u00c9v\u00e9nement " + number, line1.toString());
                if (a.managements != null && a.managements.size() > 0) {
                    for (DetectedIssueManagement m : a.managements) {
                        JoinList line = new JoinList(", ", new Object[]{SqimHtmlFormatter.formatCode(m.code), m.text});
                        JoinList line2 = new JoinList(", ", new Object[]{DateUtil.format((Long)m.time, (String)"yyyy-MM-dd"), SqimHtmlFormatter.formatAuthor(m.author)});
                        h.tr();
                        ((Html)((Html)((Html)h.td()).align("left")).text("> G\u00e9r\u00e9 par")).end();
                        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).align("left")).i()).b()).text(line.toString())).end()).end()).br()).text(line2.toString())).end();
                        h.end();
                    }
                }
                if (a.relatedSubstanceAdministrations == null || a.relatedSubstanceAdministrations.size() <= 0) continue;
                for (SubstanceAdministration sa : a.relatedSubstanceAdministrations) {
                    h.tr();
                    ((Html)((Html)h.td()).text("> Ordonnance en conflit")).end();
                    h.td();
                    ((Html)((Html)((Html)h.table()).cellpadding("2px")).bgcolor("#D0D0D0")).color("#000000");
                    SqimHtmlFormatter.tr(h, "Num\u00e9ro", sa.niu.value());
                    SqimHtmlFormatter.tr(h, "Statut", SqimHtmlFormatter.formatCode(sa.status));
                    SqimHtmlFormatter.tr(h, "Dates", SqimHtmlFormatter.formatDuration2(sa.effectiveTimeStart, sa.effectiveTimeEnd, null));
                    SqimHtmlFormatter.formatMedicationForDetectedIssueEvent(h, sa.medication);
                    h.end();
                    h.end();
                    h.end();
                }
            }
            h.end();
        }
    }

    private static void formatMedicationForDetectedIssueEvent(Html h, Medication m) {
        if (m != null) {
            if (m.ingredients == null || m.ingredients.size() == 0) {
                SqimHtmlFormatter.tr(h, m.name);
                SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(m.code));
                if (m.formCode != null) {
                    SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(m.formCode));
                }
                if (m.packageContainerFormCode != null && m.packageQuantity != null) {
                    SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(m.packageContainerFormCode) + ", " + m.packageQuantity);
                }
                if (m.description != null && !m.description.isEmpty()) {
                    SqimHtmlFormatter.tr(h, m.description);
                }
            } else {
                if (StringUtils.isBlank((CharSequence)m.name)) {
                    SqimHtmlFormatter.trbold(h, "Magistrale");
                } else {
                    SqimHtmlFormatter.trbold(h, m.name);
                }
                if (m.description != null && !m.description.isEmpty()) {
                    SqimHtmlFormatter.tr(h, "Description", m.description);
                }
                if (m.formCode != null && !SqimHtmlFormatter.formatCode(m.formCode).isEmpty()) {
                    SqimHtmlFormatter.tr(h, "Format", SqimHtmlFormatter.formatCode(m.formCode));
                }
                if (m.packageContainerFormCode != null && m.packageQuantity != null) {
                    SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(m.packageContainerFormCode) + ", " + m.packageQuantity);
                }
                Collections.sort(m.ingredients, new Comparator<Ingredient>(){

                    @Override
                    public int compare(Ingredient o1, Ingredient o2) {
                        if (o1.code == o2.code) {
                            return 0;
                        }
                        if (o1.code == null) {
                            return -1;
                        }
                        if (o2.code == null) {
                            return 1;
                        }
                        if (o1.code.code == o2.code.code) {
                            return 0;
                        }
                        if (o1.code.code == null) {
                            return -1;
                        }
                        if (o2.code.code == null) {
                            return 1;
                        }
                        return o1.code.code.compareTo(o2.code.code);
                    }
                });
                ((Html)((Html)h.tr()).td()).colspan("2");
                ((Html)((Html)((Html)((Html)h.table()).border("0")).cellpadding("2px")).bgcolor("#F0F0F0")).color("#000000");
                int i = 0;
                for (Ingredient e : m.ingredients) {
                    String name = ++i + ".  " + e.name + (e.code == null ? "" : "  (" + SqimHtmlFormatter.formatCode(e.code) + ")");
                    String qty = (e.quantity == null ? "" : e.quantity).toString();
                    String protocol = e.referenceProtocolId == null ? "" : " " + e.referenceProtocolId;
                    SqimHtmlFormatter.tr(h, name, qty, protocol);
                }
                h.end();
                ((Html)h.end()).end();
            }
            SqimHtmlFormatter.tr(h, "Num\u00e9ro de lot", m.lotNumberText);
            SqimHtmlFormatter.tr(h, "Date d'expiration", m.expirationTime);
        }
    }

    private static void annotations(ArrayList<Annotation> annotations, Html h) {
        if (annotations != null) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Annotations")).end()).end()).end();
            for (Annotation a : annotations) {
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).text("Date : ")).text(SqimHtmlFormatter.nvlt(a.time))).end()).td()).text("Auteur : ")).text(SqimHtmlFormatter.formatAuthor(a.author))).end()).end();
                String text = SqimHtmlFormatter.nvl(a.text);
                if (a.languageCode != null && a.languageCode.code != null) {
                    text = text + " (" + a.languageCode.code + ")";
                }
                ((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("2")).text(text)).end()).end();
            }
        }
    }

    private static String date(Long date) {
        return date == null ? null : DateUtil.format((Long)date, (String)"yyyy-MM-dd");
    }

    private static String datetime(Long date) {
        return date == null ? null : DateUtil.format((Long)date, (String)"yyyy-MM-dd HH:mm");
    }

    public static String getOESummary(QueryContinuationResult qcr) {
        StringWriter writer = new StringWriter();
        Html html = new Html((Writer)writer);
        if (qcr == null) {
            return null;
        }
        List list = qcr.prescriptions;
        ArrayList<PrescriptionDeviceSummary> subListDev = new ArrayList<PrescriptionDeviceSummary>();
        ArrayList<PrescriptionDrugSummary> subListDrug = new ArrayList<PrescriptionDrugSummary>();
        for (IPrescriptionSummary iPrescriptionSummary : list) {
            if (iPrescriptionSummary instanceof PrescriptionDeviceSummary) {
                subListDev.add((PrescriptionDeviceSummary)iPrescriptionSummary);
                continue;
            }
            if (!(iPrescriptionSummary instanceof PrescriptionDrugSummary)) continue;
            subListDrug.add((PrescriptionDrugSummary)iPrescriptionSummary);
        }
        if (subListDev.size() == 0 && subListDrug.size() == 0) {
            ((Html)html.h3()).text("Dossier vide.");
        } else {
            ((Html)((Html)html.h4()).text("Prescription(s)")).end();
            for (PrescriptionDrugSummary prescriptionDrugSummary : subListDrug) {
                SqimHtmlFormatter.getOESummaryDrugLine(html, prescriptionDrugSummary);
            }
            ((Html)((Html)html.h4()).text("Fourniture(s)")).end();
            for (PrescriptionDeviceSummary prescriptionDeviceSummary : subListDev) {
                SqimHtmlFormatter.getOESummaryDeviceLine(html, prescriptionDeviceSummary);
            }
        }
        html.endAll();
        return writer.toString();
    }

    public static String getDMPrescriptionSummary(QueryContinuationResult qcr) {
        StringWriter writer = new StringWriter();
        Html html = new Html((Writer)writer);
        if (qcr == null) {
            return null;
        }
        if (qcr.resultCurrentQuantity == null || qcr.resultCurrentQuantity.equals(0)) {
            ((Html)html.h3()).text("Dossier vide.");
        }
        for (IPrescriptionSummary e : qcr.prescriptions) {
            if (!(e instanceof PrescriptionDrugSummary)) continue;
            SqimHtmlFormatter.getDMSummaryDrugLine(html, (PrescriptionDrugSummary)e);
        }
        html.endAll();
        System.out.println(writer.toString());
        return writer.toString();
    }

    public static String getDispenseSummary(QueryContinuationResult qcr) {
        StringWriter writer = new StringWriter();
        Html html = new Html((Writer)writer);
        if (qcr == null) {
            return null;
        }
        List list = qcr.dispenses;
        if (list.size() == 0 && list.size() == 0) {
            ((Html)html.h3()).text("Dossier vide.");
        } else {
            for (DispenseSummary pds : list) {
                SqimHtmlFormatter.getDispenseSummaryDrugLine(html, pds);
            }
        }
        html.endAll();
        return writer.toString();
    }

    private static void getDispenseSummaryDrugLine(Html h, DispenseSummary s) {
        long distinctId = SqimHtmlFormatter.getNextCount();
        ((Html)h.div()).style("margin: 5px 0px;");
        SqimHtmlFormatter.getDispenseSummaryDrugHeadLine(h, s, distinctId);
        h.end();
        ((Html)((Html)((Html)h.div()).id(s.id + "-" + distinctId)).classAttr("dispense-rx-" + s.prescriptionId)).style("display: none;");
        ((Html)h.div()).classAttr("to-tabulate to-tabulate-" + s.id);
        h.ul();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#summary-dispense-" + s.id)).text("Sommaire")).end()).end();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#detail-dispense-" + s.id)).text("D\u00e9tails")).end()).end();
        h.end();
        SqimHtmlFormatter.formatDrugDispenseSummary(s, h);
        ((Html)((Html)((Html)h.div()).id("detail-dispense-" + s.id)).attr(new String[]{"idObj", s.id})).style("margin: 2px 0px;");
        ((Html)((Html)h.p()).text("En chargement ...")).end();
        h.end();
        h.end();
        h.end();
    }

    private static void getDMSummaryDrugLine(Html h, PrescriptionDrugSummary s) {
        String context = "";
        ((Html)h.div()).style("margin: 5px 0px;");
        SqimHtmlFormatter.getDMSummaryDrugHeadLine(h, context, s);
        h.end();
        ((Html)((Html)h.div()).id(s.id)).style("display: none;");
        ((Html)h.div()).classAttr("to-tabulate to-tabulate-" + s.id);
        h.ul();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#summary-dm-" + s.id)).text("Sommaire")).end()).end();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#detail-dm-" + s.id)).text("D\u00e9tails")).end()).end();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#dispense-dm-" + s.id)).text("D\u00e9livrances")).end()).end();
        h.end();
        SqimHtmlFormatter.formatPrescriptionDrugSummaryDM(s, h);
        ((Html)((Html)((Html)h.div()).id("detail-dm-" + s.id)).attr(new String[]{"idObj", s.id, "idVersion", s.version, "isDetail", "1", "context", context})).style("margin: 2px 0px;");
        ((Html)((Html)h.p()).text("En chargement ...")).end();
        h.end();
        ((Html)((Html)((Html)h.div()).id("dispense-dm-" + s.id)).attr(new String[]{"idObj", s.id, "idVersion", s.version, "isDispense", "1", "context", context})).style("margin: 2px 0px;");
        ((Html)((Html)h.p()).text("En chargement ...")).end();
        ((Html)((Html)h.table()).classAttr("div-list table-list-dispenses2")).end();
        h.end();
        h.end();
        h.end();
    }

    private static void getDMSummaryDrugLineMed(Html h, PrescriptionDrugSummary s) {
        ((Html)((Html)h.div()).attr(new String[]{"data-ng-show", "active".equalsIgnoreCase(s.getStatus().code) + "||dsqEle.showAllActive"})).style("margin: 5px 0px;");
        String context = "med";
        String id = context + s.id;
        SqimHtmlFormatter.getDMSummaryDrugHeadLine(h, context, s);
        h.end();
        ((Html)((Html)h.div()).id(id)).style("display: none;");
        ((Html)h.div()).classAttr("to-tabulate to-tabulate-" + s.id);
        h.ul();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#summary-dm-" + id)).text("Sommaire")).end()).end();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#detail-dm-" + id)).text("D\u00e9tails")).end()).end();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#dispense-dm-" + id)).text("D\u00e9livrances")).end()).end();
        h.end();
        ((Html)h.div()).id("summary-dm-" + id);
        SqimHtmlFormatter.formatPrescriptionDrugSummary(s, h);
        h.end();
        ((Html)((Html)((Html)h.div()).id("detail-dm-" + id)).attr(new String[]{"idObj", s.id, "idVersion", s.version, "isDetail", "1", "context", context})).style("margin: 2px 0px;");
        ((Html)((Html)h.p()).text("En chargement ...")).end();
        h.end();
        ((Html)((Html)((Html)h.div()).id("dispense-dm-" + id)).attr(new String[]{"idObj", s.id, "idVersion", s.version, "isDispense", "1", "context", context})).style("margin: 2px 0px;");
        ((Html)((Html)h.p()).text("En chargement ...")).end();
        ((Html)((Html)h.table()).classAttr("div-list table-list-dispenses2")).end();
        h.end();
        h.end();
        h.end();
    }

    public static String getDMMedicationSummary(QueryContinuationResult qcr) {
        StringWriter writer = new StringWriter();
        Html html = new Html((Writer)writer);
        if (qcr == null) {
            return null;
        }
        if (qcr.resultCurrentQuantity == null || qcr.resultCurrentQuantity.equals(0)) {
            ((Html)html.h3()).text("Dossier vide.");
        } else {
            ArrayList list = new ArrayList(qcr.resultCurrentQuantity);
            list.addAll(qcr.drugs);
            list.addAll(qcr.otherMedications);
            Collections.sort(list, sequenceSorter);
            for (Object e : list) {
                if (e instanceof PrescriptionDrugSummary) {
                    SqimHtmlFormatter.getDMSummaryDrugLineMed(html, (PrescriptionDrugSummary)e);
                }
                if (!(e instanceof OtherMedicationSummary)) continue;
                SqimHtmlFormatter.getDMOtherMedicationSummaryDrugLine(html, (OtherMedicationSummary)e);
            }
        }
        html.endAll();
        return writer.toString();
    }

    private static void getDMOtherMedicationSummaryDrugLine(Html h, OtherMedicationSummary s) {
        ((Html)h.div()).style("margin: 5px 0px;");
        SqimHtmlFormatter.getDMOtherMedicationSummaryDrugHeadLine(h, s);
        h.end();
        ((Html)((Html)h.div()).id(s.niu.value())).style("display: none;");
        ((Html)h.div()).classAttr("to-tabulate to-tabulate-" + s.niu.value());
        h.ul();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#summary-med-" + s.niu.value())).text("Sommaire")).end()).end();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#detail-med-" + s.niu.value())).text("D\u00e9tails")).end()).end();
        h.end();
        SqimHtmlFormatter.formatOtherMedicationSummaryDM(s, h);
        ((Html)((Html)((Html)h.div()).id("detail-med-" + s.niu.value())).attr(new String[]{"idObj", s.niu.value(), "idVersion", s.niu.version(), "isMed", "1"})).style("margin: 2px 0px;");
        ((Html)((Html)h.p()).text("En chargement ...")).end();
        h.end();
        h.end();
        h.end();
    }

    private static void getDMOtherMedicationSummaryDrugHeadLine(Html h, OtherMedicationSummary s) {
        boolean hasEvent = Boolean.TRUE.equals(s.hasIssues);
        String bgcolor = hasEvent ? ORANGE : NORMAL;
        ((Html)((Html)h.table()).style("width: 100%;")).tr();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).style("width: 2ch;")).checkbox()).style("margin:0px;cursor:pointer;")).id("chkdm~" + s.niu.value())).classAttr("chk-dm")).end()).end();
        ((Html)h.td()).style("width: 10ch; background-color: " + bgcolor + ";");
        if (s.drugActivePeriodStart != null) {
            h.text(LocalDate.fromTimeInMillisLOCAL((Long)s.drugActivePeriodStart).formatSlash());
        }
        h.end();
        ((Html)h.td()).style("width: 4ch; text-align: center; background-color: rgb(255,255,255);");
        if (hasEvent) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(235,144,16);")).title("Avec \u00e9v\u00e8nements")).text("E")).end();
        }
        h.end();
        ((Html)h.td()).style("background-color: " + bgcolor + ";");
        ((Html)((Html)((Html)h.a()).href("javascript:showHideDiv('" + s.niu.value() + "')")).text(s.consumable != null && s.consumable.name != null ? s.consumable.name : "")).end();
        h.end();
        ((Html)h.end()).end();
    }

    private static void formatOtherMedicationSummaryDM(OtherMedicationSummary s, Html h) {
        ((Html)h.div()).id("summary-med-" + s.niu.value());
        ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("2px")).bgcolor("#F0F0F0")).color("#000000");
        SqimHtmlFormatter.medicationGood(h, s.consumable);
        SqimHtmlFormatter.tr(h, "Date", DateUtil.format((Long)s.drugActivePeriodStart, (String)"yyyy-MM-dd"));
        if (s.drugActivePeriodEnd != null) {
            SqimHtmlFormatter.tr(h, "Fin", DateUtil.format((Long)s.drugActivePeriodEnd, (String)"yyyy-MM-dd"));
        }
        if (s.drugActivePeriodDuration != null) {
            SqimHtmlFormatter.tr(h, "Dur\u00e9e", s.drugActivePeriodDuration.toString());
        }
        SqimHtmlFormatter.tr(h, "Statut", SqimHtmlFormatter.formatCode(s.status));
        if (Boolean.TRUE.equals(s.hasIssues)) {
            SqimHtmlFormatter.tr(h, "Contient des \u00e9v\u00e9nements", "oui");
        }
        SqimHtmlFormatter.tr(h, "Auteur", SqimHtmlFormatter.formatAuthor(s.author));
        SqimHtmlFormatter.tr(h, "Num\u00e9ro", s.niu.value() + ", " + s.niu.version());
        SqimHtmlFormatter.tr(h, "Lieu d'origine", SqimHtmlFormatter.formatLocation(s.location, null));
        h.end();
        h.end();
    }

    public static String formatOtherMedicationDetails(OtherMedicationDetail s) {
        if (s == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        Html h = new Html((Writer)writer);
        ((Html)h.div()).attr(new String[]{"idObj", "" + s.niu.value()});
        ((Html)h.table()).classAttr("dsq-detail-box");
        SqimHtmlFormatter.medicationGood(h, s.consumable);
        SqimHtmlFormatter.tr(h, "Date", DateUtil.format((Long)s.drugActivePeriodStart, (String)"yyyy-MM-dd"));
        if (s.drugActivePeriodEnd != null) {
            SqimHtmlFormatter.tr(h, "Fin", DateUtil.format((Long)s.drugActivePeriodEnd, (String)"yyyy-MM-dd"));
        }
        if (s.drugActivePeriodDuration != null) {
            SqimHtmlFormatter.tr(h, "Dur\u00e9e", s.drugActivePeriodDuration.toString());
        }
        SqimHtmlFormatter.tr(h, "Statut", SqimHtmlFormatter.formatCode(s.status));
        SqimHtmlFormatter.tr(h, "Auteur", SqimHtmlFormatter.formatAuthor(s.author));
        SqimHtmlFormatter.tr(h, "Num\u00e9ro", s.niu.value() + ", " + s.niu.version());
        if (s.location != null) {
            SqimHtmlFormatter.tr(h, "Lieu d'origine", SqimHtmlFormatter.formatLocation(s.location, null));
        }
        SqimHtmlFormatter.dosageInstructions2(s.dosageInstructions, h);
        h.end();
        if (s.detectedIssueEvents != null && s.detectedIssueEvents.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("\u00c9v\u00e9nements")).end()).end()).end();
            for (DetectedIssueEvent a : s.detectedIssueEvents) {
                SqimHtmlFormatter.tr(h, SqimHtmlFormatter.formatCode(a.code), a.text, a.priority.text, a.status.text);
            }
            h.end();
        }
        if (s.historyStatusChanges != null && s.historyStatusChanges.size() > 0) {
            ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("5px")).bgcolor("#F0F0F0")).color("#000000");
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).th()).colspan("2")).align("left")).b()).text("Historique des \u00e9v\u00e9nements")).end()).end()).end();
            Collections.sort(s.historyStatusChanges, new Comparator<HistoryStatusChange>(){

                @Override
                public int compare(HistoryStatusChange o1, HistoryStatusChange o2) {
                    return -o1.changeTimestamp.compareTo(o2.changeTimestamp);
                }
            });
            for (HistoryStatusChange e : s.historyStatusChanges) {
                ((Html)((Html)((Html)h.tr()).td()).colspan("2")).border("1");
                ((Html)((Html)((Html)((Html)h.table()).border("0")).cellpadding("2px")).bgcolor("#A0A0A0")).color("#000000");
                SqimHtmlFormatter.tr(h, "Date", SqimHtmlFormatter.datetime(e.changeTimestamp));
                SqimHtmlFormatter.tr(h, "P\u00e9riode d'effet", SqimHtmlFormatter.formatDuration(e.changeEffectivePeriodStart, e.changeEffectivePeriodEnd, null));
                SqimHtmlFormatter.tr(h, "Type", SqimHtmlFormatter.formatCode(e.changeType));
                SqimHtmlFormatter.tr(h, "Raison", SqimHtmlFormatter.formatCode(e.changeReason));
                SqimHtmlFormatter.tr(h, "Auteur", SqimHtmlFormatter.formatAuthor(e.changeBy));
                SqimHtmlFormatter.tr(h, "Application", e.applicationName);
                h.end();
                h.end();
            }
            h.end();
        }
        h.end();
        return writer.toString();
    }

    private static void getOESummaryDrugLine(Html h, PrescriptionDrugSummary s) {
        ((Html)h.div()).style("margin: 5px 0px;");
        SqimHtmlFormatter.getOESummaryDrugHeadLine(h, s);
        h.end();
        ((Html)((Html)h.div()).id(s.id)).style("display: none;");
        ((Html)h.div()).classAttr("to-tabulate to-tabulate-" + s.id);
        h.ul();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#summary-oe-" + s.id)).text("Sommaire")).end()).end();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#detail-oe-" + s.id)).text("D\u00e9tails")).end()).end();
        h.end();
        SqimHtmlFormatter.formatPrescriptionDrugSummaryOE(s, h);
        ((Html)((Html)((Html)h.div()).id("detail-oe-" + s.id)).attr(new String[]{"idObj", s.id, "objType", "drug", "idVersion", s.version})).style("margin: 2px 0px;");
        ((Html)((Html)h.p()).text("En chargement ...")).end();
        h.end();
        h.end();
        h.end();
    }

    private static void getOESummaryDeviceLine(Html h, PrescriptionDeviceSummary s) {
        ((Html)h.div()).style("margin: 5px 0px;");
        SqimHtmlFormatter.getOESummaryDeviceHeadLine(h, s);
        h.end();
        ((Html)((Html)h.div()).id(s.id)).style("display: none;");
        ((Html)h.div()).classAttr("to-tabulate to-tabulate-" + s.id);
        h.ul();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#summary-oe-" + s.id)).text("Sommaire")).end()).end();
        ((Html)((Html)((Html)((Html)((Html)h.li()).a()).href("#detail-oe-" + s.id)).text("D\u00e9tails")).end()).end();
        h.end();
        SqimHtmlFormatter.formatPrescriptionDeviceSummary(s, h);
        ((Html)((Html)((Html)h.div()).id("detail-oe-" + s.id)).attr(new String[]{"idObj", s.id, "objType", "device", "idVersion", s.version})).style("margin: 2px 0px;");
        ((Html)((Html)h.p()).text("En chargement ...")).end();
        h.end();
        h.end();
        h.end();
    }

    private static void getOESummaryDrugHeadLine(Html h, PrescriptionDrugSummary s) {
        boolean hasRefusal;
        boolean inactive = !"active".equalsIgnoreCase(s.getStatus().code);
        boolean hasEvent = Boolean.TRUE.equals(s.getHasIssues());
        boolean hasAnnotation = Boolean.TRUE.equals(s.getHasAnnotations());
        boolean bl = hasRefusal = s.getRefusalsToFill() != null && s.getRefusalsToFill().size() > 0;
        String bgcolor = hasRefusal ? RED : (inactive ? YELLOW : (hasEvent ? ORANGE : (hasAnnotation ? BLUE : NORMAL)));
        ((Html)((Html)h.table()).style("width: 100%;")).tr();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).style("width: 2ch;")).checkbox()).style("margin:0px;cursor:pointer;")).id("chkoerx~" + s.id)).classAttr("chk-oe-rx")).end()).end();
        ((Html)h.td()).style("width: 10ch; background-color: " + bgcolor + ";");
        if (s.datetime != null) {
            h.text(LocalDate.fromTimeInMillisLOCAL((Long)s.datetime).formatSlash());
        }
        h.end();
        ((Html)h.td()).style("width: 4ch; text-align: center; background-color: rgb(255,255,255);");
        if (inactive) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(255,255,0);")).title("Inactif")).text("I")).end();
        }
        if (hasEvent) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(235,144,16);")).title("Avec \u00e9v\u00e8nements")).text("E")).end();
        }
        if (hasAnnotation) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(0,122,209);")).title("Avec annotations")).text("A")).end();
        }
        if (hasRefusal) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(255,0,0);")).title("A des refus")).text("R")).end();
        }
        h.end();
        ((Html)h.td()).style("text-decoartion: underline; cursor: pointer; width: 30px; text-align: center; background-color: " + bgcolor + ";");
        ((Html)((Html)h.onclick("retract('" + s.id + "','" + s.version + "','detail-oe-" + s.id + "')")).title("Annuler cette ordonnance")).text("X");
        h.end();
        ((Html)h.td()).style("background-color: " + bgcolor + ";");
        ((Html)((Html)((Html)h.a()).href("javascript:showHideDiv('" + s.id + "')")).text(s.medication != null && s.medication.name != null ? s.medication.name : "")).end();
        h.end();
        ((Html)h.end()).end();
    }

    private static void getOESummaryDeviceHeadLine(Html h, PrescriptionDeviceSummary s) {
        boolean hasRefusal;
        boolean inactive = !"active".equalsIgnoreCase(s.getStatus().code);
        boolean hasEvent = Boolean.TRUE.equals(s.getHasIssues());
        boolean hasAnnotation = Boolean.TRUE.equals(s.getHasAnnotations());
        boolean bl = hasRefusal = s.getRefusalsToFill() != null && s.getRefusalsToFill().size() > 0;
        String bgcolor = hasRefusal ? RED : (inactive ? YELLOW : (hasEvent ? ORANGE : (hasAnnotation ? BLUE : NORMAL)));
        ((Html)((Html)h.table()).style("width: 100%;")).tr();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).style("width: 2ch;")).checkbox()).style("margin:0px;cursor:pointer;")).id("chkOEDev~" + s.id)).classAttr("chk-oe-dev")).end()).end();
        ((Html)h.td()).style("width: 10ch; background-color: " + bgcolor + ";");
        if (s.datetime != null) {
            h.text(LocalDate.fromTimeInMillisLOCAL((Long)s.datetime).formatSlash());
        }
        h.end();
        ((Html)h.td()).style("width: 4ch; text-align: center; background-color: rgb(255,255,255);");
        if (inactive) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(255,255,0);")).title("Inactif")).text("I")).end();
        }
        if (hasEvent) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(235,144,16);")).title("Avec \u00e9v\u00e8nements")).text("E")).end();
        }
        if (hasAnnotation) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(0,122,209);")).title("Avec annotations")).text("A")).end();
        }
        if (hasRefusal) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(255,0,0);")).title("A des refus")).text("R")).end();
        }
        h.end();
        ((Html)h.td()).style("text-decoartion: underline; cursor: pointer; width: 30px; text-align: center; background-color: " + bgcolor + ";");
        ((Html)((Html)h.onclick("retract('" + s.id + "','" + s.version + "','detail-oe-" + s.id + "')")).title("Annuler cette ordonnance")).text("X");
        h.end();
        ((Html)h.td()).style("background-color: " + bgcolor + ";");
        ((Html)((Html)((Html)h.a()).href("javascript:showHideDiv('" + s.id + "')")).text(s.device != null && s.device.name != null ? s.device.name : "")).end();
        h.end();
        ((Html)h.end()).end();
    }

    private static void getDMSummaryDrugHeadLine(Html h, String context, PrescriptionDrugSummary s) {
        boolean hasRefusal;
        boolean inactive = !"active".equalsIgnoreCase(s.getStatus().code);
        boolean hasEvent = Boolean.TRUE.equals(s.getHasIssues());
        boolean hasAnnotation = Boolean.TRUE.equals(s.getHasAnnotations());
        boolean bl = hasRefusal = s.getRefusalsToFill() != null && s.getRefusalsToFill().size() > 0;
        String bgcolor = hasRefusal ? RED : (inactive ? YELLOW : (hasEvent ? ORANGE : (hasAnnotation ? BLUE : NORMAL)));
        ((Html)((Html)h.table()).style("width: 100%;")).tr();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).style("width: 2ch;")).checkbox()).style("margin:0px;cursor:pointer;")).id("chkdm~" + s.id)).classAttr("chk-dm")).end()).end();
        ((Html)h.td()).style("width: 10ch; background-color: " + bgcolor + ";");
        if (s.datetime != null) {
            h.text(LocalDate.fromTimeInMillisLOCAL((Long)s.datetime).formatSlash());
        }
        h.end();
        ((Html)h.td()).style("width: 4ch; text-align: center; background-color: rgb(255,255,255);");
        if (inactive) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(255,255,0);")).title("Inactif")).text("I")).end();
        }
        if (hasEvent) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(235,144,16);")).title("Avec \u00e9v\u00e8nements")).text("E")).end();
        }
        if (hasAnnotation) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(0,122,209);")).title("Avec annotations")).text("A")).end();
        }
        if (hasRefusal) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(255,0,0);")).title("A des refus")).text("R")).end();
        }
        h.end();
        ((Html)h.td()).style("background-color: " + bgcolor + ";");
        ((Html)((Html)((Html)h.a()).href("javascript:showHideDiv('" + context + s.id + "')")).text(s.medication != null && s.medication.name != null ? s.medication.name : "")).end();
        h.end();
        ((Html)h.end()).end();
    }

    private static void getDispenseSummaryDrugHeadLine(Html h, DispenseSummary s, long distinctId) {
        boolean notCompleted = !"completed".equalsIgnoreCase(s.status);
        boolean inactive = !"active".equalsIgnoreCase(s.prescriptionStatus);
        boolean hasEvent = Boolean.TRUE.equals(s.hasIssues);
        boolean hasAnnotation = Boolean.TRUE.equals(s.hasAnnotations);
        String bgcolor = notCompleted ? RED : (inactive ? YELLOW : (hasEvent ? ORANGE : (hasAnnotation ? BLUE : NORMAL)));
        ((Html)((Html)h.table()).style("width: 100%;")).tr();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).style("width: 2ch;")).checkbox()).style("margin:0px;cursor:pointer;")).id("chkdisp~" + s.id)).classAttr("chk-disp")).end()).end();
        ((Html)h.td()).style("width: 10ch; background-color: " + bgcolor + ";");
        if (s.date != null) {
            h.text(LocalDate.fromTimeInMillisLOCAL((Long)s.date).formatSlash());
        }
        h.end();
        ((Html)h.td()).style("width: 4ch; text-align: center; background-color: rgb(255,255,255);");
        if (inactive) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(255,255,0);")).title("Inactif")).text("I")).end();
        }
        if (hasEvent) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(235,144,16);")).title("Avec \u00e9v\u00e8nements")).text("E")).end();
        }
        if (hasAnnotation) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(0,122,209);")).title("Avec annotations")).text("A")).end();
        }
        if (notCompleted) {
            ((Html)((Html)((Html)((Html)h.span()).style("cursor: help; background-color: rgb(255,0,0);")).title("Non compl\u00e9t\u00e9")).text("C")).end();
        }
        h.end();
        ((Html)h.td()).style("background-color: " + bgcolor + ";");
        ((Html)((Html)((Html)h.a()).href("javascript:showHideDiv('" + s.id + "-" + distinctId + "')")).text(s.drugName != null ? s.drugName : "")).end();
        h.end();
        ((Html)h.end()).end();
    }

    public static String formatPastConsentRefusal(CandidateConsentDirective consent) {
        if (consent != null && consent.hasPastConsentRefusal() && consent.getEffectiveStartTime() != null) {
            StringWriter writer = new StringWriter();
            Html h = new Html((Writer)writer);
            ((Html)((Html)h.table()).style("width: 100%;")).tr();
            ((Html)h.td()).style("width: 150px;");
            h.text("Le patient a d\u00e9j\u00e0 refus\u00e9 par le pass\u00e9, les informations plus anciennes que " + DsqFormatter.nvld(consent.getEffectiveStartTime()) + " ne sont pas disponibles.");
            h.end();
            h.endAll();
            return writer.toString();
        }
        return "";
    }

    private static final class ComparatorImplementation
    implements Comparator<Object> {
        private ComparatorImplementation() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return this.getSeq(o1) - this.getSeq(o2);
        }

        private int getSeq(Object o) {
            if (o instanceof DispenseSummary) {
                return ((DispenseSummary)o).sequence;
            }
            if (o instanceof PrescriptionDeviceSummary) {
                return ((PrescriptionDeviceSummary)o).sequence;
            }
            if (o instanceof PrescriptionDrugSummary) {
                return ((PrescriptionDrugSummary)o).sequence;
            }
            if (o instanceof OtherMedicationSummary) {
                return ((OtherMedicationSummary)o).sequence;
            }
            if (o instanceof OtherMedicationDetail) {
                return ((OtherMedicationDetail)o).sequence;
            }
            return 9999999;
        }
    }
}

