/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.Annotation;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.DetectedIssueEvent;
import ca.infodata.dsq.domain.DosageInstruction;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.Ingredient;
import ca.infodata.dsq.domain.Medication;
import ca.infodata.dsq.domain.PrescriptionDeviceDetails;
import ca.infodata.dsq.domain.PrescriptionDeviceSummary;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.domain.PrescriptionDrugSummary;
import ca.infodata.dsq.domain.QuantityObservation;
import ca.infodata.dsq.domain.ReferenceProtocol;
import ca.infodata.dsq.domain.Refusal;
import ca.infodata.dsq.domain.RefusalReason;
import ca.infodata.dsq.domain.SupplyRequestItem;
import ca.infodata.dsq.domain.TherapeuticIntent;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class DsqFormatter {
    public static String formatDsqPrefix(XPrescription prescription) {
        if (prescription.getDsqPrescriptionDispenseId() != null) {
            return "[I.dsq] ";
        }
        if (prescription.getDsqPrescriptionId() != null) {
            if (prescription.isStillInSendingToDsqState()) {
                return "[A.dsq] ";
            }
            return "[E.dsq] ";
        }
        if (prescription.getDsqTransactionId() != null) {
            return "[X.dsq] ";
        }
        return "";
    }

    private static String formatAuthor(IProvider p) {
        if (p == null) {
            return "";
        }
        if (p.getNIU_COLLEGE() == null) {
            return p.getFirstName() + " " + p.getLastName();
        }
        return p.getFirstName() + " " + p.getLastName() + "(" + p.getNIU_COLLEGE().value() + ")";
    }

    public static String format(PrescriptionDeviceDetails d) {
        StringBuilder b = new StringBuilder(500);
        b.append("Prescription de fourniture");
        b.append("\n");
        b.append("\nNum\u00e9ro ").append(d.id).append(" ").append("Version ").append(d.version);
        if (d.previousPrescriptionId != null && d.previousPrescriptionVersion != null) {
            b.append("\nEn remplacement de la prescription num\u00e9ro ").append(d.previousPrescriptionId).append(" ").append("Version ").append(d.previousPrescriptionVersion);
        }
        b.append("\nStatut : ").append(d.status);
        b.append("\nDate : ").append(DsqFormatter.nvld(d.datetime));
        b.append("\n");
        b.append("\nAuteur : ").append(DsqFormatter.formatAuthor(d.prescriber));
        b.append("\n");
        b.append("\nLieu d'origine : ").append(DsqFormatter.formatLocation(d.location));
        b.append("\n");
        b.append("\nAutorit\u00e9 de la version \u00e9lectronique ? : ").append(DsqFormatter.nvlb(d.electronicVersionHasAuthority));
        if (d.reasons != null && d.reasons.size() > 0 && !"N/A".equals(((TherapeuticIntent)d.reasons.get((int)0)).otherIndicationText)) {
            b.append("\n");
            b.append("\nIntentions th\u00e9rapeutiques : ").append(DsqFormatter.reasons(d.reasons));
        }
        b.append("\n");
        b.append("\nFourniture : ");
        b.append(d.device == null ? "" : (d.device.name == null ? "" : d.device.name + " ") + (d.device.desc == null ? "" : d.device.desc + " "));
        b.append("\nInstructions : ").append(DsqFormatter.nvl(d.usageInstructions));
        b.append("\n");
        b.append("\nD\u00e9tails de d\u00e9livrance");
        b.append("\n");
        if (d.supplyRequestTotalDaysSupply != null) {
            b.append("\nQuantit\u00e9 totale : ").append(DsqFormatter.nvl(d.supplyRequestTotalQuantity));
        }
        if (d.supplyRequestTotalDaysSupply != null) {
            b.append("\nDur\u00e9e totale : ").append(DsqFormatter.nvl(d.supplyRequestTotalDaysSupply)).append("(jrs)");
        }
        if (d.supplyRequestNumberOfFills != null) {
            b.append("\nNombre de renouvellements : ").append(d.supplyRequestNumberOfFills.intValue() - 1);
        }
        b.append("\nQuantit\u00e9 par renouvellement : ").append(d.supplyRequestFillQuantity);
        b.append("\n");
        if (d.supplyRequestLocation != null) {
            b.append("\nLieu de ramassage : ").append(DsqFormatter.formatLocation(d.supplyRequestLocation));
        }
        if (d.supplyRequestLocationPickupDate != null) {
            b.append("\nDate du ramassage : ").append(DsqFormatter.nvld(d.supplyRequestLocationPickupDate));
        }
        b.append("\n");
        if (d.refusalsToFill != null && d.refusalsToFill.size() > 0) {
            b.append("\nRefus de d\u00e9livrance : ").append(DsqFormatter.refusal(d.refusalsToFill));
        }
        if (d.detectedIssueEvents != null && d.detectedIssueEvents.size() > 0) {
            b.append("\n\u00c9v\u00e9nements : ").append(DsqFormatter.issues(d.detectedIssueEvents));
        }
        if (d.annotations != null && d.annotations.size() > 0) {
            b.append("\nAnnotations : ").append(DsqFormatter.annotations(d.annotations));
        }
        return b.toString();
    }

    public static String format(PrescriptionDrugDetails d) {
        StringBuilder b = new StringBuilder(500);
        b.append("Prescription de m\u00e9dicament");
        b.append("\n");
        b.append("\nNum\u00e9ro ").append(d.id).append(" ").append("Version ").append(d.version);
        if (d.previousPrescriptionId != null && d.previousPrescriptionVersion != null) {
            b.append("\nEn remplacement de la prescription num\u00e9ro ").append(d.previousPrescriptionId).append(" ").append("Version ").append(d.previousPrescriptionVersion);
        }
        b.append("\nStatut : ").append(d.status);
        b.append("\nDate : ").append(DsqFormatter.nvld(d.datetime));
        b.append("\n");
        b.append("\nAuteur : ").append(DsqFormatter.formatAuthor(d.prescriber));
        b.append("\n");
        b.append("\nLieu d'origine : ").append(DsqFormatter.formatLocation(d.location));
        b.append("\n");
        b.append("\nAutorit\u00e9 de la version \u00e9lectronique ? : ").append(DsqFormatter.nvlb(d.electronicVersionHasAuthority));
        if (d.reasons != null && d.reasons.size() > 0 && !"N/A".equals(((TherapeuticIntent)d.reasons.get((int)0)).otherIndicationText)) {
            b.append("\n");
            b.append("\nIntentions th\u00e9rapeutiques : ").append(DsqFormatter.reasons(d.reasons));
        }
        if (d.treatmentTypeCode != null) {
            b.append("\nType de traitement : ").append(DsqFormatter.formatCode(d.treatmentTypeCode));
        }
        if (d.patientMesures != null && d.patientMesures.size() > 0) {
            b.append("\nObservations : ");
            for (QuantityObservation q : d.patientMesures) {
                if (d.patientMesures.size() > 1) {
                    b.append("\nObservation - ");
                }
                b.append("Date :").append(DsqFormatter.nvlt(q.date));
                b.append(" ").append(DsqFormatter.formatCode(q.code));
                b.append(" ").append(DsqFormatter.nvl(q.quantity));
            }
        }
        b.append("\n");
        b.append("\nM\u00e9dicament : ").append(DsqFormatter.medication(d.medication));
        if (d.referenceProtocols != null) {
            for (ReferenceProtocol r : d.referenceProtocols) {
                b.append("\nProtocol de r\u00e9f\u00e9rence : ").append(DsqFormatter.formatCode(r.code));
            }
        }
        b.append("\n\u00c9ligible pour des \u00e9chantillons ? : ").append(DsqFormatter.nvlb(!Boolean.TRUE.equals(d.notEligibleForTrial)));
        if (Boolean.TRUE.equals(d.substitutionNotAllowedIndicator)) {
            b.append("\nPas de substitution");
            if (d.substitutionNotAllowedReasonCode != null) {
                b.append("\n").append(DsqFormatter.formatCode(d.substitutionNotAllowedReasonCode));
            }
        } else if (d.substitutionPermissionCode != null) {
            b.append("\nSustitution permise");
            b.append("\n").append(DsqFormatter.formatCode(d.substitutionPermissionCode));
        }
        b.append("\n");
        b.append("\nInstructions : ");
        if (d.dosageInstructions != null) {
            b.append(DsqFormatter.dosageInstructions(d.dosageInstructions));
        }
        b.append("\n");
        b.append("\nD\u00e9tails de d\u00e9livrance");
        b.append("\n");
        if (d.supplyRequestStatusCode != null) {
            b.append("\nStatut : ").append(d.supplyRequestStatusCode);
        }
        if (d.supplyRequestAllowedPeriodDuration != null || d.supplyRequestAllowedPeriodLowDate != null || d.supplyRequestAllowedPeriodHighDate != null) {
            b.append("\nP\u00e9riode de validit\u00e9 : ");
            b.append(DsqFormatter.nvlt(d.supplyRequestAllowedPeriodLowDate)).append(" - ").append(DsqFormatter.nvlt(d.supplyRequestAllowedPeriodHighDate));
            if (d.supplyRequestAllowedPeriodDuration != null) {
                b.append(" ").append(d.supplyRequestAllowedPeriodDuration);
            }
        }
        b.append(DsqFormatter.SupplyRequestItems(d.supplyRequestItems));
        b.append("\n");
        if (d.supplyRequestLocation != null) {
            b.append("\nLieu de ramassage : ").append(DsqFormatter.formatLocation(d.supplyRequestLocation));
            if (d.supplyRequestLocationSubstitutionConditionCode != null) {
                b.append("\nCondition de substitution du lieu de ramassage : ").append(DsqFormatter.formatCode(d.supplyRequestLocationSubstitutionConditionCode));
            }
        }
        if (d.supplyRequestLocationPickupDate != null) {
            b.append("\nDate du ramassage : ").append(DsqFormatter.nvld(d.supplyRequestLocationPickupDate));
        }
        b.append("\n");
        if (d.refusalsToFill != null && d.refusalsToFill.size() > 0) {
            b.append("\nRefus de d\u00e9livrance : ").append(DsqFormatter.refusal(d.refusalsToFill));
        }
        if (d.detectedIssueEvents != null && d.detectedIssueEvents.size() > 0) {
            b.append("\n\u00c9v\u00e9nements : ").append(DsqFormatter.issues(d.detectedIssueEvents));
        }
        if (d.annotations != null && d.annotations.size() > 0) {
            b.append("\nAnnotations : ").append(DsqFormatter.annotations(d.annotations));
        }
        return b.toString();
    }

    private static String SupplyRequestItems(ArrayList<SupplyRequestItem> supplyRequestItems) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (SupplyRequestItem d : supplyRequestItems) {
            ++i;
            if (supplyRequestItems.size() > 1) {
                b.append("\nD\u00e9tails - ").append(i);
            }
            if (d.totalQuantity != null) {
                b.append("\nQuantit\u00e9 totale : ").append(DsqFormatter.nvl(d.totalQuantity));
            }
            if (d.totalDaysSupply != null) {
                b.append("\nDur\u00e9e totale : ").append(DsqFormatter.nvl(d.totalDaysSupply)).append("(jrs)");
            }
            if (d.numberOfFills != null) {
                b.append("\nNombre de renouvellements : ").append(d.numberOfFills.intValue() - 1);
            }
            if (d.fillQuantity != null) {
                b.append("\nQuantit\u00e9 par renouvellement : ").append(d.fillQuantity);
            }
            if (d.fillExpectedUseTime != null) {
                b.append("\nDur\u00e9e du renouvellement : ").append(d.fillExpectedUseTime);
            }
            if (d.dispenseInterval != null) {
                b.append("\nIntervale entre les renouvellements : ").append(d.dispenseInterval);
            }
            if (d.firstFillExpectedUseTime == null && d.firstFillQuantity == null && d.firstFillExpiryDate == null) continue;
            b.append("\nCas particulier, Renouvellement initial");
            if (d.firstFillQuantity != null) {
                b.append("\nQuantit\u00e9 : ").append(d.firstFillQuantity);
            }
            if (d.firstFillExpectedUseTime != null) {
                b.append("\nDur\u00e9e : ").append(d.fillExpectedUseTime);
            }
            if (d.firstFillExpiryDate == null) continue;
            b.append("\nDate d'expiration : ").append(d.firstFillExpiryDate);
        }
        return b.toString();
    }

    private static String dosageInstructions(ArrayList<DosageInstruction> dosageInstructions) {
        if (dosageInstructions.size() == 1) {
            return dosageInstructions.get((int)0).text;
        }
        StringBuilder b = new StringBuilder();
        for (DosageInstruction d : dosageInstructions) {
            b.append("\n\tInstruction - ").append(d.text);
        }
        return b.toString();
    }

    public static String format(PrescriptionDeviceSummary s) {
        StringBuilder b = new StringBuilder(500);
        b.append("Prescription de fourniture");
        b.append("\n");
        b.append("\nNum\u00e9ro ").append(s.id).append(" ").append("Version ").append(s.version);
        b.append("\nStatut : ").append(s.status);
        b.append("\nDate : ").append(DsqFormatter.nvld(s.datetime));
        b.append("\n");
        b.append("\nAuteur : ").append(DsqFormatter.formatAuthor(s.prescriber));
        b.append("\n");
        b.append("\nAutorit\u00e9 de la version \u00e9lectronique ? : ").append(DsqFormatter.nvlb(s.electronicVersionHasAuthority));
        if (s.reasons != null && s.reasons.size() > 0 && !"N/A".equals(((TherapeuticIntent)s.reasons.get((int)0)).otherIndicationText)) {
            b.append("\n");
            b.append("\nIntentions th\u00e9rapeutiques : ").append(DsqFormatter.reasons(s.reasons));
        }
        b.append("\n");
        b.append("\nFourniture : ");
        b.append(s.device == null ? "" : (s.device.name == null ? "" : s.device.name + " ") + (s.device.desc == null ? "" : s.device.desc + " "));
        b.append("\nQuantit\u00e9 : ").append(DsqFormatter.nvl(s.supplyRequestTotalQuantity));
        if (StringUtils.isNotBlank((String)s.usageInstructions)) {
            b.append("\nInstructions : ").append(DsqFormatter.nvl(s.usageInstructions));
        }
        b.append("\n");
        if (s.supplyRequestLocation != null) {
            b.append("\nLieu de ramassage : ").append(DsqFormatter.formatLocation(s.supplyRequestLocation));
        }
        if (s.supplyRequestLocationPickupDate != null) {
            b.append("\nDate du ramassage : ").append(DsqFormatter.nvld(s.supplyRequestLocationPickupDate));
        }
        if (s.refusalsToFill != null && s.refusalsToFill.size() > 0) {
            b.append("\nRefus de d'\u00e9livrance : ").append(DsqFormatter.refusal(s.refusalsToFill));
        }
        b.append("\nContient des \u00e9v\u00e9nements ? : ").append(DsqFormatter.nvlb(s.hasIssues));
        b.append("\nContient des annotations ? : ").append(DsqFormatter.nvlb(s.hasAnnotations));
        return b.toString();
    }

    public static String format(PrescriptionDrugSummary s) {
        StringBuilder b = new StringBuilder(500);
        b.append("Prescription de m\u00e9dicament");
        b.append("\n");
        b.append("\nNum\u00e9ro ").append(s.id).append(" ").append("Version ").append(s.version);
        b.append("\nStatut : ").append(s.status);
        b.append("\nDate : ").append(DsqFormatter.nvld(s.datetime));
        b.append("\n");
        b.append("\nAuteur : ").append(DsqFormatter.formatAuthor(s.prescriber));
        b.append("\n");
        b.append("\nAutorit\u00e9 de la version \u00e9lectronique ? : ").append(DsqFormatter.nvlb(s.electronicVersionHasAuthority));
        if (s.reasons != null && s.reasons.size() > 0 && !"N/A".equals(((TherapeuticIntent)s.reasons.get((int)0)).otherIndicationText)) {
            b.append("\n");
            b.append("\nIntentions th\u00e9rapeutiques : ").append(DsqFormatter.reasons(s.reasons));
        }
        b.append("\n");
        b.append("\nM\u00e9dicament : ").append(DsqFormatter.medication(s.medication));
        b.append("\nQuantit\u00e9 totale : ").append(DsqFormatter.nvl(s.supplyRequestQuantity)).append(s.supplyRequestQuantity == null ? "" : s.supplyRequestQuantity.toString());
        b.append("\nInstructions : ").append(DsqFormatter.nvl(s.dosageText));
        b.append("\n");
        if (s.supplyRequestLocation != null) {
            b.append("\nLieu de ramassage : ").append(DsqFormatter.formatLocation(s.supplyRequestLocation));
            if (s.supplyRequestSubstitutionConditionCode != null) {
                b.append("\nCondition de substitution du lieu de ramassage : ").append(DsqFormatter.formatCode(s.supplyRequestSubstitutionConditionCode));
            }
        }
        if (s.refusalsToFill != null && s.refusalsToFill.size() > 0) {
            b.append("\nRefus de d'\u00e9livrance : ").append(DsqFormatter.refusal(s.refusalsToFill));
        }
        b.append("\nContient des \u00e9v\u00e9nements ? : ").append(DsqFormatter.nvlb(s.hasIssues));
        b.append("\nContient des annotations ? : ").append(DsqFormatter.nvlb(s.hasAnnotations));
        return b.toString();
    }

    public static String formatLocation(ILocation location) {
        if (location == null) {
            return "";
        }
        JoinList list = new JoinList(", ");
        list.setTrim(true);
        list.add((CharSequence)DsqFormatter.nvl(location.getCode()));
        list.add((CharSequence)DsqFormatter.nvl(location.getName()));
        Address address = location.getAddress();
        if (address != null) {
            list.add((CharSequence)address.street);
            list.add((CharSequence)address.city);
            list.add((CharSequence)address.state);
            list.add((CharSequence)address.country);
            list.add((CharSequence)address.postalCode);
            list.add((CharSequence)address.telecom);
        }
        return list.toString();
    }

    private static String medication(Medication m) {
        StringBuilder s = new StringBuilder();
        if (m == null) {
            return "";
        }
        s.append(m.name == null ? "" : m.name);
        if (m.ingredients != null) {
            for (Ingredient i : m.ingredients) {
                s.append("\n\tIngr\u00e9dient " + (i.code == null ? "" : i.code + " ")).append(i.name).append(" " + (i.quantity == null ? "" : i.quantity)).append(i.referenceProtocolId == null ? "" : " " + i.referenceProtocolId).append(i.drugDoesNotContains == null ? "(peut contenir)" : (i.drugDoesNotContains != false ? "(ne contient pas)" : ""));
            }
        }
        return s.toString();
    }

    private static String refusal(List<Refusal> list) {
        if (list == null) {
            return "";
        }
        StringBuilder b = new StringBuilder(100);
        for (Refusal r : list) {
            b.append("\n\tRefus - ").append("Date : ").append(DsqFormatter.nvlt(r.date)).append(", Auteur : ").append(DsqFormatter.formatAuthor(r.author)).append(", Lieu : ").append(DsqFormatter.formatLocation(r.location)).append(", Raisons : ").append(DsqFormatter.refusalReason(r.reasons));
        }
        return b.toString();
    }

    private static String refusalReason(HashSet<RefusalReason> list) {
        StringBuilder b = new StringBuilder();
        for (RefusalReason r : list) {
            b.append("\n\t\t").append(DsqFormatter.formatCode(r.code) + " - " + DsqFormatter.nvl(r.text));
        }
        return b.toString();
    }

    private static String reasons(List<TherapeuticIntent> list) {
        StringBuilder b = new StringBuilder();
        for (TherapeuticIntent reason : list) {
            if (reason == null || "N/A".equals(reason.otherIndicationText)) continue;
            b.append("\n\t");
            if (reason.priority != null) {
                b.append(reason.priority).append(". ");
            }
            b.append(reason.otherIndicationText);
        }
        return b.toString();
    }

    private static String annotations(ArrayList<Annotation> annotations) {
        StringBuilder b = new StringBuilder();
        if (annotations != null) {
            for (Annotation a : annotations) {
                b.append("\n\tA - ");
                b.append("Date : ").append(DsqFormatter.nvlt(a.time));
                b.append(", Auteur : ").append(DsqFormatter.formatAuthor(a.author));
                b.append(", Texte : ");
                if (a.languageCode != null && a.languageCode.code != null) {
                    b.append("(").append(a.languageCode.code).append(") ");
                }
                b.append(DsqFormatter.nvl(a.text));
            }
        }
        return b.toString();
    }

    private static String issues(ArrayList<DetectedIssueEvent> detectedIssueEvents) {
        StringBuilder b = new StringBuilder();
        if (detectedIssueEvents != null) {
            for (DetectedIssueEvent a : detectedIssueEvents) {
                b.append("\n\tE - ").append(a.toString());
            }
        }
        return b.toString();
    }

    public static String nvlt(Long s) {
        return s == null ? "" : DateUtil.ttoc((long)s);
    }

    public static String nvld(Long s) {
        return s == null ? "" : DateUtil.dtoc((long)s);
    }

    public static String nvlb(Boolean s) {
        return Boolean.TRUE.equals(s) ? "oui" : "non";
    }

    public static String nvl(Object s) {
        if (s instanceof String) {
            return DsqFormatter.nvl((String)s, "");
        }
        if (s instanceof Long) {
            return DsqFormatter.nvl((Long)s, "");
        }
        if (s == null) {
            return "";
        }
        return s.toString();
    }

    public static String nvl(String s, String df) {
        return s == null ? df : s;
    }

    public static String nvl(Long s, String df) {
        return s == null ? df : String.valueOf(df);
    }

    public static String formatCode(Code code) {
        if (code == null) {
            return "";
        }
        if (!StringUtils.isBlank((CharSequence)code.text)) {
            return code.text;
        }
        if (!StringUtils.isBlank((CharSequence)code.code)) {
            return code.code;
        }
        return "";
    }
}

