/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.rx;

import com.hivemq.client.annotations.CheckReturnValue;
import com.hivemq.client.internal.rx.WithSingleStrictSubscriber;
import com.hivemq.client.internal.rx.operators.FlowableWithSingleMap;
import com.hivemq.client.internal.rx.operators.FlowableWithSingleMapError;
import com.hivemq.client.internal.rx.operators.FlowableWithSingleObserveOn;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.rx.FlowableWithSingleSubscriber;
import com.hivemq.client.rx.reactivestreams.PublisherWithSingle;
import com.hivemq.client.rx.reactivestreams.WithSingleSubscriber;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.annotations.BackpressureKind;
import io.reactivex.annotations.BackpressureSupport;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class FlowableWithSingle<F, S>
extends Flowable<F>
implements PublisherWithSingle<F, S> {
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @CheckReturnValue
    @NotNull
    public final FlowableWithSingle<F, S> observeOnBoth(@NotNull Scheduler scheduler) {
        return this.observeOnBoth(scheduler, false, FlowableWithSingle.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @CheckReturnValue
    @NotNull
    public final FlowableWithSingle<F, S> observeOnBoth(@NotNull Scheduler scheduler, boolean delayError) {
        return this.observeOnBoth(scheduler, delayError, FlowableWithSingle.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @CheckReturnValue
    @NotNull
    public final FlowableWithSingle<F, S> observeOnBoth(@NotNull Scheduler scheduler, boolean delayError, int bufferSize) {
        Checks.notNull(scheduler, "Scheduler");
        return new FlowableWithSingleObserveOn(this, scheduler, delayError, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NotNull
    public final <SM> FlowableWithSingle<F, SM> mapSingle(@NotNull Function<? super S, ? extends SM> singleMapper) {
        Checks.notNull(singleMapper, "Single mapper");
        return FlowableWithSingleMap.mapSingle(this, singleMapper);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NotNull
    public final <FM, SM> FlowableWithSingle<FM, SM> mapBoth(@NotNull Function<? super F, ? extends FM> flowableMapper, @NotNull Function<? super S, ? extends SM> singleMapper) {
        Checks.notNull(flowableMapper, "Flowable mapper");
        Checks.notNull(singleMapper, "Single mapper");
        return FlowableWithSingleMap.mapBoth(this, flowableMapper, singleMapper);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NotNull
    public final FlowableWithSingle<F, S> mapError(@NotNull Function<? super Throwable, ? extends Throwable> mapper) {
        Checks.notNull(mapper, "Mapper");
        return new FlowableWithSingleMapError(this, mapper);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NotNull
    public final FlowableWithSingle<F, S> doOnSingle(@NotNull Consumer<? super S> singleConsumer) {
        Checks.notNull(singleConsumer, "Single consumer");
        return FlowableWithSingleMap.mapSingle(this, s -> {
            singleConsumer.accept(s);
            return s;
        });
    }

    @Override
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final void subscribeBoth(@NotNull WithSingleSubscriber<? super F, ? super S> subscriber) {
        if (subscriber instanceof FlowableWithSingleSubscriber) {
            this.subscribeBoth((FlowableWithSingleSubscriber)subscriber);
        } else {
            Checks.notNull(subscriber, "Subscriber");
            this.subscribeBothActual(new WithSingleStrictSubscriber<F, S>(subscriber));
        }
    }

    @Override
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final void subscribeBoth(@NotNull FlowableWithSingleSubscriber<? super F, ? super S> subscriber) {
        Checks.notNull(subscriber, "Subscriber");
        this.subscribeBothActual(subscriber);
    }

    protected abstract void subscribeBothActual(@NotNull WithSingleSubscriber<? super F, ? super S> var1);

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture() {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe();
        return future;
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture(@NotNull Consumer<? super F> onNext) {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe(onNext);
        return future;
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture(@NotNull Consumer<? super F> onNext, @NotNull Consumer<? super Throwable> onError) {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe(onNext, onError);
        return future;
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture(@NotNull Consumer<? super F> onNext, @NotNull Consumer<? super Throwable> onError, @NotNull Action onComplete) {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe(onNext, onError, onComplete);
        return future;
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NotNull
    public final CompletableFuture<S> subscribeSingleFuture(@NotNull Subscriber<? super F> subscriber) {
        SingleFutureSubscriber singleFutureSubscriber = new SingleFutureSubscriber(this);
        CompletableFuture future = singleFutureSubscriber.getFutureBeforeSubscribe();
        singleFutureSubscriber.subscribe(subscriber);
        return future;
    }

    private static class SingleFutureSubscriber<F, S>
    extends Flowable<F>
    implements FlowableWithSingleSubscriber<F, S>,
    Subscription {
        @NotNull
        private final FlowableWithSingle<F, S> source;
        @Nullable
        private Subscriber<? super F> subscriber;
        private final @NotNull AtomicReference<@Nullable Subscription> subscription = new AtomicReference();
        private final @NotNull AtomicReference<@Nullable CompletableFuture<S>> future = new AtomicReference<1>(new CompletableFuture<S>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                future.set(null);
                this.cancel();
                return super.cancel(mayInterruptIfRunning);
            }
        });

        SingleFutureSubscriber(@NotNull FlowableWithSingle<F, S> source) {
            this.source = source;
        }

        @NotNull
        CompletableFuture<S> getFutureBeforeSubscribe() {
            CompletableFuture<S> future = this.future.get();
            assert (future != null);
            return future;
        }

        protected void subscribeActual(@NotNull Subscriber<? super F> subscriber) {
            this.subscriber = subscriber;
            this.source.subscribeBoth(this);
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            assert (this.subscriber != null);
            if (!this.subscription.compareAndSet(null, subscription)) {
                this.cancel(subscription);
            }
            this.subscriber.onSubscribe((Subscription)this);
        }

        @Override
        public void onSingle(@NotNull S s) {
            CompletableFuture future = this.future.getAndSet(null);
            if (future != null) {
                future.complete(s);
            }
        }

        public void onNext(@NotNull F f) {
            assert (this.subscriber != null);
            this.subscriber.onNext(f);
        }

        public void onComplete() {
            assert (this.subscriber != null);
            CompletableFuture future = this.future.getAndSet(null);
            if (future != null) {
                future.completeExceptionally(new NoSuchElementException());
            }
            this.subscriber.onComplete();
        }

        public void onError(@NotNull Throwable t) {
            assert (this.subscriber != null);
            CompletableFuture future = this.future.getAndSet(null);
            if (future != null) {
                future.completeExceptionally(t);
            }
            this.subscriber.onError(t);
        }

        public void request(long n) {
            Subscription subscription = this.subscription.get();
            assert (subscription != null);
            if (subscription != this) {
                subscription.request(n);
            }
        }

        public void cancel() {
            Subscription subscription = this.subscription.getAndSet(this);
            if (subscription != null && subscription != this) {
                this.cancel(subscription);
            }
        }

        private void cancel(@NotNull Subscription subscription) {
            subscription.cancel();
            CompletableFuture future = this.future.getAndSet(null);
            if (future != null) {
                future.cancel(false);
            }
        }
    }
}

