/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Pow2Util;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;

@NotThreadSafe
public class Index<E, K> {
    private static final int MAX_CAPACITY = 0x40000000;
    @NotNull
    private final Spec<E, K> spec;
    private @Nullable Object @NotNull [] table;
    private int size;
    private int nodeCount;
    private int nodeThreshold;

    public Index(@NotNull Spec<E, K> spec) {
        this.spec = spec;
        int minCapacityPow2 = 1 << Pow2Util.roundToPowerOf2Bits(spec.minCapacity);
        this.table = new Object[minCapacityPow2];
        this.calcThresholds(minCapacityPow2);
    }

    public int size() {
        return this.size;
    }

    @Nullable
    public E put(@NotNull E entry) {
        return this.put(entry, true);
    }

    @Nullable
    public E putIfAbsent(@NotNull E entry) {
        return this.put(entry, false);
    }

    @Nullable
    private E put(@NotNull E entry, boolean overwrite) {
        Object[] table = this.table;
        Object key = this.spec.keyFunction.apply(entry);
        int hash = key.hashCode();
        int index = hash & table.length - 1;
        Object o = table[index];
        if (o == null) {
            table[index] = entry;
            this.added();
            return null;
        }
        if (o.getClass() == Node.class) {
            Object next;
            Node node = (Node)o;
            while (true) {
                if (node.hash == hash && this.spec.keyFunction.apply(this.cast(node.value)).equals(key)) {
                    Object nodeValue = node.value;
                    if (overwrite) {
                        node.value = entry;
                    }
                    return this.cast(nodeValue);
                }
                next = node.next;
                if (next.getClass() != Node.class) break;
                node = (Node)next;
            }
            E e = this.cast(next);
            Object nextKey = this.spec.keyFunction.apply(e);
            if (nextKey.equals(key)) {
                if (overwrite) {
                    node.next = entry;
                }
                return e;
            }
            node.next = new Node(nextKey.hashCode(), next, entry);
            this.added();
            this.addedNode();
            return null;
        }
        E e = this.cast(o);
        Object oKey = this.spec.keyFunction.apply(e);
        if (oKey.equals(key)) {
            if (overwrite) {
                table[index] = entry;
            }
            return e;
        }
        table[index] = new Node(oKey.hashCode(), o, entry);
        this.added();
        this.addedNode();
        return null;
    }

    @Nullable
    public E get(@NotNull K key) {
        Object[] table = this.table;
        int hash = key.hashCode();
        int index = hash & table.length - 1;
        Object o = table[index];
        if (o == null) {
            return null;
        }
        if (o.getClass() == Node.class) {
            Object next;
            Node node = (Node)o;
            while (true) {
                if (node.hash == hash && this.spec.keyFunction.apply(this.cast(node.value)).equals(key)) {
                    return this.cast(node.value);
                }
                next = node.next;
                if (next.getClass() != Node.class) break;
                node = (Node)next;
            }
            E e = this.cast(next);
            if (this.spec.keyFunction.apply(e).equals(key)) {
                return e;
            }
            return null;
        }
        E e = this.cast(o);
        if (this.spec.keyFunction.apply(e).equals(key)) {
            return e;
        }
        return null;
    }

    @Nullable
    public E remove(@NotNull K key) {
        Object[] table = this.table;
        int hash = key.hashCode();
        int index = hash & table.length - 1;
        Object o = table[index];
        if (o == null) {
            return null;
        }
        if (o.getClass() == Node.class) {
            Node node = (Node)o;
            if (node.hash == hash && this.spec.keyFunction.apply(this.cast(node.value)).equals(key)) {
                table[index] = node.next;
                this.removedNode();
                this.removed();
                return this.cast(node.value);
            }
            Object next = node.next;
            if (next.getClass() != Node.class) {
                E e = this.cast(next);
                if (this.spec.keyFunction.apply(e).equals(key)) {
                    table[index] = node.value;
                    this.removedNode();
                    this.removed();
                    return e;
                }
                return null;
            }
            do {
                Node prevNode = node;
                node = (Node)next;
                if (node.hash != hash || !this.spec.keyFunction.apply(this.cast(node.value)).equals(key)) continue;
                prevNode.next = node.next;
                this.removedNode();
                this.removed();
                return this.cast(node.value);
            } while ((next = node.next).getClass() == Node.class);
            E e = this.cast(next);
            if (this.spec.keyFunction.apply(e).equals(key)) {
                prevNode.next = node.value;
                this.removedNode();
                this.removed();
                return e;
            }
            return null;
        }
        E e = this.cast(o);
        if (this.spec.keyFunction.apply(e).equals(key)) {
            table[index] = null;
            this.removed();
            return e;
        }
        return null;
    }

    public void clear() {
        if (this.size > 0) {
            if (this.table.length == this.spec.minCapacity) {
                Arrays.fill(this.table, null);
            } else {
                this.table = new Object[this.spec.minCapacity];
            }
            this.size = 0;
            this.nodeCount = 0;
            this.calcThresholds(this.spec.minCapacity);
        }
    }

    @NotNull
    public E any() {
        for (Object o : this.table) {
            if (o == null) continue;
            if (o.getClass() == Node.class) {
                Node node = (Node)o;
                return this.cast(node.value);
            }
            return this.cast(o);
        }
        throw new NoSuchElementException();
    }

    public void forEach(@NotNull Consumer<? super E> consumer) {
        for (Object o : this.table) {
            if (o == null) continue;
            if (o.getClass() == Node.class) {
                Object next;
                Node node = (Node)o;
                while (true) {
                    consumer.accept(this.cast(node.value));
                    next = node.next;
                    if (next.getClass() != Node.class) break;
                    node = (Node)next;
                }
                consumer.accept(this.cast(next));
                continue;
            }
            consumer.accept(this.cast(o));
        }
    }

    private void added() {
        ++this.size;
    }

    private void addedNode() {
        if (++this.nodeCount > this.nodeThreshold && this.table.length < 0x40000000) {
            Object[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            int newCapacity = oldCapacity << 1;
            int newMask = newCapacity - 1;
            Object[] newTable = new Object[newCapacity];
            int newNodeCount = 0;
            for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
                Object o = oldTable[oldIndex];
                if (o == null) continue;
                if (o.getClass() == Node.class) {
                    Object next;
                    Node node = (Node)o;
                    Node low = null;
                    Node prevLow = null;
                    Node high = null;
                    Node prevHigh = null;
                    int highIndex = oldIndex + oldCapacity;
                    while (true) {
                        if ((node.hash & newMask) == oldIndex) {
                            if (low == null) {
                                low = node;
                                newTable[oldIndex] = node;
                            } else {
                                prevLow = low;
                                low = node;
                                prevLow.next = low;
                            }
                        } else if (high == null) {
                            high = node;
                            newTable[highIndex] = node;
                        } else {
                            prevHigh = high;
                            high = node;
                            prevHigh.next = high;
                        }
                        ++newNodeCount;
                        next = node.next;
                        if (next.getClass() != Node.class) break;
                        node = (Node)next;
                    }
                    E e = this.cast(next);
                    if ((this.spec.keyFunction.apply(e).hashCode() & newMask) == oldIndex) {
                        if (low == null) {
                            newTable[oldIndex] = e;
                        } else {
                            low.next = e;
                        }
                        if (high == null) continue;
                        if (prevHigh == null) {
                            newTable[highIndex] = high.value;
                        } else {
                            prevHigh.next = high.value;
                        }
                        --newNodeCount;
                        continue;
                    }
                    if (high == null) {
                        newTable[highIndex] = e;
                    } else {
                        high.next = e;
                    }
                    if (low == null) continue;
                    if (prevLow == null) {
                        newTable[oldIndex] = low.value;
                    } else {
                        prevLow.next = low.value;
                    }
                    --newNodeCount;
                    continue;
                }
                int hash = this.spec.keyFunction.apply(this.cast(o)).hashCode();
                int newIndex = hash & newMask;
                newTable[newIndex] = o;
            }
            this.table = newTable;
            this.nodeCount = newNodeCount;
            this.calcThresholds(newCapacity);
        }
    }

    private void removedNode() {
        --this.nodeCount;
    }

    private void removed() {
        if (--this.size < this.nodeThreshold && this.table.length > this.spec.minCapacity) {
            Object[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            int newCapacity = oldCapacity >> 1;
            Object[] newTable = new Object[newCapacity];
            int newNodeCount = this.nodeCount;
            System.arraycopy(oldTable, 0, newTable, 0, newCapacity);
            for (int oldIndex = newCapacity; oldIndex < oldCapacity; ++oldIndex) {
                Object old = oldTable[oldIndex];
                if (old == null) continue;
                int newIndex = oldIndex - newCapacity;
                Object o = newTable[newIndex];
                if (o == null) {
                    newTable[newIndex] = old;
                    continue;
                }
                if (o.getClass() == Node.class) {
                    Object next;
                    Node node = (Node)o;
                    while ((next = node.next).getClass() == Node.class) {
                        node = (Node)next;
                    }
                    node.next = new Node(this.spec.keyFunction.apply(this.cast(next)).hashCode(), next, old);
                    ++newNodeCount;
                    continue;
                }
                newTable[newIndex] = new Node(this.spec.keyFunction.apply(this.cast(o)).hashCode(), o, old);
                ++newNodeCount;
            }
            this.table = newTable;
            this.nodeCount = newNodeCount;
            this.calcThresholds(newCapacity);
        }
    }

    private void calcThresholds(int capacity) {
        this.nodeThreshold = (int)((float)capacity * this.spec.nodeThresholdFactor);
    }

    @NotNull
    private E cast(@NotNull Object o) {
        return (E)o;
    }

    private static class Node {
        final int hash;
        @NotNull
        Object value;
        @NotNull
        Object next;

        Node(int hash, @NotNull Object value, @NotNull Object next) {
            this.hash = hash;
            this.value = value;
            this.next = next;
        }
    }

    public static class Spec<E, K> {
        private static final int DEFAULT_MIN_CAPACITY = 16;
        private static final float DEFAULT_NODE_THRESHOLD_FACTOR = 0.25f;
        @NotNull
        final Function<? super E, ? extends K> keyFunction;
        final int minCapacity;
        final float nodeThresholdFactor;

        public Spec(@NotNull Function<? super E, ? extends K> keyFunction) {
            this(keyFunction, 16, 0.25f);
        }

        public Spec(@NotNull Function<? super E, ? extends K> keyFunction, int minCapacity) {
            this(keyFunction, minCapacity, 0.25f);
        }

        public Spec(@NotNull Function<? super E, ? extends K> keyFunction, float nodeThresholdFactor) {
            this(keyFunction, 16, nodeThresholdFactor);
        }

        public Spec(@NotNull Function<? super E, ? extends K> keyFunction, int minCapacity, float nodeThresholdFactor) {
            this.keyFunction = keyFunction;
            this.minCapacity = minCapacity;
            this.nodeThresholdFactor = nodeThresholdFactor;
        }
    }
}

