/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.codec.decoder.mqtt5.Mqtt5MessageDecoderUtil;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.auth.MqttAuth;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.javax.inject.Singleton;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5AuthReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import java.nio.ByteBuffer;

@Singleton
public class Mqtt5AuthDecoder
implements MqttMessageDecoder {
    private static final int FLAGS = 0;
    private static final int MIN_REMAINING_LENGTH = 2;

    @Inject
    Mqtt5AuthDecoder() {
    }

    @Override
    @NotNull
    public MqttAuth decode(int flags, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        MqttMessageDecoderUtil.checkFixedHeaderFlags(0, flags);
        if (in.readableBytes() < 2) {
            throw MqttMessageDecoderUtil.remainingLengthTooShort();
        }
        Mqtt5AuthReasonCode reasonCode = Mqtt5AuthReasonCode.fromCode(in.readUnsignedByte());
        if (reasonCode == null) {
            throw Mqtt5MessageDecoderUtil.wrongReasonCode();
        }
        Mqtt5MessageDecoderUtil.checkPropertyLengthNoPayload(in);
        MqttUtf8StringImpl method = null;
        ByteBuffer data = null;
        MqttUtf8StringImpl reasonString = null;
        ImmutableList.Builder<MqttUserPropertyImpl> userPropertiesBuilder = null;
        block6: while (in.isReadable()) {
            int propertyIdentifier = Mqtt5MessageDecoderUtil.decodePropertyIdentifier(in);
            switch (propertyIdentifier) {
                case 21: {
                    method = Mqtt5MessageDecoderUtil.decodeAuthMethod(method, in);
                    continue block6;
                }
                case 22: {
                    data = Mqtt5MessageDecoderUtil.decodeAuthData(data, in, context);
                    continue block6;
                }
                case 31: {
                    reasonString = Mqtt5MessageDecoderUtil.decodeReasonStringIfRequested(reasonString, in, context);
                    continue block6;
                }
                case 38: {
                    userPropertiesBuilder = Mqtt5MessageDecoderUtil.decodeUserPropertyIfRequested(userPropertiesBuilder, in, context);
                    continue block6;
                }
            }
            throw Mqtt5MessageDecoderUtil.wrongProperty(propertyIdentifier);
        }
        if (method == null) {
            throw new MqttDecoderException(Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "must not omit authentication method");
        }
        MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.build(userPropertiesBuilder);
        return new MqttAuth(reasonCode, method, data, reasonString, userProperties);
    }
}

