/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class IntegerRange
extends Range<Integer> {
    private static final long serialVersionUID = 1L;

    public IntegerRange() {
    }

    public IntegerRange(Integer start, Integer end, RangeNotation notation) {
        super(start, end, notation);
    }

    @Override
    public void valid() {
        super.valid();
        if (this.start != null && this.end != null && this.notation == RangeNotation.OPEN && (Integer)this.start + 1 == (Integer)this.end) {
            throw new IllegalArgumentException("]n,n+1[ is invalid. was " + this);
        }
    }

    public List<IntegerRange> remove(Range<Integer> range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        if (this.intersect(range)) {
            IntegerRange r;
            Integer start1 = this.toClosedStart((Integer)this.start, this.notation);
            Integer end1 = this.toClosedEnd((Integer)this.end, this.notation);
            Integer start2 = this.toClosedStart((Integer)range.start, range.notation);
            Integer end2 = this.toClosedEnd((Integer)range.end, range.notation);
            if (start2 == null && end2 == null) {
                return Collections.emptyList();
            }
            if (start2 == null) {
                return Arrays.asList(new IntegerRange(end2, end1, end1 == null ? RangeNotation.OPEN : RangeNotation.RIGHT_CLOSED));
            }
            if (end2 == null) {
                return Arrays.asList(new IntegerRange(start1, start2, start1 == null ? RangeNotation.OPEN : RangeNotation.LEFT_CLOSED));
            }
            if (start1 == null && end1 == null) {
                IntegerRange r1 = new IntegerRange(null, start2, RangeNotation.OPEN);
                IntegerRange r2 = new IntegerRange(end2, null, RangeNotation.OPEN);
                return Arrays.asList(r1, r2);
            }
            if (start1 == null) {
                ArrayList<IntegerRange> list = new ArrayList<IntegerRange>(2);
                IntegerRange r1 = new IntegerRange(null, start2, RangeNotation.OPEN);
                list.add(r1);
                if (end1 > end2) {
                    IntegerRange r2 = new IntegerRange(end2, end1, RangeNotation.RIGHT_CLOSED);
                    list.add(r2);
                }
                return list;
            }
            if (end1 == null) {
                ArrayList<IntegerRange> list = new ArrayList<IntegerRange>(2);
                IntegerRange r1 = new IntegerRange(end2, null, RangeNotation.OPEN);
                list.add(r1);
                if (start1 < start2) {
                    IntegerRange r2 = new IntegerRange(start1, start2, RangeNotation.LEFT_CLOSED);
                    list.add(r2);
                }
                return list;
            }
            ArrayList<IntegerRange> list = new ArrayList<IntegerRange>(2);
            if (start1 < start2) {
                r = new IntegerRange(start1, start2, RangeNotation.LEFT_CLOSED);
                list.add(r);
            }
            if (end1 > end2) {
                r = new IntegerRange(end2, end1, RangeNotation.RIGHT_CLOSED);
                list.add(r);
            }
            return list;
        }
        return Arrays.asList(this);
    }

    @Override
    public boolean intersect(Range<Integer> range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        Integer start1 = this.toClosedStart((Integer)this.start, this.notation);
        Integer end1 = this.toClosedEnd((Integer)this.end, this.notation);
        Integer start2 = this.toClosedStart((Integer)range.start, range.notation);
        Integer end2 = this.toClosedEnd((Integer)range.end, range.notation);
        return start1 == null && end1 == null && start2 == null && end2 == null || RangeNotation.CLOSED.inRange(start2, start1, end1) || RangeNotation.CLOSED.inRange(end2, start1, end1) || RangeNotation.CLOSED.inRange(start1, start2, end2) || RangeNotation.CLOSED.inRange(end1, start2, end2);
    }

    public IntegerRange merge(IntegerRange range) {
        Integer newStart;
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        Integer start1 = this.toClosedStart((Integer)this.start, this.notation);
        Integer end1 = this.toClosedEnd((Integer)this.end, this.notation);
        Integer start2 = this.toClosedStart((Integer)range.start, range.notation);
        Integer end2 = this.toClosedEnd((Integer)range.end, range.notation);
        if (start1 == null || start2 == null) {
            newStart = null;
        } else {
            Integer n = newStart = start1 < start2 ? start1 : start2;
        }
        Integer newEnd = end1 == null || end2 == null ? null : (end1 > end2 ? end1 : end2);
        return new IntegerRange(newStart, newEnd, RangeNotation.CLOSED);
    }

    private Integer toClosedEnd(Integer end, RangeNotation notation) {
        if (end == null) {
            return null;
        }
        switch (notation) {
            case CLOSED: 
            case RIGHT_CLOSED: {
                return end;
            }
            case OPEN: 
            case LEFT_CLOSED: {
                return end - 1;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    private Integer toClosedStart(Integer start, RangeNotation notation) {
        if (start == null) {
            return null;
        }
        switch (notation) {
            case CLOSED: 
            case LEFT_CLOSED: {
                return start;
            }
            case RIGHT_CLOSED: 
            case OPEN: {
                return start + 1;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        Integer start = this.toClosedStart((Integer)this.start, this.notation);
        Integer end = this.toClosedEnd((Integer)this.end, this.notation);
        result = 31 * result + (end == null ? 0 : end.hashCode());
        result = 31 * result + (start == null ? 0 : start.hashCode());
        result = 31 * result + RangeNotation.CLOSED.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }
}

