/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v281.group.ADT_A60_ADVERSE_REACTION_GROUP;
import ca.uhn.hl7v2.model.v281.segment.ARV;
import ca.uhn.hl7v2.model.v281.segment.EVN;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.PID;
import ca.uhn.hl7v2.model.v281.segment.PV1;
import ca.uhn.hl7v2.model.v281.segment.PV2;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A60
extends AbstractMessage {
    public ADT_A60() {
        this(new DefaultModelClassFactory());
    }

    public ADT_A60(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(ARV.class, false, true);
            this.add(PV1.class, false, false);
            this.add(PV2.class, false, false);
            this.add(ARV.class, false, true);
            this.add(ADT_A60_ADVERSE_REACTION_GROUP.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A60 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public ARV getARV() {
        return this.getTyped("ARV", ARV.class);
    }

    public ARV getARV(int rep) {
        return this.getTyped("ARV", rep, ARV.class);
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public PV1 getPV1() {
        return this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return this.getTyped("PV2", PV2.class);
    }

    public ARV getARV2() {
        return this.getTyped("ARV2", ARV.class);
    }

    public ARV getARV2(int rep) {
        return this.getTyped("ARV2", rep, ARV.class);
    }

    public int getARV2Reps() {
        return this.getReps("ARV2");
    }

    public List<ARV> getARV2All() throws HL7Exception {
        return this.getAllAsList("ARV2", ARV.class);
    }

    public void insertARV2(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV2", structure, rep);
    }

    public ARV insertARV2(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV2", rep);
    }

    public ARV removeARV2(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV2", rep);
    }

    public ADT_A60_ADVERSE_REACTION_GROUP getADVERSE_REACTION_GROUP() {
        return this.getTyped("ADVERSE_REACTION_GROUP", ADT_A60_ADVERSE_REACTION_GROUP.class);
    }

    public ADT_A60_ADVERSE_REACTION_GROUP getADVERSE_REACTION_GROUP(int rep) {
        return this.getTyped("ADVERSE_REACTION_GROUP", rep, ADT_A60_ADVERSE_REACTION_GROUP.class);
    }

    public int getADVERSE_REACTION_GROUPReps() {
        return this.getReps("ADVERSE_REACTION_GROUP");
    }

    public List<ADT_A60_ADVERSE_REACTION_GROUP> getADVERSE_REACTION_GROUPAll() throws HL7Exception {
        return this.getAllAsList("ADVERSE_REACTION_GROUP", ADT_A60_ADVERSE_REACTION_GROUP.class);
    }

    public void insertADVERSE_REACTION_GROUP(ADT_A60_ADVERSE_REACTION_GROUP structure, int rep) throws HL7Exception {
        super.insertRepetition("ADVERSE_REACTION_GROUP", structure, rep);
    }

    public ADT_A60_ADVERSE_REACTION_GROUP insertADVERSE_REACTION_GROUP(int rep) throws HL7Exception {
        return (ADT_A60_ADVERSE_REACTION_GROUP)super.insertRepetition("ADVERSE_REACTION_GROUP", rep);
    }

    public ADT_A60_ADVERSE_REACTION_GROUP removeADVERSE_REACTION_GROUP(int rep) throws HL7Exception {
        return (ADT_A60_ADVERSE_REACTION_GROUP)super.removeRepetition("ADVERSE_REACTION_GROUP", rep);
    }
}

