/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.group.ORL_O41_SPECIMEN;
import ca.uhn.hl7v2.model.v281.segment.OBR;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORL_O41_OBSERVATION_REQUEST
extends AbstractGroup {
    public ORL_O41_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(ORL_O41_SPECIMEN.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORL_O41_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ORL_O41_SPECIMEN getSPECIMEN() {
        ORL_O41_SPECIMEN retVal = this.getTyped("SPECIMEN", ORL_O41_SPECIMEN.class);
        return retVal;
    }

    public ORL_O41_SPECIMEN getSPECIMEN(int rep) {
        ORL_O41_SPECIMEN retVal = this.getTyped("SPECIMEN", rep, ORL_O41_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<ORL_O41_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", ORL_O41_SPECIMEN.class);
    }

    public void insertSPECIMEN(ORL_O41_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public ORL_O41_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O41_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public ORL_O41_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O41_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

