/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CQ;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.EI;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.MO;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.XCN;
import ca.uhn.hl7v2.model.v28.datatype.XON;
import ca.uhn.hl7v2.model.v28.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RF1
extends AbstractSegment {
    public RF1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Referral Status");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Referral Priority");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Referral Type");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Referral Disposition");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Referral Category");
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Originating Referral Identifier");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Effective Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Expiration Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Process Date");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Referral Reason");
            this.add(EI.class, false, 0, 0, new Object[]{this.getMessage()}, "External Referral Identifier");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Referral Documentation Completion Status");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Planned Treatment Stop Date");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Referral Reason Text");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Authorized Treatments/Units");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Used Treatments/Units");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Schedule Treatments/Units");
            this.add(MO.class, false, 1, 0, new Object[]{this.getMessage()}, "Remaining Benefit Amount");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorized Provider");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorized Health Professional");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Source Text");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Source Date");
            this.add(XTN.class, false, 1, 0, new Object[]{this.getMessage()}, "Source Phone");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Comment");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(206)}, "Action Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RF1 - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getReferralStatus() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getRf11_ReferralStatus() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getReferralPriority() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getRf12_ReferralPriority() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getReferralType() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getRf13_ReferralType() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE[] getReferralDisposition() {
        CWE[] retVal = (CWE[])this.getTypedField(4, new CWE[0]);
        return retVal;
    }

    public CWE[] getRf14_ReferralDisposition() {
        CWE[] retVal = (CWE[])this.getTypedField(4, new CWE[0]);
        return retVal;
    }

    public int getReferralDispositionReps() {
        return this.getReps(4);
    }

    public CWE getReferralDisposition(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getRf14_ReferralDisposition(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getRf14_ReferralDispositionReps() {
        return this.getReps(4);
    }

    public CWE insertReferralDisposition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertRf14_ReferralDisposition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeReferralDisposition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removeRf14_ReferralDisposition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE getReferralCategory() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getRf15_ReferralCategory() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getOriginatingReferralIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getRf16_OriginatingReferralIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getEffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getRf17_EffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getRf18_ExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getProcessDate() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getRf19_ProcessDate() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE[] getReferralReason() {
        CWE[] retVal = (CWE[])this.getTypedField(10, new CWE[0]);
        return retVal;
    }

    public CWE[] getRf110_ReferralReason() {
        CWE[] retVal = (CWE[])this.getTypedField(10, new CWE[0]);
        return retVal;
    }

    public int getReferralReasonReps() {
        return this.getReps(10);
    }

    public CWE getReferralReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(10, rep);
        return retVal;
    }

    public CWE getRf110_ReferralReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(10, rep);
        return retVal;
    }

    public int getRf110_ReferralReasonReps() {
        return this.getReps(10);
    }

    public CWE insertReferralReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(10, rep);
    }

    public CWE insertRf110_ReferralReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(10, rep);
    }

    public CWE removeReferralReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(10, rep);
    }

    public CWE removeRf110_ReferralReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(10, rep);
    }

    public EI[] getExternalReferralIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(11, new EI[0]);
        return retVal;
    }

    public EI[] getRf111_ExternalReferralIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(11, new EI[0]);
        return retVal;
    }

    public int getExternalReferralIdentifierReps() {
        return this.getReps(11);
    }

    public EI getExternalReferralIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(11, rep);
        return retVal;
    }

    public EI getRf111_ExternalReferralIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(11, rep);
        return retVal;
    }

    public int getRf111_ExternalReferralIdentifierReps() {
        return this.getReps(11);
    }

    public EI insertExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(11, rep);
    }

    public EI insertRf111_ExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(11, rep);
    }

    public EI removeExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(11, rep);
    }

    public EI removeRf111_ExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(11, rep);
    }

    public CWE getReferralDocumentationCompletionStatus() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getRf112_ReferralDocumentationCompletionStatus() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getPlannedTreatmentStopDate() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getRf113_PlannedTreatmentStopDate() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getReferralReasonText() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getRf114_ReferralReasonText() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public CQ getNumberOfAuthorizedTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(15, 0);
        return retVal;
    }

    public CQ getRf115_NumberOfAuthorizedTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(15, 0);
        return retVal;
    }

    public CQ getNumberOfUsedTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(16, 0);
        return retVal;
    }

    public CQ getRf116_NumberOfUsedTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(16, 0);
        return retVal;
    }

    public CQ getNumberOfScheduleTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(17, 0);
        return retVal;
    }

    public CQ getRf117_NumberOfScheduleTreatmentsUnits() {
        CQ retVal = (CQ)this.getTypedField(17, 0);
        return retVal;
    }

    public MO getRemainingBenefitAmount() {
        MO retVal = (MO)this.getTypedField(18, 0);
        return retVal;
    }

    public MO getRf118_RemainingBenefitAmount() {
        MO retVal = (MO)this.getTypedField(18, 0);
        return retVal;
    }

    public XON getAuthorizedProvider() {
        XON retVal = (XON)this.getTypedField(19, 0);
        return retVal;
    }

    public XON getRf119_AuthorizedProvider() {
        XON retVal = (XON)this.getTypedField(19, 0);
        return retVal;
    }

    public XCN getAuthorizedHealthProfessional() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public XCN getRf120_AuthorizedHealthProfessional() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getSourceText() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getRf121_SourceText() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public DTM getSourceDate() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public DTM getRf122_SourceDate() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public XTN getSourcePhone() {
        XTN retVal = (XTN)this.getTypedField(23, 0);
        return retVal;
    }

    public XTN getRf123_SourcePhone() {
        XTN retVal = (XTN)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getComment() {
        ST retVal = (ST)this.getTypedField(24, 0);
        return retVal;
    }

    public ST getRf124_Comment() {
        ST retVal = (ST)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getRf125_ActionCode() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new EI(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new DTM(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new EI(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new DTM(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new CQ(this.getMessage());
            }
            case 15: {
                return new CQ(this.getMessage());
            }
            case 16: {
                return new CQ(this.getMessage());
            }
            case 17: {
                return new MO(this.getMessage());
            }
            case 18: {
                return new XON(this.getMessage());
            }
            case 19: {
                return new XCN(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new DTM(this.getMessage());
            }
            case 22: {
                return new XTN(this.getMessage());
            }
            case 23: {
                return new ST(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(206));
            }
        }
        return null;
    }
}

