/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LAN
extends AbstractSegment {
    public LAN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - LAN");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Language Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Language Ability Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Language Proficiency Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating LAN - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDLAN() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getLan1_SetIDLAN() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getLanguageCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getLan2_LanguageCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE[] getLanguageAbilityCode() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public CWE[] getLan3_LanguageAbilityCode() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public int getLanguageAbilityCodeReps() {
        return this.getReps(3);
    }

    public CWE getLanguageAbilityCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getLan3_LanguageAbilityCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getLan3_LanguageAbilityCodeReps() {
        return this.getReps(3);
    }

    public CWE insertLanguageAbilityCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertLan3_LanguageAbilityCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeLanguageAbilityCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removeLan3_LanguageAbilityCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE getLanguageProficiencyCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getLan4_LanguageProficiencyCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

