/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ABS
extends AbstractSegment {
    public ABS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Discharge Care Provider");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Transfer Medical Service Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Severity of Illness Code");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Date/Time of Attestation");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Attested By");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Triage Code");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Abstract Completion Date/Time");
            this.add(XCN.class, false, 1, 0, new Object[]{this.getMessage()}, "Abstracted By");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Case Category Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Caesarian Section Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Gestation Category Code");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Gestation Period - Weeks");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Newborn Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Stillborn Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ABS - this is probably a bug in the source code generator.", e);
        }
    }

    public XCN getDischargeCareProvider() {
        XCN retVal = (XCN)this.getTypedField(1, 0);
        return retVal;
    }

    public XCN getAbs1_DischargeCareProvider() {
        XCN retVal = (XCN)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getTransferMedicalServiceCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getAbs2_TransferMedicalServiceCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getSeverityOfIllnessCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getAbs3_SeverityOfIllnessCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getDateTimeOfAttestation() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getAbs4_DateTimeOfAttestation() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN getAttestedBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public XCN getAbs5_AttestedBy() {
        XCN retVal = (XCN)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getTriageCode() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getAbs6_TriageCode() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getAbstractCompletionDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getAbs7_AbstractCompletionDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public XCN getAbstractedBy() {
        XCN retVal = (XCN)this.getTypedField(8, 0);
        return retVal;
    }

    public XCN getAbs8_AbstractedBy() {
        XCN retVal = (XCN)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getCaseCategoryCode() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getAbs9_CaseCategoryCode() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getCaesarianSectionIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getAbs10_CaesarianSectionIndicator() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getGestationCategoryCode() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getAbs11_GestationCategoryCode() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getGestationPeriodWeeks() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getAbs12_GestationPeriodWeeks() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getNewbornCode() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getAbs13_NewbornCode() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getStillbornIndicator() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getAbs14_StillbornIndicator() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new XCN(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

