/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v28.group.DRC_O47_DONATION_ORDER;
import ca.uhn.hl7v2.model.v28.group.DRC_O47_DONOR;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DRC_O47
extends AbstractMessage {
    public DRC_O47() {
        this(new DefaultModelClassFactory());
    }

    public DRC_O47(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(DRC_O47_DONOR.class, false, false);
            this.add(DRC_O47_DONATION_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DRC_O47 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public DRC_O47_DONOR getDONOR() {
        return this.getTyped("DONOR", DRC_O47_DONOR.class);
    }

    public DRC_O47_DONATION_ORDER getDONATION_ORDER() {
        return this.getTyped("DONATION_ORDER", DRC_O47_DONATION_ORDER.class);
    }

    public DRC_O47_DONATION_ORDER getDONATION_ORDER(int rep) {
        return this.getTyped("DONATION_ORDER", rep, DRC_O47_DONATION_ORDER.class);
    }

    public int getDONATION_ORDERReps() {
        return this.getReps("DONATION_ORDER");
    }

    public List<DRC_O47_DONATION_ORDER> getDONATION_ORDERAll() throws HL7Exception {
        return this.getAllAsList("DONATION_ORDER", DRC_O47_DONATION_ORDER.class);
    }

    public void insertDONATION_ORDER(DRC_O47_DONATION_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("DONATION_ORDER", structure, rep);
    }

    public DRC_O47_DONATION_ORDER insertDONATION_ORDER(int rep) throws HL7Exception {
        return (DRC_O47_DONATION_ORDER)super.insertRepetition("DONATION_ORDER", rep);
    }

    public DRC_O47_DONATION_ORDER removeDONATION_ORDER(int rep) throws HL7Exception {
        return (DRC_O47_DONATION_ORDER)super.removeRepetition("DONATION_ORDER", rep);
    }
}

