/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.segment.ARV;
import ca.uhn.hl7v2.model.v28.segment.MRG;
import ca.uhn.hl7v2.model.v28.segment.PD1;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A44_PATIENT
extends AbstractGroup {
    public ADT_A44_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(ARV.class, false, true, false);
            this.add(MRG.class, true, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A44_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public ARV getARV() {
        ARV retVal = this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public MRG getMRG() {
        MRG retVal = this.getTyped("MRG", MRG.class);
        return retVal;
    }
}

