/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.EI;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SLT
extends AbstractSegment {
    public SLT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Device Number");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Device Name");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Lot Number");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Item Identifier");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Bar Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SLT - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getDeviceNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getSlt1_DeviceNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getDeviceName() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getSlt2_DeviceName() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getLotNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getSlt3_LotNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getItemIdentifier() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getSlt4_ItemIdentifier() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getBarCode() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getSlt5_BarCode() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

