/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.EI;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SDD
extends AbstractSegment {
    public SDD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Lot Number");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Device Number");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Device Name");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Device Data State");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Load Status");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Control Code");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Operator Name");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SDD - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getLotNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getSdd1_LotNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getDeviceNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getSdd2_DeviceNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getDeviceName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getSdd3_DeviceName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getDeviceDataState() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getSdd4_DeviceDataState() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getLoadStatus() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getSdd5_LoadStatus() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getControlCode() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getSdd6_ControlCode() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getOperatorName() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getSdd7_OperatorName() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

