/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.EI;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.PL;
import ca.uhn.hl7v2.model.v27.datatype.XAD;
import ca.uhn.hl7v2.model.v27.datatype.XCN;
import ca.uhn.hl7v2.model.v27.datatype.XON;
import ca.uhn.hl7v2.model.v27.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRT
extends AbstractSegment {
    public PRT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, false, 1, 4, new Object[]{this.getMessage()}, "Participation Instance ID");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(287)}, "Action Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Action Reason");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Participation");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Participation Person");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Participation Person Provider Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Participant Organization Unit Type");
            this.add(XON.class, false, 0, 0, new Object[]{this.getMessage()}, "Participation Organization");
            this.add(PL.class, false, 0, 0, new Object[]{this.getMessage()}, "Participant Location");
            this.add(EI.class, false, 0, 0, new Object[]{this.getMessage()}, "Participation Device");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Participation Begin Date/Time (arrival time)");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Participation End Date/Time (departure time)");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Participation Qualitative Duration");
            this.add(XAD.class, false, 0, 0, new Object[]{this.getMessage()}, "Participation Address");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Participant Telecommunication Address");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRT - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getParticipationInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPrt1_ParticipationInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getPrt2_ActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getActionReason() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getPrt3_ActionReason() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getParticipation() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getPrt4_Participation() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN[] getParticipationPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(5, new XCN[0]);
        return retVal;
    }

    public XCN[] getPrt5_ParticipationPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(5, new XCN[0]);
        return retVal;
    }

    public int getParticipationPersonReps() {
        return this.getReps(5);
    }

    public XCN getParticipationPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public XCN getPrt5_ParticipationPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPrt5_ParticipationPersonReps() {
        return this.getReps(5);
    }

    public XCN insertParticipationPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN insertPrt5_ParticipationPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN removeParticipationPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public XCN removePrt5_ParticipationPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public CWE getParticipationPersonProviderType() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getPrt6_ParticipationPersonProviderType() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getParticipantOrganizationUnitType() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getPrt7_ParticipantOrganizationUnitType() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public XON[] getParticipationOrganization() {
        XON[] retVal = (XON[])this.getTypedField(8, new XON[0]);
        return retVal;
    }

    public XON[] getPrt8_ParticipationOrganization() {
        XON[] retVal = (XON[])this.getTypedField(8, new XON[0]);
        return retVal;
    }

    public int getParticipationOrganizationReps() {
        return this.getReps(8);
    }

    public XON getParticipationOrganization(int rep) {
        XON retVal = (XON)this.getTypedField(8, rep);
        return retVal;
    }

    public XON getPrt8_ParticipationOrganization(int rep) {
        XON retVal = (XON)this.getTypedField(8, rep);
        return retVal;
    }

    public int getPrt8_ParticipationOrganizationReps() {
        return this.getReps(8);
    }

    public XON insertParticipationOrganization(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(8, rep);
    }

    public XON insertPrt8_ParticipationOrganization(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(8, rep);
    }

    public XON removeParticipationOrganization(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(8, rep);
    }

    public XON removePrt8_ParticipationOrganization(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(8, rep);
    }

    public PL[] getParticipantLocation() {
        PL[] retVal = (PL[])this.getTypedField(9, new PL[0]);
        return retVal;
    }

    public PL[] getPrt9_ParticipantLocation() {
        PL[] retVal = (PL[])this.getTypedField(9, new PL[0]);
        return retVal;
    }

    public int getParticipantLocationReps() {
        return this.getReps(9);
    }

    public PL getParticipantLocation(int rep) {
        PL retVal = (PL)this.getTypedField(9, rep);
        return retVal;
    }

    public PL getPrt9_ParticipantLocation(int rep) {
        PL retVal = (PL)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPrt9_ParticipantLocationReps() {
        return this.getReps(9);
    }

    public PL insertParticipantLocation(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(9, rep);
    }

    public PL insertPrt9_ParticipantLocation(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(9, rep);
    }

    public PL removeParticipantLocation(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(9, rep);
    }

    public PL removePrt9_ParticipantLocation(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(9, rep);
    }

    public EI[] getParticipationDevice() {
        EI[] retVal = (EI[])this.getTypedField(10, new EI[0]);
        return retVal;
    }

    public EI[] getPrt10_ParticipationDevice() {
        EI[] retVal = (EI[])this.getTypedField(10, new EI[0]);
        return retVal;
    }

    public int getParticipationDeviceReps() {
        return this.getReps(10);
    }

    public EI getParticipationDevice(int rep) {
        EI retVal = (EI)this.getTypedField(10, rep);
        return retVal;
    }

    public EI getPrt10_ParticipationDevice(int rep) {
        EI retVal = (EI)this.getTypedField(10, rep);
        return retVal;
    }

    public int getPrt10_ParticipationDeviceReps() {
        return this.getReps(10);
    }

    public EI insertParticipationDevice(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(10, rep);
    }

    public EI insertPrt10_ParticipationDevice(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(10, rep);
    }

    public EI removeParticipationDevice(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(10, rep);
    }

    public EI removePrt10_ParticipationDevice(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(10, rep);
    }

    public DTM getParticipationBeginDateTimeArrivaltime() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getPrt11_ParticipationBeginDateTimeArrivaltime() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getParticipationEndDateTimeDeparturetime() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getPrt12_ParticipationEndDateTimeDeparturetime() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getParticipationQualitativeDuration() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getPrt13_ParticipationQualitativeDuration() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public XAD[] getParticipationAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(14, new XAD[0]);
        return retVal;
    }

    public XAD[] getPrt14_ParticipationAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(14, new XAD[0]);
        return retVal;
    }

    public int getParticipationAddressReps() {
        return this.getReps(14);
    }

    public XAD getParticipationAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(14, rep);
        return retVal;
    }

    public XAD getPrt14_ParticipationAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPrt14_ParticipationAddressReps() {
        return this.getReps(14);
    }

    public XAD insertParticipationAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(14, rep);
    }

    public XAD insertPrt14_ParticipationAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(14, rep);
    }

    public XAD removeParticipationAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(14, rep);
    }

    public XAD removePrt14_ParticipationAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(14, rep);
    }

    public XTN[] getParticipantTelecommunicationAddress() {
        XTN[] retVal = (XTN[])this.getTypedField(15, new XTN[0]);
        return retVal;
    }

    public XTN[] getPrt15_ParticipantTelecommunicationAddress() {
        XTN[] retVal = (XTN[])this.getTypedField(15, new XTN[0]);
        return retVal;
    }

    public int getParticipantTelecommunicationAddressReps() {
        return this.getReps(15);
    }

    public XTN getParticipantTelecommunicationAddress(int rep) {
        XTN retVal = (XTN)this.getTypedField(15, rep);
        return retVal;
    }

    public XTN getPrt15_ParticipantTelecommunicationAddress(int rep) {
        XTN retVal = (XTN)this.getTypedField(15, rep);
        return retVal;
    }

    public int getPrt15_ParticipantTelecommunicationAddressReps() {
        return this.getReps(15);
    }

    public XTN insertParticipantTelecommunicationAddress(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(15, rep);
    }

    public XTN insertPrt15_ParticipantTelecommunicationAddress(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(15, rep);
    }

    public XTN removeParticipantTelecommunicationAddress(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(15, rep);
    }

    public XTN removePrt15_ParticipantTelecommunicationAddress(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(15, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new XON(this.getMessage());
            }
            case 8: {
                return new PL(this.getMessage());
            }
            case 9: {
                return new EI(this.getMessage());
            }
            case 10: {
                return new DTM(this.getMessage());
            }
            case 11: {
                return new DTM(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new XAD(this.getMessage());
            }
            case 14: {
                return new XTN(this.getMessage());
            }
        }
        return null;
    }
}

